#!/usr/bin/perl -- -*-perl-*-

$mailto   = 'useradmin';
$mailprog = '/bin/mail';
$antrag   = '/var/spool/antr';

# Print out a content-type for HTTP/1.0 compatibility
print "Content-type: text/html\n\n";

# Print a title and initial heading
print "<Head><Title>Benutzerantrag stellen</Title></Head>";
print "<Body>";

# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Split the name-value pairs
@pairs = split(/&/, $buffer);

foreach $pair (@pairs)
{
    ($name, $value) = split(/=/, $pair);

    # Un-Webify plus signs and %-encoding
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    # Stop people from using subshells to execute commands
    # Not a big deal when using sendmail, but very important
    # when using UCB mail (aka mailx).
    # $value =~ s/~!/ ~!/g; 

    # Uncomment for debugging purposes
    # print "Setting $name to $value<P>";

    $FORM{$name} = $value;
}

# If the comments are blank, then give a "blank form" response
&blank_vorname unless $FORM{'vorname'};
&blank_nachname unless $FORM{'nachname'};
&blank_strasse unless $FORM{'strasse'};
&blank_ort unless $FORM{'ort'};
#&blank_telefon unless $FORM{'telefon'};
&blank_geburt unless $FORM{'geburt'};
&blank_beruf unless $FORM{'beruf'};
#&blank_buero unless $FORM{'buero'};
#&blank_btelefon unless $FORM{'btelefon'};

$zeit=time();
$filename = "$antrag/gast_$zeit";

# write data

open (TEXT, ">$filename") || die "Can't write data!\n";

print TEXT "$FORM{'vorname'}\n";
print TEXT "$FORM{'nachname'}\n";
print TEXT "$FORM{'strasse'}\n";
print TEXT "$FORM{'ort'}\n";
print TEXT "$FORM{'telefon'}\n";
print TEXT "$FORM{'geburt'}\n";
print TEXT "$FORM{'beruf'}\n";
print TEXT "$FORM{'buero'}\n";
print TEXT "$FORM{'btelefon'}\n";

close (TEXT);

# Now send mail

open (MAIL, "|$mailprog $mailto") || die "Can't open $mailprog!\n";
print MAIL "Reply-to: postmaster\n";
print MAIL "Subject: Benutzerantrag\n\n";

print MAIL "  Name   : $FORM{'vorname'} $FORM{'nachname'}\n";
print MAIL "  Strasse: $FORM{'strasse'}\n";
print MAIL "  Ort    : $FORM{'ort'}\n";
print MAIL "  Telefon: $FORM{'telefon'}\n";
print MAIL "  Geburt ; $FORM{'geburt'}\n";
print MAIL "  Beruf  : $FORM{'beruf'}\n";
print MAIL "  Buero  : $FORM{'buero'}\n";
print MAIL "  B-Tel  : $FORM{'btelefon'}\n";

print MAIL "\n\n------------------------------------------------------------\n";
print MAIL "Server protocol  : $ENV{'SERVER_PROTOCOL'}\n";
print MAIL "Remote host      : $ENV{'REMOTE_HOST'}\n";
print MAIL "Remote IP address: $ENV{'REMOTE_ADDR'}\n";
print MAIL "ID               : $zeit\n";
close (MAIL);

# Make the person feel good for writing to us
print "<h1>Alles klar</h1>";
print "Benutzerantrag wird innerhalb der naechsten Woche bearbeitet\n";
print "und kann in einer Woche im Fachschaftsraum AI waehrend der\n";
print "Oeffnungszeit abgeholt werden.<p>\n";
print "Zurueck zur <A HREF=\"/~gast\">Hauptseite</A>.<hr>\n";
print "ID: $zeit\n";

# ------------------------------------------------------------


# subroutine blank_username
sub blank_vorname
{
    print "<h1>Fehler!</h1>";
    print "Der Vorname wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_nachname
{
    print "<h1>Fehler!</h1>";
    print "Der Nachname wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_strasse
{
    print "<h1>Fehler!</h1>";
    print "Die Strasse wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_ort
{
    print "<h1>Fehler!</h1>";
    print "Der Ort wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_telefon
{
    print "<h1>Fehler!</h1>";
    print "Die Telefonnummer wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_geburt
{
    print "<h1>Fehler!</h1>";
    print "Das Geburtsdatum wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}
sub blank_fach
{
    print "<h1>Fehler!</h1>";
    print "Die Fachrichtung/der Beruf wurde nicht angegeben.\n";
    print "Sie koennen mit CURSOR-Links zurueckblaettern um den Eintrag";
    print "zu ergaenzen oder zur <a href=/~gast>Hauptseite zurueckkehren</a>.\n";
    exit;
}


