#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#include <unistd.h>

#include <Xclasses/Xclasses.h>

XCprogram	myprg("xteinheiten",
					XCP_Version,"1.0",
					XCP_Copyright,"by Jrgen Schmitz 1996, Freeware",
					XCP_Author,"Jrgen Schmitz",
					XCP_Desc,"Telefoneinheiten whrend der Onlinezeit anzeigen",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/Xclasses/",
					XCP_XC_logo,
					XCP_Done);

class einheiten
{
	time_t  startzeit;
	time_t  restv;
	time_t  online;
	time_t  login;
	int		start_zone;
	int		start_tag;
	int     einheitenzahl;
	char	zw[40];
	char    out[200];

	struct zeiten {
	    double dauer;
	    int    bisher;
	    time_t start;
	} zonen[6][7];

	int getzone(int stunde);
	int bisher(void);
public:

	const double PREIS=0.12;
	enum zone {city=0,region50=1,region200=2,fern=3};

	einheiten(zone stunde=city);
	void set(zone stunde);	

	void start(void);
    int current(void);
    int loginsince(void) { return (int)login; };
    int onlinesince(void) { return (int)online; };
    double dauer(void) { return zonen[start_zone][start_tag].dauer; };
	int rest(void) { return restv; };
    char *zonentxt(void);

	char *print(void);
};

int einheiten::getzone(int stunde)
{
	switch (stunde)
	{
		case 2:
		case 3:
		case 4:
			return 0;
			break;
		case 5:
		case 6:
		case 7:
		case 8:
			return 1;
			break;
		case 9:
		case 10:
		case 11:
			return 2;
			break;
		case 12:
		case 13:
		case 14:
		case 15:
		case 16:
		case 17:
			return 3;
			break;
		case 18:
		case 19:
		case 20:
			return 4;
			break;
		case 21:
		case 22:
		case 23:
		case 0:
		case 1:
			return 5;
			break;
	}
	return 0;
}
einheiten::einheiten(zone z)
{
	set(z);
}
void einheiten::set(zone z)
{
	int t;
	restv=0;
	startzeit=0;
	start_zone=0;
	start_tag=-1;
	online=0;
	login =0;

	for(t=0;t<7;t++)
	{
		switch(z)
		{
			case city:
				if (t>=1&&t<=5)
				{
					zonen[0][t].dauer=240.0;
					zonen[1][t].dauer=150.0;
					zonen[2][t].dauer= 90.0;
					zonen[3][t].dauer= 90.0;
					zonen[4][t].dauer=150.0;
					zonen[5][t].dauer=240.0;
				}
				else
				{
					zonen[0][t].dauer=240.0;
					zonen[5][t].dauer=240.0;
					zonen[1][t].dauer=150.0;
					zonen[2][t].dauer=150.0;
					zonen[3][t].dauer=150.0;
					zonen[4][t].dauer=150.0;
				}
                break;
			case region50:
				if (t>=1&&t<=5)
				{
					zonen[0][t].dauer=120.0;
					zonen[1][t].dauer= 45.0;
					zonen[2][t].dauer= 26.0;
					zonen[3][t].dauer= 30.0;
					zonen[4][t].dauer= 45.0;
					zonen[5][t].dauer= 60.0;
				}
				else
				{
					zonen[0][t].dauer= 60.0;
					zonen[5][t].dauer= 60.0;
					zonen[1][t].dauer= 45.0;
					zonen[2][t].dauer= 45.0;
					zonen[3][t].dauer= 45.0;
					zonen[4][t].dauer= 45.0;
				}
                break;
			case region200:
				if (t>=1&&t<=5)
				{
					zonen[0][t].dauer=120.0;
					zonen[1][t].dauer= 21.5;
					zonen[2][t].dauer= 12.0;
					zonen[3][t].dauer= 13.5;
					zonen[4][t].dauer= 21.5;
					zonen[5][t].dauer= 30.0;
				}
				else
				{
					zonen[0][t].dauer= 30.0;
					zonen[5][t].dauer= 30.0;
					zonen[1][t].dauer= 21.5;
					zonen[2][t].dauer= 21.5;
					zonen[3][t].dauer= 21.5;
					zonen[4][t].dauer= 21.5;
				}
                break;
			case fern:
				if (t>=1&&t<=5)
				{
					zonen[0][t].dauer=120.0;
					zonen[1][t].dauer= 20.0;
					zonen[2][t].dauer= 11.5;
					zonen[3][t].dauer= 12.5;
					zonen[4][t].dauer= 20.0;
					zonen[5][t].dauer= 25.0;
				}
				else
				{
					zonen[0][t].dauer= 25.0;
					zonen[5][t].dauer= 25.0;
					zonen[1][t].dauer= 20.0;
					zonen[2][t].dauer= 20.0;
					zonen[3][t].dauer= 20.0;
					zonen[4][t].dauer= 20.0;
				}
                break;
		}
	}
}
void einheiten::start(void)
{
	int t,o;
	struct tm *tmp;

	time(&startzeit); 
	tmp=localtime(&startzeit); 
	start_zone=getzone(tmp->tm_hour); 
	start_tag =tmp->tm_wday; 
	login     =startzeit; 

	for(t=0;t<7;t++)
	{
		for(o=0;o<6;o++)
		{
			zonen[o][t].bisher=0;
			if (o==start_zone && t==start_tag)
			{
				zonen[o][t].start=startzeit;
			}
			else
			{
				zonen[o][t].start=0;
			}
		}
	} 
	einheitenzahl=0;
}
int einheiten::bisher(void)
{
	int g=0;
	int z=start_zone,w=start_tag;
	int zs=z,ws=w;

	do
	{
		g+=zonen[z][w].bisher;
		if ((--z)<0)
		{
			z=5;
			if ((--w)<0)
			{
				w=5;
			}
		}
	}
	while (zonen[z][w].start && ((zs-z)||(ws-w)));
	return g;
}
int einheiten::current(void)
{
	time_t t,c;
	struct tm *tmp;
	int akt,d;

	time(&t);
	if (start_tag==-1) return einheitenzahl;

	online=t-login;
	tmp=localtime(&t);

	c=t-zonen[start_zone][start_tag].start;

	d=(int)((double)c/zonen[start_zone][start_tag].dauer);
	if ((double)c/zonen[start_zone][start_tag].dauer!=(double)d) d++;
	restv=(int)((double)d*zonen[start_zone][start_tag].dauer)-c;
	einheitenzahl=d;

	akt=getzone(tmp->tm_hour);
	if (akt!=start_zone)
	{
		zonen[start_zone][start_tag].bisher=einheitenzahl;
        start_zone=akt;
        start_tag=tmp->tm_wday;
        zonen[start_zone][start_tag].start=t;
        zonen[start_zone][start_tag].bisher=0;
	}

	einheitenzahl+=bisher();

	return einheitenzahl;
}
char *einheiten::zonentxt(void)
{
	time_t t;
	struct tm *tmp;

	time(&t);
	tmp=localtime(&t);

	if (tmp->tm_wday>=1&&tmp->tm_wday<=5)
	{
		strcpy(zw,"Woche, ");
	}
	else
	{
		strcpy(zw,"Wocheende, ");
	}
	switch (getzone(tmp->tm_hour))
	{
		case 0:
			strcat(zw,"Nacht 2-5");
			break;
		case 1:
			strcat(zw,"Freizeit 5-9");
			break;
		case 2:
			strcat(zw,"Vormittag 9-12");
			break;
		case 3:
			strcat(zw,"Nachmittag 12-18");
			break;
		case 4:
			strcat(zw,"Freizeit 18-21");
			break;
		case 5:
			strcat(zw,"Mondschein 21-2");
			break;
	}
	return zw;
}
char *einheiten::print(void)
{
	int eh=current();
	
   	sprintf(out,"DM %.2f, Einheiten %2d, \nOnline %2d:%02d m:s, Restzeit %3d s",eh*PREIS,eh,(int)online/60,(int)online%60,(int)restv);
   	return out;
}

#define FONT FONT_GADGET
#define BFONT FONT_GROUP
#define WIDTH 150
#define HEIGHT 25
#define BHEIGHT 60
#define RAND 10
#define ORAND 5
#define ZRAND 5

#define TWIDTH (WIDTH*2+70+RAND*2)
#define THEIGHT (BHEIGHT+5+4*HEIGHT+4+ORAND*2+ZRAND)

// private function!
int hashtest(void);

appwindow mywin;
group g1,g2,g3,sg1,sg2;
bordergroup g4,g5;
//mxbutton zo;
mxknob zo;
button start,stop,ueber,ende;
indicator ind,ind2;
xclock cl;
menu mymenu;

int main(int argc,char *argv[])
{
	int run=1,r=-1,w,zne=0;
	einheiten eh;
	char *tzo[]={"City","Region 50","Region 200","Fern",NULL};
	char out[70],out2[30];

	char c;
	int max=100;

	mywin.InitSize(0,0,TWIDTH,THEIGHT);	
	if (!mywin.Init(argc,argv,"#b0b0c0"))
	{
		printf("Error: Can't open display\n");
		exit(1);
	} 

	eh.set((einheiten::zone)zne);

	while ((c=getopt(argc,argv,"z:s?h-"))!=-1 && max-->0)
	{
		switch (c)
		{
			case '?':
			case 'h':
			case ':':
			case '-':
				printf("Usage: %s [-z zone] [-s]\n\n",argv[0]);
				printf(" -z zone : Fern|Fernzone|Region200|200|Region50|50|City\n");
				printf(" -s      : Start\n");
				printf("\n");
				exit(0);
				break;
			case 's':
				run=2;
				break;
			case 'z':
				if (!strcasecmp(optarg,"city")) zne=(int)einheiten::city;
				if (!strcasecmp(optarg,"region50")||!strcasecmp(optarg,"50")) zne=(int)einheiten::region50;
				if (!strcasecmp(optarg,"region200")||!strcasecmp(optarg,"200")) zne=(int)einheiten::region200;
				if (!strcasecmp(optarg,"fernzone")||!strcasecmp(optarg,"fern")) zne=(int)einheiten::fern;
				break;
		}
	}
	if (run==2)
	{
		eh.set((einheiten::zone)zne);
		eh.start();
	}

	mywin.Title("xteinheiten - von Jrgen Schmitz");
	mywin.IconTitle("xteinheiten");
	mywin.Class("xteinheiten","Xteinheiten");

	g1.Vert();
 	g1.Add(g2);
	 g2.Horiz();
	 g2.XDistance(4);
	 g2.UseSmallest();
	 g2.Add(cl);
	  cl.Seconds();
//	  cl.SmallSeconds();
//	  cl.FormCrazy();
	  cl.NoMinutes();
	 g2.Add(ind);
	  ind.Font(BFONT);
	  ind.Title("Restzeit");
	  ind.HelpText("Zeigt die Restzeit bis\nzum Ende der aktuellen Einheit.");
	 g2.Add(ind2);
	  ind2.Font(BFONT);
	  ind2.Title("Online");
	  ind2.MaxValue(3600,300);
	  ind2.CircleIndicator();
	  ind2.HelpText("Zeigt die verstrichene Onlinezeit.");

	g1.Add(g3);	 
	 g3.Horiz();
	 g3.UseSmallest();
	 g3.Add(g4);	
	  g4.Vert();
	  g4.Title("Zonen");
	  g4.Add(zo);
	   zo.ID(1);
	   zo.Font(FONT);
	   zo.Items(tzo);
	   zo.Selected(zne);
	   zo.HelpText("Entfernungszonen\nnach Telekom-Bezeichnung");

	 g3.Add(g5); 	 
	 g5.Vert();
	 g5.Title("Kontrolle");
	 g5.Add(sg1);
	  sg1.Add(start);
	   start.ID(2);
	   start.Text("Start");
	   start.Font(FONT);
	   start.HelpText("Startet Zhler");
	  sg1.AddShadow(sg2);
	   sg2.Add(stop);
	    stop.ID(3);
	    stop.Text("Stopp");
	    stop.Font(FONT);
	    stop.HelpText("Stoppt Zhler");
	 g5.Add(ende);
	  ende.ID(5);
	  ende.Text("Ende");
	  ende.Font(FONT);

	mywin.SetGroup(g1);

	mymenu.AddMenu("Programm");
	mymenu.Add("Ende","q",1);
	mymenu.ID(5);
	mywin.SetMenu(mymenu);
	mywin.Create();

	stop.Lock();
	sg1.Show();
	if (run==2)
	{
		stop.Unlock();
		start.Lock();
		g4.Lock();
		ueber.Lock();
		ind.MaxValue((int)(eh.dauer()*500),10*500);
		mywin.IconTitle("xteinheiten - Running");
	}
	while (run)
	{
		w=mywin.TickEvent();
		if (run==2)
		{
			int e=eh.current();
			   	
			if (r!=eh.onlinesince())
			{
			   	sprintf(out,"DM %.2f, Einheiten %2d, \nRestzeit %3d s",e*einheiten::PREIS,e,eh.rest());
				ind.Value(eh.rest()*500,out);
				mywin.Update();
				sprintf(out2,"%2d:%02d\nmin:sec",eh.onlinesince()/60,eh.onlinesince()%60);
				ind2.Value(eh.onlinesince()%3600,out2);
				mywin.Update();
				r=eh.onlinesince();
			}
		}
		if (w==EV_WINDOWCLOSE)
		{
			if (mywin.CloseMe())
			{
				run=0;
			}
		}
		else if (w==EV_GADGET)
		{
			w=mywin.ID();
			switch (w)
			{
				case 1: // Zone
					eh.set((einheiten::zone)zo.Selected());
					break;
				case 2: // Start
					eh.start();

					run=2;
					stop.Unlock();
					sg2.Show();
					start.Lock();
					g4.Lock();
					ueber.Lock();
					ind.MaxValue((int)(eh.dauer()*500),10*500);
					mywin.IconTitle("Xteinheiten - Running");
					break;
				case 3: // Stopp
					run=1;
					mywin.IconTitle("Xteinheiten");
					start.Unlock();
					sg1.Show();
					stop.Lock();
					g4.Unlock();
					ueber.Unlock();
					break;
				case 5: // Ende
					run=0;
					break;
			}
			mywin.Update();
		}
	}

	mywin.Close();
	return 0;
}
