#ifndef CODE_NEWCLASS_CPP
#define CODE_NEWCLASS_CPP

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/xpm.h>
#include <stdio.h>
#include <Xclasses/types.h>

#include <Xclasses/gadget.h>
#include <Xclasses/Ddraw.h>
#include "include/newclass_p.h"


void outOfMemory(char *classname);

newclass::newclass(): Ddraw(this), gadget()
{
    while (!(p=new pnewclass))
    {
        outOfMemory("newclass");
    }
    p->o=this;

	Name("newclass");	// set a name as default
    BorderSize(3);		// set normal button border size

// init public and protected members
}
newclass::~newclass()
{
    Free();
    if (p) delete p;
}
pnewclass::pnewclass()
{
// init private members
}
pnewclass::~pnewclass()
{
}

// a CreateGadget() example
int newclass::Create(void)
{ 
    Background(col_background());       // set standard background color
    
    if (gadget::Create())
    {
        MCursor(XC_hand2);              // a nice mouse cursor
        Mode(GM_BUTTON1|GM_ONEEXPOSE);  // and our events
        return 1;                       // return success
    } 
    return 0;                           // some error, return 0
}
// G functions examples
void newclass::GExpose(XEvent *event)
{
    borderUpFill(this,0,0,width,height);             // draw border
    if (locked) borderlocked(this,0,0,width,height); // if locked paint it
}
void newclass::GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason)
{
    borderDownFill(this,0,0,width,height);           // draw pressed border
}
void newclass::GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason)
{
    borderUpFill(this,0,0,width,height);             // draw released border
}
int newclass::GActivate(XEvent *event,int why)
{
    return GAR_ACTIVE;                               // always active
}
int newclass::GSelected(XEvent *event,int why,int wasabove)
{
    return wasabove?GSR_SELECTION|GSR_MESSAGE:0;     // always selected if mouse was above
}
void newclass::GSetLimits(void)
{
    minwidth=10;                                     // minimum width
    minheight=10;                                    // minimum height
}

#endif
