#ifndef INCL_POPUP_H
#define INCL_POPUP_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: popup
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/gadget.h>

class popup : Ddraw, public gadget
{
	friend class ppopup;
	
	class ppopup *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
	virtual void GSetLimits(void);
	virtual int GActivate(XEvent *event,int why);
	virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual int GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);

    popup();
    virtual ~popup();

	int Create();
	void Free(void);

	void KeyHook(int hook(popup *,int),int);
	void KeyHook(void *,int hook(popup *,int),int);
	void KeyHook(void *,...);
// opens after create or any times later
	void Open(int w=0);
	void Open(int x,int y,int w=0);
	void OpenAt(int x,int y,int atsel,int w=0);
	void Close(void);
	
	int PopupOpen(void);	// 0 - no, 1 - yes
	
	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	void LockItem(int pid);
	void UnlockItem(int pid);
	void LockHeadOf(int pid);
	void UnlockHeadOf(int pid);

	void State(int pid,int state);
	int State(int pid);

	void Selected(int pid,int s);
	int Selected(int pid);

	void Add(char *text,char *scut,int pid);
	void AddRuler(void);
	void AddHeadline(char *);
	void AddSel(char *text,char *scut,int pid);
	void AddMX(char **text,char **scut,int pid);
	void AddSub(char *text);
	void EndSub(void);
	void Clear(void);

	int PID();
};

#endif
