/*
 * Copyright (C) 1994 Communications and Systems Specialists, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Communications and Systems 
 * Specialists, Inc. shall not be used in advertising or otherwise to promote 
 * the sale, use or other dealings in this Software without prior written 
 * authorization from Communications and Systems Specialists, Inc.
 */

#ifndef __XmsgXm_h
#define __XmsgXm_h

#include <Xmsg.h>

/******************************************************************************
 * This structure defines message attributes that are available for display 
 * in message popups.  The message attributes are defined via the 
 * XmsgXmInstall() function.
 *****************************************************************************/
typedef struct _XmsgXmLookupStruct
{
   _XmsgConst _XmsgString name_str;	/* the name of the resource associated 
                                           with this message attribute */
   _XmsgConst _XmsgString label_str;	/* the text to display in the popup as
                                           a label for the message attribute */
   _XmsgConst _XmsgString lookup_str;	/* the raw text to display if a 
   					   Boolean True value is found in the
					   error database for this attribute */
}
XmsgXmLookupStruct;



/******************************************************************************
 * install an icon for a category.
 *
 * Each message category needs a unique icon to be displayed in the 
 * message dialog. The icon for each message category is stored in the Motif 
 * image cache. The name of the image is expected to be the concatenation 
 * of "Xmsg" and the message category specified when the message was created.
 *
 * Icons for Fatal, Error, Warning, Info, and Debug messages are automatically
 * installed.
 *
 * Returns True if and only if the image was successfully added to
 * the Motif image cache.
 *
 * NOTES:
 * The XmsgXm library provides no mechanism for removing images from the 
 * image cache since the address of the image structure is not returned 
 * to the caller.
 *
 * Refer to XmInstallImage() for information about the Motif image cache.
 *****************************************************************************/
Boolean XmsgXmCacheBitmap( 
#if NeedFunctionPrototypes
   _XmsgConst _XmsgString bitmap_name_str, /* the complete name of the image, 
   					      e.g., "XmsgWarning" */
   _XmsgConst _XmsgString bitmap_bits,	   /* the bits from the standard X11
   					      bitmap format */
   int                    height,	   /* the height from the standard X11
   					      bitmap format */
   int                    width		   /* the width from the standard X11
   					      bitmap format */
#endif
);


/******************************************************************************
 * named message handler for popup message dialogs.
 *
 * The named message handler which provides support for XmsgXm dialog
 * messages.  The handler is automatically registered when XmsgXmInstall()
 * is called.  
 *
 * If the handler is uninstalled, it can be reinstalled by using the
 * function XmsgAddHandler().
 *****************************************************************************/
void XmsgXmDispatchPopup(
#if NeedFunctionPrototypes
   XmsgMessageStruct* message_ptr	/* opaque structure defining the 
   					   attributes of the message to 
   					   handle */
#endif
);


/******************************************************************************
 * install the XmsgXm library.
 *
 * The XmsgXm library needs to be installed before any messages are generated. 
 * XmsgXmInstall() also installs the Xmsg library. 
 *
 * The default widget is not the specified widget, but rather the widget at 
 * the top of the specified widget's hierarchy. This default widget must not 
 * be destroyed once it has been installed.  A different widget can be 
 * installed at any time by calling XmsgInstall() again.
 *
 * The control parameters can have the following values ORed together:
 * .TP
 * .B "XmsgCONTROL_DISPATCH_ALL"
 *					 All messages are dispatched to at 
 *					least one handler. If a message is 
 *					not explicitly dispatched to any 
 *					handlers, it is dispatched to a 
 *					default handler that simply writes 
 *					the message to stderr.
 * .TP
 * .B "XmsgCONTROL_INSTALL_ALL"
 *					All XmsgCONTROL_INSTALL_... bits are
 *					set.
 * .TP
 * .B "XmsgCONTROL_INSTALL_ALL_X"
 *					All X and Xt errors and warnings are
 *					trapped.
 * .TP
 * .B "XmsgCONTROL_INSTALL_STDERR"
 *					A handler is installed that writes the 
 *					message to stderr. This handler 
 *					supports an option that allows a 
 *					message string to be added to the 
 *					beginning of the message text before 
 *					it is written to stderr.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XLIB"
 *					All X events and I/O errors are trapped.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XERROR"
 *					X error events are trapped by the Xmsg 
 *					facility.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XIO"
 *					X I/O errors are trapped by the Xmsg 
 *					facility.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XT"
 *					All Xt errors and warnings are trapped.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTERROR"
 *					Xt high- and low-level errors are
 *					trapped.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTERRORLL"
 *					Xt low-level errors are trapped by the 
 *					Xmsg facility.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTERRORMSG"
 *					Xt high-level errors are trapped by the 
 *					Xmsg facility.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTWARNING"
 *					Xt high- and low-level warnings are
 *					trapped.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTWARNINGLL"
 *					Xt low-level warnings are trapped by 
 *					the Xmsg facility.
 * .TP
 * .B "XmsgCONTROL_INSTALL_XTWARNINGMSG"
 *					Xt high-level warnings are trapped by 
 *					the Xmsg facility.
 *
 * NOTES:
 * The function XmsgXmInstall() should only be called once; additional calls 
 * are ignored. 
 *****************************************************************************/
void XmsgXmInstall(
#if NeedFunctionPrototypes
   Widget              w,		/* used to derive the default widget 
   					   that is associated with widgetless 
					   messages */
   unsigned int        control,		/* a bit-field that specifies install
   					   options */
   XmsgXmLookupStruct* lookup_ptr,	/* optional list of message attributes 
   					   that are available for display in 
   					   message popups */
   Cardinal            lookup_total	/* specifies the number of elements in 
   					   the lookup_ptr list */
#endif
);

#endif
