/*
 * Copyright (C) 1994 Communications and Systems Specialists, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the 
 * "Software"), to deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, merge, publish, 
 * distribute, sublicense, and/or sell copies of the Software, and to 
 * permit  persons to whom the Software is furnished to do so, subject to 
 * the following conditions:
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
 * IN NO EVENT SHALL COMMUNICATIONS AND SYSTEMS SPECIALISTS, INC. BE 
 * LIABLE FOR ANY CLAIM,  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Communications and 
 * Systems Specialists, Inc. shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without 
 * prior written authorization from Communications and Systems 
 * Specialists, Inc.
 */


#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <X11/Intrinsic.h>

#if USE_EDITRES
#  include <X11/Xmu/Editres.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>

#include <Xmsg.h>


void activateCB(
   Widget w,
   XtPointer cd,
   XtPointer cbd )
{
   String param = "Parameter";
   static String bigparams[11]={"1","2","3","4","5","6","7","8","9","10","11"};
   
   XmsgDebug( w, "debug", "type", "Class", "This is the message", NULL, 0, cd );

   XtWarning( "This is an XtWarning message" );
   XTestCompareCursorWithWindow( XtDisplay( w ), (Window) 0, (Cursor) 0 );
   XCreateSimpleWindow( XtDisplay( w ), (Window) -1, 0, 0, 1, 1, 1, 0, 0 );
   XtAddCallback( w, "bogus", activateCB, NULL );

   XmsgWarningPos( w, "name", "type", "Class", "Default Text",
                   &param, 1, cd, XmsgPositionDEFAULT );

   XmsgInfo( w, "info", "type", "Class", "Big Params", bigparams, 11, cd );

#if 0
   XmsgFatal( w, "name", "type", "Class", "Default Text",
              &param, 1, cbd );
#endif
}


int main(
   int    argc,
   char** argv )
{
   XtAppContext app_context;
   Widget shell;
   Widget form;
   Widget button;
   XmString cs;

   shell = XtVaAppInitialize( 
              &app_context, "XmsgTest", NULL, 0, &argc, argv, NULL, NULL );

#  if USE_EDITRES
      XtAddEventHandler( shell, (EventMask)0, True, 
                         (XtEventHandler)_XEditResCheckMessages, NULL );
#   endif

   XmsgAppMergeErrorDB( app_context, "./XmsgErrorDB" );

   XmsgAppDirectOverrideErrorDB( app_context, 
                                 "*popupTitle: (overrided) @a : @m" );

   XmsgXmInstall( shell, XmsgCONTROL_INSTALL_ALL, NULL, 0 );

   form = XtVaCreateManagedWidget( "form", xmFormWidgetClass, shell, NULL );

   cs = XmStringCreateLocalized( "Press This" );
   button = XtVaCreateManagedWidget( "btn", xmPushButtonWidgetClass, form, 
                                     XmNlabelString, cs,
                                     NULL );
   XmStringFree( cs );

   XtAddCallback( button, XmNactivateCallback, activateCB, NULL );

   XtRealizeWidget( shell );

   XtAppMainLoop( app_context );

   return 0;
}
