#ifndef _DDSTREAM_
#define _DDSTREAM_
//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <strstream.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

class DDstream
{
public:
  virtual int eof() 	{ return iostr->eof(); }
  virtual int fail() 	{ return iostr->fail(); }
  virtual int bad()	{ return iostr->bad(); }
  virtual int good()	{ return iostr->good(); }
  virtual int rdstate() { return iostr->rdstate(); }     
  virtual void clear(int v=0) { iostr->clear(v); }
  virtual ~DDstream() = 0;
protected:
  DDstream(): iostr(NULL) {}
  ios *iostr;
};


class DDistream: public DDstream
{
public:
  DDistream(char *, size_t size);
  ~DDistream();
  DDistream&	get(char& c);
  DDistream&	read(char*& s, int n);
  DDistream&	read(u_char*& s, int n);

  DDistream&	operator>>(char*&  );
  DDistream&	operator>>(u_char*&);
  DDistream&	operator>>(char&  );
  DDistream&	operator>>(double&);
  DDistream&	operator>>(float& );
  DDistream&	operator>>(int&   );
  DDistream&	operator>>(long&  );
  DDistream&	operator>>(short& );
  DDistream&	operator>>(unsigned char& );
  DDistream&	operator>>(unsigned int&  );
  DDistream&	operator>>(unsigned long& );
  DDistream&	operator>>(unsigned short&);
private:  
  DDistream& operator=(const DDistream&) { return *this;}
protected:
  XDR xdr;
  char *buf;
  strstream i;			// this is used only for set/get status
};

class DDostream: public DDstream
{
public:
  DDostream(streambuf *);
  ~DDostream();

  DDostream&	operator<<(const char*);
  DDostream&	operator<<(char);
  DDostream&	operator<<(u_char);
  DDostream&	operator<<(double);
  DDostream&	operator<<(float);
  DDostream&	operator<<(int);
  DDostream&	operator<<(u_int);
  DDostream&	operator<<(long);
  DDostream&	operator<<(u_long);
  DDostream&	operator<<(short);
  DDostream&	operator<<(u_short);
  
  DDostream&	put(char c);

  DDostream&	write(const char* s, int n);
  DDostream&	write(const u_char* s, int n);

  // tellp is for debugging only
  int tellp() { return o.tellp(); }
  
private:  
  DDostream& operator=(const DDostream&) { return *this;}

protected:
  XDR xdr;
  char *buf;			// mem-XDR buffer
  int size;			// current buffer size
  ostream o;
};


#endif
