//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <DD++/SpecificDragSite.H>


Cardinal SpecificDragSite::dragContextProperties(ArgList* aret)
{
  Cardinal      n = 0;
  ArgList       a;

  a = (ArgList)XtCalloc( 4, sizeof(Arg) );

  XtSetArg( a[0], XmNblendModel, blendModel );  n++;

  if( source->getPixmap() != XmUNSPECIFIED_PIXMAP )
    XtSetArg( a[n], XmNsourcePixmapIcon, sourceDragIcon=source->createDragIcon() );  n++;

  if( state->getPixmap() != XmUNSPECIFIED_PIXMAP )
    XtSetArg( a[n], XmNstateCursorIcon, stateDragIcon=state->createDragIcon() );  n++;

  if( operation->getPixmap() != XmUNSPECIFIED_PIXMAP )
    XtSetArg( a[n], XmNoperationCursorIcon, operationDragIcon=operation->createDragIcon() );  n++;

  *aret = a;
  return( n );
}

SpecificDragSite::SpecificDragSite( Widget aWidget,
				    int blendModel_,
				    char *sourcePixmapName_,
				    char *statePixmapName_,
				    char *operationPixmapName_ ):
    DragSite(aWidget),
    blendModel(blendModel_),
    sourceDragIcon(NULL),
    stateDragIcon(NULL),
    operationDragIcon(NULL)
{
  source = new XPixmap( w, sourcePixmapName_ );
  state = new XPixmap( w, statePixmapName_ );
  operation = new XPixmap( w, operationPixmapName_ );
}

// Destructor will destroy dragIcon-related widgets

SpecificDragSite::~SpecificDragSite()
{
  delete source;
  delete state;
  delete operation;
  XtDestroyWidget(sourceDragIcon);
  XtDestroyWidget(stateDragIcon);
  XtDestroyWidget(operationDragIcon);
}
