//
// Copyright (C) 1994-1995 Harry Danilevsky and Andrew Renalds
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish and distribute copies of the 
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESSED OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// HARRY DANILEVSKY AND ANDREW RENALDS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <stream.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/DrawnB.h>
#include <Xm/PushB.h>
#include <DD++/DDstring.H>
#include <DD++/DDint.H>
#include <DD++/DD.H>

class StringDropTarget: public DropTarget
{
  int receive (Widget) {
    cout << "string trash received: " << *((DraggableString*)dPtr) << endl;
    return 1;
  }
public:
  StringDropTarget(DraggableString& s): DropTarget(s) {}
};

class IntDropTarget: public DropTarget
{
  int receive (Widget) {
    cout << "integer trash received: " << *((DraggableInt*)dPtr) << endl;
    return 1;
  }
public:
  IntDropTarget(DraggableInt& i): DropTarget(i) {}
};

main( int argc, char *argv[] )
{
  XtAppContext app_context;
  Widget toplevel, bb, button1;
  Arg args[15];
  int n;
  Pixmap drop_pixmap = (Pixmap)NULL;
  Pixel fg, bg;

  toplevel = XtAppInitialize( &app_context, "DropTrash", NULL, 0,
                              &argc, argv, NULL, NULL, 0 );

  n = 0;
  XtSetArg( args[n], XmNwidth, 85 );  n++;
  XtSetArg( args[n], XmNheight, 85 );  n++;
  bb = XtCreateManagedWidget( "", xmFormWidgetClass,
                              toplevel, args, n );

  XtVaGetValues( bb, XmNforeground, &fg, XmNbackground, &bg, NULL );
  drop_pixmap = XmGetPixmap( XtScreen(bb), "trashcan.xpm", fg, bg );

  n = 0;
  XtSetArg( args[n], XmNtopAttachment, XmATTACH_FORM );  n++;
  XtSetArg( args[n], XmNbottomAttachment, XmATTACH_FORM );  n++;
  XtSetArg( args[n], XmNleftAttachment, XmATTACH_FORM );  n++;
  XtSetArg( args[n], XmNrightAttachment, XmATTACH_FORM );  n++;
  XtSetArg( args[n], XmNtopOffset, 15 );  n++;
  XtSetArg( args[n], XmNbottomOffset, 15 );  n++;
  XtSetArg( args[n], XmNleftOffset, 15 );  n++;
  XtSetArg( args[n], XmNrightOffset, 15 );  n++;
  XtSetArg( args[n], XmNshadowType, XmSHADOW_IN );  n++;
  XtSetArg( args[n], XmNlabelType, XmPIXMAP );  n++;
  XtSetArg( args[n], XmNrecomputeSize, False );  n++;
  XtSetArg( args[n], XmNresizable, False );  n++;
  if( drop_pixmap != XmUNSPECIFIED_PIXMAP )
  {
    XtSetArg( args[n], XmNlabelPixmap, drop_pixmap );  n++;
  }
  button1 = XtCreateManagedWidget( "", xmDrawnButtonWidgetClass,
                                       bb, args, n );

  DropSite dropSite1(button1, XmDROP_COPY|XmDROP_MOVE, 
			XmDRAG_UNDER_PIXMAP, "trashcan_open.xpm" );

  DraggableString dstring;
  StringDropTarget dropTarget1(dstring);
  dropSite1.append(&dropTarget1);

  DraggableInt    dint;
  IntDropTarget dropTarget2(dint);
  dropSite1.append(&dropTarget2);

  XtRealizeWidget( toplevel );
  XtAppMainLoop( app_context );
}
