#include <stdio.h>
#include "tamil.h"

typedef enum 
{
  t_TAMIL,
  t_MADURAI,
  t_POSTSCRIPT,
  t_PRINTER,
  t_UNKNOWN
} tamil_file_type;

#define DEFAULT_PRINT_CMD "lpr"

#ifdef __STDC__
static void usage (char* progname);
#else
static void usage ();
#endif

int
#ifdef __STDC__
main (int ac, char** av)
#else
main (ac, av)
 int ac;
 char** av;
#endif /* __STDC__ */
{
  char*           ifile = 0;
  char*           ofile = 0;
  char            lpr [80];
  FILE*           ifp = 0;
  FILE*           ofp = 0;
  tamil_file_type ift   = t_MADURAI;
  tamil_file_type oft   = t_PRINTER;
  char*           progname = av [0];
  
  strcpy (lpr, DEFAULT_PRINT_CMD);

  while (*++av)
    {
      if (strcmp (*av, "-from") == 0)
	{
	  av++;
	  if (*av == 0)
	    {
	      usage (progname);
	      return 1;
	    }
	  switch (av [0][0])
	    {
	    case 'm':
	      ift = t_MADURAI;
	      break;
	    case 't':
	      ift = t_TAMIL;
	      break;
	    default:
	      usage (progname);
	      return 1;
	    }
	}
      else if (strcmp (*av, "-to") == 0)
	{
	  av++;
	  if (*av == 0)
	    {
	      usage (progname);
	      return 1;
	    }
	  if (strcmp (*av, "m") == 0)
	    oft = t_MADURAI;
	  else if (strcmp (*av, "t") == 0)
	    oft = t_TAMIL;
	  else if (strcmp (*av, "p") == 0)
	    oft = t_POSTSCRIPT;
	  else
	    {
	      oft = t_PRINTER;
	      strcpy (lpr, *av);
	    }
	}
      else if (ifile == 0)
	ifile = *av;
      else if (ofile == 0)
	{
	  ofile = *av;
	  if (oft == t_PRINTER)
	    {
	      if (strcmp (*av, "-") == 0)
		{
		  oft = t_POSTSCRIPT;
		}
	      else
		{
		  fprintf (stderr, "ignoring output file %s\n", *av);
		  fprintf (stderr, "the output is sent to the stdin of \"%s\"\n", lpr);
		}
	    }
	}
      else
	{
	  usage (progname);
	  return 1;
	}
    }

  if (ift == oft)
    {
      fprintf (stderr, "%s: both input and output formats are same\n\n", progname);
      usage (progname);
      return 1;
    }
      

  if (ifile == 0)
    {
      usage (progname);
      return 1;
    }
  else if (*ifile != '-')
    {
      ifp = fopen (ifile, "r");
      if (ifp == 0)
	{
	  fprintf (stderr, "%s: cannot open input file %s\n", progname, ifile);
	  return 1;
	}
    }

  if (oft == t_PRINTER)
    {
      ofp = popen (lpr, "w");
      if (ofp == 0)
	{
	  char buf [128];
	  sprintf (buf, "%s: unable to execute the print command %s\n",
		   progname, lpr);
	  perror (buf);
	  fclose (ifp);
	  return 1;
	}
    }
  else if (ofile && *ofile != '-')
    {
      ofp = fopen (ofile, "w");
      if (ofp == 0)
	{
	  fprintf (stderr, "%s: cannot open output file %s\n", progname, ifile);
	  fclose (ifp);
	  return 1;
	}
    }
  
  if (ift == t_MADURAI)
    {
      if (oft == t_TAMIL)
	{
	  fp_madurai2tamil (ifp, ofp);
	}
      else
	{
	  FILE* tfp = tmpfile ();

	  fp_madurai2tamil (ifp, tfp);
	  fseek (tfp, 0L, 0);
	  fp_tamil2ps (tfp, ofp);
	}
    }
  else if (ift == t_TAMIL)
    {
      if (oft == t_MADURAI)
	{
	  fp_tamil2madurai (ifp, ofp);
	}
      else
	{
	  fp_tamil2ps (ifp, ofp);
	}
    }
  else
    {
      usage (progname);
      if (ifp)
	fclose (ifp);
      if (ofp)
	{
	  if (oft == t_PRINTER)
	    pclose (ofp);
	  else
	    fclose (ofp);
	}
      return 1;
    }
  if (ifp)
    fclose (ifp);
  if (ofp)
    {
      if (oft == t_PRINTER)
	pclose (ofp);
      else
	fclose (ofp);
    }
  return 0;
}

static void
#ifdef __STDC__
usage (char* progname)
#else
usage (progname)
     char* progname;
#endif /* __STDC__ */
{
  fprintf (stderr, "USAGE: %s [ -from type ] [ -to type ] input_file [output_file]\n", progname);
  fprintf (stderr, "\n\ttype is m for MADURAI, t for TAMIL, p for POSTSCRIPT\n");
  fprintf (stderr, "\tvalid input types are m and t (default = m)\n");
  fprintf (stderr, "\tvalid output types are m, t, p, and print_cmd (default = %s)\n", DEFAULT_PRINT_CMD);
  fprintf (stderr, "\t\tprint_cmd specifies what command to use\n\t\tto print the PostScript file\n");
  fprintf (stderr, "\tif input_file is -, stdin is used\n");
  fprintf (stderr, "\tif output_file is - or none is specified, stdout is used\n");
  fprintf (stderr, "\toutput_file is ignored if output type is print_cmd\n");
  fprintf (stderr, "\n%s converts the input_file in the given format to the output file\n", progname);
  fprintf (stderr, "in the specified format\n\n");
  fprintf (stderr, "Please send bug reports to gs4t@virginia.edu\n");
}
