.TH TAMIL 1 "3 Sep 1993" "Version 0.4"
.SH NAME
tamil \- translate between Madurai and Tamil and to PostScript
.SH SYNOPSIS
.B tamil
.RB [ " \-from type " ]
.RB [ " \-to type " ]
.IR inputfilename
.IR [ outputfilename ]
.SH DESCRIPTION
.B tamil
takes the input file
.I inputfilename
in Madurai or Tamil format and converts it to Madurai, Tamil,
or PostScript format or converts it to PostScript format
and sends the PostScript output to the printer. If
.B tamil
is not sending the output to the printer, it saves the result in
.I outputfilename,
if it is specified. Otherwise,
.B tamil
sends the output to
.I stdout.
.LP
If the
.I inputfilename
is \-,  then
.I stdin
is assumed.
.LP
Similarly, if the
.I outputfilename
is \- or not specified, then
.I stdout
is assumed. Also, the
.I outputfilename
is ignored if
.B tamil
is sending the output to the printer.
.LP
The default print command is "lpr".
.SH OPTIONS
.TP
.B \-from type
Specify the format of the input file. Valid types are
.I m
for Madurai and
.I t
for Tamil. Default is
.I m.
.TP
.B \-to type
Specify the desired format of the output file or
the printer command. Valid
types are
.I m
for Madurai,
.I t
for Tamil and
.I p
for PostScript. Default is the printer command "lpr".
.SH EXAMPLES
To print a Madurai file:
.IP
tamil file.mdu
.LP
To print a Madurai file on the printer hagar_l1:
.IP
tamil -to "lpr -Phagar_l1" file.mdu
.LP
To convert a Madurai file to Tamil file:
.IP
tamil -to t file.mdu file.tamil
.LP
To convert a Tamil file to Madurai file:
.IP
tamil -from t -to m file.tamil file.mdu
.LP
To print a Tamil file:
.IP
tamil -from t file.tamil
.LP
To convert a Madurai file to a PostScript file:
.IP
tamil -to p file.mdu file.ps
.LP
or
.IP
tamil file.mdu - > file.ps
.SH SEE ALSO
.BR libtamil (3)
.SH COPYRIGHT
(C) 1993 Gnanasekaran Swaminathan

Permission is granted to distribute
.B tamil
in source and binary forms at your own risk as long
as the above copyright notice and this permission notice
are also included in your distribution.
.SH ACKNOWLEDGEMENT
.LP
Madurai transliteration scheme was invented by
Bala Swaminathan <bala@wucs1.wustl.edu>
.LP
PostScript is a registered trade mark of Adobe Systems, Inc.
.LP
Badrinarayanan Seshadri <badri@sofia.tn.cornell.edu> sent
a bug report for an earlier version of
.B tamil.
.SH BUG REPORTS
Send all the bug reports to the author Gnanasekaran Swaminathan
<gs4t@virginia.edu>.
