/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no
representations about the suitability of this software for any purpose.  It
is provided "as is" without express or implied warranty.

*/

static char aliases_rcsid[]="$Id: aliases.c,v 1.9 92/09/30 13:47:53 bobo Exp $";

#include <stdio.h>
#include <X11/Xos.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include "defs.h"

extern char EOT_FLAG[];
extern Display *dpy;
extern char cmd_buff[];
extern int mail_out;




struct alias_ent {
	char *alias;
	char *exp;
	int current_len;
	struct alias_ent *next;
} *alias_tab=(struct alias_ent *)0;

int remote_address;


/*
 * This is implemented as a stack.
 * each layer will grab a token, call expand_alias
 * The caller is responsible for freeing the pointer passed
 * to it.  The loop string is passed to indicate what the original
 * string is therefore preventing a possible alias loop.
 */
char *
expand_alias(st,lev,loop)
char *st,*loop;
int lev;
{
struct alias_ent *alias_ptr;
char *addr;
char *exp,*tmp1_exp,*tmp2_exp,*tmp_exp,*tmp_addr;
int expand_flag=1,comma_flag=0;



	exp=(char *)malloc(1);
	strcpy(exp,"");

	if(lev>10)
	{
		warn("alias level > 10.\nThis is a possible alias loop.");
		return(exp);
	}

	/*
	 * grab a token
	 */
	addr=strtok(st," \t\n");


	if(addr==NULL)
		return(exp);

	/*
	 * This really sucks.  It is left to the responsibility
	 * of the user to do the right thing with commas.  If there
	 * is a comma, we'll put one at the end of the expanded
	 * address.  That is... if given an address of the form
	 *  "addr1, addr2" where addr1 expands to alias1, we'll expand
	 * the address to "alias1, addr2"  It is left to the user to
	 * make sure that alias1 contains the correct commas and spaces.
	 */
	if(addr[strlen(addr)-1]==',')
	{
		comma_flag=1;
		addr[strlen(addr)-1]=(char)0;
	}
		
	/*
	 * addresses that are enclosed in brackets, braces, and parens,
	 * are to be left alone.
	 */
	if(strchr("{[<(",(int)addr[0])!=NULL)
	{
		expand_flag=0;
		for(;;tmp_addr=strtok(NULL," \t\n"))
		{
			if(addr[strlen(addr)-1]==',')
			{
				if(strchr("}]>)",
					(int)addr[strlen(addr)-2]) != NULL)
					break;
			}
			else
			{
				if(strchr("}]>)",
					(int)addr[strlen(addr)-1]) != NULL)
					break;
			}

			addr[strlen(addr)]=' ';
		}
	}


	/*
	 * got one token.  Expand the rest of the line
	 */
	tmp1_exp=expand_alias((char *)NULL,lev,loop);

	alias_ptr=(struct alias_ent *)0;
	if(expand_flag && (strcmp(loop,addr)!=0))
	{
		/*
		 * find this addr in the alias table.
		 */
		for(alias_ptr=alias_tab;
				alias_ptr!=(struct alias_ent *)0;
				alias_ptr=alias_ptr->next)
		{
			if(strcmp(alias_ptr->alias,addr)==0)
				break;
		}
	}
	/*
	 * this alias is in the alias table.
	 * Expand it... if necessary.
	 */
	if(alias_ptr!=(struct alias_ent *)0)
	{
		tmp_exp=(char *)malloc(strlen(alias_ptr->exp)+1);
		strcpy(tmp_exp,alias_ptr->exp);
		tmp2_exp=expand_alias(tmp_exp,lev+1,addr);
		free(tmp_exp);
	}
	else
	{
		/*
		 * not in the alias table.  This is a pure
		 * address.  use it as is.
		 */
		tmp2_exp=(char *)malloc(strlen(addr)+1);
		strcpy(tmp2_exp,addr);
	}

	exp=(char *)realloc(exp,strlen(tmp1_exp)+strlen(tmp2_exp)+3);

	strcpy(exp,tmp2_exp);
	if(comma_flag)
		strcat(exp,",");

	if(strlen(tmp1_exp)!=0)
	{
		strcat(exp," ");
		strcat(exp,tmp1_exp);
	}
	free(tmp1_exp);	
	free(tmp2_exp);	

	return(exp);
}

void
free_aliases()
{
struct alias_ent *alias_ptr;
struct alias_ent *alias_tmp;

	for(alias_ptr=alias_tab;
		alias_ptr != (struct alias_ent *)0;
		alias_ptr = alias_tmp)
	{
		free(alias_ptr->alias);
		free(alias_ptr->exp);
		alias_tmp=alias_ptr->next;
		free(alias_ptr);
	}

	alias_tab=(struct alias_ent *)0;
}

#define LINE_LENGTH 5024
void
get_aliases()
{
struct alias_ent *alias_tmp,*alias_ptr;
static char *alias_line_buff=(char *)0;
char *exp;
int exp_len,exp_index;
static alias_line_len=2024;

	/*free_aliases();*/

	if(alias_line_buff==(char *)0)
	{
		alias_line_buff=(char *)malloc(alias_line_len);
	}

	/*
	 * tell mail to tell us about aliases.
	 */
	sprintf(cmd_buff,"alias\n");
	mail_cmd();

	for(;;)
	{
		if(readln(mail_out,alias_line_buff,alias_line_len)==-1)
		{
			perror("readln");
			say_good_bye();
		}

		if(strcmp(alias_line_buff,EOT_FLAG)==0)
			break;

		alias_tmp=(struct alias_ent *)malloc(sizeof(struct alias_ent));

		/*
		 * this code looks pretty darned stupid.  But... if the user pushes the
		 * mailrc button, the aliases will grow incredably in size.  This will
		 * prevent that from happening (at least for xmailtool).  There is
		 * a limit to the size of an alias.
		 */

		/*
		 * mail will separate the alias name from the actual alias by either a space
		 * or a tab or both.
		 */
		exp=strpbrk(alias_line_buff," \t");
		exp[0]=(char)0;

		/*
		 * unfortunatly some mail programs will put extra spaces or tabs between
		 * the alias name and the acual alias.  This strips that out.
		 */
		for(exp++;(exp[0]==' ') || (exp[0]=='\t'); exp++);

		/*
		 * pretend that we are starting with a new alias.
		 */
		alias_tmp->exp=(char *)malloc(strlen(exp)+1);
		strcpy(alias_tmp->exp,exp);
		alias_tmp->current_len=strlen(exp);
		alias_tmp->alias=(char *)malloc(strlen(alias_line_buff)+1);
		strcpy(alias_tmp->alias,alias_line_buff);

		/*
		 * if the alias already exists we need to just copy
		 * the new version of the alias.
		 */
		for(alias_ptr=alias_tab;
			alias_ptr != (struct alias_ent *)0;
			alias_ptr = alias_ptr->next)
		{
			if(strcmp(alias_ptr->alias,alias_tmp->alias)==0)
			{
				free(alias_ptr->exp);
				exp_len=strlen(exp);
				alias_ptr->exp=(char *)malloc(exp_len -
						alias_ptr->current_len +1);

				/*
				 * the new part of the alias will probably have
				 * a space and/or commas separating it from the
				 * old version.  The new version is first in this
				 * string.
				 */
				exp[exp_len-alias_ptr->current_len]=(char)0;
				for(exp_index=exp_len-alias_ptr->current_len -1;
					(exp[exp_index]==' ') ||
					 (exp[exp_index]==','); exp_index--)
				{
					exp[exp_index]=(char)0;
				}
				alias_ptr->current_len=exp_len;
				strcpy(alias_ptr->exp,
					exp);
				if(exp_len+strlen(exp) > alias_line_len)
				{
					alias_line_len+=exp_len;
					alias_line_buff=(char *)realloc(alias_line_buff,alias_line_len);
					if(alias_line_buff==(char *)0)
					{
						warn("can't realloc() more alias line space.  Restart XMailTool.");
					}
				}
				free(alias_tmp->exp);
				free(alias_tmp->alias);
				free(alias_tmp);
				alias_tmp=(struct alias_ent *)0;
				break;
			}
		}

		if(alias_tmp!=(struct alias_ent *)0)
		{
			alias_tmp->next=alias_tab;
			alias_tab=alias_tmp;
		}

	}
}


exp_addrs(f)
char *f;
{
	char *new_file;
	int exp_fd,old_fd,nread;
	char line_buff[1024];
	char *tmp_ptr;
	int doing_header=0;

	if((old_fd=open(f,O_RDONLY))==-1)
	{
		perror(f);
		warn("Couldn't open Out Bond Message file\n");
		XBell (dpy, 10);
		XFlush(dpy);
		return;
	}
		
	new_file=(char *)malloc(50);
	strcpy(new_file,"/tmp/XMTeXXXXXX");

	if((exp_fd=mkstemp(new_file))==-1)
	{
		warn("Couldn't create Out Bound message file\n");
		XBell (dpy, 10);
		XFlush(dpy);
		free(new_file);
		return;
	}

	/*
	 * we start with the assumtion of a local address.
	 */
	remote_address=0;

	/*
	 * read header stuff.
	 */
	for(;;)
	{
		if(readln(old_fd,line_buff,1024)==-1)
		{
			warn("Couldn't read Out Bound Message file\n");
			XBell (dpy, 10);
			XFlush(dpy);
			free(new_file);
			return;
		}

		if(strcmp(line_buff,"")==0)
		{
			/*
			 * this is the first empty line.  That means there's
			 * no more header stuff.
			 */
			break;
		}

		if(line_buff[0]!=' ')
			doing_header=0;
	

		/*
		 * if the line contains a colon, then it is a header line
		 */
		if((tmp_ptr=strchr(line_buff,':'))!=(char *)0)
		{
	
			*tmp_ptr=(char)0;
			if(strcasecmp(line_buff,"to") == 0 ||
				strcasecmp(line_buff,"cc") == 0 ||
				strcasecmp(line_buff,"bcc") == 0)
			{
				write(exp_fd,line_buff,strlen(line_buff));
				write(exp_fd,":",1);
				doing_header=1;
				strcpy(line_buff,&tmp_ptr[1]);
			}
			else
			{
				*tmp_ptr=':';
				doing_header=0;
			}
			
		}



		/*
		 * at this point either we have a full header line, part
		 * of an ADDR header line, or a continuation of a header
		 * line in line_buff.  If it is "part" of an ADDR line, it
		 * will look just like a continued ADDR line.
		 */
		if(doing_header)
		{
			tmp_ptr=expand_alias(line_buff,0,"");
			if(strlen(tmp_ptr)==0)
				doing_header=0;
			else
				write(exp_fd," ",1);
			write(exp_fd,tmp_ptr,strlen(tmp_ptr));
			write(exp_fd,"\n",1);
			free(tmp_ptr);
		}
		else
		{

			write(exp_fd,line_buff,strlen(line_buff));
			write(exp_fd,"\n",1);
		}

	}

	/*
	 * we are done expanding the header data.  The only thing to do
	 * now is to copy the rest of the message.
	 */
	write(exp_fd,"\n",1);

	for(;;)
	{
		if((nread=read(old_fd,line_buff,1024))<1)
			break;

		if(write(exp_fd,line_buff,nread)==-1)
		{
			perror(f);
			warn("Couldn't write expansion file\n");
			XBell (dpy, 10);
			XFlush(dpy);
			free(new_file);
			return;
		}

	}


	/*
	 * close every thing.  Move the new file in to the
	 * old file, and free any data.
	 */

	close(old_fd);
	close(exp_fd);
	unlink(f);
	link(new_file,f);
	unlink(new_file);
	free(new_file);
}


