/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in 
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no 
representations about the suitability of this software for any purpose.  It 
is provided "as is" without express or implied warranty.

*/

static char check_mail_rcsid[]="$Id: check_mail.c,v 1.11 92/10/02 10:35:39 bobo Exp $";

#include <X11/Xlib.h>			/* for Xlib definitions */
#include <stdio.h>
#include <X11/cursorfont.h>		/* for cursor constants */
#include <X11/StringDefs.h>		/* for useful atom names */
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <sys/stat.h>

#include <pwd.h>			/* for getting username */

#include "check_mail.h"
#include "defs.h"
#include "newmail.icon"
#include "oldmail.icon"
#include "nomail.icon"

#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))


extern Widget mail_msg;
extern int interval;
static void GetMailFile();
static void check_mailbox();
static void beep();
Boolean is_iconic=True;

char *system_mbox_fname;
static long last_size;
static struct stat stb;
int mail_state;
Pixmap mbox_pix[3];
extern Widget toplevel;
extern XtAppContext my_app_con;
extern char *expand_fname();


/* ARGSUSED */
static XtTimerCallbackProc
#if NeedFunctionPrototypes
mail_timeout(caddr_t c, XtIntervalId *i)
#else
mail_timeout(c,i)
caddr_t c;
XtIntervalId *i;
#endif
{

	XtAppAddTimeOut(my_app_con,(long)1000 * interval,
		(XtTimerCallbackProc)mail_timeout,
		(XtPointer)0);
	check_mailbox();
	return(NULL);
	
}

void
init_mbox(dpy)
Display *dpy;
{
	/*
	 * find mailbox
	 */
	GetMailFile();

	/*
	 * Create pixmaps for Icon
	 */
	mbox_pix[NEW_MAIL] = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),newmail_bits,
				newmail_width,newmail_height);
	mbox_pix[OLD_MAIL] = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),oldmail_bits,
				oldmail_width,oldmail_height);
	mbox_pix[NO_MAIL] = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),nomail_bits,
				nomail_width,nomail_height);
	XFlush(dpy);

	check_mailbox();

	/*
	 * setup timer routine
	 */
	XtAppAddTimeOut(my_app_con,(long)1000 * interval,
		(XtTimerCallbackProc)mail_timeout,
		(XtPointer)0); 
}

static void GetMailFile();

static void
update_mbox_icon()
{
	Arg arg[1];
	if(toplevel==0)
		return;
	arg[0].name=XtNiconPixmap;
	arg[0].value=(XtArgVal)mbox_pix[mail_state];
	XtSetValues(toplevel,arg,1);
	XFlush(XtDisplay(toplevel));
}

static void 
check_mailbox ()
{
	extern warn();
	int	CurrentState;
	int ret;
	char *tmp_file_name;

	tmp_file_name=expand_fname(system_mbox_fname);
	ret=stat(tmp_file_name, &stb);
	free(tmp_file_name);

	if( ret == -1 )
		CurrentState = NO_MAIL;
	else if(stb.st_size == 0)
		CurrentState = NO_MAIL;
	else if(stb.st_mtime >= stb.st_atime)
		CurrentState = NEW_MAIL;
	else
		CurrentState = OLD_MAIL;
		

        if (mail_state != CurrentState) {
                mail_state = CurrentState;
		update_mbox_icon();
       }
        if (CurrentState == NEW_MAIL &&
			 stb.st_size != last_size) {
		if(mail_msg!=0)
			warn("You have 'New Mail' in your system mail box.");
		beep(toplevel);
        }
        /* update file size */
        last_size = stb.st_size;

    return;
} /* end CheckMail() */


/*
 * get user name for building mailbox
 */

static void GetMailFile ()
{
	char *getlogin();
	char *username;
	uid_t getuid();
	struct passwd *pw;
	extern char *resource_mbox_fname;

	username = getlogin ();

	if (!username)
	{
		pw = getpwuid (getuid ());

		if (!pw)
		{
			fprintf(stderr,
				"%s:  unable to find a username for you.\n",
				"GetMailboxFileName");
		}
		username = pw->pw_name;
   	}

	system_mbox_fname = (String)malloc(
		strlen(MAILBOX_DIRECTORY) + 1 + strlen(username) + 1);
	strcpy (system_mbox_fname, MAILBOX_DIRECTORY);
	strcat (system_mbox_fname, "/");
	strcat (system_mbox_fname, username);

    return;
}



/* ARGSUSED */
static void beep (w)
    Widget w;
{
extern Display *dpy;
extern int bell;
int bell_count;

	for(bell_count=0; bell_count < bell ; bell_count ++)
	{
  		XBell (dpy, 10);
		XFlush(dpy);
	}

    return;
}



/* ARGSUSED */
XtEventHandler
#if NeedFunctionPrototypes
map_handler(Widget w,caddr_t c,XEvent *e)
#else
map_handler(w,c,e)
Widget w;
caddr_t c;
XEvent *e;
#endif
{
extern show_tool();
extern park_mail();

	switch(e->type) {
	case MapNotify:

		/*
		 * if it's already a tool, we ignore
		 * multiple MapNotifies.
		 */
		if(!is_iconic)
			break;

		/*
		 * going from icon to tool.
		 */
		show_tool();
		is_iconic=False;
		break;
	case UnmapNotify:

		/*
		 * if it's already an Icon, we ignore
		 * multiple UnmapNotifies.
		 */
		if(is_iconic)
			break;
		/*
		 * going from tool to icon.
		 */
		park_mail();
		is_iconic=True;
		break;
	default:
		/*
		 * must be some other event...
		 * we don't care about them.
		 */
		break;
	}

	return(0);
}
