/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in 
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no 
representations about the suitability of this software for any purpose.  It 
is provided "as is" without express or implied warranty.

*/

static char proc_rcsid[]="$Id: proc.c,v 1.54 92/10/05 15:36:04 bobo Exp $";

#include <stdio.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/List.h>
#include <X11/Shell.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/errno.h>
#include <fcntl.h>
#include "defs.h"

#include <sys/stat.h>


#define min(a,b) ((a)<(b) ? (a) : (b))

extern Cursor watch_cur,norm_cur;
extern int errno;
extern int debug;
extern find_line();
extern Widget command_button();
extern Widget text_label();
extern look_at_line();
extern struct msg_header *header_list,*del_list, *cur_msg;
extern int mail_out,mail_in;
extern char *get_headers(),  *get_data(),file_fname[],pwd[];
extern do_signature;
extern char msg_fname[];

extern char file_name[50];
extern char dir_name[50];

extern int current_msg;
extern int num_headers;	/* the number of the header with the highest number */
extern int header_count;	/* the number of active headers */
extern int header_index;
extern int header_right,header_left;	

extern Display *dpy;
extern Window win;
extern Arg place_arg[];

extern Widget toplevel;
extern Widget icon,replywidg,helpsw;

extern Widget deliver_item,cancel_item,cd_item,reply_item,done_item,command_button();
extern Widget next_item,show_item,del_item,undel_item,print_item,text_label();
extern Widget quit_item,abort_item,mailrc_item,pre_item,copy_item,aboutsw;
extern Widget save_item,folder_item,nmail_item,comp_item,mail_msg;

extern Widget header_box,cmd_box,msg_box,box,replysw,cmd_box1,rtsf;

extern Widget  file_item, dir_item, do_folder_item, do_save_item, filesw,
			dirsw,file_cmd_box,dir_cmd_box,file_name_item;

Window root,child;
int win_x,win_y,root_x,root_y;
unsigned int keys;

static char tmp_buff[MAXMESLEN];
extern int in_fd[],out_fd[];
extern int pid;
extern char cmd_buff[];

void
center_wig_on_pointer(w)
Widget w;
{
XtWidgetGeometry my_geom;


	XQueryPointer(dpy,win,&root,&child,(int *)&root_x,
			(int *)&root_y,&win_x,&win_y,&keys);

	XtQueryGeometry(w,NULL,&my_geom);

	place_arg[0].value=(XtArgVal) root_x - 
				(my_geom.width/2 + my_geom.border_width);
	place_arg[1].value=(XtArgVal) root_y - 
				(my_geom.height/2 + my_geom.border_width);
	XtSetValues(w,place_arg,2);
}

int pointer_state;

/* ARGSUSED */
void
state_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern Cursor del_cur,save_cur,pres_cur,show_cur;

	if((int)callData == 1)
	{
		pointer_state=(int)closure;
		switch(pointer_state) {
		case 0:
			chang_cursor(header_box,show_cur);
			break;
		case 1:
			chang_cursor(header_box,del_cur);
			break;
		case 2:
			chang_cursor(header_box,save_cur);
			break;
		case 3:
			chang_cursor(header_box,pres_cur);
			break;
		}
	}
	

	return;

}

/* ARGSUSED */
void
next_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{

	if(callData==(char *)0 || strcmp(callData,"next")==0)
	 	next_msg();
	else if(strcmp(callData,"prev")==0)
		prev_msg();
	else
	{
		warn("not a valid command\n");
		return;
	}

	refresh_headers(0);

	if(header_list == (struct msg_header *)0)
	{
		XtSetSensitive(next_item,False);
		XtSetSensitive(del_item,False);
		XtSetSensitive(reply_item,False);
		XtSetSensitive(print_item,False);
		XtSetSensitive(save_item,False);
	}

	if(debug)
		pr_msg_list();
}

/* ARGSUSED */
void
help_proc(widget,closure,callData)
	Widget widget;
	caddr_t closure;
	caddr_t callData;
{
extern Atom      wm_delete_window;
	XtPopup(helpsw,XtGrabNone);
	(void) XSetWMProtocols(dpy, XtWindow(helpsw),
			&wm_delete_window, 1);

}

/* ARGSUSED */
void
about_proc(widget,closure,callData)
	Widget widget;
	caddr_t closure;
	caddr_t callData;
{
extern char *ABOUT_STRING;
extern Atom      wm_delete_window;

	warn(ABOUT_STRING);
	/*center_wig_on_pointer(aboutsw);*/
	XtPopup(aboutsw,XtGrabNone);
	(void) XSetWMProtocols(dpy, XtWindow(aboutsw),
			&wm_delete_window, 1);
}

/* ARGSUSED */
void
del_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{

	delete_msg();
	if(del_list != (struct msg_header *)0)
		XtSetSensitive(undel_item,True);

	refresh_headers(0);

	if(header_list == (struct msg_header *)0)
	{
		XtSetSensitive(next_item,False);
		XtSetSensitive(del_item,False);
		XtSetSensitive(reply_item,False);
		XtSetSensitive(print_item,False);
		XtSetSensitive(save_item,False);
	}

	if(debug)
		pr_msg_list();
}


/* ARGSUSED */
void
undel_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{

	undelete_msg();
	if(header_list != (struct msg_header *)0)
	{
		XtSetSensitive(next_item,True);
		XtSetSensitive(del_item,True);
		XtSetSensitive(reply_item,True);
		XtSetSensitive(save_item,True);
		XtSetSensitive(print_item,True);


	}
	refresh_headers(0);

	if(del_list == (struct msg_header *)0)
		XtSetSensitive(undel_item,False);

	if(debug)
		pr_msg_list();
}


/* ARGSUSED */
void
cancel_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
	XtPopdown((Widget)closure);
	XtSetSensitive(cmd_box,True);

}

/* ARGSUSED */
void
preserve_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
XawTextPosition left,right;
XawTextBlock text;
char c1,stuff[3];
Widget my_source;

	preserve_msg();
	XawTextGetSelectionPos(header_box,&left,&right);
	my_source=XawTextGetSource(header_box);
	left=XawTextSourceScan(my_source,left,XawstEOL,XawsdLeft,1,False);
	if(read_header_text(my_source,left,&c1,1)==0)
		return;

	strcpy(stuff,"P");
	text.firstPos=0;
	text.ptr=stuff;
	text.length=1;

	XawTextReplace(header_box,left+1,left+2,&text);
}

/* ARGSUSED */
void
save_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
Widget my_source;
XawTextPosition left,right;
XawTextBlock text;
char c1,stuff[3];


	
	if((callData!=(caddr_t)0) && (strcmp(callData,"Save")==0))
	{
		if(save_msg("",callData)==-1)
		return;
	}
	else
	{
		if(save_msg(file_fname,callData)==-1)
			return;
	}

	XawTextGetSelectionPos(header_box,&left,&right);
	my_source=XawTextGetSource(header_box);
	left=XawTextSourceScan(my_source,left,XawstEOL,XawsdLeft,1,False);
	if(read_header_text(my_source,left+1,&c1,1)==0)
		return;

	if(c1!='P')
	{
		strcpy(stuff,"*");
		text.firstPos=0;
		text.ptr=stuff;
		text.length=1;

		XawTextReplace(header_box,left+1,left+2,&text);
	}

}


/* ARGSUSED */
void
print_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
int fd,pr_pid,print_fd[2],nread;
extern char *SHELL;
extern char msg_fname[],*print_cmd;
char *PRINTER,*message, *getenv();
char line_buff[1024];

	if((fd=open(msg_fname,O_RDONLY))==-1)
	{
		perror("open(message file)");
		warn("couldn't open message file");
			XBell (dpy, 10);
			XFlush(dpy);
		return;
	}

	if ((PRINTER=(char *)getenv("PRINTER")) == NULL)
	{
		PRINTER="";
 	}

	if(pipe(print_fd)==-1)
	{
		perror("Can't create printer pipe");
		warn("Can't create printer pipe\n");
		return;
	}

	if((pr_pid=fork())==0)
	{
		close(0);
		close(1);
		close(2);
		close(print_fd[0]);
		dup(fd);
		dup(print_fd[1]);
		dup(print_fd[1]);
		execlp(SHELL,SHELL,"-c",(callData==0?print_cmd:callData),
					(char *)0);

	}
	if(pr_pid==-1)
	{
		warn("Couldn't start printing proccess.  Sorry.");
			XBell (dpy, 10);
			XFlush(dpy);
		return;
	}
	close(fd);
	close(print_fd[1]);
	message=(char *)malloc(256);
	strcpy(message, "Sent message to printer ");
 	strcat(message, PRINTER);
	strcat(message," using \"");
	strcat(message,(callData==0?print_cmd:callData));
	strcat(message,"\"");
 	strcat(message, ".\nPrinter Output:\n");
	
	for(;;)
	{
		nread=read(print_fd[0],line_buff,1023);
		if(nread<1)
			break;
		line_buff[nread]=(char)0;
		message=(char *)realloc(message,strlen(message)+nread+1);
		strcat(message,line_buff);
	}
	close(print_fd[0]);
		
	warn(message);
	free(message);

}

/* ARGSUSED */
void
nmail_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{

	change_mail_file("%",False,"system mail box");
	return;
}

/* ARGSUSED */
void
done_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern char dbox_fname[];
extern void park_mail();
Status make_iconic;
extern Boolean is_iconic;

	chang_cursor(toplevel,watch_cur);
	
	make_iconic = XIconifyWindow(
		XtDisplay(toplevel),
		XtWindow(toplevel),
		DefaultScreen(XtDisplay(toplevel)));

	XFlush(XtDisplay(toplevel));

	if(make_iconic == 0)
	{
		warn("Unable to iconify");
			XBell (dpy, 10);
			XFlush(dpy);
		/* No Vallet parking.  We'll have to park it our selves. */
		park_mail();
		is_iconic=True;
	}


	chang_cursor(toplevel,norm_cur);
	

}


/* ARGSUSED */
void
outbound_cancel(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
struct outbound_msg *parm;


	parm=(struct outbound_msg *)closure;
	warn("Outbound message has not been sent.");
	XtPopdown(parm->box);
	XtDestroyWidget(parm->box);
	unlink(parm->file);
	free(parm->file);
	free(parm);
}

int
creat_outbound(reply_file,ins,t)
char *reply_file,*t;
int ins;
{
struct outbound_msg *parm;
Widget reply_vpane,reply_cmd_box;
void deliver_proc();
extern Pixmap envelope;
extern char *EDITOR;
extern int edit_needs_xterm;
int edit_pid;
extern struct proc_msg *pptr_last,*pptr_first;
struct proc_msg *pptr_tmp;
struct stat buff;
char DISPLAY_STRING[100];
extern char *SHELL;
char *EDIT_STRING;
static Arg shell_arg[2];
extern Atom wm_delete_window;
static Arg file_arg[] = {{XtNstring,(XtArgVal)0},
		{XtNtype,(XtArgVal)XawAsciiFile},
		{XtNeditType,(XtArgVal)XawtextEdit},
		{XtNinsertPosition,(XtArgVal)0},
		{XtNdisplayPosition,(XtArgVal)0},
};


	if((EDITOR!=(char *)0) && strcmp(EDITOR,"none")!=0)
	{
		if((edit_pid=fork())==-1)
		{
			warn("Couldn't Fork editor Process\n");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}

		if(edit_pid==0)
		{

#ifdef SYSV
			sprintf(DISPLAY_STRING,"DISPLAY=%s",
					DisplayString(dpy));

			putenv(DISPLAY_STRING);
#endif
			if(edit_needs_xterm)
			{
				EDIT_STRING=(char *)malloc(strlen(EDITOR)+
						strlen(reply_file)+
						strlen(DisplayString(dpy))+
						strlen(t) + 55);
				sprintf(EDIT_STRING,
	"xterm -display %s -name outbound_msg -T \"%s\" -e %s %s",
					DisplayString(dpy),
					t,EDITOR,reply_file);
				execlp(SHELL,SHELL,"-c",EDIT_STRING,0L);
/*				execlp("xterm","xterm",
					"-display",DisplayString(dpy),
					"-name","outbound_msg",
					"-T",t,"-e",EDITOR,reply_file,0L); */
			}
			else
			{
				EDIT_STRING=(char *)malloc(strlen(EDITOR)+
						strlen(reply_file)+2);
				sprintf(EDIT_STRING,"%s %s",EDITOR,reply_file);
				execlp(SHELL,SHELL,"-c",EDIT_STRING,0L);
			}

			perror("Couldn't exec xterm EDITOR");
			XBell (dpy, 10);
			XFlush(dpy);
			exit(1);
		}

		if(edit_pid!=0)
		{
			pptr_tmp=(struct proc_msg *)malloc(
					sizeof(struct proc_msg));
			stat(reply_file,&buff);
			pptr_tmp->mtime=buff.st_mtime;
			pptr_tmp->file=reply_file;
			pptr_tmp->pid=edit_pid;
			pptr_tmp->next=NULL;
			pptr_tmp->box=(Widget)0;
			pptr_tmp->text=(Widget)0;
			if(pptr_first==NULL)
			{
				pptr_first=pptr_tmp;
			}
			else
			{
				pptr_last->next=pptr_tmp;
			}
			pptr_last=pptr_tmp;
			
		}
		return(0);
	}	

	parm=(struct outbound_msg *)malloc(sizeof(struct outbound_msg));
	if(parm == (struct outbound_msg *) 0)
	{
		perror("malloc");
		warn("Can't create param structure for outbound message");
		return(0);
	}

	XtSetArg(shell_arg[0],XtNiconPixmap,envelope);
	XtSetArg(shell_arg[1],XtNtitle,t);
	XtSetArg(file_arg[0],XtNstring,reply_file);
	XtSetArg(file_arg[3],XtNinsertPosition,ins);

	/*
	 * Reply/Compose pop up window.
	 */
	replysw=XtCreatePopupShell("outbound_msg",applicationShellWidgetClass,
		toplevel,shell_arg,2);

	reply_vpane=XtCreateManagedWidget("reply_vpane",panedWidgetClass,
					replysw, NULL, 0);

	reply_cmd_box=XtCreateManagedWidget("reply_cmd_box",boxWidgetClass,
                       	 reply_vpane,NULL,0);

	replywidg=XtCreateManagedWidget("reply",asciiTextWidgetClass,
                        reply_vpane,file_arg,XtNumber(file_arg));

	set_text_columns(replywidg,80);

	parm->box=replysw;
	parm->file=reply_file;
	parm->text=replywidg;

	deliver_item=command_button("send",reply_cmd_box,
			deliver_proc,parm);
	XtInstallAccelerators(replywidg,deliver_item);

	cancel_item=command_button("cancel", reply_cmd_box,
			outbound_cancel,parm);

	XtInstallAccelerators(replywidg,cancel_item);

	XtPopup(replysw,XtGrabNone);

	(void) XSetWMProtocols(dpy, XtWindow(replysw),
			&wm_delete_window, 1);
	return(0);
}

void
confirm_send(reply_file)
char *reply_file;
{
struct outbound_msg *parm;
Widget reply_vpane,reply_cmd_box;
void deliver_proc();
extern Pixmap envelope;
static Arg shell_arg[2];
extern Atom wm_delete_window;
static Arg file_arg[] = {{XtNstring,(XtArgVal)0},
		{XtNtype,(XtArgVal)XawAsciiFile},
		{XtNeditType,(XtArgVal)XawtextEdit},
		{XtNinsertPosition,(XtArgVal)0},
		{XtNdisplayPosition,(XtArgVal)0},
};

	parm=(struct outbound_msg *)malloc(sizeof(struct outbound_msg));
	if(parm == (struct outbound_msg *) 0)
	{
		perror("malloc");
		warn("Can't create param structure for outbound message");
		return;
	}
	XtSetArg(shell_arg[0],XtNiconPixmap,envelope);
	XtSetArg(shell_arg[1],XtNtitle," Confirm ?? ");
	XtSetArg(file_arg[0],XtNstring,reply_file);

	/*
	 * Reply/Compose pop up window.
	 */
	replysw=XtCreatePopupShell("outbound_msg",applicationShellWidgetClass,
		toplevel,shell_arg,2);

	reply_vpane=XtCreateManagedWidget("reply_vpane",panedWidgetClass,
					replysw, NULL, 0);

	reply_cmd_box=XtCreateManagedWidget("reply_cmd_box",boxWidgetClass,
                       	 reply_vpane,NULL,0);

	replywidg=XtCreateManagedWidget("reply",asciiTextWidgetClass,
                        reply_vpane,file_arg,XtNumber(file_arg));

	set_text_columns(replywidg,80);

	parm->box=replysw;
	parm->file=reply_file;
	parm->text=replywidg;

	deliver_item=command_button("send",reply_cmd_box,
			deliver_proc,parm);
	XtInstallAccelerators(replywidg,deliver_item);

	cancel_item=command_button("cancel", reply_cmd_box,
			outbound_cancel,parm);

	XtInstallAccelerators(replywidg,cancel_item);

	XtPopup(replysw,XtGrabNone);

	(void) XSetWMProtocols(dpy, XtWindow(replysw),
			&wm_delete_window, 1);
}


int
put_stuff_in(reply_fd,include_flag,sign_flag)
int include_flag,sign_flag;
{
int msg_fd,count=0;
extern char *mprefix;

	count=include_envelope(reply_fd);

	write(reply_fd,"\n",1);

	tmp_buff[0]=(char)0;

	if(include_flag)
	{	
		strcat(tmp_buff,"---------  Received message begins Here  ---------\n");

		if((msg_fd=open(msg_fname,O_RDONLY))==-1)
		{
			perror("open(message file)");
			warn("Couldn't open message file");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}

		if(write(reply_fd,tmp_buff,strlen(tmp_buff))==-1)
		{
			perror("write(message file)");
			warn("Couldn't write to reply file");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}

		strcpy(tmp_buff,"\n");
		strcat(tmp_buff,mprefix);
		for(;;)
		{
			if(readln(msg_fd,&tmp_buff[strlen(mprefix)+1],
						MAXMESLEN)==0)
				break;

			if(write(reply_fd,tmp_buff,strlen(tmp_buff))==-1)
			{
				perror("write(reply file)");
				warn("Couldn't write to reply file");
				XBell (dpy, 10);
				XFlush(dpy);
				return(-1);
			}
		}
		close(msg_fd);
	}

	if(write(reply_fd,"\n\n",2)==-1)
	{
		perror("write(reply file)");
		warn("Couldn't write reply file");
		XBell (dpy, 10);
		XFlush(dpy);
		return(-1);
	}

	if(sign_flag)
		if(append_signature(reply_fd)==-1)
		{
			perror("write(reply file)");
			warn("Couldn't write reply file");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}
	return(count);
}


/* ARGSUSED */
void
reply_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern int askcc,askbcc,replyall;
extern int asksub,include_msg;
extern char *mprefix;
char stuff[100];
char title[100];
Boolean nosub=True,nocc=True;
int all_flag=0,sign_flag=0,include_flag=0;
int reply_fd,insert_position,count;
char *reply_file,*reply_arg,*reply_cmd;

	if(cur_msg == (struct msg_header *)0)
	{
		warn("no message to reply to\n");
		XBell (dpy, 10);
		XFlush(dpy);
		return;
	}

	sign_flag=do_signature;
	include_flag=include_msg;

	if(callData!=(caddr_t)0)
	{
		reply_arg=strtok((char *)callData," ,-");
		for(;;)
		{
			if(reply_arg==(char *)0)
				break;

			if(strcmp(reply_arg,"all")==0)
				all_flag=1;
			else if(strcmp(reply_arg,"sign")==0)
				sign_flag=1;
			else if(strcmp(reply_arg,"nosign")==0)
				sign_flag=0;
			else if(strcmp(reply_arg,"notsign")==0)
				sign_flag=(!sign_flag);
			else if(strcmp(reply_arg,"include")==0)
				include_flag=1;
			else if(strcmp(reply_arg,"noinclude")==0)
				include_flag=0;
			else if(strcmp(reply_arg,"notinclude")==0)
				include_flag=(!include_flag);
			else
				warn("invalid argument to reply.");

			reply_arg=strtok((char *)0," ,-");
		}
	}

	reply_file=(char *)malloc(50);
	strcpy(reply_file,"/tmp/XMTrXXXXXX");
	if((reply_fd=mkstemp(reply_file))==-1)
	{
		warn("Couldn't create Out Bound message file\n");
		XBell (dpy, 10);
		XFlush(dpy);
		free(reply_file);
		return;
	}


	switch(BSDREPLY) {
	case 1:
		/* reply=all Reply=one */
		if(all_flag)
			reply_cmd="reply";
		else
			reply_cmd="Reply";
		break;
	case 2:
	case 3:
		/* reply=all Reply=one has replyall-variable */
		if(all_flag)
		{
			if(replyall)
				reply_cmd="Reply";
			else
				reply_cmd="reply";
		}
		else
		{
			if(replyall)
				reply_cmd="reply";
			else
				reply_cmd="Reply";
		}
		break;
	case 4:
	case 5:
		/* reply=one Reply=all has replyall-variable */
		if(all_flag)
		{
			if(replyall)
				reply_cmd="reply";
			else
				reply_cmd="Reply";
		}
		else
		{
			if(replyall)
				reply_cmd="Reply";
			else
				reply_cmd="reply";
		}
		break;
	case 6:
		/* reply=one replyall=all has replyall-variable */
		if(all_flag)
		{
			if(replyall)
				reply_cmd="reply";
			else
				reply_cmd="replyall";
		}
		else
		{
			if(replyall)
				reply_cmd="replyall";
			else
				reply_cmd="reply";
		}
		break;
	case 7:
		/* replyall is unaffected by replyall-variable */
		if(all_flag)
		{
			reply_cmd="replyall";
		}
		else
		{
			if(replyall)
				reply_cmd="Reply";
			else
				reply_cmd="reply";
		}
		break;
	}
		
	sprintf(cmd_buff,"%s %d\n",reply_cmd,cur_msg->num);

	if(write(mail_in,cmd_buff,strlen(cmd_buff))==-1)
	{
		perror("write(Mail Pipe)");
		warn("Couldnt' write mail pipe");
		XBell (dpy, 10);
		XFlush(dpy);
		close(reply_fd);
		free(reply_file);
		return;
	}

	sprintf(cmd_buff,"~p\n~q\n");
	if(write(mail_in,cmd_buff,strlen(cmd_buff))==-1)
	{
		perror("write(Mail Pipe)");
		warn("Couldn't write Mail Pipe");
		XBell (dpy, 10);
		XFlush(dpy);
		close(reply_fd);
		free(reply_file);
		return;
	}

	for(;;)
	{
		if(readln(mail_out,stuff,100)==-1)
		{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			close(reply_fd);
			free(reply_file);
			return;
		}
		if(strcmp("Message contains:",stuff)==0)
			break;

		if(strncmp("Unknown command:",stuff,
				strlen("Unknown command:"))==0)
		{
			/*
			 * Something went wrong... This command isn't
			 * supported by this version of mail.
			 * There will be two more lines for the tilde
			 * commands that we tried to perform.
			 */
			warn(stuff);
			if((readln(mail_out,stuff,100)==-1) ||
				(readln(mail_out,stuff,100)==-1))
			{
				perror("Can't read Mail Pipe");
				warn("Can't read Mail Pipe");
			}
			XBell (dpy, 10);
			XFlush(dpy);
			close(reply_fd);
			free(reply_file);
			return;

		}
	}

	tmp_buff[0]=(char)0;

	for(;;)
	{
		if(readln(mail_out,stuff,100)==-1)
		{
			perror("Can't read Mail Pipe");
			warn("Can't read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			close(reply_fd);
			free(reply_file);
			return;
		}


		if(bcmp(stuff,"Subject:",8)==0)
			nosub=False;

		if(bcmp(stuff,"Cc:",3)==0)
			nocc=False;

		if(bcmp(stuff,"(continue)",10)==0)
			break;

		strcat(tmp_buff,stuff);
		strcat(tmp_buff,"\n");
	}

	tmp_buff[strlen(tmp_buff) - 1]=(char) 0;

	if(asksub & nosub)
	{
		strcat(tmp_buff,"Subject:  Reply to your message.\n");
	}

	if(askcc & nocc)
		strcat(tmp_buff,"Cc: \n");

	if(askbcc)
		strcat(tmp_buff,"Bcc: \n");

	/* get interupt message	*/
	for(;;)
	{
		if(readln(mail_out,stuff,100)==-1)
		{
			perror("Can't Read Mail Pipe");
			warn("Can't Read Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			close(reply_fd);
			free(reply_file);
			return;
		}

		if(strcmp(stuff,"Interrupt")==0)
			break;
	}

	if(write(reply_fd,tmp_buff,strlen(tmp_buff))==-1)
	{
		perror("write(reply file)");
		warn("Couldn't write reply file");
		XBell (dpy, 10);
		XFlush(dpy);
		close(reply_fd);
		free(reply_file);
		return;
	}
	insert_position = strlen(tmp_buff) ; 

	if((count=put_stuff_in(reply_fd,include_flag,sign_flag)) == -1)
	{
		free(reply_file);
		close(reply_fd);
		return;
	}

	insert_position+=count;

	close(reply_fd);

	sprintf(title,"Re: %s",cur_msg->data);
	creat_outbound(reply_file,insert_position,title);
}

/* ARGSUSED */
void
gripe_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
int reply_fd;
char *reply_file;
extern char *ABOUT_STRING;

	reply_file=(char *)malloc(50);
	strcpy(reply_file,"/tmp/XMTrXXXXXX");
	if((reply_fd=mkstemp(reply_file))==-1)
	{
		warn("Couldn't create Out Bound message file\n");
		XBell (dpy, 10);
		XFlush(dpy);
		free(reply_file);
		return;
	}


	if(write(reply_fd,GRIPE_MSG,strlen(GRIPE_MSG))==-1)
	{
		perror("write(reply file)");
		warn("Couldn'nt write reply file");
		XBell (dpy, 10);
		XFlush(dpy);
		free(reply_file);
		return;
	}
	if(write(reply_fd,ABOUT_STRING,strlen(ABOUT_STRING))==-1)
	{
		perror("write(reply file)");
		warn("Couldn'nt write reply file");
		XBell (dpy, 10);
		XFlush(dpy);
		free(reply_file);
		return;
	}
	if(do_signature)
		if(append_signature(reply_fd)==-1)
		{
			perror("write(reply file)");
			warn("Couldn't write reply file");
			XBell (dpy, 10);
			XFlush(dpy);
			free(reply_file);
			return;
		}

	close(reply_fd);

	creat_outbound(reply_file,strlen(GRIPE_MSG),"Gripe");
 
}


/* ARGSUSED */
void
compose_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern int askcc,askbcc,do_signature,include_msg;
extern int asksub;
int reply_fd,sign_flag,include_flag;
char *reply_file,*reply_arg;
extern char *mprefix;

	sign_flag=do_signature;
	include_flag=include_msg;

	if(callData!=(caddr_t)0)
	{
		reply_arg=strtok((char *)callData," ,-");
		for(;;)
		{
			if(reply_arg==(char *)0)
				break;

			if(strcmp(reply_arg,"sign")==0)
				sign_flag=1;
			else if(strcmp(reply_arg,"nosign")==0)
				sign_flag=0;
			else if(strcmp(reply_arg,"notsign")==0)
				sign_flag=(!sign_flag);
			else if(strcmp(reply_arg,"include")==0)
				include_flag=1;
			else if(strcmp(reply_arg,"noinclude")==0)
				include_flag=0;
			else if(strcmp(reply_arg,"notinclude")==0)
				include_flag=(!include_flag);
			else
				warn("invalid argument to reply.");

			reply_arg=strtok((char *)0," ,-");
		}
	}
	reply_file=(char *)malloc(50);
	strcpy(reply_file,"/tmp/XMTrXXXXXX");
	if((reply_fd=mkstemp(reply_file))==-1)
	{
		warn("Couldn't create Out Bound message file\n");
		XBell (dpy, 10);
		XFlush(dpy);
		free(reply_file);
		return;
	}


	strcpy(tmp_buff,"To: \n");

	if(asksub)
		strcat(tmp_buff,"Subject: \n");
	if(askcc)
		strcat(tmp_buff,"Cc: \n");
	if(askbcc)
		strcat(tmp_buff,"Bcc: \n");

	write(reply_fd,tmp_buff,strlen(tmp_buff));

	put_stuff_in(reply_fd,(include_flag &&
				 (header_list != (struct msg_header *)0)),
						sign_flag);
	close(reply_fd);

	if(include_flag && (cur_msg != (struct msg_header *)0))
		creat_outbound(reply_file,4,"Forward");
	else
		creat_outbound(reply_file,4,"New Message");

}

/* ARGSUSED */
void
deliver_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
struct outbound_msg *parm;

	parm=(struct outbound_msg *)closure;
	warn("Message has been sent.");
	XawAsciiSave(XawTextGetSource(parm->text));
	if(send_reply(parm->file)==0)
	{
		XtPopdown(parm->box);
		XtDestroyWidget(parm->box);
		unlink(parm->file);
		free(parm->file);
		free(parm);
	}
}



/* ARGSUSED */
void
mailrc_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern char *MAILRC,*folder,*PWD;

	if(MAILRC==(char *)0)
		MAILRC="~/.mailrc";

	sprintf(cmd_buff,"source %s\n",MAILRC);
	mail_cmd();

	get_info(mail_out,tmp_buff,MAXMESLEN);
	warn(tmp_buff);
	get_vars();

	/*
	 * get mails working directory and lets go there.
	 */
	get_cwd(pwd);
	chdir(pwd);
	refresh_dir(pwd);

	init_saved_fnames();

	XtSetSensitive(folder_item,(folder==(char *)0?False:True));
}

/* ARGSUSED */
void
rtsf_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
	XtPopdown((Widget)closure);
	XFlush(dpy);
	XtSetSensitive(cmd_box,True);
	XtSetSensitive(rtsf,False);

	nmail_proc(widget,closure,callData);
}

/* ARGSUSED */
void
folder_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
int change_flag=0,save_flag=0,load_flag;
char *tok_ptr,*ptr;
char buff[200];
extern Widget lst_list,list_folder;
extern char fdirname[],*fnames[];
extern int use_folders_cmd;
struct stat st;
static Arg arglist[]={{XtNlabel,(XtArgVal) 0}};
static Arg farglist[]={{XtNstring,(XtArgVal) file_fname}};
myListReturnStruct *item = (myListReturnStruct *)callData;
Widget my_source;
XawTextPosition left,right;
XawTextBlock text;
char c1,stuff[3];
extern char *folder;
	


	sprintf(buff,"%s/%s/%s",folder,fdirname,item->string);
	if(stat(buff,&st)==-1)
	{
		perror(buff);
	}
	/*
	 * by default, the selection of a file will cause
	 * that file to be loaded.
	 */
	load_flag=1;
	if(((st.st_mode&S_IFMT)!=S_IFDIR ) &&(item->data != (caddr_t) 0))
	{

		change_flag=0;
		save_flag=0;
		load_flag=0;
		for(tok_ptr=strtok((char *)item->data," ,;.")
			;tok_ptr!=(char *)0;
			tok_ptr=strtok((char *)0," ,;."))
		{
			if(strcasecmp("change",tok_ptr)==0)
			{
				change_flag=1;
			}
			else if((strcasecmp("save",tok_ptr)==0) && 
				(cur_msg != (struct msg_header *)0))
			{
				save_flag=1;
			}
			else if(strcasecmp("load",tok_ptr)==0)
			{
				load_flag=1;
			}
			else
			{
				sprintf(buff,"%s is an invalid command",
					tok_ptr);
				warn(buff);
			}
		}
	}

	if((use_folders_cmd) || ((st.st_mode&S_IFMT)!=S_IFDIR ))
	{
		XtPopdown((Widget)closure);
		XFlush(dpy);
		XtSetSensitive(cmd_box,True);
		XtSetSensitive(rtsf,True);

		if(strlen(fdirname)!=0)
			sprintf(buff,"+%s/%s",fdirname,item->string);
		else
			sprintf(buff,"+%s",item->string);

		if(save_flag)
		{
			if(save_msg(buff,"save")!=-1)
			{
				XawTextGetSelectionPos(header_box,
								&left,&right);
					my_source=XawTextGetSource(header_box);
					left=XawTextSourceScan(my_source,
						left,XawstEOL,XawsdLeft,
						1,False);
				if(read_header_text(my_source,left+1,&c1,1)!=0)
				{
					if(c1!='P')
					{
						strcpy(stuff,"*");
						text.firstPos=0;
						text.ptr=stuff;
						text.length=1;

						XawTextReplace(header_box,
							left+1,left+2,&text);
					}
				}
			}
		}

		if(load_flag)
		{
			change_mail_file(buff,True,"mail file");
		}

		if(change_flag)
		{
			strcpy(file_fname,buff);
			XtSetValues(file_name_item,farglist,1);
			XFlush(dpy);
		}
	}
	else
	{
		if((strcmp("../",item->string)==0) &&
					 (strlen(fdirname)!=0))
		{
			ptr=strrchr(fdirname,'/');
			if(ptr==(char*)0)
				fdirname[0]=(char)0;
			else
				*ptr=(char)0;
		}
		else
		{
			item->string[strlen(item->string)-1]=(char)0;
			if(strlen(fdirname)!=0)
				strcat(fdirname,"/");
			strcat(fdirname,item->string);
		}
		if(strlen(fdirname)==0)
			strcpy(buff,folder);
		else
			sprintf(buff,"%s/%s",folder,fdirname);

		warn("Building Folder list");
		get_dir(buff,(strlen(fdirname)!=0?1:0));
		warn("Done Building Folder list");
		arglist[0].value=(XtArgVal) buff;
		XtSetValues(list_folder,arglist,1);
		XawListChange(lst_list,fnames,0,0,True);
		XFlush(dpy);
	}

}

/* ARGSUSED */
void
saved_fn_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
extern int current_sf_index,num_saved_fnames;
extern char **saved_fnames;
static Arg arglist[]={{XtNstring,(XtArgVal) file_fname}};

	if(num_saved_fnames==0)
		return;
	current_sf_index=(current_sf_index+1) % num_saved_fnames;
	if(saved_fnames[current_sf_index]==(char *)0)
		current_sf_index=0;
	strcpy(file_fname,saved_fnames[current_sf_index]);
	XtSetValues(file_name_item,arglist,1);
	XFlush(dpy);

}

/* ARGSUSED */
void
file_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
char buff[100];


	sprintf(buff,"%s",file_fname);

	change_mail_file(buff,True,"mail file");
}

/* ARGSUSED */
void
cd_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
char cd_buff[500];
	warn("Changing Directory.  -- Please Wait --");
	sprintf(cmd_buff,"cd %s\n",pwd);
	XFlush(dpy);
	mail_cmd();
	get_info(mail_out,cd_buff,500);

	
	get_cwd(pwd);
	chdir(pwd);
	refresh_dir(pwd);
	/*  
	 *  Setting the directory string to pwd  isn't necesary.
	 *  It might be a good Idea if there is a problem with the cd command
	 *  but I think it's nicer to leave it alone.
	 */
	warn(cd_buff);
}


/* ARGSUSED */
void
quit_proc(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{	
	clean_up();
	if((callData==(caddr_t)0) || (strcmp(callData,"quit")==0))
		sprintf(cmd_buff,"quit\n");
	else  if(strcmp(callData,"abort")==0)
	{
		sprintf(cmd_buff,"x\n");
	}
	else
	{
		warn("Unknown Command");
		return;
	}

	mail_cmd();
	exit(0);
}


