/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in 
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no 
representations about the suitability of this software for any purpose.  It 
is provided "as is" without express or implied warranty.

*/

static char xmailtool_rcsid[]="$Id: xmailtool.c,v 1.69 92/10/02 11:44:22 bobo Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Shell.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/ListP.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <errno.h>
#include <sys/param.h>

#ifndef X_NOT_POSIX
#include <unistd.h>
#else
extern char *getcwd();
#endif


#ifdef CRAY
#include <fcntl.h>
#endif


#include <sys/stat.h>

#include "defs.h"
#include "patchlevel.h"

#include "envelope.xbm"

#include "about.xbm"
#define RES_NAME "XMailTool"
#define RES_NAME_C "XMailTool-color"

Arg place_arg[2] = {{XtNx,(XtArgVal)0},
			{XtNy,(XtArgVal)0}};

extern char *MAILRC,*folder;
extern char msg_fname[];
extern char reply_fname[];
extern char *MBOX,EOT_FLAG[];
extern int autoprint,cmd_box_box;
extern long interval;

extern int errno;
#if NeedFunctionPrototypes
extern XtEventHandler map_handler(Widget w,caddr_t c,XEvent *e);
#else
extern XtEventHandler map_handler();
#endif
extern find_line();
extern Widget command_button(),make_dialog(),make_cancel();
extern Widget text_label();
extern look_at_line();
extern struct msg_header *header_list,*del_list, *cur_msg;
extern int mail_out,mail_in;
extern char *get_data();
extern int chg_file(),get_headers();


extern void show_proc(),next_proc(),del_proc(), undel_proc(), save_proc(),
	print_proc(), folders_proc(), nmail_proc(), done_proc(), reply_proc(), compose_proc(),
	deliver_proc(), cancel_proc(), mailrc_proc(), folder_proc(),
	cd_proc(),file_popup(),okay_proc(),about_proc(),help_proc(),
	gripe_proc(),file_proc(),state_proc(), rtsf_proc(), quit_proc(),
	preserve_proc(),saved_fn_proc();

#if !NeedFunctionPrototypes
extern char *getenv();
#endif
extern int in_fd[],out_fd[];
extern int state_box,MAIL_pid;
extern char dbox_fname[];
extern char cmd_buff[];

#if NeedFunctionPrototypes
static XtActionProc clear_old(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc show_select(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc help_msg(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc XMTnotify(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc XMTlabel(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc XMTtilde(Widget w,XEvent *e,char **p,Cardinal *n);
static XtActionProc XMTWMProtocols(Widget w,XEvent *e,char **p,Cardinal *n);
#else
static XtActionProc clear_old(),show_select(),help_msg(),XMTnotify(),
			XMTlabel(),XMTtilde(),XMTWMProtocols();
#endif

XtAppContext my_app_con;
extern Pixmap  mbox_pix[];
Pixmap envelope;
Display *dpy;

Atom      wm_delete_window;


Window win;
void (*dump_core)();
Boolean auto_help;
char *ProgramName;
char *resource_mbox_fname;
extern char *system_mbox_fname;
char **saved_fnames;
int current_sf_index=0;

struct _app_resources app_resources;

#define Offset(field) XtOffsetOf(struct _app_resources, field)

static XtResource resources[] = {
	{"autoHelp", XtCBoolean, XtRBoolean, sizeof(Boolean),
		Offset(autoHelp), XtRImmediate, (caddr_t)TRUE},
	{"cmdBox", XtCBoolean, XtRBoolean, sizeof(Boolean),
		Offset(cmdBox), XtRImmediate, (caddr_t)FALSE},
	{"stateBox", XtCBoolean, XtRBoolean, sizeof(Boolean),
		Offset(stateBox), XtRImmediate, (caddr_t)TRUE},
	{"interval", XtCInterval, XtRInt, sizeof(int),
		Offset(interval), XtRString, "15"},
	{"patchLevel", "PatchLevel", XtRString, sizeof(String),
		Offset(patchLevel), XtRString, "0"},
	{"file", XtCFile, XtRString, sizeof(String),
		Offset(file), XtRString, NULL},
	{"iconGeometry", XtCGeometry, XtRString, sizeof(String),
		Offset(iconGeometry), XtRString, NULL},
	{"helpFile", "HelpFile", XtRString, sizeof(String),
		Offset(helpFile), XtRString, DEFAULT_HELPFILE},
	{"showCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(show), XtRString, "hand2"},
	{"deleteCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(delete), XtRString, "pirate"},
	{"saveCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(save), XtRString, "plus"},
	{"preserveCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(preserve), XtRString, "pencil"},
	{"normalCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(norm), XtRString, "top_left_arrow"},
	{"waitCursor",XtCCursor, XtRCursor, sizeof(Cursor),
		Offset(wait), XtRString, "watch"},
};

static XrmOptionDescRec options[] = {
{"+autoHelp",	"*autoHelp",		XrmoptionNoArg,		"False"},
{"-autoHelp",	"*autoHelp",		XrmoptionNoArg,		"True"},
{"+cmdBox",	"*cmdBox",		XrmoptionNoArg,		"False"},
{"-cmdBox",	"*cmdBox",		XrmoptionNoArg,		"True"},
{"+stateBox",	"*stateBox",		XrmoptionNoArg,		"False"},
{"-stateBox",	"*stateBox",		XrmoptionNoArg,		"True"},
{"-interval",	"*interval",		XrmoptionSepArg,	(caddr_t)NULL},
{"-file",	"*file",		XrmoptionSepArg,	(caddr_t)NULL},
{"-iconGeometry",".iconGeometry",	XrmoptionSepArg,	(caddr_t)NULL},
{"#",		".iconGeometry",	XrmoptionStickyArg,	(caddr_t)NULL},
{"-font",	"*font",		XrmoptionSepArg,	(caddr_t)NULL}
};



static char *translation_table = "#override \n\
 <Btn1Down>:    clear-old() select-start() show-select() extend-end(SECONDARY)\n\
 <Btn1Up>: no-op() \n\
 <Btn1Motion>: no-op() \n\
 <Btn2Down>: no-op() \n\
 <Btn3Down>: no-op() \n\
 <Btn3Motion>: no-op() \n\
 <Btn3Up>: no-op() \n";


static char *toggle_translation = "#override \n\
	<EnterWindow>:	highlight(Always) \n\
	<LeaveWindow>:	unhighlight() \n\
	<Btn1Down>,<Btn1Up>:	set() notify() \n";

static char *file_translation = "#override\n\
 <Key>Return:    no-op() \n\
Ctrl<Key>M:      no-op() \n\
Ctrl<Key>J:	no-op() \n\
 <Enter>:	help-msg(stuff)";


XtActionsRec my_actionsTable[] = {
	{"show-select",	(XtActionProc)show_select },
	{"clear-old",	(XtActionProc)clear_old},
	{"help-msg",	(XtActionProc)help_msg},
	{"xmt-notify",	(XtActionProc)XMTnotify},
	{"xmt-label",	(XtActionProc)XMTlabel},
	{"xmt-tilde",	(XtActionProc)XMTtilde},
	{"xmt-WMProtocols", (XtActionProc)XMTWMProtocols}
};

char *folder_list[1024];
char file_fname[80];

String fallback_resources[] = {
	"*input:			True",
	"*allowResize:			True",
	"*cmd_box.allowResize:		False",
	"*autoFill:			False",
	"*scrollVertical:		never",
	"*scrollHorizontal:		never",
	"*Text.resize:			width",
	"*Text*resizable:		True",
	"*file_name*resize:		width",
	"*file_name*resizable:		True",
	"*file_name*width:		300",
	"*directory_name*resize:	width",
	"*directory_name*resizable:	True",
	"*directory_name*width:		300",
	"*msg_box.scrollVertical:		always",
	"*msg_box.scrollHorizontal:		never",
	"*msg_box.wrap:			word", 
	"*msg_box.resize:		never",
	"*header_box.scrollVertical:	always",
	"*header_box.scrollHorizontal:	never",
	"*mail_output.scrollVertical:	always",
	"*mail_output.scrollHorizontal:	never",
	"*Reply.scrollVertical:		always",
	"*Reply.scrollHorizontal:	never",
	"*Reply.autoFill:		True",

	NULL};


char signature[MAXMESLEN];

Pixmap about_pic;

int num_headers;	/* the number of the header with the highest number */
int header_index;
int header_right,header_left;	
int here_before=0;

char pwd[MAXPATHLEN];

Widget toplevel,lst_list,toggle;
Widget replywidg;

Widget deliver_item,cancel_item,cd_item,reply_item,done_item,command_button();
Widget next_item,del_item,undel_item,print_item,text_label();
Widget mailrc_item,about_box,aboutsw,helpsw,about_item,help_item,quit_item;
Widget save_item,folder_item,nmail_item,comp_item,mail_msg,file_item;
Widget gripe_item,preserve_item,folder_shell;
Widget header_box,cmd_box,rtsf,msg_box,box,replysw, file_cmd_box,dir_cmd_box,
		list_folder,folder_name_item,file_name_item,help_msg_item,
		dir_name_item;

Widget  state_cmd_box,file_name_label;
Cursor watch_cur,norm_cur,del_cur,save_cur,pres_cur,show_cur;

struct proc_msg *pptr_first=NULL,*pptr_last=NULL;


void
clean_up()
{
	unlink(msg_fname);
	unlink(dbox_fname);
	unlink(reply_fname);
}

void
say_good_bye()
{
	clean_up();
	strcpy(cmd_buff,"x\n");
	mail_cmd();

	exit(1);
}

/* ARGSUSED */
int
xmt_IOerr(dipy)
Display *dipy;
{
	/*
	 * My BIG assumtion here is that
	 * if we need to run this code... Someone decided
	 * to use the "Close" feature of a window manager rather
	 * than the "Iconify" feature.  So, We will simply quit
	 * from mail.  If this is a poor assumtion... And it
	 * probably is... then the following line should be
	 * "say_good_by()" or conditionaly compiled.
	 *  This allows the builder to decide what (s)he is more
	 * likely to assume.
	 */

#ifdef ABORT_ON_CLOSE
	quit_proc((Widget)0,(caddr_t)0,(caddr_t)"abort");
#else
	quit_proc((Widget)0,(caddr_t)0,(caddr_t)"quit");
#endif
	return(0);

}


/* ARGSUSED */
int
#if NeedFunctionPrototypes
xmt_err(Display *dpy,XErrorEvent *ev)
#else
xmt_err(dpy,ev)
Display *dpy;
XErrorEvent *ev;
#endif
{
	/*
	 * Just ignore it.
	 */
	return(0);
}


/* ARGSUSED */
static XtActionProc 
#if NeedFunctionPrototypes
XMTWMProtocols(Widget w,XEvent *e,String *p,Cardinal *n)
#else
XMTWMProtocols(w,e,p,n)
Widget w;
XEvent *e;
String *p;
Cardinal *n;
#endif
{
	Widget button;

        while (w && !XtIsShell(w))
            w = XtParent(w);

	if(w==toplevel)
		button=XtNameToWidget(w,"*quit");
	else
		button=XtNameToWidget(w,"*cancel");

	if( ! button)
		return((XtActionProc)0);

	XtCallActionProc(button, "set", e, (String*)NULL, 0);
	XtCallActionProc(button, "notify", e, (String*)NULL, 0);
	XtCallActionProc(button, "unset", e, (String*)NULL, 0);
	return((XtActionProc)0);
}



/* ARGSUSED */
static XtActionProc
#if NeedFunctionPrototypes
XMTtilde(Widget w,XEvent *e,String *p,Cardinal *n)
#else
XMTtilde(w,e,p,n)
Widget w;
XEvent *e;
String *p;
Cardinal *n;
#endif
{
int pos1,pos2,msg_fd,nread,buff_index=0,edit_pid;
Widget my_source;
extern struct proc_msg *pptr_last,*pptr_first;
struct proc_msg *pptr_tmp;
XawTextBlock text;
char tild_buff[50],*msg_buff,*tmp_file;
extern char *Sign,*sign,*DEAD,*mprefix,*VISUAL;
extern int edit_needs_xterm;
Arg file_arg[1];
char DISPLAY_STRING[100];
char *expand_string();
char *EDIT_STRING;
extern char *SHELL;

pos1=XawTextGetInsertionPoint(w);
my_source=XawTextGetSource(w);

pos2=XawTextSourceScan(my_source,pos1,XawstEOL,XawsdLeft,1,False);


if(pos1!=pos2)
{
	text.firstPos=0;
	text.length=1;
	if(*n==0)
		text.ptr="~";
	else
		text.ptr=(p[0]);

	XawTextReplace(w,pos1,pos1,&text);
	XawTextSetInsertionPoint(w,pos1+1);
	here_before=0;
}
else if(here_before && (*n==0))
{
	text.firstPos=0;
	text.length=1;
	text.ptr="~";
	XawTextReplace(w,pos1,pos1,&text);
	XawTextSetInsertionPoint(w,pos1+1);
	here_before=0;
}
else if( !here_before && (*n==0) )
{
	here_before=1;
}
else
{

	switch (p[0][0]) {

	case 'r':
		break;
	case 'a':
		msg_buff=expand_string(sign);
		text.firstPos=0;
		text.length=strlen(msg_buff);	
		text.ptr=msg_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+strlen(msg_buff));
		break;
	case 'A':
		msg_buff=expand_string(Sign);
		text.firstPos=0;
		text.length=strlen(msg_buff);	
		text.ptr=msg_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+strlen(msg_buff));
		break;
	case 'd':

	if((msg_fd=open(DEAD,O_RDONLY))==-1)
	{
		perror(DEAD);
		XBell (dpy, 10);
		XFlush(dpy);
		warn("Couldn't open Dead letter file");
		return((XtActionProc)-1);
	}
	msg_buff=(char *)malloc(1025);
	for(;;)
	{
		msg_buff=(char *)realloc(msg_buff,buff_index+1025);
		if((nread=read(msg_fd,&msg_buff[buff_index],1024))==-1)
		{
			if(errno == EINTR)
				continue;

			perror(DEAD);
			warn("Can't read Dead Letter File.");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}

		if(nread==0)
		{
			break;
		}
		buff_index+=nread;
		msg_buff[buff_index]=(char)0;

	}

		text.firstPos=0;
		text.length=strlen(msg_buff);
		text.ptr=msg_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+strlen(msg_buff));
		free(msg_buff);
		close(msg_fd);
		break;
	case 'f':
		if(header_list == (struct msg_header *)0)
		{
			warn("No messages.");
			XBell (dpy, 10);
			XFlush(dpy);
			break;
		}
		if((msg_fd=open(msg_fname,O_RDONLY))==-1)
		{
			perror(msg_fname);
			warn("Couldn't open message file");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}
	if((msg_buff=(char *)malloc(1025))==NULL)
	{
		perror("malloc");
		warn("couldn't malloc space.");
		XBell (dpy, 10);
		XFlush(dpy);
		return((XtActionProc)-1);
	}
	msg_buff[0]='>';
	buff_index=1;

	for(;;)
	{
		if((msg_buff=(char *)realloc(msg_buff,buff_index+1025))==NULL)
		{
			perror("realloc");
			warn("couldn't realloc space.");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}

		if((nread=read(msg_fd,&msg_buff[buff_index],1024))==-1)
		{

			if(errno == EINTR)
				continue;

			perror(msg_fname);
			warn("Can't read message File.");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}

		if(nread==0)
		{
			break;
		}

		buff_index+=nread;
		msg_buff[buff_index]=(char)0;

	}

		text.firstPos=0;
		text.length=strlen(msg_buff);
		text.ptr=msg_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+strlen(msg_buff));
		free(msg_buff);
		close(msg_fd);
		break;

	case 'm':
		if(header_list == (struct msg_header *)0)
		{
			warn("No messages.");
			XBell (dpy, 10);
			XFlush(dpy);
			break;
		}

		if((msg_fd=open(msg_fname,O_RDONLY))==-1)
		{
			perror(msg_fname);
			warn("Couldn't open message file");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}
	msg_buff=(char *)malloc(1025);

	strcpy(msg_buff,"\n\n---------  Received message begins Here  ---------\n\n");
	strcat(msg_buff,mprefix);
	buff_index=strlen(msg_buff);

	for(;;)
	{
		msg_buff=(char *)realloc(msg_buff,buff_index+1025);
		if((nread=readln(msg_fd,&msg_buff[buff_index],1024))==-1)
		{
			perror(msg_fname);
			warn("Can't read message File.");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}

		if(nread==0)
		{
			break;
		}
		strcat(&msg_buff[buff_index],"\n");
		strcat(&msg_buff[buff_index],mprefix);
		buff_index+=(nread + strlen(mprefix));

	}
		text.firstPos=0;
		text.length=strlen(msg_buff);
		text.ptr=msg_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+strlen(msg_buff));
		free(msg_buff);
		close(msg_fd);
		break;

	case 'v':
		XawAsciiSave(XawTextGetSource(w));
		XtPopdown(XtParent(XtParent(w)));
		XtSetArg(file_arg[0],XtNstring,&tmp_file);
		XtGetValues(w,file_arg,1);


		if(VISUAL==(char *)0)
		{
			warn("VISUAL not set.");
			XBell (dpy, 10);
			XFlush(dpy);
			break;
		}
		if((edit_pid=fork())==-1)
		{
			warn("Couldn't Fork editor Process\n");
			XBell (dpy, 10);
			XFlush(dpy);
			return((XtActionProc)-1);
		}
		if(edit_pid==0)
		{
#ifdef SYSV
			sprintf(DISPLAY_STRING,"DISPLAY=%s",
					DisplayString(dpy));
			putenv(DISPLAY_STRING);
#endif
			if(edit_needs_xterm)
				execlp("xterm","xterm",
					"-display",DisplayString(dpy),
					"-name","outbound_msg",
					"-T",VISUAL,"-e",VISUAL,tmp_file,0L);
			else
			{
				EDIT_STRING=(char *)malloc(strlen(VISUAL)+
						strlen(tmp_file)+2);
				sprintf(EDIT_STRING,"%s %s",VISUAL,tmp_file);
				execlp(SHELL,SHELL,"-c",EDIT_STRING,0L);
			}

			perror("Couldn't exec xterm VISUAL");
			XBell (dpy, 10);
			XFlush(dpy);
			exit(1);
		}

		if(edit_pid!=0)
		{
			pptr_tmp=(struct proc_msg *)malloc(
					sizeof(struct proc_msg));

			pptr_tmp->file=tmp_file;
			pptr_tmp->pid=edit_pid;
			pptr_tmp->next=NULL;
			pptr_tmp->box=XtParent(XtParent(w));
			pptr_tmp->text=w;
			if(pptr_first==NULL)
			{
				pptr_first=pptr_tmp;
			}
			else
			{
				pptr_last->next=pptr_tmp;
			}
			pptr_last=pptr_tmp;
			
		}
		break;

	default:
		sprintf(tild_buff,"~%s",p[0]);
		text.firstPos=0;
		text.length=2;
		text.ptr=tild_buff;
		XawTextReplace(w,pos1,pos1,&text);
		XawTextSetInsertionPoint(w,pos1+2);
	}

	here_before=0;
}
return((XtActionProc)0);

}



static int
CvtToItem(w, xloc, yloc, item)
Widget w;
int xloc, yloc;
int *item;
{
    int one, another;
    ListWidget lw = (ListWidget) w;
    int ret_val = OKAY;

    if (lw->list.vertical_cols) {
        one = lw->list.nrows * ((xloc - (int) lw->list.internal_width)
	    / lw->list.col_width);
        another = (yloc - (int) lw->list.internal_height) 
	        / lw->list.row_height;
	 /* If out of range, return minimum possible value. */
	if (another >= lw->list.nrows) {
	    another = lw->list.nrows - 1;
	    ret_val = OUT_OF_RANGE;
	}
    }
    else {
        one = (lw->list.ncols * ((yloc - (int) lw->list.internal_height) 
              / lw->list.row_height)) ;
	/* If in right margin handle things right. */
        another = (xloc - (int) lw->list.internal_width) / lw->list.col_width;
	if (another >= lw->list.ncols) {
	    another = lw->list.ncols - 1; 
	    ret_val = OUT_OF_RANGE;
	}
    }  
    if ((xloc < 0) || (yloc < 0))
        ret_val = OUT_OF_RANGE;
    if (one < 0) one = 0;
    if (another < 0) another = 0;
    *item = one + another;
    if (*item >= lw->list.nitems) return(OUT_OF_RANGE);
    return(ret_val);
}


/* ARGSUSED */
static XtActionProc
#if NeedFunctionPrototypes
XMTnotify(Widget w,XEvent *e,String *p,Cardinal *n)
#else
XMTnotify(w,e,p,n)
Widget w;
XEvent *e;
String *p;
Cardinal *n;
#endif
{
	char *call_data;
	int p_index,item,item_len;
	CommandWidget cbw = (CommandWidget)w;
	ListWidget lw = (ListWidget)w;
	myListReturnStruct ret_value;
	call_data=(char *)malloc(2);
	call_data[0]=(char)0;

	for(p_index=0;p_index<*n;p_index++)
	{
		call_data=(char *)realloc(call_data,strlen(call_data) +
					strlen(p[p_index])+2);
		strcat(call_data,p[p_index]);

		strcat(call_data," ");
	}
	call_data[strlen(call_data)-1]=(char)0;

	if(w->core.widget_class == listWidgetClass)
	{
	/* Find item and if out of range then unhighlight and return. 
	 * 
	 * If the current item is unhighlighted then the user has aborted the
	 * notify, so unhighlight and return.
	 */
		if ( ((CvtToItem(w, e->xbutton.x, e->xbutton.y, &item))
			== OUT_OF_RANGE) || (lw->list.highlight != item) )
		{
			XawListUnhighlight(w);
			 return(0);
		}

		item_len = strlen(lw->list.list[item]);

		/*
		 * if XtNpasteBuffer set then paste it.
		 */
		if ( lw->list.paste )	
			XStoreBytes(XtDisplay(w), lw->list.list[item],
							item_len);
		/* 
		 * Call Callback function.
		 */
		ret_value.string = lw->list.list[item];
		ret_value.list_index = item;
		ret_value.data=(*n==0?NULL:call_data);
    
		XtCallCallbacks( w, XtNcallback, (XtPointer) &ret_value);
		free(call_data);
	}
	else if(w->core.widget_class == commandWidgetClass)
	{
		/*
		 * check to be sure state is still Set so that user can cancel
		 * the action (e.g. by moving outside the window, in the
		 * default bindings.
		 */
		if (cbw->command.set)
		{
			XtCallCallbackList(w, cbw->command.callbacks,
					(*n==0?NULL:call_data) );
		}
		free(call_data);
	}
	else
	{
		fprintf(stderr,"xmt-notify not valid for %s\n",
				w->core.widget_class->core_class.class_name);

	}
	return(0);
}


/* ARGSUSED */
static
XtActionProc
#if NeedFunctionPrototypes
XMTlabel(Widget w,XEvent *e,String *p,Cardinal *n)
#else
XMTlabel(w,e,p,n)
Widget w;
XEvent *e;
String *p;
Cardinal *n;
#endif
{
static Arg arglist[]={{XtNlabel,(XtArgVal) 0}};

	if(*n == 0)
		return(0);

	arglist[0].value=(XtArgVal)p[0];
	XtSetValues(w,arglist,1);
	return(0);

}


/* ARGSUSED */
static
XtActionProc
#if NeedFunctionPrototypes
help_msg(Widget w,XEvent *e,String *p,Cardinal *n)
#else
help_msg(w,e,p,n)
Widget w;
XEvent *e;
String *p;
int *n;
#endif
{
static Arg arglist[]={{XtNlabel,(XtArgVal) 0}};
char help_line[350];
int x;

	if((auto_help==0) || (*n==0))
		return(0);

	strcpy(help_line,p[0]);

	for(x=1;x<*n;x++)
	{
		strcat(help_line," ");
		strcat(help_line,p[x]);
	}

	arglist[0].value=(XtArgVal) help_line;
	XtSetValues(help_msg_item,arglist,1);
	return(0);

}


/* ARGSUSED */
static
XtActionProc
#if NeedFunctionPrototypes
clear_old(Widget w,XEvent *e,char **p,Cardinal *n)
#else
clear_old(w,e,p,n)
Widget w;
XEvent *e;
char **p;
int *n;
#endif
{
XawTextPosition left, right;
XawTextBlock text;
char stuff[3],header_flag;
Widget my_source;


	if(header_list == (struct msg_header *)0)
	{
		return(0);
	}

	XawTextGetSelectionPos(header_box,&left,&right);
	my_source=XawTextGetSource(header_box);
	left=XawTextSourceScan(my_source,left,XawstEOL,XawsdLeft,1,False);

	if(read_header_text(my_source,left+1,&header_flag,1)==0)
		return(0);

	switch(header_flag) 
	{

	case '*':
		sprintf(stuff," *");
		break;
	case 'P':
		sprintf(stuff," P");
		break;
	default:
		sprintf(stuff,"  ");
		break;
	}
	

	text.firstPos=0;
	text.ptr=stuff;
	text.length=2;

	XawTextReplace(header_box,left,left + 2,&text);
	return(0);
}

/* ARGSUSED */
static XtActionProc 
#if NeedFunctionPrototypes
show_select(Widget w,XEvent *e,char **p,Cardinal *n)
#else
show_select(w,e,p,n)
Widget w;
XEvent *e;
char **p;
int *n;
#endif
{
XawTextPosition left;
XawTextBlock text;
char stuff[3];
int num;
extern int pointer_state;
extern struct msg_header *get_num_msg();
Widget my_source;
char header_buff[11];


	if(header_list == (struct msg_header *)0)
	{
		warn("No messages\n");
		return(0);
	}

	my_source=XawTextGetSource(header_box);
	left=XawTextSourceScan(my_source,XawTextGetInsertionPoint(header_box)
			,XawstEOL,XawsdLeft,1,False);
	if(read_header_text(my_source,left,header_buff,10)==0)
		return(0);

	sscanf(&header_buff[2]," %d",&num);

	switch(header_buff[1]) 
	{

	case '*':
		sprintf(stuff,">*");
		break;
	case 'P':
		sprintf(stuff,">P");
		break;
	default:
		sprintf(stuff,"> ");
		break;
	}



	text.firstPos=0;
	text.ptr=stuff;
	text.length=2;

	XawTextReplace(header_box,left,left+2,&text);

	switch (pointer_state) {
	case 0:
		show_msg(num);
		break;
	case 1:
		cur_msg=get_num_msg(num);
		delete_msg();
		refresh_headers(0);
		XtSetSensitive(undel_item,True);
		break;
	case 2:
		cur_msg=get_num_msg(num);
		if(save_msg(file_fname,"save" )==-1)
			return(0);
	
		if(header_buff[1]!='P')
		{
			strcpy(stuff,"*");
			text.firstPos=0;
			text.ptr=stuff;
			text.length=1;

			XawTextReplace(header_box,left+1,left+2,&text);
		}
		break;
	case 3:
		cur_msg=get_num_msg(num);
		preserve_msg();

		strcpy(stuff,"P");
		text.firstPos=0;
		text.ptr=stuff;
		text.length=1;

		XawTextReplace(header_box,left+1,left+2,&text);
		break;
	}
	return(0);

}

void
chang_cursor(w,c)
Widget w;
Cursor c;
{
Window wig_win;

	wig_win=XtWindow(w);
	XDefineCursor(dpy,wig_win,c);
	XFlush(dpy);
}


void
change_mail_file(fn,r,w)
char *fn; 		/* actual file name to change to */
Boolean r;		/* weather rtsf is sensitive */
char *w;		/* where mail is coming from */
{
char *ptr,*header_string,warning[150];
int res;
extern char dbox_fname[];

	chang_cursor(toplevel,watch_cur);
	XawTextDisableRedisplay(header_box);
	XawTextDisableRedisplay(msg_box); 

	res=chg_file(fn,&ptr);
	warn(ptr);

	if(res==-1)
	{
		chang_cursor(toplevel,norm_cur);
		XawTextEnableRedisplay(header_box);
		XawTextEnableRedisplay(msg_box); 
		if(header_list==(struct msg_header *)0)
			display_msg(NULL);
		return;
		
	}

	if(get_headers(1,&header_string)==-1)
	{
		fprintf(stderr,"refresh_headers():: fatal error, cant get headers\n");
		say_good_bye();
	}

	XtSetSensitive(rtsf,r);
	XtSetSensitive(undel_item,False);

	if(header_list==(struct msg_header *)0)
	{
			XtSetSensitive(next_item,False);
			XtSetSensitive(del_item,False);
			XtSetSensitive(reply_item,False);
			XtSetSensitive(save_item,False);
			XtSetSensitive(print_item,False);
			sprintf(warning,"No mail in %s.",w);
			warn(warning);
			refresh_headers(0);
			display_msg(NULL);
	}
	else
	{
			XtSetSensitive(next_item,True);
			XtSetSensitive(del_item,True);
			XtSetSensitive(reply_item,True);
			XtSetSensitive(save_item,True);
			XtSetSensitive(print_item,True);
			show_msg(cur_msg->num);
			refresh_headers(0);
	}

	chang_cursor(toplevel,norm_cur);
	XawTextEnableRedisplay(header_box);
	XawTextEnableRedisplay(msg_box); 
	XFlush(dpy);
	return;
}

void
show_tool()
{
extern int pointer_state;

	switch(pointer_state) {
	case 0:
		chang_cursor(header_box,show_cur);
		break;
	case 1:
		chang_cursor(header_box,del_cur);
		break;
	case 2:
		chang_cursor(header_box,save_cur);
		break;
	case 3:
		chang_cursor(header_box,pres_cur);
		break;
	}
	change_mail_file("%",False,"system mail box");
}

/* ARGSUSED */
void
segv_catch(s,c,scp)
int s,c;
struct sigcontext *scp;
{
	char my_wd[200];
	clean_up();
	strcpy(cmd_buff,"x\n");
	mail_cmd();

	fprintf(stderr,"Mail aborted gracefully.\n");
#ifdef SYSV
	if(getcwd(my_wd,200) == (char *)0)
#else
	if(getwd(my_wd) == (char *)0)
#endif
		fprintf(stderr,
			"A core file is located in the current directory.\n");
	else
		fprintf(stderr,
			"A core file is located in %s/core.\n",my_wd);

	dump_core(s,c,scp);
}

/* ARGSUSED */
void
cld_catch(s,c,scp)
int s,c;
struct sigcontext *scp;
{
int cld_pid;
extern int confirm_EDITOR;
Widget oldsrc;
struct proc_msg *pptr,*pptr_p=NULL;
struct stat buff;
static Arg file_arg[]={{XtNstring,(XtArgVal) 0},
			{XtNtype,(XtArgVal) XawAsciiFile},
                        {XtNeditType,(XtArgVal) XawtextEdit}};

	cld_pid=wait(0);

#ifdef SYSV
	signal(SIGCLD,
#ifdef __STDC__
	(void(*)(int))cld_catch);
#else
	cld_catch);
#endif
#endif

	if(cld_pid==MAIL_pid)
	{
		/*
		 * this is a problem!
		 */
		warn("Mail process has died.  Shutting down XMailTool.");
		fprintf(stderr,
			"Mail process has died.  Shutting down XMailTool.");
		sleep(5);
		clean_up();
		exit(1);
	}

	for(pptr=pptr_first;pptr!=NULL;pptr=pptr->next)
	{
		if(pptr->pid == cld_pid)
		{
			/*
			 * we need to remove this one from the list.
			 */
			if(pptr_first==pptr)
			{
				pptr_first=pptr->next;
			}
			else
			{
				pptr_p->next=pptr->next;
			}
			
			/*
			 * check if this is a visual for an outbound message
			 * window.
			 */
			if(pptr->box!=(Widget)0)
			{
				oldsrc = XawTextGetSource(pptr->text);
				XtDestroyWidget(oldsrc);
				XtSetArg(file_arg[0],XtNstring,pptr->file);
				XawTextSetSource(pptr->text,
					XtCreateWidget("reply",
						asciiSrcObjectClass,
						pptr->text,file_arg,3),0);
				XtPopup(pptr->box,XtGrabNone);
				return;
			}

			if(confirm_EDITOR)
			{
				warn("Please confirm message delivery.");
				XBell(dpy,10);
				XFlush(dpy);
				confirm_send(pptr->file);
				/*
				 * since the confirm window will use
				 * the file and filename memory, we
				 * don't need to free or unlink it here.
				 */
				free(pptr);
				return;
			}
			
			stat(pptr->file,&buff);
			if(pptr->mtime==buff.st_mtime)
			{
				unlink(pptr->file);
				free(pptr->file);
				free(pptr);
				warn("Outbound message has not been sent.");
				return;
			}
			
			if(send_reply(pptr->file)==0)
			{
				unlink(pptr->file);
				free(pptr->file);
				free(pptr);
				warn("Message has been sent.");
				return;
			}
			else
			{
				warn("Couldn't send message");
				XBell (dpy, 10);
				XFlush(dpy);
				free(pptr->file);
				free(pptr);
				return;
			}

		}
		pptr_p=pptr;
	}
	/*
	 * if we have gotten to here... It wasn't an xterm process.
	 *  It must have been something else... It it was mail we'll
	 * find out somewhere eles.
	 */


	return;
}

/* ARGSUSED */
void
pipe_catch(s,c,scp)
int s,c;
struct sigcontext *scp;
{
	clean_up();
	exit(0);
	/* NOTREACHED */
}

warn(msg)
char *msg;
{
static Arg args[]={{XtNstring,(XtArgVal)0}};

	if(msg==(char *)0)
		args[0].value=(XtArgVal)"";
	else
		args[0].value=(XtArgVal)msg;


	XtSetValues(mail_msg,args,1);
	XFlush(dpy);

}


/* ARGSUSED */
void
popup_folderlist(w,cl,cd)
Widget w;
caddr_t cl,cd;
{
int list_index;
char *folder_name;
extern char *fnames[], fdirname[];
static Arg arglist[]={{XtNlabel,(XtArgVal) 0}};
extern int use_folders_cmd;

	warn("Building Folder list");
	if(use_folders_cmd)
	{
		sprintf(cmd_buff,"folders\n");
		mail_cmd();
	
		for(list_index=0;;list_index++)
		{
			folder_name=(char *)malloc(100);
			readln(mail_out,folder_name,100);
			if(folder_list[list_index]!=(char *)0)
				free(folder_list[list_index]);
			folder_list[list_index]=(char *)0;

			if(strcmp(folder_name,EOT_FLAG) == 0)
			{
				free(folder_name);
				break;
			}
			folder_list[list_index]=folder_name;
		}
	}
	else
	{
		get_dir(folder,0);
		strcpy(fdirname,"");
	}

	warn("Done Building Folder list");

	arglist[0].value=(XtArgVal) folder;
	XtSetValues(list_folder,arglist,1);

	if(use_folders_cmd)
		XawListChange(lst_list,folder_list,0,0,True);
	else
		XawListChange(lst_list,fnames,0,0,True);

	XtPopup((Widget)cl,XtGrabNone);
	(void) XSetWMProtocols(dpy, XtWindow((Widget)cl),
			&wm_delete_window, 1);
	XtSetSensitive(cmd_box,False);
}

create_folder_menu(w)
Widget w;
{
static Arg farg[]={{XtNallowShellResize,(XtArgVal) False}};
static Arg vparg[]={{XtNallowVert,(XtArgVal) True},
			{XtNforceBars,(XtArgVal)True}};
static Arg larg[]={{XtNdefaultColumns,(XtArgVal)4},
			{XtNforceColumns,(XtArgVal) True}};
		
Widget lst_cmd_box,lst_pane,lst_view;


	folder_shell = XtCreatePopupShell("Folder_List",
			applicationShellWidgetClass,toplevel,farg,1);

	XtAddCallback(w,XtNcallback,(XtCallbackProc)popup_folderlist,(XtPointer)folder_shell);

	lst_pane=XtCreateManagedWidget("list_pane",panedWidgetClass,
			folder_shell,NULL,0);

	lst_cmd_box=XtCreateManagedWidget("list_cmd_box",boxWidgetClass,
			lst_pane,NULL,0);

	rtsf=command_button("Return To System Folder",lst_cmd_box,
						rtsf_proc,folder_shell);
	make_cancel(lst_cmd_box,folder_shell);

	list_folder=XtCreateManagedWidget("folder_name",labelWidgetClass,
		lst_pane,NULL,0);

	lst_view =XtCreateManagedWidget("list_view",viewportWidgetClass,
			lst_pane,vparg,2);

	lst_list=XtCreateManagedWidget("folder_list",listWidgetClass,
			 lst_view,larg,2);

	XtAddCallback(lst_list,XtNcallback,(XtCallbackProc)folder_proc,(XtPointer)folder_shell);
}

refresh_headers(load)
int load;
{
XawTextBlock text;
Widget my_source;
char *header_string;
char *my_select="SECONDARY";

	my_source=XawTextGetSource(header_box);
	XawTextDisableRedisplay(header_box); 
	if(get_headers(load,&header_string)==-1)
	{
		fprintf(stderr,"refresh_headers():: fatal error, cant get headers\n");
		say_good_bye();
	}
	text.firstPos=0;
	text.ptr=header_string;
	text.length=strlen(header_string);

	XawTextReplace(header_box,0,
		XawTextSourceScan(my_source,0,XawstAll,XawsdRight,1,True),
		&text);

       _XawTextSetSelection(header_box,header_left,header_right,&my_select,1);
	XawTextSetInsertionPoint(header_box,header_left);

XawTextInvalidate(header_box,0,strlen(header_string));
	XawTextEnableRedisplay(header_box);

}





#ifdef NEED_COPYMSG
int
copy_msg(msg_num)
int msg_num;
{
	char msg_buff[2024];
	int msg_file,nread;
	int eot_len=strlen(EOT_FLAG);

	/*
	 * Tell mail to make a new message file.
	 */
	sprintf(cmd_buff,"print %d\n",msg_num);
	mail_cmd();

	if((msg_file=open(msg_fname,O_WRONLY|O_CREAT|O_TRUNC,0600))==-1)
	{
		perror(msg_fname);
		XBell (dpy, 10);
		XFlush(dpy);
		warn("Couldn't write reply file");
		return(-1);
	}

	readln(mail_out,msg_buff,1024); /* This line is ignored */
	
	for(;;)
	{
		/*
		 * Start the read so that the
		 */
		if((nread=read(mail_out,&msg_buff[eot_len],2024-eot_len))==-1)
		{
			if(errno == EINTR)
				continue;
			perror("Can't read mail pipe");
			warn("Can't read mail pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}

		if(nread==0)
		{
			warn("End of file on Mail Pipe");
			XBell (dpy, 10);
			XFlush(dpy);
			return(-1);
		}


		if(bcmp(&msg_buff[nread-1],
				EOT_FLAG,eot_len)==0)
		{
			write(msg_file,&msg_buff[eot_len],
					nread-eot_len-1);
			break;
		}
		write(msg_file,&msg_buff[eot_len],nread);
		bcopy(&msg_buff[nread],
				msg_buff,eot_len);

	}
	close(msg_file);
	return(0);
}

#endif


display_msg(d)
struct msg_header *d;
{
Widget oldsrc;
static Arg arglist[]={{XtNheight,(XtArgVal)300},
			{XtNstring,(XtArgVal) 0},
			{XtNtype,(XtArgVal) 0},
			{XtNeditType,(XtArgVal)XawtextEdit},
			{XtNwidth,(XtArgVal)500}
			};

	if(d==(struct msg_header *)NULL)
	{
		arglist[1].value=(XtArgVal)"No Message.";
		arglist[2].value=(XtArgVal)XawAsciiString;
	}
	else
	{
		arglist[1].value=(XtArgVal)msg_fname;
		arglist[2].value=(XtArgVal)XawAsciiFile;

		/*
		 * remove old message.
		 */
		truncate(msg_fname,0);

		/*
		 * Tell mail to make a new message file.
		 */
#ifdef NEED_COPYMSG
		copy_msg(d->num);
#else
		sprintf(cmd_buff,"copy %d %s\n",d->num,msg_fname);
		mail_cmd();
		read_rest(mail_out);
#endif
		if(cur_msg != (struct msg_header *)0)
		{
			if((cur_msg->stat!='*')&&(cur_msg->stat!='P'))
				cur_msg->stat=' ';
			cur_msg->cur=' ';
		}
		cur_msg = d;
		cur_msg->cur='>';
		if((cur_msg->stat!='*')&&(cur_msg->stat!='P'))
				cur_msg->stat=' ';
	}

	oldsrc = XawTextGetSource(msg_box);
	XtDestroyWidget(oldsrc);
	XawTextSetSource(msg_box,XtCreateWidget("msgtext",asciiSrcObjectClass,
				msg_box,arglist,4),0);

}



create_helpmsg()
{
Widget help_box,help_text;
Arg help_arg[10];

	helpsw=XtCreatePopupShell("help",applicationShellWidgetClass,
			toplevel,NULL,0);

	help_box=XtCreateManagedWidget("help_vpane",panedWidgetClass,
                        helpsw,NULL,0);
	
	make_cancel(help_box,helpsw);

	XtSetArg(help_arg[0],XtNstring,app_resources.helpFile);
	XtSetArg(help_arg[1],XtNtype,XawAsciiFile);
	XtSetArg(help_arg[2],XtNeditType,XawtextRead);

	help_text=XtCreateManagedWidget("helpText",asciiTextWidgetClass,
			help_box,help_arg,3);
	set_text_columns(help_text,80);
}


Syntax(call)
	char *call;
{
	fprintf(stderr,
		"Usage: %s [X-Toolkit Options...] [XMailTool Options...]\n\n",
			call);
	fprintf(stderr,"Where [XMailTool Options...] include:\n");
	fprintf(stderr,"\t+|-autoHelp		turn off (on) Auto-Help\n");
	fprintf(stderr,"\t-color			use the color resources\n");
	fprintf(stderr,"\t+|-cmdBox		cmd_box should be a form (box)\n");
	fprintf(stderr,"\t+|-stateBox		don't (do) create the state box\n");
	fprintf(stderr,"\t-interval seconds	time between mailbox checking\n\n");

    say_good_bye();
}



void main(argc, argv)
    unsigned int argc;
    char **argv;
{
char sig_fname[100];
int sig_fd,do_color=0;
extern int state_box,pointer_state;
extern set_text_columns();
char **saved_argv;
int x,saved_argc=argc;
int x_return,y_return;
unsigned int width_return,height_return;

XtTranslations translations,toggle_trans,file_trans;
	static XawTextSelectType select_list[]={XawselectLine,XawselectNull};


        static Arg header_arg[] = {
					{XtNstring,(XtArgVal) ""},
					{XtNlength,(XtArgVal) 0},
					{XtNuseStringInPlace,(XtArgVal) False},
					{XtNeditType,(XtArgVal)XawtextEdit},
					{XtNselectTypes,(XtArgVal)select_list},
					{XtNtype,(XtArgVal) XawAsciiString}
	};
	
	static Arg mail_arg[] = {
					{XtNstring,(XtArgVal) ""},
					{XtNeditType,(XtArgVal)XawtextEdit},
					{XtNtype,(XtArgVal)XawAsciiString}
	};

        static Arg msg_arg[] = {
					{XtNstring,(XtArgVal) msg_fname},
					{XtNeditType,(XtArgVal)XawtextEdit},
					{XtNtype,(XtArgVal)XawAsciiFile}	};


	static Arg shell_arg[]={{XtNiconPixmap,(XtArgVal)0},
				{XtNargc, (XtArgVal)0},
				{XtNargv, (XtArgVal)0},
				{XtNscreen, (XtArgVal)0}
	};

	static Arg toga_arg[]={{XtNradioData,(XtArgVal)0},
				{XtNradioGroup,(XtArgVal)0},
				{XtNlabel,(XtArgVal)" Show\nMessage"},
				{XtNstate,(XtArgVal)True}};

	static Arg file_diag[]={
				{XtNfromHoriz,(XtArgVal)0},
				{XtNfromVert,(XtArgVal)0},
				{XtNright,(XtArgVal)XtRubber},
				{XtNtop,(XtArgVal)XtChainTop},
				{XtNleft,(XtArgVal)XtRubber},
				{XtNbottom,(XtArgVal)XtChainBottom},
				{XtNresizable,(XtArgVal)True},
				{XtNinternalWidth,(XtArgVal)0},
				{XtNjustify,(XtArgVal) "left"},
				{0,(XtArgVal)0},
				{0,(XtArgVal)0}
};
				

	extern int quiet,hold,mail_state;

#ifdef DEF_AD_FILE
        putenv (DEF_AD_FILE);
#endif

    	ProgramName = argv[0];
	resource_mbox_fname=(char *)getenv("MAIL");

	saved_argv = (char **)malloc((argc+1)*sizeof(char *));
	for(x=0;x<argc;x++)
	{
		if(strcmp(argv[x],"-color")==0)
			do_color=1;
		saved_argv[x]=argv[x];
	}
	saved_argv[x]=NULL;

	start_mail();

	get_vars();

	init_saved_fnames();

	/*
	 * if Autoprint is set, turn it off.  It would
	 * just confuse us.
	 */
	if(autoprint)
	{
		sprintf(cmd_buff,"set noautoprint\n");
		mail_cmd();
		read_rest(mail_out);
	}

	XtToolkitInitialize();

	my_app_con=XtCreateApplicationContext();
	XtAppAddActions(my_app_con,my_actionsTable,XtNumber(my_actionsTable));

/*	XtAppSetFallbackResources(my_app_con,fallback_resources);*/

	dpy=XtOpenDisplay(my_app_con,(String)NULL, (String)NULL,
		(String)(do_color?RES_NAME_C:RES_NAME), (XrmOptionDescRec *)options,
		(Cardinal)XtNumber(options), (int *)&argc,(String *)argv);

	if(dpy==NULL)
	{
		fprintf(stderr,"Unable to open Display\n");
		exit(1);
	}

	if ((argc > 1) && (strcmp(argv[1],"-color")!=0))
		Syntax(argv[0]);


	XSetIOErrorHandler(xmt_IOerr);
	XSetErrorHandler(xmt_err);

	wm_delete_window = XInternAtom(dpy, "WM_DELETE_WINDOW", False);



	/*
	 * there doesn't appear to be a clean way of doing this
	 * part.  The system mailbox needs to be defined prior to
	 * the call to init_mbox so that we can determine which icon
	 * to start up with.  However the mailbox file may be specified
	 * in the resources.  So.. What I've decided to do is to assume
	 * the "system" system mailbox for now, and if it's a resource
	 * mailbox, change it latter.
	 */
	init_mbox(dpy);


	shell_arg[0].value=(XtArgVal) mbox_pix[mail_state];
	shell_arg[1].value=(XtArgVal) saved_argc;
	shell_arg[2].value=(XtArgVal) saved_argv;
	shell_arg[3].value=(XtArgVal) DefaultScreenOfDisplay(dpy);

	toplevel=XtAppCreateShell(NULL,(do_color?RES_NAME_C:RES_NAME),
		applicationShellWidgetClass,dpy,shell_arg,
		(Cardinal)XtNumber(shell_arg));

	XtGetApplicationResources(toplevel,(XtPointer) &app_resources,
			(XtResourceList)resources, 
			(Cardinal)XtNumber(resources),
			(ArgList) NULL ,(Cardinal)0);

	if(app_resources.iconGeometry != (char *)0)
	{
		XParseGeometry(app_resources.iconGeometry, &x_return,
				&y_return, &width_return, &height_return);
		XtSetArg(shell_arg[0],XtNiconX,x_return);
		XtSetArg(shell_arg[1],XtNiconY,y_return);
		XtSetValues(toplevel,shell_arg,2);
		XFlush(dpy);
	}

	auto_help=app_resources.autoHelp;
	/*
	 * the next three resources have .mailrc equivalents.
	 * If they have been changed in .mailrc, then we need
	 * to ignore the resource value.  So we check to see if
	 * they are the default value.  This could be a problem
	 * if the .mailrc setting set it to the default value.
	 */
	if(!cmd_box_box)
		cmd_box_box=app_resources.cmdBox;
	if(state_box)
		state_box=app_resources.stateBox;
	if(interval == 15)
		interval=app_resources.interval;

	/*
	 * by default the value of the resource and option
	 * is NULL.  If they exist, I will assume that this
	 * will override the MAIL environment variable.
	 * It's a gamble... But hey, so is life.
	 */
	if(app_resources.file != NULL)
		resource_mbox_fname=app_resources.file;
	watch_cur=app_resources.wait;
	norm_cur=app_resources.norm;
	del_cur=app_resources.delete;
	save_cur=app_resources.save;
	pres_cur=app_resources.preserve;
	show_cur=app_resources.show;

	if((resource_mbox_fname!=(char *)0) && 
		(strcmp(system_mbox_fname,resource_mbox_fname)!=0))	
	{
		free(system_mbox_fname);
		system_mbox_fname = resource_mbox_fname;
	}
	else
	{
		resource_mbox_fname=(char *)0;
	}

	/*
	 * Check to see that the app-defaults file matches this patch level.
	 * This check is for dummies that think they can use old app-defaults
	 * files with new XMailTool.
	 */
	if(strcmp(app_resources.patchLevel,PATCHLEVEL)!=0)
	{
		fprintf(stderr,
		"\n\nApp-defaults file is not from the same patch level.\n");
		fprintf(stderr,
		"Contact your system administrator to install a new copy.\n\n");
		fprintf(stderr,"Expecting: [%s], Got: [%s]\n\n",
			PATCHLEVEL,app_resources.patchLevel);
		exit(1);
	}



	/*
	 * Start up mail checker.  And specify a map/unmap handling
	 * routine.  
	 */
	
	XtAddEventHandler(toplevel,StructureNotifyMask,False,
			(XtEventHandler)map_handler,(XtPointer)NULL);


	sprintf(sig_fname,"%s/.signature",getenv("HOME"));
	if(access(sig_fname,4) != -1)
	{
		if((sig_fd=open(sig_fname,O_RDONLY))==-1)
		{
			perror("read(signature file)");
		}
		else
		{
			signature[read(sig_fd,signature,MAXMESLEN)]=0;
			close(sig_fd);
		}
	}
	else
		sprintf(signature,"");	


	/*
	 * The less I seek my source for some devinity the closer
	 * I am to fine...  (Indigo Girls)
	 */
	box = XtCreateManagedWidget("outerbox", panedWidgetClass,
				toplevel, NULL, 0);
	if(state_box)
	{
		state_cmd_box=XtCreateManagedWidget("state_cmd_box",boxWidgetClass,
			box,NULL,0);
	}


	folder_name_item=XtCreateManagedWidget("folder_name",labelWidgetClass,
			box,NULL,0);
	if(auto_help!=0)
		help_msg_item=XtCreateManagedWidget("help_msg",
					labelWidgetClass,box,NULL,0);

	header_box=XtCreateManagedWidget("header_box",asciiTextWidgetClass,
			box,header_arg,XtNumber(header_arg));

	set_text_columns(header_box,80);
	
	translations =XtParseTranslationTable(translation_table);


	XtOverrideTranslations(header_box,translations);

	if(cmd_box_box)
		cmd_box=XtCreateManagedWidget("cmd_box",boxWidgetClass,
                        box,NULL,0);
	else
		cmd_box=XtCreateManagedWidget("cmd_box",formWidgetClass,
                        box,NULL,0);

	file_cmd_box=XtCreateManagedWidget("file_box",formWidgetClass,
		box,NULL,0);

	dir_cmd_box=XtCreateManagedWidget("dir_box",formWidgetClass,
		box,NULL,0);

	mail_msg=XtCreateManagedWidget("mail_output",asciiTextWidgetClass,
                        box,mail_arg,XtNumber(mail_arg));

	set_text_columns(mail_msg,80);


        msg_box=XtCreateManagedWidget("msg_box",asciiTextWidgetClass,
                        box,msg_arg,XtNumber(msg_arg));

	set_text_columns(msg_box,80); 

	XtSetArg(file_diag[0],XtNborderWidth,0);


	file_name_label=XtCreateManagedWidget("file_label",
			commandWidgetClass,file_cmd_box,file_diag,1);
	XtAddCallback(file_name_label,XtNcallback,saved_fn_proc,NULL);

	file_trans =XtParseTranslationTable(file_translation);
	strcpy(file_fname,MBOX);

	XtSetArg(file_diag[0],XtNeditType,XawtextEdit);
	XtSetArg(file_diag[1],XtNstring,file_fname);
	XtSetArg(file_diag[2],XtNuseStringInPlace,True);
	XtSetArg(file_diag[3],XtNlength,80);
	XtSetArg(file_diag[4],XtNscrollVertical,XawtextScrollNever);
	XtSetArg(file_diag[5],XtNscrollHorizontal,XawtextScrollNever);
	XtSetArg(file_diag[6],XtNresize,XawtextResizeWidth);
	XtSetArg(file_diag[7],XtNresizable,True);
	XtSetArg(file_diag[8],XtNinsertPosition,80);
	XtSetArg(file_diag[9],XtNtranslations,file_trans);
	
	
	file_name_item=XtCreateManagedWidget("file_name",asciiTextWidgetClass,
			file_cmd_box,file_diag,9);

	
	XtSetArg(file_diag[0],XtNborderWidth,0);
	XtCreateManagedWidget("dir_label",labelWidgetClass,
			dir_cmd_box,file_diag,1);

	/*
	 * get mails working directory and lets go there.
	 */
	get_cwd(pwd);
	chdir(pwd);

	XtSetArg(file_diag[0],XtNeditType,XawtextEdit);
	XtSetArg(file_diag[1],XtNstring,pwd);


	dir_name_item=XtCreateManagedWidget("directory_name",
			asciiTextWidgetClass, dir_cmd_box,file_diag,9);

	refresh_dir(pwd);

	if(state_box)
	{
		toggle_trans =XtParseTranslationTable(toggle_translation);

		toggle=XtCreateManagedWidget("Show",toggleWidgetClass,
			state_cmd_box,&toga_arg[2],2);
		XMT_InstallAccelerators(toggle);

		XtAddCallback(toggle,XtNcallback,state_proc,(XtPointer) 0);

		toga_arg[0].value=(XtArgVal) toggle;
		XtSetValues(toggle,toga_arg,1);

		toga_arg[1].value=(XtArgVal)toggle;
		toga_arg[2].value=(XtArgVal)"Delete\nMessage";
		toggle=XtCreateManagedWidget("Delete",toggleWidgetClass,
			state_cmd_box,&toga_arg[1],2);
		XMT_InstallAccelerators(toggle);

		XtAddCallback(toggle,XtNcallback,state_proc,(XtPointer) 1);
		toga_arg[0].value=(XtArgVal)toggle;
		XtSetValues(toggle,toga_arg,1);

		toga_arg[2].value=(XtArgVal)" Save\nMessage";
		toggle=XtCreateManagedWidget("Save",toggleWidgetClass,
			state_cmd_box,&toga_arg[1],2);
		XMT_InstallAccelerators(toggle);

		XtAddCallback(toggle,XtNcallback,state_proc,(XtPointer) 2);
		toga_arg[0].value=(XtArgVal)toggle;
		XtSetValues(toggle,toga_arg,1);

		toga_arg[2].value=(XtArgVal)"Preserve\n Message";
		toggle=XtCreateManagedWidget("Preserve",toggleWidgetClass,
			state_cmd_box,&toga_arg[1],2);
		XMT_InstallAccelerators(toggle);

		XtAddCallback(toggle,XtNcallback,state_proc,(XtPointer) 3);
		toga_arg[0].value=(XtArgVal)toggle;
		XtSetValues(toggle,toga_arg,1);
	}
	else
	{
		pointer_state=0;
	}

	chang_cursor(header_box,show_cur);


	aboutsw=XtCreatePopupShell("about",transientShellWidgetClass,
			toplevel,NULL,0);

	about_box=XtCreateManagedWidget("about_box",boxWidgetClass,
                        aboutsw,NULL,0);

	about_pic=XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),about_bits,
			about_width,about_height);

	picture_button(make_cancel(about_box,aboutsw),about_pic);

	create_helpmsg();

	envelope=XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),
		envelope_bits,envelope_width,envelope_height);

	next_item=command_button("next",cmd_box,next_proc,NULL);
	del_item=command_button("delete",cmd_box,del_proc,NULL);
	undel_item=command_button("undelete",cmd_box,undel_proc,NULL);
	XtSetSensitive(undel_item, False );
	save_item=command_button("save",cmd_box,save_proc,NULL);
	preserve_item=command_button("preserve",cmd_box,
					preserve_proc,NULL);
	print_item=command_button("print",cmd_box,print_proc,NULL);
	nmail_item=command_button("new mail",cmd_box,nmail_proc,NULL);
	done_item=command_button("done",cmd_box,done_proc,NULL); 
	reply_item=command_button("reply",cmd_box,reply_proc,NULL);
	comp_item=command_button("compose",cmd_box,compose_proc,NULL);
	gripe_item=command_button("gripe",cmd_box,
					gripe_proc,NULL);
	mailrc_item=command_button("mailrc",cmd_box,mailrc_proc,NULL);
	folder_item=XtCreateManagedWidget("Folder",commandWidgetClass,
		cmd_box,NULL,0);
	create_folder_menu(folder_item);
	XtSetSensitive(rtsf,False);
	if(folder == (char *)0)
		XtSetSensitive(folder_item,False);
	file_item=command_button("file",cmd_box,
					file_proc,NULL);
	cd_item=command_button("cd",cmd_box,cd_proc,NULL);
	quit_item=command_button("quit",cmd_box,
					quit_proc,NULL);
	about_item=command_button("about",cmd_box,
					about_proc,NULL);
	help_item=command_button("help",cmd_box,
					help_proc,NULL);

	if(header_list == (struct msg_header *)0)
	{
		XtSetSensitive(del_item, False );
		XtSetSensitive(save_item, False );
		XtSetSensitive(print_item, False );
		XtSetSensitive(reply_item, False );
		XtSetSensitive(next_item, False );
	}

	XMT_InstallAccelerators(next_item);
	XMT_InstallAccelerators(del_item);
	XMT_InstallAccelerators(undel_item);
	XMT_InstallAccelerators(save_item);
	XMT_InstallAccelerators(file_name_label);
	XMT_InstallAccelerators(cd_item);
	XMT_InstallAccelerators(folder_item);
	XMT_InstallAccelerators(mailrc_item);
	XMT_InstallAccelerators(comp_item);
	XMT_InstallAccelerators(reply_item);
	XMT_InstallAccelerators(print_item);
	XMT_InstallAccelerators(nmail_item);
	XMT_InstallAccelerators(done_item);
	XMT_InstallAccelerators(about_item);
	XMT_InstallAccelerators(help_item);
	XMT_InstallAccelerators(quit_item);
	XMT_InstallAccelerators(file_item);
	XMT_InstallAccelerators(gripe_item);
	XMT_InstallAccelerators(preserve_item);

	XtRealizeWidget(toplevel);


	(void) XSetWMProtocols(dpy, XtWindow(toplevel),
			&wm_delete_window, 1);

/*	dump_core=signal(SIGSEGV,segv_catch);
	signal(SIGBUS,segv_catch); */
#ifdef __STDC__
	signal(SIGCLD,(void(*)(int))cld_catch);
	signal(SIGPIPE,(void(*)(int))pipe_catch);
	signal(SIGTERM,(void(*)(int))pipe_catch);
	signal(SIGHUP,(void(*)(int))pipe_catch);
	signal(SIGINT,(void(*)(int))pipe_catch);
#else
	signal(SIGCLD,cld_catch);
	signal(SIGPIPE,pipe_catch);
	signal(SIGTERM,pipe_catch);
	signal(SIGHUP,pipe_catch);
	signal(SIGINT,pipe_catch);
#endif

    XtAppMainLoop(my_app_con);
}
