.\" $Id: xmailtool.man,v 1.24 92/10/02 11:44:26 bobo Exp $
.TH XMAILTOOL 1 "92/09/10" "Cray Research, Inc."
.SH NAME
xmailtool \- X-Window(X11R4)- and mouse-based interface for \fImail\fP
.SH SYNOPSIS
.B xmailtool [X-Toolkit Options...] [XMailTool Options...]
[options]
.SH DESCRIPTION
.IX xmailtool "" "\fLxmailtool\fR \(em X Window ucb mail interface"
.IX tools xmailtool "" "\fLxmailtool\fR"
.LP
\fBXMailTool\fP manages your mail in much the same manner as \fImail\fP, 
but provides a more convenient and powerful user interface.
Scrollable windows allow easy access to 
your mailbox and mail folders. Software "buttons" make the most frequently 
used commands readily available. 
The full editing capabilities of \fIxedit\fP(1)
are available for modifying and composing mail.
In addition, the behavior of \fIxmailtool\fP may be customized 
by setting parameters with \fIxrdb\fP(1).
Users who are not familiar with the \fImail\fP
program should read 
the manual for \fIMail\fP.
.SH OPTIONS
.LP
\fBXMailTool\fP accepts all of the standard X Toolkit command line options
along with the additional options listed below.    See \fIX\fP(1).
.TP 8
.B \+|\-autoHelp
This option turns off (on) the Auto-Help feature.  If \fBXMailTool\fP is being
run over a slow connection, the Auto-Help strings can slow down the overall
performance of the server.
.TP 8
.B \+|\-cmdBox
This option indicates that the button box in the middle of the tool should
be a box (form) widget.  Additional geometry control is provided for form
widgets.  However, some people have expressed a dislike for its appearance.
.TP 8
.B \-color
This option indicates that \fBXMailTool\fP should use the app-defaults file
that defines some really cool colors.  The default is that \fBXMailTool\fP
uses the default foreground and background colors.
.TP 8
.B \+|\-stateBox
This option indicates that the state toggle buttons shouldn't (should) be
created.
.TP 8
.B \-interval \fIseconds\fP
This option specifies the frequency in  seconds at which \fBXMailTool\fP
should check the system mailbox for a state change.  The default is 15 seconds.
.TP 8
.B \-file \fIfile_name\fP
This option specifies the file to be used as the system mailbox.  This is an
experimental thing and doesn't work very well.  There are a number of
differences in the way \fBMail\fP handles files that are not the default system
mailbox.  For this reason the status of the mailbox may not be correct and 
\fBXMailTool\fP may incorrectly report new mail.
.SH SUBWINDOWS
.LP
\fBXMailTool\fP consists of several subwindows.  They are:
.IP "state (state_cmd_box)" 12
a subwindow with software buttons used to change the action taken by selecting
a message header from the header subwindow.
.IP "folder name (folder_name)" 12
a label indicating the name of the current folder.
.IP "help message (help_msg)" 12
a label that changes to give information about the window the pointer is in.
.IP "header (header_box)" 12
a text subwindow which lists the header information (\fIFrom:\fP
and \fISubject:\fP and so on) for mail messages in the current folder or
system mailbox
.IP "command (cmd_box)" 12
a subwindow with
software buttons corresponding to the most frequently used \fImail\fP commands.
.IP "file (file_name)" 12
a subwindow in which to enter the file name for the file and save
commands.
.IP "directory (directory_name)" 12
a subwindow in which to enter the directory to which to change.
.IP "Mail Output (mail_output)"
responses from \fBMail\fP other than messages or header information will be
displayed in this window.  In addition, error messages from \fBxmailtool\fP
will be displayed in this window.
.IP "message (msg_box)"12
a text subwindow that allows reading of messages that you have received
.IP "Author information (about_box)" 12
a Pop-up that tell you about me.  Click once on it to dismiss it.
.IP "composition (outbound_msg)" 12
a Pop-up text subwindow in which to compose and reply to messages.  This subwindow
appears only when composing, replying, forwarding, or sending a gripe message.
This window may also be an xterm named \fBoutbound_msg\fP if the \fIEDITOR\fP
variable in your .mailrc file is set to use \fBvi\fP.
.SH "State Buttons"
.LP
These buttons are used to change the action taken when selecting a message
from the header window.  The specified action will be taken as long as the
corresponding toggle is set.
.IP  "\fBShow Message\fP" 12
When this toggle is set and a message header is selected from the header
window, the message associated with that header is displayed in the message
window.
.IP "\fBDelete Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is deleted.  The message following the deleted message
becomes the current message and is displayed in the message window.
.IP "\fBSave Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is saved in the file or folder specified in the file
window.
.IP "\fBPreserve Message\fP" 12
When this toggle is set and a message header is selected from the header
window, that message is marked to be preserved when the changes are committed
.SH "COMMAND BUTTONS"
.LP
All buttons except \fBundelete\fP and \fBnext\fP operate on the 
currently selected message.  
To select a message, make a selection anywhere 
on the line in the header subwindow corresponding to the desired message.
This is accomplished by positioning the cursor anywhere on the line,
and clicking the select mouse button (the leftmost one).  The selected message
will automatically be displayed in the message subwindow.
.LP
The  set of command buttons in the \fIcommand subwindow\fP 
is as follows.
.LP
.IP "\fBnext/prev\fP" 12
advance to the next message if there is one.  Move to the previous message if
there isn't a message following the current message.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBprev\fP.  By pressing on this
button while it is \fBprev\fP causes \fBXMailtool\fP to display the
previous message if there is one.  If this is the first message in the
current mailbox, \fBxmailtool\fP will display the next message instead.
.IP \fBcd\fP 12
change to the directory specified in the \fBdirectory\fP subwindow.
.IP \fBcancel\fP 12
abort the operation being performed.  This button appears in each of the
Pop-up subwindows and allows you to abort certain activities.  If your
\fIEDITOR\fP variable is set to something like \fBvi\fP, there won't be
a cancel button on the outbound message window.
.IP \fBcompose/forward\fP 12
Pop-up the composition subwindow to compose a new message.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBforward\fP.  By pressing on this
button while it is \fBforward\fP causes \fBXMailTool\fP to Pop-up a
composition subwindow.  The current message is copied to the composition
buffer optionally with a string prepended to every line.  The user specifies
this string with the \fImprefix\fP variable in the .mailrc file.
.IP \fBsend\fP 12
send the message being composed in the composition subwindow.  This button
appears in the composition subwindow.  Pressing it causes the subwindow to
Pop-down and the message is transferred to \fBMail\fP.  If your
\fIEDITOR\fP variable is set to something like \fBvi\fP, there won't be
a send or cancel button on the outbound message window.
.IP \fBdelete\fP 12
delete the selected message 
.IP "\fBquit/abort\fP" 12
sends the quit command to \fBMail(1)\fP.
.IP "" 12
the key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBabort\fP.  By pressing on this
button while it is \fBabort\fP causes \fBxmailtool\fP to terminate
immediately.  This also causes Mail to
terminate as well.  The changes made to the system mailbox are not saved.
This is equivalent to the abort \fBMail(1)\fP command.
.IP \fBfile\fP 12
commit changes and switch to the file or folder specified in the \fBFile\fP 
window 
.IP \fBFolder\fP 12
Pop-up a window asking the user to select a file in the folder directory.  The
folder directory is specified with the \fIfolder\fP variable in the .mailrc file.
.IP "\fBnew mail\fP" 12
commit changes and reread the system mailbox to see new mail
.IP "\fBdone\fP" 12
commit changes and attempt to iconify the tool window.  If a window manager isn't
running, it will simply commit the changes.  It will not reread the system mailbox.
.IP \fBprint\fP 12
print the selected message on a hardcopy printer.  This causes a copy of the
current message to be piped to the command in the \fIprint_cmd\fP variable. 
The user specifies this variable in the .mailrc file.
.IP \fBreply/reply-all\fP 12
open a composition subwindow to reply to the selected message.  If the
\fIinclude_msg\fP variable has been set, the current message will be copied
to the reply buffer optionally with a string prepended to every line.  The
user specifies this string with the \fImprefix\fP variable in the .mailrc file.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBreply-all\fP.  By pressing
on this button while it is \fBreply-all\fP, you will send the replyall
command to \fBMail\fP causing a reply to go to all recipients of the
original message.  If your version of \fBMail\fP doesn't support the replyall
command, this should be removed.
.IP "\fBsave/Save\fP" 12
save the selected message in the file or folder specified in the \fBFile\fP 
subwindow.
.IP "" 12
The key bindings for this button have been changed so that if you press a
Shift key while in this button, it becomes \fBSave\fP.  By pressing
on this button while it is \fBSave\fP, causes \fBxmailtool\fP to send
the Save command to \fBMail\fP.  This causes \fBMail\fP to save the message
in a file based on the senders name.  If your version of \fBMail\fP doesn't
support the Save command, this should be removed.
.IP \fBpreserve\fP 12
mark a previously saved message to be kept in the system mailbox.  Normally
a saved message will be removed from the system mailbox.
.IP \fBundelete\fP 12
undelete the most recently deleted message(s) - this may be used repeatedly
.IP \fBmailrc\fP 12
source your ~/.mailrc file and thereby acquire the current option/variable settings
.IP \fBabout\fP 12
Pop-up a window showing information about me and displaying a cute picture.
.IP \fBgripe\fP 12
open a composition subwindow.  My address, a subject, and the beginning of
a message will be copied to the reply buffer.
.IP \fBhelp\fP 12
Pop-up a window containing a list of the accelerators.
.SH XMT-NOTIFY
.LP
\fBXMailTool\fP allows the user to pass strings to a number of buttons.
A list of the buttons and their use of the strings is as follows:
.IP \fBnext\fP 12
The string is used to determine if the next message or the previous message
is to be displayed.  The two valid values are "next" and "prev".  Any other
value will cause an error message.
.IP \fBsave\fP 12
The string is passed as the command to mail.  The message number and
contents of the \fIfile_name\fP are passed to \fBMail\fP as the first
and second argument.  If the string is "Save" then only the message number is
passed to \fBMail\fP.  It is assumed that a command similar to save will
be used in this string.
.IP \fBprint\fP 12
The string is executed by \fBsh\fP.  The stdin of the command will be
a file containing the message.
.IP \fBcompose\fP 12
The string is used to determine how \fBXMailTool\fP is to create an outbound
message.  The string can be a space, comma, or dash (-) separated list of any
of the following strings:  "include" -- include the current message,
"noinclude" -- don't include the current message, "notinclude" -- do the
opposite of the include_msg flag set in the .mailrc file, "sign" -- append the
~/.signature file, "nosign" -- don't append the ~/.signature file, "notsign" --
do the opposite of the do_signature flage in the .mailrc file.  Any other
value will cause an error message.
.IP \fBreply\fP 12
The string is used to determin how \fBXMailTool\fP is to create a reply
message.  The string can be a space, comma, or dash (-) separated list of any
of the strings used by the compose button and the string "all" -- reply to
the originator and all recipients of the original message.
.IP \fBquit\fP 12
The string is used to determine how \fBXMailTool\fP should terminate
\fBMail(1)\fP.  The two valid values are "quit" and "abort".  Any other
value will cause an error message.
.SH FOLDER SELECTION
.LP
\fBXMailTool\fP allows the user to traverse through the directory structure
that begins at the directory specified by the \fIfolder\fP variable.  When the
Folder button is pressed, a pop-up window appears containing a list of files
in the folder directory.  Subdirectories are marked with a "/" (slash) after
their name.  If the user selects a subdirectory from the list, the current list
is destroyed and the list of files from the subdirectory are displayed.  Other
files are treated as mailbox files
.LP
When a mailbox file is selected, there are three possible actions that 
\fBXMailTool\fP will take.  These actions may be specified in any combination
and are passed to XMT-Notify as strings.  They are as follows:
.IP \fBSAVE\fP 12
The currently selected message is saved in the file specified by this name.
The default is that this action is taken when ever a Shift key is depressed
while selecting a mailbox file.
.IP \fBCHANGE\fP 12
The text that appears in the "File Name:" string will be changed to this
value.  The default is that this action is taken when ever a Control key is
depressed while selecting a mailbox file.
.IP \fBLOAD\fP 12
Changes to the current mailbox file are committed and messages from this
mailbox file are read and displayed.  The default is that this action is taken
when ever a Mod1 key (usually the Meta or Alt keys) are depressed or no 
modifier keys are depressed while selecting a mailbox file.
.LP
From the description above, it can be concluded that if a mailbox file is
selected while the Shift and Control keys are depressed, the current message
will be saved to that file and the "File Name:" string will be changed.
.SH SAVED FILE NAMES
.LP
\fBXMailTool\fP will save the names of the mailbox files that have most
recently been saved to or viewed.  The "File Name:" label is then a button that
allows the user to circulate through the saved file names.  The number of
saved file names is specified by the \fInum_saved_fnames\fP variable.  See the
VARIABLES section below.
.SH HEADER SEARCHING
.LP
\fBXMailTool\fP allows the user to search for message header information.  This
is done by pressing \fICtrl-s\fP in the header_box window.  The search dialog
for this window acts slightly different than the normal Xaw Text Widget search
dialog in that if you press the "search" button, any matches will cause those
messages to be displayed.
.SH VISUAL EDITOR
.LP
\fBXMailTool\fP allows the user to specify the visual editor to use when
composing an outbound message.  This is done by setting the EDITOR variable
in the .mailrc file.  See the VARIABLES section below.  \fBXMailTool\fP
supports three sets of editors.
.IP Internal 12
An Athena Widgets Text editor is used when the EDITOR variable is set to
"none" in the .mailrc file.  This editor gives the user the most control
and a more intuitive user interface.  The key bindings are almost identical
to the Xaw Text Widget with the exception to special tilde bindings.  See
the TILDE COMMANDS section below.  For more information about the key bindings
for the Xaw Text Widget, see the \fIAthena Widget Set - C Language
Interface\fP manual from M.I.T.  This editor is essentially \fBemacs\fP based.
.IP "Terminal Based" 12
\fBXMailTool\fP allows the user to specify a terminal based editor such as
\fBvi\fP.  This is done by setting the EDITOR variable to the desired editor
and setting the edit_needs_xterm variable.  An \fBxterm\fP is forked specifying
the -e option as follows:  "xterm -e $EDITOR message_file", where message_file
is the temporary file containing the outbound message.  In order to indicate
that the message is to be sent, the user must update the file so that it's
modification time is after it's creation time.  To indicate that the
message is not to be sent, the user must either remove the file, or not
update the file.  The modification time is checked when \fBxmailtool\fP
receives the death of child signal from \fBxterm\fP.
.IP "Independent" 12
\fBXMailTool\fP allows the user to specify an editor which doesn't require
an \fBxterm\fP.  This is done by setting the EDITOR variable to the desired
editor and setting the edit_needs_xterm to zero.  NOTE:  by default the
edit_needs_xterm variable is assumed to be 1.  A shell is forked specifying
the -c option as follows:  "$SHELL -c $EDITOR message_file", where message_file
is the temporary file containing the outbound message.  As above, if the file's
modification time is after it's creation time, \fBxmailtool\fP assumes the
message is to be sent.
.SH TILDE COMMANDS
.LP
\fBXMailTool\fP supports a number of tilde (~) commands in the composition
window if the user has set the EDITOR variable to "none."  These commands may
be slightly different than your implementation of \fBMail\fP.  Each tilde
command must start at the beginning of a line.  If a tilde (~) is typed at
the beginning of the line followed by a character that isn't a recognized
command, both the tilde (~) and the second character are printed.  The
recognized commands are as follows:
.IP "~r" 12
read a file into the current outbound message beginning at the current line.
This command is almost synonymous to the Meta-i command except that it
must begin the line -- Meta-i can be used in the middle of a line.
.IP "~a" 12
insert the contents of the sign variable into the current outbound message
beginning at the current line.  The sign variable is scanned for escaped
characters prior to insertion.  Currently only n,r, and t are supported
escaped characters.
.IP "~A" 12
insert the contents of the Sign variable into the current outbound message
beginning at the current line.  As above the Sign variable is scanned for
escaped characters.
.IP "~d" 12
inserts the contents of the file named in the DEAD variable.  This is normally
the dead.letter file.
.IP "~f" 12
inserts the currently viewed message into the current outbound message.  The
current viewed message is the one being viewed in the \fBxmailtool\fP window.
.IP "~m" 12
inserts the currently viewed message into the current outbound message
prepending the contents of the mprefix variable to each line.  The current
message is the one being viewed in the \fBxmailtool\fP window.
.IP "~v" 12
Switch to the editor specified by the VISUAL variable.  This has got to be
one of the coolest features I've done.  It pops down the Xaw editor window
and forks a process as described above in the VISUAL EDITOR section.  When
you are done editing the file, it switches you back to the Xaw editor.
.IP "~~" 12
insert the tilde character at the first position of the line.
.SH ALIASES
.LP
\fBXMailTool\fP supports recursive aliases.  That is to say that if you
have defined aliases in your .mailrc file, \fBXMailTool\fP will expand an
address in an outbound message that matches your aliases.  Most versions of
\fBMail\fP don't support recursive aliases -- aliases that reference other
aliases.  I'm not sure why that is, but I choose to support them.
.LP
If an alias contains the name of the alias as one of its entries,
\fBXMailTool\fP will not expand that entry.  That is, if the alias "man"
expands to "foo, man, choo," \fBXMailTool\fP will attempt to expand only
"foo" and "choo."  It is important that the user be careful not to specify
aliases in such a way as to create a loop.  An example of this would be if
the user defined an alias "foo" that expands to "bar," and an alias "bar"
that expands to "foo."  Because of the scope of such loops, \fBXMailTool\fP
does not make an attempt to detect such loops.
.LP
Aliasing can be turned off by setting the do_xmtaliases to 0. See the
VARIABLES section for more details.
.SH VARIABLES
.LP
Not every version of mail supports each of the variables that \fBXMailTool\fP
supports.  Special \fBxmailtool\fP variables are as follows -- these are
specified in the .mailrc file:
.LP
.IP do_signature 12
if the file $HOME/.signature exists and this variable is set to 1, the contents
of the $HOME/.signature file will be appended to the outbound message
buffer when a compose, reply, forward, or gripe button is pressed.  The
default is 1.
.IP do_xmtaliases 12
if this variable is set to 1, \fBXMailTool\fP will attempt to perform
it's own alias expansion.  If this variable is set to 0, the contents of
the outbound message buffer will be passed to the mail sender as is.  The
default is 1.
.IP do_xmtrecord 12
if this variable is set to 1 and the record variable is set, then
\fBXMailTool\fP will append the contents of the outbound message buffer to
the contents of the file specified by the record variable.  The default is 1
if \fBXMailTool\fP has been compiled to use sendmail, and 0 otherwise.
.IP showlast 12
the last message in the mailbox should be displayed first after deiconifying
\fBXMailTool\fP, pressing the newmail button, or selecting a new mailbox file.
The default is 0 (show first new or unread message).
.IP num_saved_files 12
the number of strings that should be allocated for saving file names that are
referenced.  The default is 5.
.IP include_msg 12
insert the original message body within the reply buffer just after the message
header information and just before the signature information when the reply
button is pressed.  The default is 0 (don't include the message).
.IP interval 12
the frequency in seconds that \fBXMailTool\fP should check the system mailbox
for a state change.  The default is 15 seconds.
.IP mprefix 12
.IP indentprefix 12
when including the original message body as in a reply or forward, prepend each
line with this string.  Both mprefix and indentprefix are stored internally in
the same place.  If both variables are used, the last one set will override the
first.
.IP asksub 12
always ask the user to specify a subject in a compose message.
.IP askcc 12
always ask the user to specify a carbon copy list.
.IP askbcc 12
always ask the user to specify a blind carbon copy list.
.IP bell 12
ring the bell this number of times.  The default is 1.
.IP print_cmd 12
use this command for the print command.  The stdin of this command will be
the message.
.IP edit_needs_xterm 12
indicates that the command in the EDITOR variable needs to be wrapped with
an \fBxterm\fP.  The default is 1.
.IP cmd_box 12
indicates whether the command box is to be a box widget or a form widget.
In a box widget, button placement is very loose.  In a form widget a great
deal of control is enforced on the buttons.  By setting this variable, the
user indicates that they want a box widget.  The default is 0 (use a form).
.IP confirm_EDITOR 12
indicates that when the EDITOR variable is set to use an external editor,
\fBXMailTool\fP should ask the user whether to send the message when the
editor process terminates.  The default is 1 (confirm outbound messsages).
.IP state_box 12
indicates whether the state command box is to be created.  If you find the
toggles at the top of the \fBXMailTool\fP window to be annoying, set this
variable to zero (0).  The default is 1 (show state box).
.SH FILES
.br
/usr/spool/mail/*       post office
.br
~/\fB.\fPmailrc		file giving initial mail commands
.br
~/\fB.\fPsignature	file to be appended to each outbound message
.br
~/\fB.\fPenvelope	file containing mail headers to include in
			outbound messages
.SH SEE ALSO
.br
.IR binmail (1), 
.IR xrdb (1),
.IR mail (1), 
.IR xedit (1)
.br 
.IR aliases (5),  
.IR mailaddr (7),
.IR newaliases( 8), 
.IR sendmail (8)
.SH BUGS
.LP
New mail status is only approximate, therefore the presence of new mail
is not always accurately reflected in the icon image.
.LP
Some versions of \fBMail\fP don't handle multiple definitions of an alias.
If you have two lines that define the same alias, the second may augment
the first line.  In addition, if you source your .mailrc file, your aliases
will be doubled on themselves.
.SH ACKNOWLEGEMENTS
.LP
Thanks go to the following people for their contribution in the
shaping and creation of \fBXMailTool\fP.
.IP "\fBSharon and Ward Kierski\fP (my Mom and Dad)" 12
.IP "\fBKeith A. Fredericks\fP" 12
.IP "\fBSteve Crooks, Intergraph\fP" 12
.IP "\fBGordon Lack\fP" 12
.IP "\fBRichard K. Lloyd, Computer Science Dept., Liverpool University\fP" 12
.IP "\fBHarald* Vogt, Department of Computer Science, Utrecht University\fP" 12
.IP "\fBJose Manuel Menendez, Universidad Politecnica de Madrid, Spain\fP" 12
.IP "\fBPhill Everson, Sequent\fP" 12
.IP "\fBFrederick R. Phelan Jr.\fP" 12
.IP "\fBGrant Totten, Trent University, Peterborough Ontario\fP" 12
.IP "\fBPaul A. Weber, Loral Command & Control Systems\fP" 12
.IP "\fBSekera Zdenek\fP" 12
.IP "\fBJohn Gillono\fP" 12
.IP "\fBJohn Freeman\fP" 12
.IP "\fBNeil Williams\fP" 12
.IP "\fBChris Butler\fP" 12
.IP "\fBJohn Rollwagen\fP (He signs my check)" 12



