#!ttwish -file
#
# tclttmon
# A Tooltalk monitor in Tcl
#
# $Id: tclttmon.tcl,v 1.2 93/08/25 11:06:23 beust Exp Locker: beust $
#

# Boolean variable that says if the monitor is active
# Toggled by the procedure toggleMonitorActive
set monitorActive 1

# These booleans are related to the Pattern Attributes window
set PatAddressTog 1
set PatClassTog 1
set PatDispositionTog 0
set PatFileTog 0
set PatObjectTog 0
set PatOperationTog 0
set PatOtypeTog 0
set PatScopeTog 1
set PatSenderTog 0
set PatSenderPtypeTog 0
set PatSessionTog 0
set PatStateTog 0

# These variables hold the actual value of the patterns
set PatAddressVal Procedure
set PatClassVal Notice
set PatDispositionVal Queue
set PatFileVal ""
set PatObjectVal ""
set PatOperationVal ""
set PatOtypeVal ""
set PatScopeVal Session
set PatSenderVal ""
set PatSenderPtypeVal ""
set PatSessionVal ""
set PatStateVal Created

# These booleans are related to the Message Attributes window
set MsgDispositionTog 0
set MsgFileTog 0
set MsgHandlerTog 0
set MsgHandlerPtypeTog 0
set MsgObjectTog 0
set MsgOperationTog 0
set MsgOtypeTog 0
set MsgScopeTog 1
set MsgSessionTog 0
set MsgArgsTog 1

# These variables hold the actual value of the messages
set MsgAddressVal Procedure
set MsgClassVal Notice
set MsgDispoVal Queue
set MsgFileVal ""
set MsgHandlerVal ""
set MsgHandlerPtypeVal ""
set MsgObjectVal ""
set MsgOperationVal ""
set MsgOtypeVal ""
set MsgScopeVal Session
set MsgSessionVal ""
set MsgArgsVal "{One} {Two} {Three}"

# These booleans are related to the Display Settings window
set DisAddressTog 1
set DisClassTog 1
set DisDispositionTog 0
set DisFileTog 0
set DisGidTog 0
set DisHandlerTog 0
set DisHandlerPtypeTog 0
set DisObjectTog 0
set DisOperationTog 1
set DisOtypeTog 0
set DisScopeTog 1
set DisSenderTog 0
set DisSenderPtypeTog 0
set DisSessionTog 0
set DisStateTog 1
set DisStatusTog 0
set DisStatusStringTog 0
set DisUidTog 0
set DisArgsTog 1

# Last used pattern, to be destroyed before any new one is registered
set lastPattern 0

# Debug
set wantTooltalk 1

proc listboxContents {lb} {
    set result ""
    $lb select from 0
    $lb select to end
    set indices [$lb curselection]
    while {[llength $indices] != 0} {
	lappend result [$lb get [lindex $indices 0]]
	set indices [lrange $indices 1 end]
    }
    return $result
}

# Toggle the value of the boolean value monitorActive
proc toggleMonitorActive {} {
    global monitorActive lastPattern
    if {$monitorActive == 1} {
	global monitorActive
	set monitorActive 0
	.main.start configure -text "Start"
	tt_pattern_unregister $lastPattern
    } else {
	global monitorActive
	set monitorActive 1
	.main.start configure -text "Stop"
	tt_pattern_register $lastPattern
	tt_session_join [tt_default_session]
    }
}

###########################################################################
# Pattern procedures
###########################################################################

# Query a new pattern from the interface and register it
proc registerNewPattern {} {
    global PatAddressTog PatClassTog PatDispositionTog PatFileTog \
	   PatObjectTog PatOperationTog PatOtypeTog PatScopeTog PatSenderTog \
	   PatSenderPtypeTog PatSessionTog PatStateTog \
	   lastPattern \
	   TT_HANDLER TT_OBJECT TT_OTYPE TT_PROCEDURE \
	   TT_NOTICE TT_REQUEST \
	   TT_SESSION TT_FILE TT_BOTH TT_FILE_IN_SESSION \
	   TT_OBJECT TT_HANDLER TT_OTYPE TT_ADDRESS_LAST \
	   TT_OBSERVE TT_HANDLE \
	   TT_IN TT_OUT TT_IN_OUT TT_MODE_LAST \
           TT_QUEUE TT_START \
           TT_INT_MSG_ARG_TYPE TT_STRING_MSG_ARG_TYPE

    if {$lastPattern != 0} { tt_pattern_destroy $lastPattern }
    set pat [tt_pattern_create]

    if {$PatAddressTog == 1} {
	global PatAddressVal
	case $PatAddressVal in {
	    Handler {set val $TT_HANDLER}
	    Object {set val $TT_OBJECT}
	    Otype {set val $TT_OTYPE}
	    Procedure {set val $TT_PROCEDURE}
	}
	tt_pattern_address_add $pat $val
    }
    if {$PatClassTog == 1} {
	global PatClassVal
	case $PatClassVal in {
	    Notice {set val $TT_NOTICE}
	    Request {set val $TT_REQUEST}
	}
	tt_pattern_class_add $pat $val
    }
    if {$PatDispositionTog == 1} {
	global PatDispositionVal
	case $PatDispositionVal in {
	    Queue {set val $TT_QUEUE}
	    Start {set val $TT_START}
	    "Queue+Start" {set val [expr "$TT_QUEUE + $TT_START"]}
	}
	tt_pattern_disposition_add $pat $val
    }
    if {$PatFileTog == 1} {
	global PatFileVal
	set PatFileVal [.pw.fpat.radios.file.r2 get 1.0 end]
           TT_PROCEDURE
	tt_pattern_file add $pat $PatFileVal
    }
    if {$PatObjectTog == 1} {
	global PatObjectVal
	set PatObjectVal [.pw.fpat.radios.object.r2 get 1.0 end]
	tt_pattern_object_add $pat $PatObjectVal
    }
    if {$PatOperationTog == 1} {
	global PatOperationVal
	set PatOperationVal [.pw.fpat.radios.operation.r2 get 1.0 end]
	tt_pattern_operation_add $pat $PatOperationVal
    }
    if {$PatOtypeTog == 1} {
	global PatOtypeVal
	set PatOtypeVal [.pw.fpat.radios.otype.r2 get 1.0 end]
	tt_pattern_otype_add $pat $PatOperationVal
    }
    if {$PatScopeTog == 1} {
	global PatScopeVal
	case $PatScopeVal in {
	    File {set val $TT_FILE}
	    Session {set val $TT_SESSION}
	    Both {set val $TT_BOTH}
	    {File in session} {set val $TT_FILE_IN_SESSION}
	}
	tt_pattern_scope_add $pat $val
    }
    if {$PatSenderTog == 1} {
	global PatSenderVal
	set PatSenderVal [.pw.fpat.radios.sender.r2 get 1.0 end]
	tt_pattern_sender_add $pat $PatSenderVal
    }
    if {$PatSenderPtypeTog == 1} {
	global PatSenderPtypeVal
	set PatSenderPtypeVal [.pw.fpat.radios.senderPtype.r2 get 1.0 end]
	tt_pattern_sender_ptype_add $pat $PatSenderPtypeVal
    }
    if {$PatSessionTog == 1} {
	global PatSessionVal
	set PatSessionVal [.pw.fpat.radios.session.r2 get 1.0 end]
        tt_pattern_session_add $pat $PatSessionVal
    }
    tt_pattern_callback_add $pat patternCallback
    tt_pattern_category_set $pat $TT_OBSERVE
    tt_pattern_register $pat
    tt_session_join [tt_default_session]
    set lastPattern $pat
    destroy .pw
}

proc buildPatternWindow {} {
    global PatFileVal PatObjectVal PatOperationVal PatOtypeVal \
	   PatSenderVal PatSenderPtypeVal PatSessionVal
    toplevel .pw
    wm title .pw "Pattern Attributes"
    frame .pw.fpat -borderwidth 2 -relief raised

# Create a vertical frame that will hold all the toggle buttons
    frame .pw.fpat.tog
    pack append .pw.fpat.tog \
	[checkbutton .pw.fpat.tog.address -variable PatAddressTog \
	 -text Address -relief flat] {top frame nw } \
	[checkbutton .pw.fpat.tog.class -variable PatClassTog \
	 -text Class -relief flat] {top frame nw } \
	[checkbutton .pw.fpat.tog.dispo -variable PatDispositionTog \
	 -text Disposition -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.file -variable PatFileTog \
	 -text File -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.object -variable PatObjectTog \
	 -text Object -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.operation -variable PatOperationTog \
	 -text Operation -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.otype -variable PatOtypeTog \
	 -text Otype -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.scope -variable PatScopeTog \
	 -text Scope -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.sender -variable PatSenderTog \
	 -text Sender -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.senderPtype -variable PatSenderPtypeTog \
	 -text "Sender ptype" -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.session -variable patSessionTog \
	 -text Session -relief flat] {top frame nw} \
	[checkbutton .pw.fpat.tog.state -variable PatStateTog \
	 -text State -relief flat] {top frame nw}

# Create another vertical frame that will hold all the radio buttons
    frame .pw.fpat.radios

# Create a frame for Address radio buttons
    frame .pw.fpat.radios.address 
    pack append .pw.fpat.radios.address \
	[radiobutton .pw.fpat.radios.address.r1 -variable PatAddressVal -text \
	 Handler -relief flat -value Handler -command {.pw.fpat.tog.address select}] {left fillx} \
	[radiobutton .pw.fpat.radios.address.r2 -variable PatAddressVal -text \
	 Object -relief flat -value Object -command {.pw.fpat.tog.address select}] {left fillx} \
	[radiobutton .pw.fpat.radios.address.r3 -variable PatAddressVal -text \
	 Otype -relief flat -value Otype -command {.pw.fpat.tog.address select}] {left fillx} \
	[radiobutton .pw.fpat.radios.address.r4 -variable PatAddressVal -text \
	 Procedure -relief flat -value Procedure -command {.pw.fpat.tog.address select}] {left fillx}

    pack append .pw.fpat.radios .pw.fpat.radios.address {top frame w}

# Create a frame for Class radio buttons
    frame .pw.fpat.radios.class
    pack append .pw.fpat.radios.class \
	[radiobutton .pw.fpat.radios.class.r2 -variable PatClassVal -text \
	 Notice -relief flat -value Notice  -command {.pw.fpat.tog.class select}] {left } \
	[radiobutton .pw.fpat.radios.class.r3 -variable PatClassVal -text \
	 Request -relief flat -value Request -command {.pw.fpat.tog.class select}] {left  }

    pack append .pw.fpat.radios .pw.fpat.radios.class {top frame w}

# Create a frame for Disposition radio buttons
    frame .pw.fpat.radios.dispo
    pack append .pw.fpat.radios.dispo \
	[radiobutton .pw.fpat.radios.dispo.r2 -variable PatDispositionVal -text \
	 Queue -relief flat -value Queue  -command {.pw.fpat.tog.dispo select}] {left } \
	[radiobutton .pw.fpat.radios.dispo.r3 -variable PatDispositionVal -text \
	 Start -relief flat -value Start  -command {.pw.fpat.tog.dispo select}] {left } \
	[radiobutton .pw.fpat.radios.dispo.r4 -variable PatDispositionVal -text \
	 "Queue+Start" -relief flat -value "Queue+Start"  -command {.pw.fpat.tog.dispo select}] {left }

    pack append .pw.fpat.radios .pw.fpat.radios.dispo {top frame w}

# Create a frame for File text button
    frame .pw.fpat.radios.file -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.file \
	[text .pw.fpat.radios.file.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.file.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.file {top frame w}

# Create a frame for Object text button
    frame .pw.fpat.radios.object -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.object \
	[text .pw.fpat.radios.object.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.object.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.object {top frame w}

# Create a frame for Operation text button
    frame .pw.fpat.radios.operation -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.operation \
	[text .pw.fpat.radios.operation.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.operation.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.operation {top frame w}

# Create a frame for Otype text button
    frame .pw.fpat.radios.otype -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.otype \
	[text .pw.fpat.radios.otype.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.otype.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.otype {top frame w}

# Create a frame for Scope radio buttons
    frame .pw.fpat.radios.scope
    pack append .pw.fpat.radios.scope \
	[radiobutton .pw.fpat.radios.scope.r2 -variable PatScopeVal -text \
	 File -relief flat -value File  -command {.pw.fpat.tog.scope select}] {left } \
	[radiobutton .pw.fpat.radios.scope.r3 -variable PatScopeVal -text \
	 Session -relief flat -value Session  -command {.pw.fpat.tog.scope select}] {left } \
	[radiobutton .pw.fpat.radios.scope.r4 -variable PatScopeVal -text \
	 Both -relief flat -value Both  -command {.pw.fpat.tog.scope select}] {left } \
	[radiobutton .pw.fpat.radios.scope.r5 -variable PatScopeVal -text \
	 "File in session" -relief flat -value "File in session"  -command {.pw.fpat.tog.scope select}] {left }

    pack append .pw.fpat.radios .pw.fpat.radios.dispo {top frame w}

# Create a frame for Sender text button
    frame .pw.fpat.radios.sender -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.sender \
	[text .pw.fpat.radios.sender.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.sender.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.sender {top frame w}

# Create a frame for Sender ptype text button
    frame .pw.fpat.radios.senderPtype -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.senderPtype \
	[text .pw.fpat.radios.senderPtype.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.senderPtype.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.senderPtype {top frame w}

# Create a frame for Session text button
    frame .pw.fpat.radios.session -borderwidth 1 -relief raised
    pack append .pw.fpat.radios.session \
	[text .pw.fpat.radios.session.r2 -height 1] {left pady 4}

    set tmp .pw.fpat.radios.session.r2
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.session {top frame w}

# Create a frame for State radio buttons
    frame .pw.fpat.radios.state -borderwidth 2
    pack append .pw.fpat.radios.state \
	[radiobutton .pw.fpat.radios.state.r2 -variable PatStateVal -text \
	 Created -relief flat -value Created  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r3 -variable PatStateVal -text \
	 Failed -relief flat -value Failed  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r4 -variable PatStateVal -text \
	 Handled -relief flat -value Handled  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r5 -variable PatStateVal -text \
	 Rejected -relief flat -value Rejected  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r6 -variable PatStateVal -text \
	 Sent -relief flat -value Sent  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r7 -variable PatStateVal -text \
	 Started -relief flat -value Started  -command {.pw.fpat.tog.state select}] {left } \
	[radiobutton .pw.fpat.radios.state.r8 -variable PatStateVal -text \
	 Queued -relief flat -value Queued  -command {.pw.fpat.tog.state select}] {left }

    set tmp .pw.fpat.radios.file.r2
    $tmp insert end $PatFileVal
    bind $tmp <Any-Key-Return> registerNewPattern
    pack append .pw.fpat.radios .pw.fpat.radios.state {top frame w}

# Stack vertically all the frames containing the radios
    pack append .pw.fpat.radios .pw.fpat.radios.address {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.class {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.dispo {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.file {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.object {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.operation {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.otype {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.scope {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.sender {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.senderPtype {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.session {top frame w}
    pack append .pw.fpat.radios .pw.fpat.radios.state {top frame w}

# Create the Apply button
    frame .pw.fpat.app
    pack append .pw.fpat.app \
	[button .pw.fpat.app.apply -text Register -command registerNewPattern] \
	{left padx 30 pady 10 expand} \
	[button .pw.fpat.app.cancel -text Abort -command {destroy .pw}] \
	{left padx 30 pady 30 expand}


# Finally, gather the main frames
    pack append .pw.fpat .pw.fpat.app {bottom pady 10}
    pack append .pw.fpat .pw.fpat.tog {left frame nw}
    pack append .pw.fpat .pw.fpat.radios {right }

    pack append  .pw .pw.fpat {top }
}

###########################################################################
# Message procedures
###########################################################################

proc sendMessage {} {
    global MsgDispositionTog MsgFileTog \
	   MsgHandlerTog MsgHandlerPtypeTog MsgObjectTog MsgOperationTog \
	   MsgOtypeTog MsgScopeTog MsgSessionTog MsgAddressVal MsgClassVal \
           MsgArgsTog \
	   TT_HANDLER TT_OBJECT TT_OTYPE TT_PROCEDURE \
	   TT_NOTICE TT_REQUEST \
	   TT_SESSION TT_FILE TT_BOTH TT_FILE_IN_SESSION \
	   TT_OBJECT TT_HANDLER TT_OTYPE TT_ADDRESS_LAST \
	   TT_OBSERVE TT_HANDLE \
	   TT_IN TT_OUT TT_IN_OUT TT_MODE_LAST \
           TT_INT_MSG_ARG_TYPE TT_STRING_MSG_ARG_TYPE

    set msg [tt_message_create]
    case $MsgAddressVal in {
	Handler {set val $TT_HANDLER}
	Object {set val $TT_OBJECT}
	Otype {set val $TT_OTYPE}
	Procedure {set val $TT_PROCEDURE}
    }
    tt_message_address_set $msg $val
    case $MsgClassVal in {
	Notice {set val $TT_NOTICE}
	Request {set val $TT_REQUEST}
    }
    tt_message_class_set $msg $val

    if {$MsgDispositionTog == 1} {
	global MsgDispositionVal
	case $MsgDispositionVal in {
	    Queue {set val $TT_QUEUE}
	    Start {set val $TT_START}
	    "Queue+Start" {set val [expr "$TT_QUEUE + $TT_START"]}
	}
	tt_message_disposition_set $msg $val
    }
    if {$MsgFileTog == 1} {
	global MsgFileVal
	set MsgFileVal [.mw.fmsg.radios.file.r2 get 1.0 end]
	tt_message_file_set $msg $MsgFileVal
    }
    if {$MsgHandlerPtypeTog == 1} {
	global MsgHandlerPtypeVal
	set MsgHandlerPtypeVal [.mw.fmsg.radios.handlerPtype.r2 get 1.0 end]
	tt_message_handler_ptype_set $msg $MsgHandlerPtypeVal
    }
    if {$MsgObjectTog == 1} {
	global MsgObjectVal
	set MsgObjectVal [.mw.fmsg.radios.object.r2 get 1.0 end]
	tt_message_object_set $msg $MsgObjectVal
    }
    if {$MsgOperationTog == 1} {
	global MsgOperationVal
	set MsgOperationVal [.mw.fmsg.radios.operation.r2 get 1.0 end]
	tt_message_op_set $msg $MsgOperationVal
    }
    if {$MsgOtypeTog == 1} {
	global MsgOtypeVal
	set MsgOtypeVal [.mw.fmsg.radios.otype.r2 get 1.0 end]
	tt_message_otype_set $msg $MsgOtypeVal
    }
    if {$MsgScopeTog == 1} {
	global MsgScopeVal
	case $MsgScopeVal in {
	    File {set val $TT_FILE}
	    Session {set val $TT_SESSION}
	    Both {set val $TT_BOTH}
	    {File in session} {set val $TT_FILE_IN_SESSION}
	}
	tt_message_scope_set $msg $val
    }
    if {$MsgSessionTog == 1} {
	global MsgSessionVal
	set MsgSessionVal [.mw.fmsg.radios.session.r2 get 1.0 end]
	tt_message_session_set $msg $MsgSessionVal
    }

    if {$MsgArgsTog == 1} {
	global MsgArgsVal
	set lb .mw.fmsg.radios.args.f2.r2
	$lb select from 0
	$lb select to end
	set MsgArgsVal [listboxContents $lb]
	foreach i $MsgArgsVal {
	    global TT_IN_OUT
	    tt_message_arg_add $msg $TT_IN_OUT $TT_STRING_MSG_ARG_TYPE $i
	}
    }

    tt_message_send $msg
    tt_message_destroy $msg
    destroy .mw
}

proc buildMessageWindow {} {
    global MsgFileVal MsgHandlerVal MsgHandlerPtypeVal MsgObjectVal \
	   MsgOperationVal MsgOtypeVal MsgSessionVal MsgArgsVal
    toplevel .mw
    wm title .mw "Message Attributes"
    frame .mw.fmsg -borderwidth 2 -relief raised

# Create a vertical frame that will hold all the toggle buttons
    frame .mw.fmsg.tog
    pack append .mw.fmsg.tog \
	[checkbutton .mw.fmsg.tog.dispo -variable MsgDispositionTog \
	 -text Disposition -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.file -variable MsgFileTog \
	 -text File -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.handler -variable MsgHandlerTog \
	 -text Handler -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.handlerPtype -variable MsgHandlerPtypeTog\
	 -text {Handler Ptype} -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.object -variable MsgObjectTog \
	 -text Object -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.operation -variable MsgOperationTog \
	 -text Operation -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.otype -variable MsgOtypeTog \
	 -text Otype -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.scope -variable MsgScopeTog \
	 -text Scope -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.session -variable MsgSessionTog \
	 -text Session -relief flat] {top frame nw} \
	[checkbutton .mw.fmsg.tog.args -variable MsgArgsTog \
	 -text Args -relief flat] {top frame nw}

# Create another vertical frame that will hold all the radio buttons
    frame .mw.fmsg.radios

# Create a frame for Address radio buttons
    frame .mw.fmsg.radios.address 
    pack append .mw.fmsg.radios.address \
	[radiobutton .mw.fmsg.radios.address.r1 -variable MsgAddressVal -text \
	 Handler -relief flat -value Handler] {left fillx} \
	[radiobutton .mw.fmsg.radios.address.r2 -variable MsgAddressVal -text \
	 Object -relief flat -value Object] {left fillx} \
	[radiobutton .mw.fmsg.radios.address.r3 -variable MsgAddressVal -text \
	 Otype -relief flat -value Otype] {left fillx} \
	[radiobutton .mw.fmsg.radios.address.r4 -variable MsgAddressVal -text \
	 Procedure -relief flat -value Procedure] {left fillx}

    pack append .mw.fmsg.radios .mw.fmsg.radios.address {top frame w}

# Create a frame for Class radio buttons
    frame .mw.fmsg.radios.class
    pack append .mw.fmsg.radios.class \
	[radiobutton .mw.fmsg.radios.class.r2 -variable MsgClassVal -text \
	 Notice -relief flat -value Notice ] {left } \
	[radiobutton .mw.fmsg.radios.class.r3 -variable MsgClassVal -text \
	 Request -relief flat -value Request] {left  }

    pack append .mw.fmsg.radios .mw.fmsg.radios.class {top frame w}

# Create a frame for Disposition radio buttons
    frame .mw.fmsg.radios.dispo
    pack append .mw.fmsg.radios.dispo \
	[radiobutton .mw.fmsg.radios.dispo.r2 -variable MsgDispoVal -text \
	 Queue -relief flat -value Queue -command {.mw.fmsg.tog.dispo select}] {left } \
	[radiobutton .mw.fmsg.radios.dispo.r3 -variable MsgDispoVal -text \
	 Start -relief flat -value Start  -command {.mw.fmsg.tog.dispo select}] {left } \
	[radiobutton .mw.fmsg.radios.dispo.r4 -variable MsgDispoVal -text \
	 "Queue+Start" -relief flat -value "Queue+Start" -command {.mw.fmsg.tog.dispo select} ] {left }

    pack append .mw.fmsg.radios .mw.fmsg.radios.dispo {top frame w}

# Create a frame for File text button
    frame .mw.fmsg.radios.file -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.file \
	[text .mw.fmsg.radios.file.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.file.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgFileVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.file {top frame w}

# Create a frame for Handler text button
    frame .mw.fmsg.radios.handler -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.handler \
	[text .mw.fmsg.radios.handler.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.handler.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgHandlerVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.handler {top frame w}

# Create a frame for Handler Ptype text button
    frame .mw.fmsg.radios.handlerPtype -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.handlerPtype \
	[text .mw.fmsg.radios.handlerPtype.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.handlerPtype.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgHandlerPtypeVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.handlerPtype {top frame w}

# Create a frame for Object text button
    frame .mw.fmsg.radios.object -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.object \
	[text .mw.fmsg.radios.object.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.object.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgObjectVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.object {top frame w}

# Create a frame for Operation text button
    frame .mw.fmsg.radios.operation -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.operation \
	[text .mw.fmsg.radios.operation.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.operation.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgOperationVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.operation {top frame w}

# Create a frame for Otype text button
    frame .mw.fmsg.radios.otype -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.otype \
	[text .mw.fmsg.radios.otype.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.otype.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgOtypeVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.otype {top frame w}

# Create a frame for Scope radio buttons
    frame .mw.fmsg.radios.scope
    pack append .mw.fmsg.radios.scope \
	[radiobutton .mw.fmsg.radios.scope.r2 -variable MsgScopeVal -text \
	 File -relief flat -value File  -command {.mw.fmsg.tog.scope select}] {left } \
	[radiobutton .mw.fmsg.radios.scope.r3 -variable MsgScopeVal -text \
	 Session -relief flat -value Session   -command {.mw.fmsg.tog.scope select}] {left } \
	[radiobutton .mw.fmsg.radios.scope.r4 -variable MsgScopeVal -text \
	 Both -relief flat -value Both  -command {.mw.fmsg.tog.scope select} ] {left } \
	[radiobutton .mw.fmsg.radios.scope.r5 -variable MsgScopeVal -text \
	 "File in session" -relief flat -value "File in session"   -command {.mw.fmsg.tog.scope select}] {left }

    pack append .mw.fmsg.radios .mw.fmsg.radios.dispo {top frame w}

# Create a frame for Session text button
    frame .mw.fmsg.radios.session -borderwidth 1 -relief raised -width 40
    pack append .mw.fmsg.radios.session \
	[text .mw.fmsg.radios.session.r2 -height 1] {left pady 4}

    set tmp .mw.fmsg.radios.session.r2
    bind $tmp <Any-Key-Return> sendMessage
    $tmp insert end $MsgSessionVal
    pack append .mw.fmsg.radios .mw.fmsg.radios.session {top frame w}

# Create a frame for Args Listbox button
    frame .mw.fmsg.radios.args -borderwidth 1 -relief raised 
    # create the string gadget and its frame
    frame .mw.fmsg.radios.args.f1 -borderwidth 1 -relief sunken
    text .mw.fmsg.radios.args.f1.t -borderwidth 2 -height 1 -width 31
    button .mw.fmsg.radios.args.f1.b1 -text Add -command { \
	.mw.fmsg.radios.args.f2.r2 insert 0 [.mw.fmsg.radios.args.f1.t get 1.0 end] }
    button .mw.fmsg.radios.args.f1.b2 -text Remove -command { \
	set sel [.mw.fmsg.radios.args.f2.r2 curselection]
	if {$sel != ""} {.mw.fmsg.radios.args.f2.r2 delete $sel}
    }
    pack append .mw.fmsg.radios.args.f1 .mw.fmsg.radios.args.f1.t {left } \
                                       .mw.fmsg.radios.args.f1.b1 {left} \
                                       .mw.fmsg.radios.args.f1.b2 {left}
    # create the listbox
    frame .mw.fmsg.radios.args.f2 -width 40 -borderwidth 1 -relief raised
    pack append .mw.fmsg.radios.args.f2 \
	[listbox .mw.fmsg.radios.args.f2.r2 -yscrollcommand \
	  ".mw.fmsg.radios.sb set"] {left frame w pady 4} \
        [ scrollbar .mw.fmsg.radios.sb -command ".mw.fmsg.radios.args.f2.r2 yview"]\
	{right filly}

    # stack the 2 frames vertically
    pack append .mw.fmsg.radios.args .mw.fmsg.radios.args.f2 {top frame w}
    pack append .mw.fmsg.radios.args .mw.fmsg.radios.args.f1 {top frame w}

    set tmp .mw.fmsg.radios.args.f2.r2
    $tmp configure -width 40 -height 3
    $tmp delete 0 end
    foreach i $MsgArgsVal {
	$tmp insert end $i
    }
    pack append .mw.fmsg.radios .mw.fmsg.radios.args {top frame w}

    # bind the clicks
    set lb .mw.fmsg.radios.args.f2.r2
    set txt .mw.fmsg.radios.args.f1.t
    bind $lb <Double-1> "
             $txt delete 1.0 end
             $txt insert 1.0 \[$lb get \[$lb curselection\]\]"
    # make Return an equivalent to Add
    bind $txt <Return> {\
	.mw.fmsg.radios.args.f2.r2 insert 0 [.mw.fmsg.radios.args.f1.t get 1.0 end] }

# Stack vertically all the frames containing the radios
    pack append .mw.fmsg.radios .mw.fmsg.radios.address {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.class {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.dispo {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.file {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.handler {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.handlerPtype {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.object {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.operation {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.otype {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.scope {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.session {top frame w}
    pack append .mw.fmsg.radios .mw.fmsg.radios.args {top frame w}

# Create the buttons
    frame .mw.fmsg.app
    pack append .mw.fmsg.app \
	[button .mw.fmsg.app.send -text Send -command sendMessage] \
	{left padx 30 pady 10 expand} \
	[button .mw.fmsg.app.cancel -text Abort -command {destroy .mw}] \
	{left padx 30 pady 30 expand}

# Create the buttons
    frame .mw.fmsg.empty -width 30 -height 43

# Finally, gather the main frames
    pack append .mw.fmsg .mw.fmsg.app {bottom pady 30 expand fill}
    pack append .mw.fmsg .mw.fmsg.radios {right }
    pack append .mw.fmsg .mw.fmsg.empty {top}
    pack append .mw.fmsg .mw.fmsg.tog {left frame nw}

    pack append  .mw .mw.fmsg {top}
}

###########################################################################
# Display procedures
###########################################################################

proc buildDisplayWindow {} {
    global DisAddressTog DisClassTog DisDispositionTog DisFileTog DisGidTog \
           DisHandlerTog DisHandlerPtypeTog DisObjectTog DisOperationTog \
	   DisOtypeTog DisScopeTog DisSenderTog DisSenderPtypeTog \
           DisSessionTog DisStateTog DisStatusTog DisStatusStringTog DisUidTog\
	   DisArgsTog
    
    toplevel .dw
    wm title .dw "Display Settings"
    frame .dw.dis -borderwidth 2 -relief raised

# Create two vertical frames holding the checkbuttons
    frame .dw.dis.tog1
    pack append .dw.dis.tog1 \
	[checkbutton .dw.dis.tog1.address -variable DisAddressTog \
	 -text Address -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.class -variable DisClassTog \
	 -text Class -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.disposition -variable DisDispositionTog \
	 -text Disposition -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.file -variable DisFileTog \
	 -text File -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.gid -variable DisGidTog \
	 -text Gid -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.handler -variable DisHandlerTog \
	 -text Handler -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.handlerPtype -variable DisHandlerPtypeTog \
	 -text HandlerPtype -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.object -variable DisObjectTog \
	 -text Object -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.operation -variable DisOperationTog \
	 -text Operation -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog1.args -variable DisArgsTog \
	 -text Args -relief flat] {top frame nw}

    frame .dw.dis.tog2
    pack append .dw.dis.tog2 \
	[checkbutton .dw.dis.tog2.otype -variable DisOtypeTog \
	 -text Otype -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.scope -variable DisScopeTog \
	 -text Scope -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.sender -variable DisSenderTog \
	 -text Sender -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.senderPtype -variable DisSenderPtypeTog \
	 -text SenderPtype -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.session -variable DisSessionTog \
	 -text Session -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.state -variable DisStateTog \
	 -text State -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.status -variable DisStatusTog \
	 -text Status -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.statusString -variable DisStatusStringTog \
	 -text StatusString -relief flat] {top frame nw} \
	[checkbutton .dw.dis.tog2.uid -variable DisUidTog \
	 -text Uid -relief flat] {top frame nw}

# Create the Ok button
    frame .dw.dis.ok
    pack append .dw.dis.ok \
	[button .dw.dis.ok.b -text Ok -command {destroy .dw}] {top padx 30 fill}

# Layout the frames
    pack append .dw.dis .dw.dis.ok {bottom pady 10}
    pack append .dw.dis .dw.dis.tog1 {left frame nw}
    pack append .dw.dis .dw.dis.tog2 {left frame nw}

    pack append .dw .dw.dis {top}
}

###########################################################################
# Main window
###########################################################################

proc buildMainWindow {} {
    wm title . "Tooltalk monitor"

# Main frame
    frame .main -borderwidth 2 -relief raised
    frame .main.f -borderwidth 2 -relief raised
    pack append .main .main.f {bottom pady 30}

#Build the text widget and its scrollbar
    pack append .main.f \
	[text .main.f.log -borderwidth 2 -height 20 -width 50\
	 -yscrollcommand ".main.f.sb set"]\
	{left expand fill padx 15 pady 15} \
	[scrollbar .main.f.sb -command ".main.f.log yview"]\
	{right filly}

# Add the buttons
    pack append .main \
	[button .main.start -text "Stop" -command toggleMonitorActive] \
	{left padx 30 pady 30} \
	[button .main.pattern -text "Pattern..." -command buildPatternWindow] \
        {left padx 30} \
        [button .main.message -text "Message..." -command buildMessageWindow] \
        {left padx 30} \
        [button .main.display -text "Display..." -command buildDisplayWindow] \
        {left  padx 30} \
        [button .main.quit -text "Quit" -command closeAndExit] \
        {left  padx 30}

    pack append . .main {top fillx}
}

###########################################################################
# Tooltalk callbacks
###########################################################################

proc mainttcb {} {
# This function will be called each time a new Tooltalk message arrives
    set msg [tt_message_receive]
}

# This procedure will be called when we receive a message matching our
# pattern
proc patternCallback {msg pat} {
    global DisAddressTog DisClassTog DisDispositionTog DisFileTog DisGidTog \
	   DisHandlerTog DisHandlerPtypeTog DisObjectTog DisOperationTog \
          DisOtypeTog DisScopeTog DisSenderTog DisSenderPtypeTog DisSessionTog\
	   DisStateTog DisStatusTog DisStatusStringTog DisUidTog DisArgsTog

    if {$DisAddressTog == 1} {
	global TT_PROCEDURE TT_HANDLER TT_OBJECT TT_OTYPE
	set v [tt_message_address $msg]
	set val "Address:\t$v\n"
	if {$v ==  $TT_PROCEDURE} {set val "Address:\tTT_PROCEDURE\n"} 
	if {$v == $TT_HANDLER} {set val "Address:\tTT_HANDLER\n"}
	if {$v == $TT_OBJECT} {set val "Address:\tTT_OBJECT\n"}
	if {$v ==  $TT_OTYPE} {set val "Address:\tTT_OTYPE\n"}
	.main.f.log insert end $val
    }
    if {$DisClassTog == 1} {
	global TT_NOTICE TT_REQUEST
	set v [tt_message_class $msg]
	set val "Class:\t\t$v\n"
	if {$v ==  $TT_NOTICE} {set val "Class:\t\tTT_NOTICE\n"} 
	if {$v == $TT_REQUEST} {set val "Class:\t\tTT_REQUEST\n"}
	.main.f.log insert end $val
    }
    if {$DisDispositionTog == 1} {
	global TT_QUEUE TT_START
	set v [tt_message_disposition $msg]
	set val "Disposition:\t$v\n"
	if {$v ==  $TT_QUEUE} {set val "Disposition:\tTT_QUEUE\n"} 
	if {$v == $TT_START} {set val "Disposition:\tTT_START\n"}
#	if {$v == [expr "$TT_START + $TT_QUEUE"} {set val "Disposition:\tTT_QUEUE+START\n"}
	.main.f.log insert end $val
    }
    if {$DisFileTog == 1} {
	set file [tt_message_file $msg]
	.main.f.log insert end "File:\t\t[tt_message_file $msg]\n"
    }
    if {$DisGidTog == 1} {
	.main.f.log insert end "Gid:\t\t[tt_message_gid $msg]\n"
    }
    if {$DisHandlerTog == 1} {
	.main.f.log insert end "Handler:\t\t[tt_message_handler $msg]\n"
    }
    if {$DisHandlerPtypeTog == 1} {
	.main.f.log insert end "Handler Ptype:\t[tt_message_handler_ptype $msg]\n"
    }
    if {$DisObjectTog == 1} {
	.main.f.log insert end "Object:\t\t[tt_message_object $msg]\n"
    }
    if {$DisOperationTog == 1} {
	.main.f.log insert end "Operation:\t\t[tt_message_op $msg]\n"
    }
    if {$DisOtypeTog == 1} {
	.main.f.log insert end "Otype:\t\t[tt_message_otype $msg]\n"
    }
    if {$DisScopeTog == 1} {
	global TT_FILE TT_SESSION TT_BOTH TT_FILE_IN_SESSION
	set val "Scope:\t\t[tt_message_scope $msg]\n"
	set v [tt_message_scope $msg]
	if {$v ==  $TT_FILE} {set val "Scope:\t\tTT_FILE\n"}
	if {$v == $TT_SESSION} {set val "Scope:\t\tTT_SESSION\n"}
	if {$v == $TT_BOTH} {set val "Scope:\t\tTT_BOTH\n"}
	if {$v == $TT_FILE_IN_SESSION} {set val "Scope:\t\tTT_FILE_IN_SESSION\n"}
	.main.f.log insert end $val
    }
    if {$DisSenderTog == 1} {
	.main.f.log insert end "Sender:\t\t[tt_message_sender $msg]\n"
    }
    if {$DisSenderPtypeTog == 1} {
	.main.f.log insert end "Sender Ptype:\t[tt_message_sender_ptype $msg]\n"
    }
    if {$DisSessionTog == 1} {
	.main.f.log insert end "Session:\t[tt_message_session $msg]\n"
    }
    if {$DisStatusTog == 1} {
	.main.f.log insert end "Status:\t\t[tt_message_status $msg]\n"
    }
    if {$DisStatusStringTog == 1} {
	.main.f.log insert end "Status string:\t[tt_message_status_string $msg]\n"
    }
    if {$DisUidTog == 1} {
	.main.f.log insert end "Uid:\t\t[tt_message_uid $msg]\n"
    }
    if {$DisArgsTog == 1} {
	.main.f.log insert end "Args:\n"
	set n [tt_message_args_count $msg]
	for {set i 0} {$i < $n} {incr i} {
	    .main.f.log insert end "\t[tt_message_arg_val $msg $i]\n"
	}

    }
    .main.f.log insert end "-------------------------\n"
   .main.f.log yview -pickplace end
}

# Clean things up before exiting
proc closeAndExit {} {
    tt_close
    destroy .
}

###########################################################################
# Start of the program
###########################################################################

# Init Tooltalk
if {$wantTooltalk == 1} {
    global TT_SESSION TT_OBSERVE
    if {[tt_open] == 0} {
	puts stdout "Couldn't connect to Tooltalk"
    }
    set pat [tt_pattern_create]
    tt_pattern_scope_add $pat $TT_SESSION
    tt_pattern_category_set $pat $TT_OBSERVE
    tt_pattern_callback_add $pat patternCallback
    tt_pattern_register $pat
    tt_session_join [tt_default_session]
    set lastPattern $pat
    TT_main_tooltalk_callback mainttcb
}

# Open the window
buildMainWindow


