/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttAppInit.c --
 *
 *	Init Tooltalk interface to Tcl
 *
 * $Id: tclttAppInit.c,v 1.7 93/08/26 16:20:01 beust Exp $
 */

#include "tcl.h"
#include "main.h"

char initCmd[] =
"if {[catch {set tclttlib $env(TCLTT_LIBRARY)}] == 1} { \n\
  set tclttlib [info library] \n\
} else {\n\
  if [file exists $tclttlib/tooltalk.tcl] {\n\
      set tclttlib $env(TCLTT_LIBRARY)\n\
  } else {\n\
      set tclttlib [info library]\n\
  }\n\
}\n\
\n\
if {[file exists $tclttlib/tooltalk.tcl]} {\n\
    source $tclttlib/tooltalk.tcl\n\
} else {\n\
    set msg \"\"
    set msg \"Can't find tooltalk.tcl neither in [info library] nor in TCLTT_LIBRARY.\n\"\n\
    append msg \"Perhaps you need to install Toocl or set your TCLTT_LIBRARY environment\n\"\n\
    append msg \"variable?\"\n\
    puts stdout $msg\n\
}";

Tcl_Interp *Interp;
char Tcltt_Result[256];     /* to store results */

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcltt_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
  int result;
  char interpString[128];

  /* This structure will hold all the new commands I provide */
  struct _Commands {
    char *tclProc;
    Tcl_CmdProc *cProc;
  } *p, commands[] = {
    "TT_wait_for_message", (Tcl_CmdProc *) TclTT_wait_for_message,
    "TT_main_tooltalk_callback", (Tcl_CmdProc *) TclTT_main_tooltalk_callback,
    "tt_close", (Tcl_CmdProc *) Tcltt_close,
    "tt_open", (Tcl_CmdProc *) Tcltt_open,
    "tt_X_session", (Tcl_CmdProc *) Tcltt_X_session,
    "tt_status_message", (Tcl_CmdProc *) Tcltt_status_message,
    "tt_fd", (Tcl_CmdProc *) Tcltt_fd,
    "tt_message_receive", (Tcl_CmdProc *) Tcltt_message_receive,
    "tt_prequest_create", (Tcl_CmdProc *) Tcltt_prequest_create,
    "tt_pnotice_create", (Tcl_CmdProc *) Tcltt_pnotice_create,
    "tt_mark", (Tcl_CmdProc *) Tcltt_mark,
    "tt_release", (Tcl_CmdProc *) Tcltt_release,
    "tt_pointer_error", (Tcl_CmdProc *) Tcltt_pointer_error,
    "tt_int_error", (Tcl_CmdProc *) Tcltt_int_error,
    "tt_error_pointer", (Tcl_CmdProc *) Tcltt_error_pointer,
    "tt_error_int", (Tcl_CmdProc *) Tcltt_error_int,
    "tt_onotice_create", (Tcl_CmdProc *) Tcltt_onotice_create,
    "tt_orequest_create", (Tcl_CmdProc *) Tcltt_orequest_create,
    "tt_objid_equal", (Tcl_CmdProc *) Tcltt_objid_equal,
    "tt_objid_objkey", (Tcl_CmdProc *) Tcltt_objid_objkey,
    "tt_ptype_declare", (Tcl_CmdProc *) Tcltt_ptype_declare,

    "tt_session_join", (Tcl_CmdProc *) Tcltt_session_join,
    "tt_session_quit", (Tcl_CmdProc *) Tcltt_session_quit,
    "tt_session_propname", (Tcl_CmdProc *) Tcltt_session_propname,
    "tt_session_propnames_count", (Tcl_CmdProc *) Tcltt_session_propnames_count,
    "tt_session_prop", (Tcl_CmdProc *) Tcltt_session_prop,
    "tt_session_prop_add", (Tcl_CmdProc *) Tcltt_session_prop_add,
    "tt_session_prop_count", (Tcl_CmdProc *) Tcltt_session_prop_count,
    "tt_session_prop_set", (Tcl_CmdProc *) Tcltt_session_prop_set,
    "tt_initial_session", (Tcl_CmdProc *) Tcltt_initial_session,

    "tt_default_session", (Tcl_CmdProc *) Tcltt_default_session,
    "tt_default_ptype", (Tcl_CmdProc *) Tcltt_default_ptype,
    "tt_default_ptype_set", (Tcl_CmdProc *) Tcltt_default_ptype_set,
    "tt_default_file", (Tcl_CmdProc *) Tcltt_default_file,
    "tt_default_file_set", (Tcl_CmdProc *) Tcltt_default_file_set,
    "tt_default_session_set", (Tcl_CmdProc *) Tcltt_default_session_set,
    "tt_default_procid", (Tcl_CmdProc *) Tcltt_default_procid,
    "tt_default_procid_set", (Tcl_CmdProc *) Tcltt_default_procid_set,

    "tt_message_address_set", (Tcl_CmdProc *) Tcltt_message_address_set,
    "tt_message_class_set", (Tcl_CmdProc *) Tcltt_message_class_set,
    "tt_message_scope_set", (Tcl_CmdProc *) Tcltt_message_scope_set,
    "tt_message_create", (Tcl_CmdProc *) Tcltt_message_create,
    "tt_message_op", (Tcl_CmdProc *) Tcltt_message_op,
    "tt_message_op_set", (Tcl_CmdProc *) Tcltt_message_op_set,
    "tt_message_send", (Tcl_CmdProc *) Tcltt_message_send,
    "tt_message_arg_val", (Tcl_CmdProc *) Tcltt_message_arg_val,
    "tt_message_arg_val_set", (Tcl_CmdProc *) Tcltt_message_arg_val_set,
    "tt_message_arg_add", (Tcl_CmdProc *) Tcltt_message_arg_add,
    "tt_message_callback_add", (Tcl_CmdProc *) Tcltt_message_callback_add,
    "tt_message_reply", (Tcl_CmdProc *) Tcltt_message_reply,
    "tt_message_create_super", (Tcl_CmdProc *) Tcltt_message_create_super,
    "tt_message_destroy", (Tcl_CmdProc *) Tcltt_message_destroy,
    "tt_message_reject", (Tcl_CmdProc *) Tcltt_message_reject,
    "tt_message_fail", (Tcl_CmdProc *) Tcltt_message_fail,
    "tt_message_pattern", (Tcl_CmdProc *) Tcltt_message_pattern,
    "tt_message_user", (Tcl_CmdProc *) Tcltt_message_user,
    "tt_message_user_set", (Tcl_CmdProc *) Tcltt_message_user_set,
    "tt_message_arg_mode", (Tcl_CmdProc *) Tcltt_message_arg_mode,
    "tt_message_arg_type", (Tcl_CmdProc *) Tcltt_message_arg_type,
    "tt_message_arg_val", (Tcl_CmdProc *) Tcltt_message_arg_val,
    "tt_message_args_count", (Tcl_CmdProc *) Tcltt_message_args_count,
    "tt_message_class", (Tcl_CmdProc *) Tcltt_message_class,
    "tt_message_file", (Tcl_CmdProc *) Tcltt_message_file,
    "tt_message_file_set", (Tcl_CmdProc *) Tcltt_message_file_set,
    "tt_message_object", (Tcl_CmdProc *) Tcltt_message_object,
    "tt_message_object_set", (Tcl_CmdProc *) Tcltt_message_object_set,
    "tt_message_opnum", (Tcl_CmdProc *) Tcltt_message_opnum,
    "tt_message_otype", (Tcl_CmdProc *) Tcltt_message_otype,
    "tt_message_otype_set", (Tcl_CmdProc *) Tcltt_message_otype_set,
    "tt_message_address", (Tcl_CmdProc *) Tcltt_message_address,
    "tt_message_handler", (Tcl_CmdProc *) Tcltt_message_handler,
    "tt_message_handler_set", (Tcl_CmdProc *) Tcltt_message_handler_set,
    "tt_message_handler_ptype", (Tcl_CmdProc *) Tcltt_message_handler_ptype,
    "tt_message_handler_ptype_set", (Tcl_CmdProc *) Tcltt_message_handler_ptype_set,
    "tt_message_disposition", (Tcl_CmdProc *) Tcltt_message_disposition,
    "tt_message_disposition_set", (Tcl_CmdProc *) Tcltt_message_disposition_set,
    "tt_message_scope", (Tcl_CmdProc *) Tcltt_message_scope,
    "tt_message_sender", (Tcl_CmdProc *) Tcltt_message_sender,
    "tt_message_sender_ptype", (Tcl_CmdProc *) Tcltt_message_sender_ptype,
    "tt_message_sender_ptype_set", (Tcl_CmdProc *) Tcltt_message_sender_ptype_set,
    "tt_message_session", (Tcl_CmdProc *) Tcltt_message_session,
    "tt_message_session_set", (Tcl_CmdProc *) Tcltt_message_session_set,
    "tt_message_state", (Tcl_CmdProc *) Tcltt_message_state,
    "tt_message_status", (Tcl_CmdProc *) Tcltt_message_status,
    "tt_message_status_set", (Tcl_CmdProc *) Tcltt_message_status_set,
    "tt_message_status_string", (Tcl_CmdProc *) Tcltt_message_status_string,
    "tt_message_status_string_set", (Tcl_CmdProc *) Tcltt_message_status_string_set,
    "tt_message_uid", (Tcl_CmdProc *) Tcltt_message_uid,
    "tt_message_gid", (Tcl_CmdProc *) Tcltt_message_gid,
    
    "tt_pattern_create", (Tcl_CmdProc *) Tcltt_pattern_create,
    "tt_pattern_register", (Tcl_CmdProc *) Tcltt_pattern_register,
    "tt_pattern_address_add", (Tcl_CmdProc *) Tcltt_pattern_address_add,
    "tt_pattern_class_add", (Tcl_CmdProc *) Tcltt_pattern_class_add,
    "tt_pattern_callback_add", (Tcl_CmdProc *) Tcltt_pattern_callback_add,
    "tt_pattern_op_add", (Tcl_CmdProc *) Tcltt_pattern_op_add,
    "tt_pattern_scope_add", (Tcl_CmdProc *) Tcltt_pattern_scope_add,
    "tt_pattern_category_set", (Tcl_CmdProc *) Tcltt_pattern_category_set,
    "tt_pattern_destroy", (Tcl_CmdProc *) Tcltt_pattern_destroy,
    "tt_pattern_unregister", (Tcl_CmdProc *) Tcltt_pattern_unregister,
    "tt_pattern_user", (Tcl_CmdProc *) Tcltt_pattern_user,
    "tt_pattern_user_set", (Tcl_CmdProc *) Tcltt_pattern_user_set,
    "tt_pattern_category_set", (Tcl_CmdProc *) Tcltt_pattern_category_set,
    "tt_pattern_arg_add", (Tcl_CmdProc *) Tcltt_pattern_arg_add,
    "tt_pattern_class_add", (Tcl_CmdProc *) Tcltt_pattern_class_add,
    "tt_pattern_file_add", (Tcl_CmdProc *) Tcltt_pattern_file_add,
    "tt_pattern_object_add", (Tcl_CmdProc *) Tcltt_pattern_object_add,
    "tt_pattern_opnum_add", (Tcl_CmdProc *) Tcltt_pattern_opnum_add,
    "tt_pattern_otype_add", (Tcl_CmdProc *) Tcltt_pattern_otype_add,
    "tt_pattern_disposition_add", (Tcl_CmdProc *) Tcltt_pattern_disposition_add,
    "tt_pattern_sender_add", (Tcl_CmdProc *) Tcltt_pattern_sender_add,
    "tt_pattern_sender_ptype_add", (Tcl_CmdProc *) Tcltt_pattern_sender_ptype_add,
    "tt_pattern_session_add", (Tcl_CmdProc *) Tcltt_pattern_session_add,
    "tt_pattern_state_add", (Tcl_CmdProc *) Tcltt_pattern_state_add,

    "tt_file_join", (Tcl_CmdProc *) Tcltt_file_join,
    "tt_file_quit", (Tcl_CmdProc *) Tcltt_file_quit,
    "tt_file_move", (Tcl_CmdProc *) Tcltt_file_move,
    "tt_file_copy", (Tcl_CmdProc *) Tcltt_file_copy,
    "tt_file_destroy", (Tcl_CmdProc *) Tcltt_file_destroy,

    "tt_otype_deriveds_count", (Tcl_CmdProc *) Tcltt_otype_deriveds_count,
    "tt_otype_derived", (Tcl_CmdProc *) Tcltt_otype_derived,
    "tt_otype_base", (Tcl_CmdProc *) Tcltt_otype_base,
    "tt_otype_is_derived", (Tcl_CmdProc *) Tcltt_otype_is_derived,
    "tt_otype_osig_count", (Tcl_CmdProc *) Tcltt_otype_osig_count,
    "tt_otype_hsig_count", (Tcl_CmdProc *) Tcltt_otype_hsig_count,
    "tt_otype_osig_op", (Tcl_CmdProc *) Tcltt_otype_osig_op,
    "tt_otype_hsig_op", (Tcl_CmdProc *) Tcltt_otype_hsig_op,
    "tt_otype_osig_args_count", (Tcl_CmdProc *) Tcltt_otype_osig_args_count,
    "tt_otype_hsig_args_count", (Tcl_CmdProc *) Tcltt_otype_hsig_args_count,
    "tt_otype_osig_arg_mode", (Tcl_CmdProc *) Tcltt_otype_osig_arg_mode,
    "tt_otype_hsig_arg_mode", (Tcl_CmdProc *) Tcltt_otype_hsig_arg_mode,
    "tt_otype_osig_arg_type", (Tcl_CmdProc *) Tcltt_otype_osig_arg_type,
    "tt_otype_hsig_arg_type", (Tcl_CmdProc *) Tcltt_otype_hsig_arg_type,

    "tt_spec_create", (Tcl_CmdProc *) Tcltt_spec_create,
    "tt_spec_write", (Tcl_CmdProc *) Tcltt_spec_write,
    "tt_spec_destroy", (Tcl_CmdProc *) Tcltt_spec_destroy,
    "tt_spec_file", (Tcl_CmdProc *) Tcltt_spec_file,
    "tt_spec_type", (Tcl_CmdProc *) Tcltt_spec_type,
    "tt_spec_type_set", (Tcl_CmdProc *) Tcltt_spec_type_set,
    "tt_spec_move", (Tcl_CmdProc *) Tcltt_spec_move,
    "tt_spec_propname", (Tcl_CmdProc *) Tcltt_spec_propname,
    "tt_spec_propnames_count", (Tcl_CmdProc *) Tcltt_spec_propnames_count,
    "tt_spec_prop", (Tcl_CmdProc *) Tcltt_spec_prop,
    "tt_spec_prop_add", (Tcl_CmdProc *) Tcltt_spec_prop_add,
    "tt_spec_prop_count", (Tcl_CmdProc *) Tcltt_spec_prop_count,
    "tt_spec_prop_set", (Tcl_CmdProc *) Tcltt_spec_prop_set,
    NULL, NULL
  };


  /*
   * Calls to init procedures for various included packages should
   * appear below, if there are any included packages:
   */

  printf("TooCL v%s\n", TOOCL_VERSION);

  /*
   * Execute a start-up script.
   */
  
#if (TCL_MAJOR_VERSION < 7)
  result = Tcl_Eval(interp, initCmd, 0, NULL);
#else
  result =  Tcl_Eval(interp, initCmd);
#endif

  /*
   * Initialize the callbacks database
   */

  TclTT_property_initialize();
  interp -> result = (char *) malloc(256);
  
  /*
   * Store our interpreter in the session, so the callbacks can find it
   */
  
/*
  sprintf(interpString, "%u", interp);
  tt_session_prop_add(tt_default_session(), TCLTT_PROP_INTERP, interpString);
*/
  Interp = interp;

  /*
   * Enter new functions
   */

  p = commands;
  while (p -> tclProc) {
    Tcl_CreateCommand (interp, p -> tclProc,
		       (Tcl_CmdProc *) p -> cProc,
/*
		       (ClientData) NULL, (void (*) ()) NULL);
*/
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) 0);
    p++;
  }

  return result;
}



