/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttPattern.c
 *
 *	tt_pattern_* functions
 *
 * $Id: tclttPattern.c,v 1.6 93/08/13 15:38:35 beust Exp $
 */

#include "main.h"

int
Tcltt_pattern_create(ClientData data, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int result = 0;
  ARG(0);
  sprintf(Tcltt_Result, "%u", tt_pattern_create());
  interp -> result = Tcltt_Result;
  return result;
}


int
Tcltt_pattern_register(ClientData data, Tcl_Interp *interp,
		       int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_pattern_register((Tt_pattern) atol(argv[1]));
  return result;
}

int
Tcltt_pattern_address_add(ClientData data, Tcl_Interp *interp,
			  int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_address_add((Tt_pattern) atol(argv[1]),
				  (Tt_address) atol(argv[2]));
  return result;
}

int
Tcltt_pattern_class_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_class_add((Tt_pattern) atol(argv[1]),
				(Tt_class) atol(argv[2]));
  return result;
}

int
Tcltt_pattern_scope_add(ClientData data, Tcl_Interp *interp,
			int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_scope_add((Tt_pattern) atol(argv[1]),
				(Tt_scope) atol(argv[2]));
  return result;
}

int
Tcltt_pattern_op_add(ClientData data, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_op_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_category_set(ClientData data, Tcl_Interp *interp,
			   int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_category_set((Tt_pattern) atol(argv[1]),
				   (Tt_category) atol(argv[2]));
  return result;
}

int
Tcltt_pattern_callback_add(ClientData data, Tcl_Interp *interp,
			   int argc, char **argv)
{
  int result = 0;
  Tt_message_callback f;

#if (TCL_MAJOR_VERSION < 7)
  ARG(2);
  TclTT_property_add((void *) atoi(argv[1]), argv[2]);
  result = tt_pattern_callback_add((Tt_pattern) atol(argv[1]),
				   TclTT_generic_pattern_callback);
#else
  Tcl_CmdInfo info;
  ARG(2);

  if (result = Tcl_GetCommandInfo(interp, argv[2], & info) == 0) {
    fprintf(stderr, "*** tcltt: '%s' no such callback\n", argv[1]);
  }
  else {
    TclTT_property_add((void *) atoi(argv[1]), argv[2]);
    result = tt_pattern_callback_add((Tt_pattern) atol(argv[1]),
				     TclTT_generic_pattern_callback);
/*
				     (Tt_message_callback) info.proc);
*/
  }
#endif
  return result;

}

int
Tcltt_pattern_destroy(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_pattern_destroy((Tt_pattern) atol(argv[1]));
  return result;
}

int
Tcltt_pattern_unregister(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_pattern_unregister((Tt_pattern) atol(argv[1]));
  return result;
}

int
Tcltt_pattern_user(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u", tt_pattern_user((Tt_pattern) atol(argv[1]),
					      atol(argv[2])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_pattern_user_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_pattern_user_set((Tt_pattern) atol(argv[1]),
			       atol(argv[2]),
			       (void *) atol(argv[3]));
  return result;
}

int
Tcltt_pattern_arg_add(ClientData data, Tcl_Interp *interp,
			  int argc, char **argv)
{
  int result = 0;
  ARG(4);
  result = tt_pattern_arg_add((Tt_pattern) atol(argv[1]),
			      (Tt_mode) atol(argv[2]),
			      argv[3],
			      argv[4]);
  return result;
}

int
Tcltt_pattern_file_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_file_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_object_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_object_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_opnum_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_opnum_add((Tt_pattern) atol(argv[1]), atol(argv[2]));
  return result;
}


int
Tcltt_pattern_otype_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_otype_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_disposition_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_opnum_add((Tt_pattern) atol(argv[1]),
				(Tt_disposition) atol(argv[2]));
  return result;
}

int
Tcltt_pattern_sender_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_sender_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_sender_ptype_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_sender_ptype_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_session_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_session_add((Tt_pattern) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_pattern_state_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_pattern_state_add((Tt_pattern) atol(argv[1]),
				(Tt_state) atol(argv[2]));
  return result;
}

