/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttSpec.c
 *
 *	tt_spec_* functions
 *
 * $Id: tclttSpec.c,v 1.5 93/08/26 16:21:54 beust Exp $
 */

#include "main.h"

int
Tcltt_spec_create(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_spec_create(argv[1]);
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_spec_write(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_spec_write(argv[1]);
  return result;
}

int
Tcltt_spec_destroy(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_spec_destroy(argv[1]);
  return result;
}

int
Tcltt_spec_file(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_spec_file(argv[1]);
  return result;
}

int
Tcltt_spec_type(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_spec_type(argv[1]);
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_spec_type_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_spec_type_set(argv[1], argv[2]);
  return result;
}

int
Tcltt_spec_move(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_spec_move(argv[1], argv[2]);
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_spec_propname(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_spec_propname(argv[1], atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_spec_propnames_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_spec_propnames_count(argv[1]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_spec_prop(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  interp -> result = tt_spec_prop(argv[1], argv[2], atol(argv[3]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_spec_prop_add(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_spec_prop_add(argv[1], argv[2], argv[3]);
  return result;
}

int
Tcltt_spec_prop_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u", tt_spec_prop_count(argv[1], argv[2]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_spec_prop_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_spec_prop_set(argv[1], argv[2], argv[3]);
  return result;
}

