/*----------------------------------------------------------------------------
--
--  Module:           txj_demo
--
--  Project:          <>
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Demo program to show resource set changes.
--
--  Contents:
--    <>
--
--  Filename:         txj_demo.c
--
--  Authors:          Ulrika Bornetun
--  Creation date:    1994-08-04
--
--  Modifications:
--
--  Who            When
--  What
--  -----------------------------
--  <>             <>
--  <>
--
--
--  Copyright 1994 by Union Bank of Switzerland.
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies.
--  Union Bank of Switzerland makes no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
--
------------------------------------------------------------------------------
--
-- SCCSID = "@(#) Module: %M%, Version: %R%.%L%, Date: %E% %U%"
--
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#if XlibSpecificationRelease > 4
#include <X11/Xlocale.h>
#endif

#include <Xm/Xm.h>

#include <Xm/CascadeBG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>

#ifdef VMS
#include "xmubCustUtil.h"
#include "xmubCustUi.h"
#else
#include <xmub/xmubCustUtil.h>
#include <xmub/xmubCustUi.h>
#endif


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define APP_CLASS        "TxjDemo"

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

static xmubAppResDesc  mapping_options[] = {

  { "palette", "Palette" },
  { "fmap",    "Fmap"    },
  { NULL, NULL },

};

static XrmOptionDescRec  options[] = {
  { "-palette",        "*palette",          XrmoptionSepArg, NULL },
  { "-fmap",           "*fmap",             XrmoptionSepArg, NULL },
};

static xmubResourceMappingInfo  *res_info;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


static void 
  ExitCB( Widget                      widget,
          Widget                      toplevel,
          XmPushButtonCallbackStruct  *call_data );

static void 
  NewPaletteCB( Widget                      widget,
                Widget                      toplevel,
                XmPushButtonCallbackStruct  *call_data );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  main( int argc, char *argv[] )
{

  XtAppContext      app;
  Arg               args[ 20 ];
  Widget            action_area, anchor_sep, band, cap, casc, filem,
                    form, frame, hsep, lb, lform, mbr, pb, toplevel, tx,
                    vsep;
  int               index;
  Cardinal          n;
  Boolean           ok;
  char              *palette;
  Dimension         width, height;
  XmString          xm;

  /* Code. */

  if( getenv( "XRESOURCE_MAP_FILE" ) == NULL ){
    printf( "Error: XRESOURCE_MAP_FILE must be defined.\n" );
    printf( "Run the program with the script doDemo.\n" );
    printf( "Exiting.\n" );
    exit( 1 );
  }
  
  /* Enable NLS. */
#if XlibSpecificationRelease > 4
  XtSetLanguageProc( NULL, (XtLanguageProc) NULL, NULL ); 
#endif

  /* Initialize and create top level shell. */
  n = 0;
  toplevel = xmubAppInitialize( &app, APP_CLASS, options, XtNumber( options ),
                                (Cardinal *) &argc, argv,
                                NULL, args, n, NULL, 0, &res_info );


  /* Main form. */
  n = 0;
  form = XmCreateForm( toplevel, "topFo", args, n );  

  /* Command button area. */
  n = 0;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNorientation,      XmHORIZONTAL ); n++;
  action_area = XmCreateRowColumn( form, "actA", args, n );  

  /* A separator between the command buttons and the main area. */
  n = 0;
  XtSetArg( args[ n ], XmNorientation,      XmHORIZONTAL ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     action_area ); n++;
  hsep = XmCreateSeparator( form, "hsep", args, n );

  /* A menubar on top. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment, XmATTACH_FORM ); n++;
  mbr = XmCreateMenuBar( form, "mbr", args, n );

  filem = XmCreatePulldownMenu( mbr, "filepdm", NULL, 0 );
  casc = XtVaCreateManagedWidget( "filecasc", 
                                  xmCascadeButtonGadgetClass, mbr,
                                  XmNsubMenuId,               filem,
                                  NULL );

  pb = XtVaCreateManagedWidget( "fexitPb", xmPushButtonGadgetClass,
                                filem, NULL );
  XtAddCallback( pb, XmNactivateCallback, (XtCallbackProc) ExitCB, NULL );

  /* Simple usage of form instead of caption widget. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        mbr ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     hsep ); n++;
  XtSetArg( args[ n ], XmNfractionBase,     100 ); n++;
  cap = XmCreateForm( form, "cap", args, n );  
  
  /* Use an invisible separator to attach stuff to the middle. */
  n = 0;
  XtSetArg( args[ n ], XmNorientation,      XmVERTICAL ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_POSITION ); n++;
  XtSetArg( args[ n ], XmNleftPosition,     30 ); n++;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNmappedWhenManaged,False ); n++;
  vsep = XmCreateSeparator( cap, "vsep", args, n );
  XtManageChild( vsep );


  /* Create the fields. */
  /* Name. */

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNleftWidget,       vsep ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  tx = XmCreateText( cap, "namTxt", args, n );
  XtManageChild( tx );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNrightWidget,      vsep ); n++;
  XtSetArg( args[ n ], XmNalignment,        XmALIGNMENT_BEGINNING ); n++;
  lb = XmCreateLabel( cap, "namLb", args, n );
  XtManageChild( lb );

  /* Address. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNleftWidget,       vsep ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  tx = XmCreateText( cap, "addTxt", args, n );
  XtManageChild( tx );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNrightWidget,      vsep ); n++;
  XtSetArg( args[ n ], XmNalignment,        XmALIGNMENT_BEGINNING ); n++;
  lb = XmCreateLabel( cap, "addLb", args, n );
  XtManageChild( lb );

  /* City. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNleftWidget,       vsep ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  tx = XmCreateText( cap, "citTxt", args, n );
  XtManageChild( tx );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNrightWidget,      vsep ); n++;
  XtSetArg( args[ n ], XmNalignment,        XmALIGNMENT_BEGINNING ); n++;
  lb = XmCreateLabel( cap, "citLb", args, n );
  XtManageChild( lb );

  /* Phone. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNleftWidget,       vsep ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  tx = XmCreateText( cap, "phnTxt", args, n );
  XtManageChild( tx );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNrightWidget,      vsep ); n++;
  XtSetArg( args[ n ], XmNalignment,        XmALIGNMENT_BEGINNING ); n++;
  lb = XmCreateLabel( cap, "phnLb", args, n );
  XtManageChild( lb );

  /* E-mail. */
  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNleftWidget,       vsep ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_FORM ); n++;
  tx = XmCreateText( cap, "emlTxt", args, n );
  XtManageChild( tx );

  n = 0;
  XtSetArg( args[ n ], XmNtopAttachment,    XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNtopWidget,        tx ); n++;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET ); n++;
  XtSetArg( args[ n ], XmNbottomWidget,     tx ); n++;
  XtSetArg( args[ n ], XmNleftAttachment,   XmATTACH_FORM ); n++;
  XtSetArg( args[ n ], XmNrightAttachment,  XmATTACH_WIDGET ); n++;
  XtSetArg( args[ n ], XmNrightWidget,      vsep ); n++;
  XtSetArg( args[ n ], XmNalignment,        XmALIGNMENT_BEGINNING ); n++;
  lb = XmCreateLabel( cap, "emlLb", args, n );
  XtManageChild( lb );

  /* Command buttons. */

  /* Change colors. */
  n = 0;
  pb = XmCreatePushButton( action_area, "palPb", args, n );
  XtManageChild( pb );

  XtAddCallback( pb, XmNactivateCallback,
                 (XtCallbackProc) NewPaletteCB, toplevel );

  /* Manage the widgets. */

  XtManageChild( mbr );
  XtManageChild( action_area );
  XtManageChild( hsep );
  XtManageChild( cap );

  XtManageChild( form );

  XtRealizeWidget( toplevel );


  XtAppMainLoop( app );

} /* main */


/*----------------------------------------------------------------------*/

static void 
  ExitCB( Widget                      widget,
          Widget                      toplevel,
          XmPushButtonCallbackStruct  *call_data )
{

  exit( 0 );

}


/*----------------------------------------------------------------------*/

static void 
  NewPaletteCB( Widget                      widget,
                Widget                      toplevel,
                XmPushButtonCallbackStruct  *call_data )
{

  xmubPopupPaletteDialog( toplevel, True, res_info );

  return;

}
