/*----------------------------------------------------------------------------
//
//   Class/module:     xmubCustUi
//
//   Project:          xmub
//   System:           <>
//    Subsystem:       <>
//    Function block:  <>
//
//   Creation date:    05.11.1994 

// = LIBRARY
//    xmub
//
// = FILENAME
//    xmubCustUi.h
//
// = AUTHORS
//    Ulrika Bornetun <bre@ubszh.ch.net>
//
// = COPYRIGHT
//    (C) Copyright Union Bank of Switzerland 1994
//        All rights reserved

//  Permission to use, copy, modify, and distribute this software and its
//  documentation for any purpose and without fee is hereby granted,
//  provided that the above copyright notice appear in all copies.
//  Union Bank of Switzerland makes no representations about the usability
//  of this software for any purpose. It is provided "as is" without express
//  or implied warranty.
//
//   Modifications:
//
//   Version / When / Who
//   What
//   --------------------------------------------
//   %StartLog%
//   %EndLog%
//
//---------------------------------------------------------------------------*/

#ifndef xmubCustUi_h
#  define xmubCustUi_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#ifdef VMS
#include "xmubCustUtil.h"
#else
#include <xmub/xmubCustUtil.h>
#endif

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/*  For man-page generation: class xmubCustUi */
/*
// = TITLE
//    User interface functions for the resource mapping facility.
//	   
// = DESCRIPTION
//    This module contains Motif-based user interface components for
//    working with the resource mapping system in xmubCustUtil.
//
// = SEE ALSO
//	  xmubCustUtil
*/

/*  For man-page generation: public: */
/*
// = DIALOGS
*/
void
xmubPopupFontDialog( Widget                   toplevel,
                     xmubResourceMappingInfo  *info );
/*
// Pops up a dialog box that enables the user to choose the fonts for
// the application.
*/

void
xmubPopupPaletteDialog( Widget                   toplevel,
                        Boolean                  update_shadows,
                        xmubResourceMappingInfo  *info );
/*
// Pops up a dialog box that enables the user to choose the colors for
// the application.
*/

/*
// = UPDATING RESOURCE SETS
*/
void
xmubUpdateFontmap( char                     *fontmap,
                   xmubResourceMappingInfo  *info );
/*
// Updates the resource database with the values from the new fontmap.
*/

void
xmubUpdatePalette( char                     *palette,
                   xmubResourceMappingInfo  *info );
/*
// Updates the resource database with the values from the new palette.
*/

/*
// = APPLYING NEW RESOURCES
*/
void
xmubApplyColorResources( Widget   toplevel,
                         Boolean  update_shadows );
/*
// Walks through the widget hierarchy with the root at toplevel, and
// applies the new background and foreground color resources.
// If update_shadows is True, the shadow colors are calculated new
// and updated as well. Beware that this fills up the color table
// pretty quickly.
*/

void
xmubApplyFontResources( Widget  toplevel );
/*
// Walks through the widget hierarchy with the root at toplevel, and
// applies the new fontlist resource. It does not do any resizing.
*/

/*
// = GETTING INFORMATION
*/
String
xmubCurrentFontmap( Display  *display );
/*
// Returns the current fontmap. The returned string should be freed with
// XtFree when no longer needed.
// NULL is returned if no fontmap is set (default is used).
*/

String
xmubCurrentPalette( Display  *display );
/*
// Returns the current palette. The returned string should be freed with
// XtFree when no longer needed.
// NULL is returned if no palette is set (default is used).
*/

#ifdef __cplusplus
}
#endif

#endif
