/*----------------------------------------------------------------------------
--
--  Module:           xmubUtils
--
--  Project:          <>
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Utility functions for the dialogs.
--
--  Contents:
--    <>
--
--  Filename:         xmubUtils.h
--
--  Authors:          Ulrika Bornetun
--  Creation date:    1994-03-30
--
--  Modifications:
--
--  Who            When
--  What
--  -----------------------------
--  <>             <>
--  <>
--
--
--  Copyright 1994 by Union Bank of Switzerland.
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies.
--  Union Bank of Switzerland makes no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
--
------------------------------------------------------------------------------
--
-- SCCSID = "@(#) Module: %M%, Version: %R%.%L%, Date: %E% %U%"
--
----------------------------------------------------------------------------*/

#ifndef xmubUtils_h
#  define xmubUtils_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

void
xmubGetPopups( Widget       widget,
               WidgetList  *list,
               Cardinal    *num_popups );
/*
// Returns the popups defined on the widget.
// Returned is a pointer into the widget structure, so don't manipulate or
// free it!
*/

void
xmubIterateTree( Widget          toplevel,
                 XtCallbackProc  callback,
                 XtPointer       client_data );
/*
// Starts at toplevel and calls the callback for every child.
// The callback is called with the parameters
//   ( widget, NULL, client_data ).
*/



#ifdef __cplusplus
}
#endif

#endif
