#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, button;
    int status;
    Pixmap pixmap, armpixmap;
    XpmAttributes attributes;
    XpmColorSymbol symbol;

    top = XtAppInitialize(&app, "BulletButton", NULL, 0, &argc,
			  argv, NULL, NULL, 0);
    button = XmCreatePushButton(top, "button", NULL, 0);

    /* create a red bullet pixmap */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_symb.xpm", &pixmap, NULL, NULL);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* set the Foreground to green */
    symbol.name = "Foreground";
    symbol.value = "green";

    attributes.colorsymbols = &symbol;
    attributes.numsymbols = 1;
    attributes.valuemask = XpmColorSymbols;

    /* create a green bullet pixmap with these attributes */
    status = XpmReadFileToPixmap(XtDisplay(top),
				 XRootWindowOfScreen(XtScreen(top)),
				 "bullet_symb.xpm", &armpixmap, NULL,
				 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* then put the pixmaps onto the button */
    XtVaSetValues(button,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  XmNarmPixmap, armpixmap,
		  NULL);

    XtManageChild(button);
    XtRealizeWidget(top);
    XtAppMainLoop(app);
}
