#include <stdio.h>
#include <stdlib.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>

main(int argc, char *argv[])
{
    XtAppContext app;
    Widget top, button;
    int status;
    Pixmap pixmap, armPixmap;
    XpmAttributes attributes;
    XpmColorSymbol symbols[2];
    Pixel color;
    XpmImage xpmimage;

    top = XtAppInitialize(&app, "BulletButton", NULL, 0, &argc, argv,
			  NULL, NULL, 0);
    button = XmCreatePushButton(top, "button", NULL, 0);

    /* read the XPM file */
    status = XpmReadFileToXpmImage("bullet_transp.xpm", &xpmimage, NULL);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }

    /* create a red bullet pixmap from the XpmImage structure */
    XtVaGetValues(button, XmNbackground, &color, NULL);

    symbols[0].name = NULL;
    symbols[0].value = "none";
    symbols[0].pixel = color;

    attributes.colorsymbols = symbols;
    attributes.numsymbols = 1;
    attributes.valuemask = XpmColorSymbols;
    status = XpmCreatePixmapFromXpmImage(XtDisplay(top),
					 XRootWindowOfScreen(XtScreen(top)),
					 &xpmimage, &pixmap, NULL,
					 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* then, create a green pixmap from the XpmImage structure */
    XtVaGetValues(button, XmNarmColor, &color, NULL);

    symbols[0].pixel = color;
    symbols[1].name = "Foreground";
    symbols[1].value = "green";
    attributes.numsymbols = 2;
    attributes.valuemask = XpmColorSymbols;

    status = XpmCreatePixmapFromXpmImage(XtDisplay(top),
					 XRootWindowOfScreen(XtScreen(top)),
					 &xpmimage, &armPixmap, NULL,
					 &attributes);
    if (status != XpmSuccess) {
	fprintf(stderr, "XpmError: %s\n", XpmGetErrorString(status));
	exit(1);
    }
    /* now put the two pixmaps onto the button */
    XtVaSetValues(button, XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, pixmap,
		  XmNarmPixmap, armPixmap,
		  NULL);

    XtManageChild(button);
    XtRealizeWidget(top);
    XtAppMainLoop(app);
}
