#ifndef lint
static char	*RCSid = "$Id: util.c,v 2.0 1995/03/27 18:56:22 mjhammel Exp $";
#endif

/*
 * util.c - utility routines.
 *
 * David A. Curry
 * SRI International
 * 333 Ravenswood Avenue
 * Menlo Park, CA 94025
 * davy@itstd.sri.com
 *
 * Modified by
 * Michael J. Hammel (03/01/95)
 * Contractor
 * 1150 Inca St. TH 70
 * Denver, CO 80204
 * mjhammel@csn.org
 *
 * $Log: util.c,v $
 * Revision 2.0  1995/03/27  18:56:22  mjhammel
 * Initial update to 2.0
 *
 *
 * Revision 1.2  90/06/14  11:21:14  davy
 * Ported to X11 Release 4.
 * 
 * Revision 1.1  90/06/13  09:48:49  davy
 * Initial revision
 * 
 */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "xpostit.h"

/*
 * ByeBye - clean up and exit.
 */
void
ByeBye()
{
	/*
	 * If saving notes is on, save all notes.
	 */
	if (app_res.save_notes)
		SaveAllNotes();

	XtUnmapWidget(toplevel);
	XCloseDisplay(display);
	exit(0);
}

/*
 * SetNoteDir - determine the path to the note directory.
 */
void
SetNoteDir()
{
	char *getenv();
	char *home, *s;
	struct passwd *pwd;
	char fname[MAXPATHLEN];
	struct stat *stat_buf;
	int rc;

	/*
	 * If it's an absolute path name,
	 * we're done.
	 */
	if (app_res.note_dir[0] != '/')
	{

		/*
		 * Find the user's home directory.
		 */
		if ((home = getenv("HOME")) == NULL) {
			if ((pwd = getpwuid(getuid())) == NULL) {
				fprintf(stderr, "xpostit: who are you?\n");
				exit(1);
			}
	
			home = pwd->pw_dir;
		}

		/*
		 * Save the path.
		 */
		sprintf(fname, "%s/%s", home, app_res.note_dir);

		s = SafeAlloc(strlen(fname) + 1);
		app_res.note_dir = s;
		strcpy(s, fname);
	}
	
	/* now we have the name of the directory pointed at by app_res.note_dir
	 * so check if it exists, and if it doesn't, try to create it
	 */

    stat_buf = (struct stat *) malloc( sizeof(struct stat) );
    if ( ( rc = stat ( app_res.note_dir, stat_buf ) ) !=0 ) {
        switch ( errno ) {
            case EACCES:
                printf ( "Search permission denied for portion of path");
                printf ( " leading to %s\n", app_res.note_dir );
                printf ( "Aborting.\n");
                free ( stat_buf );
                exit ( -1 );
                break;
            case ENOTDIR:
                printf ( "A portion of the pathname to %s", app_res.note_dir);
                printf ( " is invalid\n" );
                printf ( "Aborting.\n");
                free ( stat_buf );
                exit ( -1 );
                break;
            case ENOENT:
				/* if it doesn't exist, try to create it */
                printf ( "%s: no such file or directory\n", app_res.note_dir);
                printf ( "Trying to create.\n");
				rc = mkdir ( app_res.note_dir, 0755 );
				if ( rc != 0 ) {
					printf ("Can't create %s\n; Aborting", app_res.note_dir );
                	free ( stat_buf );
                	exit ( -1 );
				}
                break;
            default:
                printf ("Unknown error (%d) while stat()'ing %s\n", errno,
                    app_res.note_dir );
                exit ( -1 );
                break;
        }
    }
 
}

/*
 * MakeFname - make a file name from a note index number.
 */
char *
MakeFname(index)
register int index;
{
	char *s;
	char fname[MAXPATHLEN];

	sprintf(fname, "%s/%s%d", app_res.note_dir, PostItNoteFname, index);
	s = SafeAlloc(strlen(fname) + 1);
	strcpy(s, fname);
	return(s);
}

/*
 * SafeAlloc - allocate n bytes of memory, exit if we run out.
 */
char *
SafeAlloc(nbytes)
register int nbytes;
{
	register char *s;

	if ((s = (char *)malloc(nbytes)) == NULL) {
		fprintf(stderr, "xpostit: out of memory.\n");
		exit(1);
	}

	bzero(s, nbytes);
	return(s);
}

/*
 * AutoSave - save all notes automatically when timer expires
 */
void
AutoSave(client_data, id)
XtPointer client_data;
XtIntervalId	*id;
{
	XtIntervalId	timer;

	SaveAllNotes();
	timer = XtAppAddTimeOut (
				XtWidgetToApplicationContext(toplevel),
				timer_interval,
				AutoSave,
				NULL);
}
