/* asedit.h - the main include file for the asedit program,
		(C) A.Stochniol, 1991-1994
		Note: that for asedit 1.2 type of the data in the as_menuh_struct
		was changed from "XtPointer" to int
		& asClientDataStruct was introduced
*/
/*
 * Copyright 1991 - 1994,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or 
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on 
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * By using or copying this Software, Licensee agrees to abide by the
 * copyright law and all other applicable laws, and the terms of this
 * license.
 * AS shall have the right to terminate this license immediately by
 * written notice upon Licensee's breach of, or non-compliance with, any
 * of its terms.  Licensee may be held legally responsible for any
 * copyright infringement that is caused or encouraged by Licensee's
 * failure to abide by the terms of this license.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 */

#ifndef _asedit_h
#define _asedit_h

#include <Xm/Xm.h>

typedef struct _as_menuh_struct{
   char*                  name;           /* name of the button */
   void                  (*func)();       /* Callback to be invoked */
   void                  (*helpCB)();     /* help Callback to be invoked */
   int	                  data;           /* Data (id) for the callback (transformed with mk_asdat) */
   unsigned int mnemonic;		  /* mnemonic for the button */
   char*		  acceleratorText;  /* text of the accelerator ... */
   char*		  accelerator;	    /* accelerator itself (in a special X11 format) */
   struct _as_menuh_struct *sub_menu;       /* data for submenu of this button */
   int                    n_sub_items;    /* How many items in sub_menu */
   char                  *sub_menu_title; /* Title of submenu */
   Widget		  w;		  /* pointer to the created widget button */
 } as_menuh_struct;

/* definition of undo/redo data structures */
/* size of the undo/redo stacks*/
#if (XmVersion >= 1002)
#   define EditSTACK_SIZE          500
#else
#   define EditSTACK_SIZE          250
#endif

/* in Motif XmTextBlock's are used to pass text around and the internal
   structure is as follow
  typedef struct {
    char *ptr;                  |* Pointer to data. *|
    int length;                 |* Number of bytes of data. *|
    XmTextFormat format;        |* Representation format. *|
  } XmTextBlockRec, *XmTextBlock;
*/

typedef struct
{
   int reason;
   long currInsert, newInsert;
   long startPos, endPos;
   char *del_text, *ins_text;
   Boolean undo_sequence, redo_sequence;
}  EditAction, *EditActionPtr;

typedef struct
{
   int          bottom;                 /* bootom (head) of the stack */
   int          top;                    /* top (tail) of the stack */
   EditActionPtr el[EditSTACK_SIZE];    /* pointers to stack elements */
}  EditStack;

#define MAX_TABSIZE	    32
#define MAX_SEL_TOOLS	    10



/* define data structure to hold some static information for
   Search|Change|Change All sequence
*/

typedef struct
{
    Boolean searchForward;		/* search direction */
    Boolean caseSensitive;
    Boolean wholeWordsOnly;
    int itemsChanged;
    long startPosition;	/* it remembers the starting position
			and it is used to detect that the change has been finished;
			this value is updated to take into account replacement
			with different length of the new string */

}  ChangeAllPar;

/* define data structure to hold some static information for
   Search|Change or Search|Find and continue search cases
*/

typedef struct
{
    Boolean forward;			/* search direction */
    Boolean on;				/* used to show that standard
				continuation is taking place as opposite
				to ChangeAll continuation */
    long startPosition;	/* it remembers the starting position */

}  ContinueSearchPar;

/* we support total number of TOTAL_MARKS bookmarks */
#define TOTAL_MARKS	10

/* define data structure that contains all information for one, fully
   functioning, self contained asedit window
 */
typedef struct aseditWindowStruct
{

  Widget menu_bar;		/* menu_bar, used as a parent for dialogs */
  Widget topshell;		/* top level shell for that asedit window */

  Widget edit_text;
  Widget edit_text1;		/* multi-line main editable text widget	    */

  Widget frame_bottom;         /*  Frame       */

  Widget menu_cut_button;      /* some menu_... widgets follows:		*/
  Widget menu_copy_button;	/*   they represent buttons in the pull-down menus */
  Widget menu_paste_button;	/*   that must be globally accessible (to change   */
  Widget menu_clear_button;	/*   their sensitivity etc. )			 */
  Widget menu_undo_button;
  Widget menu_redo_button;

  Widget menu_save_button;
  Widget menu_save_as_button;
  Widget menu_close_button;
  Widget menu_insert_button;
  Widget menu_print_button;

  Widget menu_find_button;
  Widget menu_replace_button;
  Widget menu_find_again_button;
  Widget menu_gotoline_button;
  Widget menu_mark_button;
  Widget menu_match_button;

  Widget open_dialog;		/* file selection dialog used to open a file	*/
  Widget save_as_dialog;		/* save as prompt dialog	 	    */
  Widget save_changes_dialog;	/* question if save file before opening a new one,
				   starting a new one, closing the file or exiting the
				   program, asked when the changes has not been saved */
  Widget insert_dialog;		/* insert dialog (NEW in 1.2) */
  Widget print_dialog;		/* print dialog (NEW in 1.2) */
  Widget overwrite_question;	/* question if write over an existing file for save as option */
  Widget error_message;		/* general error message; should be accessed
				   via show_error_message procedure */

  Widget gotoline_dialog;	/* go to line prompt dialog 			*/
  Widget replace_dialog;	/* replace (change) 4-buttons prompt dialog;
				   the same dialog after dynamic changes
				   is used for the find dialog 	*/
  Widget change_prompt;		/* prompt for change action: Change | Skip | Cancel | Help */
  Widget continue_search_question;/* a widget to pop-up when the end or the beginning of
				   the file has been reached during the search */
  Widget search_end_message;	/* message about end of the search */

  Widget help_dialog;		/* hypertext on-line help */
  Widget about_program_message;	/* widget with the message about the program*/

  Widget changes_status;	/* widget displaying a star when file has been changed */
  Widget line_number;		/* widget displaying line number */
  Widget column_number;		/* widget displaying column number */


  Widget text_to_find;		/* following 8 widgets are initialized in CreateReplaceDialog */
  Widget new_text_title;
  Widget new_text;
  Widget case_sensitive_toggle;
  Widget whole_words_only_toggle;
  Widget forward_toggle;
  Widget change_all_button;
  Widget change_verify_button;
  Widget cancel_replace_dialog_button;

  Widget view_only_toggle;


  Widget menu_spell_button;		/* spell button (in the pulldown menu) */
  Widget menu_commands_button;		/* tool's commands button */
  Widget toolsSelNeeded[MAX_SEL_TOOLS];	/* menu buttons that need selection to be active */
  int    nToolsSelNeeded;		/* numbers of the above */
  
  int		tabsize;	/* current tab size value */

  Widget moveLeft_dialog;
  Widget moveRight_dialog;
  Widget indentWith_dialog;
  Widget reformat_dialog;
  Widget left_margin;
  Widget right_margin;

  Widget quick_access_popup;
  Widget popup_undo_button;
  Widget popup_cut_button;
  Widget popup_copy_button;
  Widget popup_paste_button;
  Widget popup_save_button;

  Widget filter_dialog;
  Widget command_dialog;
  Widget print_complete_toggle;

  int	  filterOutDepot;	/* flag where goes the child (filter) output */
  int	  commandOutDepot;	/* flag where goes the command output */

  long    changes_counter;	/* counter of changes made to a file since last
				   save; if != 0 the present file is not saved;
				   replaces file_saved for the version without
				   undo/redo */
  Boolean file_read_only;	/* status of the read in file */
  char    *filename;		/* string containing file name 		    */
  int     reason_save_question;	/* gives the reason for prompting save_changes_dialog
				   (i.e. is equal to MENU_OPEN, MENU_NEW etc.) */
  char    *search_string;       /*  string to be searched for */
  char    *new_string;		/*  a new string after replacement */
  long    start_search_position;/*  starting position for a new search or change */

  Time	  timestamp_search_request;	/* timestamp from an event that trigerred
					   the search request (used to set the
					   selection i.e. highlighting of the found text) */
  int 	  search_reason;
  long	  found_string_start_pos;	/* start position of the found string */
  long	  found_string_end_pos;		/* end position of the found string */
  long    line;				/* current line position of a cursor */
  long    column;			/* current column position of a cursor */
  long    column_ntab;


  Boolean   nextSelectionSearch;	/* to distinguish Find/Replace and Find Selection/Find next */
  Boolean   weOwnPrimarySelection;
  Boolean   file_just_loaded;

  Boolean   do_undo_redo_action;
  Boolean   status_line_on;

  struct    aseditWindowStruct *prev;	/* pointer to the previous asedit...*/

  /* undo/redo data follows ... */
  Boolean    can_undo, can_redo;	/* new in 1.27 to support undo/redo actions */
  EditStack  undo_stack;
  EditStack  redo_stack;
  EditAction edit_history[EditSTACK_SIZE];
  Boolean    edit_history_initialized;

  /* bookmarks data follow ... */
  Boolean	 marks_used;		/* true if at least one mark is set */
  Boolean 	 mark_set[TOTAL_MARKS];
  XmTextPosition mark_pos[TOTAL_MARKS];
  Widget	 menu_mark_set_button[TOTAL_MARKS];
  Widget	 menu_mark_go_button[TOTAL_MARKS];

  ChangeAllPar  chgAll;
  ContinueSearchPar cntSearch;

} aseditWindowStruct, *aseditWindowStructPtr;


typedef struct
{
    int  	id;	/* the "classic" client_data (integer id) used in GUI
			   programming to identify where the call comes from */
    aseditWindowStruct *win;	/* pointer to the data structure that contains
				   all information for one, fully functioning,
				   self contained asedit window
				*/

} asClientDataStruct, *asClientDataStructPtr;


/*
 * lstr - local definitions, language dependent message strings and some
	  other new resources in asedit.
 */
typedef struct
{
    /* first resources that are most probable to be changed, then the i18n resources,
       then the special resources */
    String noname;		/* noname string ... ("NoName")	*/
    String tmpDir;            /* default NULL; if not set, $TMPDIR or system tmp dir is used */
    String helpDir;           /* default NULL; if not set a value set during
				 the installation procedure is used */
    String helpName;           /* default NULL; if not set a help file name (without path) */
    String backupFileSuffix;  /* default NULL; if not se a value set during
				 the installation process is used */

    /* fm_... file messages ...*/
    String fm_unable_to_open;	/* "Error: unable to open file:\n" 	*/
    String fm_unable_to_save;	/* "Error: unable to save file:\n" 	*/
    String fm_not_closed;	/* " .\nFile not closed!"		*/
    String fm_print_failed;	/* "Print failed !"                    	*/
    String fm_exit_aborted;	/* " .\nExit aborted!"			*/
    String fm_not_printed;	/* " .\nFile not printed."		*/
    String fm_not_regular;	/* "not a regular file."		*/
    String fm_no_selection;	/* "Cannot print selection. Text not selected!" */
    String fm_no_printer;	/* "Select or specify a printer, please!" */
    String fm_no_filename;	/* "Select or specify a filename, please!" */

    /* fq_... file questions ... */
    String fq_overwrite;	/* "Overwrite existing file:\n" */
    String fq_save_changes;	/* "Save Current Changes?"		*/

    /* labels for find/change buttons (shared widget) */
    String find_label;		/* "Find"				*/
    String find_next_label;	/* " Find Next "			*/
    String change_label;	/* "Change"				*/
    String find_n_verify_label; /* "Find & Verify"			*/

    /* titles for find/change dialogs (shared widget) */
    String find_dialogTitle;	/* "asedit - find"			*/
    String change_dialogTitle;  /* "asedit - change"			*/

    /* sm_... search messages ... */
    String sm_have_to_enter;	/* "You have to enter a string to search for!" */
    String sm_have_to_select;
    String sm_not_found; 	/* "Search string not found"		*/
    String sm_change_all_completed; /* "Change All has been completed.\nNumber of items changed: %d." */
    String sm_line_range;	/* "Line number is not within the legal range.\nLegal range is:" */

    /* sq_... search questions ... */
    String sq_change;     	/* "Change this occurrence ?"		*/
    String sq_doc_end;		/* "Reached end of document.\nContinue search at beginning ?" */
    String sq_doc_beg;		/* "Reached beginning of document.\nContinue search at end ?" */

    /* flt_... filter messages */
    String flt_no_selection;     /* "Cannot filter selection. Text not selected!" */
    String flt_no_filter;	 /* "Specify a filter command, please!" */
    String flt_no_text;	 	 /* "Enter a text, please!" */
    String flt_no_value;	 /* "Enter a value, please!" */
    String flt_wrong_margins;	 /* "Wrong margin values!" */
    String flt_missing_margins;	 /* "Missing margin values!" */

    String cant_find_lf;	 /* "Can't find closing line feed!" */

    /* string (character) to be shown for read-only files */
    String read_only_marker;	/* "R"					*/

    /* text used in the ht_help.c (hypertext help) */
    String help_err_fopen;	/* "Help ERROR. Can't open Help file '%s'." */
    String help_err_finc;	/* "Help ERROR. Incorrect Help file '%s'."	*/
    String help_no_info;	/* "SORRY. No help information for this item." */

    /* other locale dependent messages */
    String load_font_err;	/* "Could not open font '%s'\n"	*/
    String open_tmp_err;	/* "Warning: unable to open temp file '%s'... */
    String close_tmp_err;	/* "Warning: unable to close temp file '%s'... */
    String backup_file_err;	/* "Unable to create ... '%s'\n. ... '%s'\n" */
    String file_close_err;	/* "Warning: unable to close file '%s'.\n"	*/
    String file_move_err;	/* "Warning: unable to move temp file. File '%s' not saved\n" */
    String open_tmp_print_err;  /* Warning: unable to open temp file '%s', text not printed.\n */


    String initial_geometry;	/* defaults to NULL */
    Boolean first_window_iconic;	/* defaults to False */
    String changeHint;			/* (Changed) extra text used to show that file was changed */
    String wrong_syntax;	/* "Unrecognized option: '%s'.\n" */
    String syntax;		/* string showing syntax of the command line */
    String oldAppDefs;		/* "Warning: old application defaults file loaded!" */
    String noAppDefs;		/* "Warning: application defaults file not found!" */
    String fallAppDefs;		/* "Warning: fallback resources used!" */


    int tabSize;		/* tab size; default 8 */


    Boolean defaultWrap;		/* initial value for the wrap mode */
    Boolean autoAddEOFnewline;		/* when True, automatically add a newline to the
					   end of any saved file if the file does
					   not end in one already */
    Boolean selectDelimitedText;	/* when True, the text between matched pair (e.g. { } )
					   will be selected after search; default is False */
    Boolean defaultStatus;		/* default value of the status option toogle */
    Boolean defaultAutoIndent;		/* default value of the auto indent */
    Boolean useOldColorSetup;		/* new in 1.27; since version 1.27 defaults to False
					   and colours of all recessed widgets
					   have to be set via resources; the same
					   goes for the colour of edit widgets in read
					   only mode
					*/
    Pixel readOnlyBackground;		/* new in 1.27; used to specify the
					   colour of a read only text widget
					   when the new color setup is used, i.e.
					   useOldColorSetup is False
					*/
    int    startLine;
    int    appDefaultsVersion;

    int    progressInterval;	/* interval for progress working dialog */
    int    progressInitialDelay;
    int    progressShortInitialDelay;

    String sortCmd;		/* sort filter command definition */
    String spellCmd;		/* spell filter command definition */
    String expandCmd;		/* expand filter command definition */
    String unexpandCmd;		/* unexpand filter command definition */
    XmStringTable sortExt;	/* filter extension definition for sort */
    XmStringTable spellExt;	/* filter extension definition for spell */
    XmStringTable expandExt;	/* filter extension definition for expand */
    XmStringTable unexpandExt;	/* filter extension definition for unexpand */

    String fmtCmd;		/* fmt filter command definition (used internally) */

    XmStringTable allFormatExt;	/* extension for *All* filters in Format menu */

    int filterNum;               /* number of user definable filters; give us a number
				    of filter's & filterExt's to take into account */
    String filter0;		/* definition of a filter 0 command (system command string) */
    String filter1;
    String filter2;
    String filter3;
    String filter4;
    String filter5;
    String filter6;
    String filter7;
    String filter8;
    String filter9;

    XmStringTable filterExt0;	/* definition of filter extended parameters; (filterDepot \, dlgTitle) */
    XmStringTable filterExt1;
    XmStringTable filterExt2;
    XmStringTable filterExt3;
    XmStringTable filterExt4;
    XmStringTable filterExt5;
    XmStringTable filterExt6;
    XmStringTable filterExt7;
    XmStringTable filterExt8;
    XmStringTable filterExt9;

    int cmdNum;               	/* number of user definable commands; give us a number
				    of cmdDef to take into account */
    String cmdDef0;		/* definition of a command 0  (system command string) */
    String cmdDef1;
    String cmdDef2;
    String cmdDef3;
    String cmdDef4;
    String cmdDef5;
    String cmdDef6;
    String cmdDef7;
    String cmdDef8;
    String cmdDef9;

    XmStringTable cmdExt0;   	/* definition of command extended parameters  */
    XmStringTable cmdExt1;
    XmStringTable cmdExt2;
    XmStringTable cmdExt3;
    XmStringTable cmdExt4;
    XmStringTable cmdExt5;
    XmStringTable cmdExt6;
    XmStringTable cmdExt7;
    XmStringTable cmdExt8;
    XmStringTable cmdExt9;



}   as_lstr, *as_lstr_ptr;
    /* above:  the offset calculation macro XtOffset needs a pointer to a structure,
     therefore as_lstr_ptr has been also defined */



/*****************************	Forward Declarations  ***********************/

#ifdef _NO_PROTO	/* prototypes for non-ANSI systems follow ... */

extern Widget CreateEditWorkArea();
extern Boolean SaveFile();
extern Boolean OpenFile();
extern void CloseFile();
extern char * ReadFile();
extern long find_line_pos();
extern void calc_text_lcn ();
extern void textPosToLineColumn();
extern void back_textPosToLineColumn();
extern void find_string();
extern long find_string_pos_in_buffer();
extern void set_asedit_icon();

extern void set_change_buttons_sensitivity();
extern void change_all_found_strings();
extern void set_dialog_title();
extern void MenuCB ();
extern void TextCB ();
extern void HelpCB ();
extern void DialogOkCB ();
extern void DialogApplyCB ();
extern void DialogCancelCB ();
extern void allowOnlyNumbersCB();
extern Boolean acceptChildOutput();

extern void set_titles_mwindow_icon();
extern void TurnWatchCursor();

extern void UndoRedo ();
extern void reset_undo_redo();
extern void SaveActionForUndo();

extern Widget CreateHyperTextHelp();
extern void focusCB();
extern void as_create_menuh();
extern void as_create_popup_menu();


extern char *make_tmpnam ();
extern void asManageDialog();
extern XtPointer mk_asdat();
extern XtPointer mk_asdat_w();
extern int get_id_from_asdat();
extern aseditWindowStruct *get_win_from_asdat();
extern void next_window();
extern void show_error_message();
extern aseditWindowStruct *new_asedit_win();
extern void remove_asedit_win ();
extern void open_file_in_last_window();
extern void create_set_font_list();
extern void create_set2_font_list();
extern XImage * CreateDefaultImage ();
extern Widget create_4buttons_dialog ();
extern Widget create_4buttons_image_dialog ();
extern void install_as_images ();
extern char *getTextSubstring();
extern void checkRadioBoxSetting();
extern void show_open_dialog ();
extern void show_save_as_dialog ();
extern void show_save_changes_dialog ();
extern void show_overwrite_question ();
extern void show_insert_dialog ();

extern void show_replace_dialog ();
extern void show_change_prompt ();
extern void create_continue_search_question ();
extern void create_search_end_message ();
extern void show_gotoline_dialog ();
extern void show_print_dialog ();
extern void show_filter_dialog ();
extern void show_tabsize_dialog ();
extern void show_spell_dialog ();
extern void setDefaultHomeEndTranslations();
extern void disableRedisplay();
extern void enableRedisplay();
extern Boolean extendSelectionToLF ();
extern Boolean extendSelectionToBOL ();
extern Boolean extendSelectionToLines ();
extern Boolean extendSelectionToWholeFile ();


extern Boolean empty_name();
extern Boolean isFileRegular();
extern Boolean checkSyntax();
extern Boolean checkCommandForOption();
extern void go_to_line();

extern get_option_id();
extern void set_option_id();
extern void cnv_lang_code();

extern void show_about_message();

extern void write_ll();
extern void write_ls();

#else  /* ! _NO_PROTO, ANSI prototypes follow */

extern Widget CreateEditWorkArea(aseditWindowStruct *win, Widget parent);
extern Boolean SaveFile(aseditWindowStruct *win);
extern Boolean OpenFile(aseditWindowStruct *win, Boolean only_existing_files);
extern void CloseFile(aseditWindowStruct *win);
extern char * ReadFile(char *file_name, Boolean *read_only);
extern long find_line_pos(long line, char *buf, long *found_lines);
extern void calc_text_lcn (Widget w, XtPointer client_data, XtPointer call_data);
extern void textPosToLineColumn(char *buf, long buf_size, long pos, int tab_size, 
	long *line, long *column, long *column_ntab);
extern void back_textPosToLineColumn(char *buf, long buf_size, long pos, int tab_size, 
	long *line, long *column, long *column_ntab);
extern void find_string(aseditWindowStruct *win, Boolean start);
extern long find_string_pos_in_buffer(char *searchstring, char *buf,
			long startpos, long endpos, Boolean forward,
			Boolean case_sensitive, Boolean whole_words_only);
extern void set_asedit_icon(Widget shell, Widget colours_source, char *icon_name);

extern void set_change_buttons_sensitivity(aseditWindowStruct *win, Boolean state);
extern void change_all_found_strings(aseditWindowStruct *win, Boolean start);
extern void set_dialog_title(Widget w, char *title);
extern void MenuCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void TextCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void HelpCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void DialogOkCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void DialogApplyCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void DialogCancelCB (Widget w, XtPointer client_data, XtPointer call_data);
extern void allowOnlyNumbersCB (Widget w, XtPointer client_data, XtPointer call_data);
extern Boolean acceptChildOutput(Widget parent,  char *errstr, int defaultButtonType);

extern void set_titles_mwindow_icon(aseditWindowStruct *win, char *filename, char *extra);
extern void TurnWatchCursor(Boolean turn_on);

extern void UndoRedo (aseditWindowStruct *win, int action_type);
extern void reset_undo_redo( aseditWindowStruct *win);
extern void SaveActionForUndo(Widget w, XtPointer client_data, XtPointer call_data);

extern Widget CreateHyperTextHelp( Widget parent, String name,
		Arg arglist[], int argcount );
extern void focusCB(Widget w, XtPointer data, XtPointer dummy);
extern void as_create_menuh(char *title, Widget menu, as_menuh_struct *menulist, int nitems,
		       XmStringCharSet charset );
extern void as_create_popup_menu(char *title, Widget menu, as_menuh_struct *menulist, int nitems,
		       XmStringCharSet charset );

extern char *make_tmpnam (void);
extern void asManageDialog(Widget w);
extern XtPointer mk_asdat(int client_data);
extern XtPointer mk_asdat_w(aseditWindowStruct *win , int client_data);
extern int get_id_from_asdat(XtPointer as_client_data);
extern aseditWindowStruct *get_win_from_asdat(XtPointer as_client_data);
extern void next_window(aseditWindowStruct *win_prev);
extern void show_error_message(aseditWindowStruct *win, char *message);
extern aseditWindowStruct *new_asedit_win(aseditWindowStruct *win_prev);
extern void remove_asedit_win (aseditWindowStruct *win);
extern void open_file_in_last_window(char *filename);
extern void create_set_font_list(Widget w, char *font_name);
extern void create_set2_font_list(Widget w, Widget w2, char *font_name);
extern XImage * CreateDefaultImage (char *bits, int width, int height);
extern Widget create_4buttons_dialog (Widget parent, String name, Pixmap pixmap,
	String message, Arg arglist[], int argcount);
extern Widget create_4buttons_image_dialog (Widget parent, String name,
	String image_string, String message, Arg arglist[], int argcount);
extern char *getTextSubstring(Widget w, XmTextPosition start, int num_chars);
extern void checkRadioBoxSetting(Widget w, int deflt);
extern void install_as_images (Widget parent);
extern void show_open_dialog (aseditWindowStruct *win);
extern void show_save_as_dialog (aseditWindowStruct *win, char *proposed_fname);
extern void show_save_changes_dialog (aseditWindowStruct *win);
extern void show_overwrite_question (aseditWindowStruct *win, char *filename);
extern void show_insert_dialog (aseditWindowStruct *win);

extern void show_replace_dialog (aseditWindowStruct *win);
extern void show_change_prompt (aseditWindowStruct *win);
extern void create_continue_search_question (aseditWindowStruct *win);
extern void create_search_end_message (aseditWindowStruct *win);
extern void show_gotoline_dialog (aseditWindowStruct *win);
extern void show_print_dialog (aseditWindowStruct *win);
extern void show_filter_dialog (aseditWindowStruct *win);
extern void show_tabsize_dialog (aseditWindowStruct *win);
extern void show_spell_dialog (aseditWindowStruct *win);
extern void setDefaultHomeEndTranslations(Widget w);
extern void disableRedisplay(aseditWindowStruct *win);
extern void enableRedisplay(aseditWindowStruct *win);
extern Boolean extendSelectionToLF (aseditWindowStruct *win, XmTextPosition *left, XmTextPosition *right);
extern Boolean extendSelectionToBOL (aseditWindowStruct *win, XmTextPosition *left, XmTextPosition *right);
extern Boolean extendSelectionToLines (aseditWindowStruct *win, XmTextPosition *left, XmTextPosition *right);
extern Boolean extendSelectionToWholeFile (aseditWindowStruct *win, XmTextPosition *left, XmTextPosition *right);



extern Boolean empty_name(char *str);
extern Boolean isFileRegular(char *file_name);
extern Boolean checkSyntax(unsigned int argc, char *argv[], char *program_name, char *introStr, char *syntaxStr);
extern Boolean checkCommandForOption(unsigned int argc, char *argv[], char *option );
extern void go_to_line(aseditWindowStruct *win, long line_no, Boolean setTopCharacter);

extern void write_ll(Widget label, XmStringCharSet charset, char *format, long n);
extern void write_ls(Widget label, XmStringCharSet charset, char *format, char *s);


extern void show_about_message (aseditWindowStruct *win);

#endif	/* end of conditional _NO_PROTO prototypes  compilation */


/************************    Global Definitions & Data   **********************/


/* special hypertext link definitions  ***/

#define HTEXT_KEYS              8000
#define HTEXT_INDEX             8001
#define HTEXT_HELP              8002
#define HTEXT_ABOUT             8003


#define MENU_FILE		  10
#define MENU_NEW                1000
#define MENU_OPEN		1001
#define MENU_CLOSE		1002
#define MENU_SAVE		1003
#define MENU_SAVE_AS		1004
#define MENU_INSERT		1005
#define MENU_PRINT		1006
#define MENU_EXIT		1007

#define MENU_EDIT		  20
#define MENU_UNDO	        2000
#define MENU_REDO               2001
#define MENU_CUT		2002
#define MENU_COPY		2003
#define MENU_PASTE		2004
#define MENU_CLEAR		2005

#define MENU_SEARCH		  30
#define	MENU_FIND		3000
#define	MENU_FIND_NEXT		3001
#define	MENU_CHANGE		3002
#define	MENU_GOTOLINE		3003
#define MENU_MARK       	3004
#define MENU_MATCH       	3005

#define MENU_MARK_SET   	300400
#define MENU_MARK_GO    	300401

#define MENU_MARK_SET0  	30040000
#define MENU_MARK_SET1  	30040001
#define MENU_MARK_SET2  	30040002
#define MENU_MARK_SET3  	30040003
#define MENU_MARK_SET4  	30040004
#define MENU_MARK_SET5  	30040005
#define MENU_MARK_SET6  	30040006
#define MENU_MARK_SET7  	30040007
#define MENU_MARK_SET8  	30040008
#define MENU_MARK_SET9  	30040009

#define MENU_MARK_GO0   	30040100
#define MENU_MARK_GO1   	30040101
#define MENU_MARK_GO2   	30040102
#define MENU_MARK_GO3   	30040103
#define MENU_MARK_GO4   	30040104
#define MENU_MARK_GO5   	30040105
#define MENU_MARK_GO6   	30040106
#define MENU_MARK_GO7   	30040107
#define MENU_MARK_GO8   	30040108
#define MENU_MARK_GO9   	30040109

#define MENU_MATCH_FORWARD   	300500
#define MENU_MATCH_BACKWARD    	300501



#define MENU_TOOLS		50
#define MENU_SPELL		5000
#define MENU_SORT		5001
#define MENU_FORMAT		5002
#define MENU_CASE		5003

#define MENU_FILTER		5004
#define MENU_COMMAND		5005

#define DIALOG_SPELL		500000

#define MENU_FORMAT_MOVE_LEFT	500200
#define MENU_FORMAT_MOVE_RIGHT	500201
#define MENU_FORMAT_INDENT_WITH	500202
#define MENU_FORMAT_REFORMAT	500203

#define MENU_EXPAND		500204
#define MENU_UNEXPAND		500205

#define DIALOG_MOVE_LEFT	50020000
#define DIALOG_MOVE_RIGHT	50020100
#define DIALOG_INDENT_WITH	50020200
#define DIALOG_REFORMAT		50020300

#define MENU_CASE_UPPER		500300
#define MENU_CASE_LOWER		500301
#define MENU_CASE_TITLE		500302
#define MENU_CASE_TOGGLE	500303

#define MENU_FILTER_EXTRA	500400
#define MENU_FILTER_0		500401
#define MENU_FILTER_1		500402
#define MENU_FILTER_2		500403
#define MENU_FILTER_3		500404
#define MENU_FILTER_4		500405
#define MENU_FILTER_5		500406
#define MENU_FILTER_6		500407
#define MENU_FILTER_7		500408
#define MENU_FILTER_8		500409
#define MENU_FILTER_9		500410

#define MENU_COMMAND_EXTRA	500500
#define MENU_COMMAND_0		500501
#define MENU_COMMAND_1		500502
#define MENU_COMMAND_2		500503
#define MENU_COMMAND_3		500504
#define MENU_COMMAND_4		500505
#define MENU_COMMAND_5		500506
#define MENU_COMMAND_6		500507
#define MENU_COMMAND_7		500508
#define MENU_COMMAND_8		500509
#define MENU_COMMAND_9		500510

#define DIALOG_FILTER		50040000
#define DIALOG_COMMAND		50050000


#define MENU_HELP		  80

#define	MENU_H_ON_KEYS		HTEXT_KEYS
#define	MENU_H_INDEX            HTEXT_INDEX
#define	MENU_H_ON_HELP          HTEXT_HELP
#define	MENU_H_ABOUT            HTEXT_ABOUT


#define MENU_QACCESS		90

#define DIALOG_OPEN		100100
#define DIALOG_SAVE_AS		100400
#define DIALOG_INSERT		100500
#define DIALOG_PRINT_NEW	100600

#define DIALOG_SAVE_CHANGES	100101
#define QUESTION_OVERWRITE      100401
#define DIALOG_FIND_OR_CHANGE	300000
#define DIALOG_GOTOLINE		300300
#define DIALOG_CHANGE_PROMPT	 30020001
#define QUESTION_CONTINUE_SEARCH 30020002
#define MESSAGE_SEARCH_END	 30020003
#define ERROR_MESSAGE		 7777


enum childOutDepot { TO_NONE, TO_STDOUT, TO_STDERR, TO_CURRENT, TO_NEW, TO_TEXT_DIALOG};

enum changeCaseToFlag { TO_UPPER_CASE, TO_LOWER_CASE, TO_TITLE_CASE, TO_TOGGLE_CASE};

extern Display	*display;	/*  Display		*/
extern XmStringCharSet charset;
extern char *PROGRAM_CLASS;
extern char *PROGRAM_NAME;

extern Display		*display;	/*  Display		*/
extern Widget toplevel;			/* application shell (top level)*/
extern Widget help_dialog;		/* global help for all asedit windows */
extern int    aseditWinCount;		/* global count of active windows */

extern aseditWindowStruct *asedit_last_window;	/* the last asedit win structure in the chain */

extern Boolean	clipboard_filled; 	/* to show if there is something in clipbboard to paste from */

extern Pixel	text_edit_background;	/* background colour of the main text widget
				   ( it is the colour of a recessed widget) */
extern Pixel   text_read_only_background;	/* a lighter colour to show that the file
					   is read only */
extern Pixel	select_menu_background;	/* background for editable widgets pop down
				   from the menus; it is equal to the menu buttons
				   arm colour */
extern Pixmap	xm_question_mark, xm_excl_mark;	/* Motif pixmaps (initialized in install_as_images) */

extern XmFontList default_fontlist;	/* default font list for the edit text widget */


extern XmStringCharSet charset;		/* used to set up XmStrings */

extern as_lstr		lstr;		/* language dependent messages */



#endif	/* do NOT add any stuff after this line */


