.TH ASEDIT n "Free Release 1.3"
.SH NAME
\fBasedit\fP - text editor for X/Motif
.SH SYNTAX
\fBasedit\fP [ \fIoptions\fP ...] [ \fIfilename(s)\fP ]
.SH DESCRIPTION
.I asedit
is an easy to use text editor for X Window System built around Motif Text
widget. Version 1.3, international free Release, includes the following
language versions: English, Dutch, French, German, Polish, Portuguese 
and Swedish. All commands and messages are localized for each
language. The on-line help is available only in English.
.SH OVERVIEW
.PP
The main features include:
  - international release (versions for 7 languages)
  - graphical user interface (GUI)
  - multiple editing windows
  - easy to use "point and click" interface
  - drag and drop support (Motif 1.2 and above only)
  - file selection via file selection dialog
  - read only mode to view files
  - file insert functionality
  - print dialog that allows:
.nf
	  (i)  selection of a printer and using extra print options
	  (ii) selection of a print range (selected text only or 
	       the complete document)
.fi
  - comprehensive context sensitive, hypertext on-line help
  - multiple undo and redo of edit actions
  - Cut/Copy/Paste features
  - bookmarks (up to 10)
  - parenthesis (pair) matching
  - comprehensive search and replace
  - line and column numbers
  - automatic indentation
  - shortcut keys for the most common edit features
  - pop-up menu for mouse oriented editing
  - special version with keyboard bindings for EMACS's users
  - customization via X11/Motif resources
  - easy localization for left to right languages
  - spell and sort commands
  - commands to change case of letters
  - formatting commands (expand/unexpand, move left/right, 
    indent with, reformat margins)
  - user customizable filters (up to 10); following filters
    are preconfigured: word count, compress multiple blank 
    lines, delete blank lines, double space the text, 
    delete extra spaces;
    new filter dialog is also available
  - user customizable commands (up to 10); following 
    commands are preconfigured:  pwd, date, hostname;
    new command dialog is also available
  - extended syntax (on program startup: show line <N>, 
    open multiple files, set tabstops interval, set 
    autoindent, etc.)


.SH OPTIONS
.PP
The following options are available:
.TP 8
.B \-bg \fI<COLOR>\fP
sets background (page) color for all elements
.TP 8
.B \-fg \fI<COLOR>\fP
sets foreground (text) color
.TP 8
.B \-fn \fI<FONT>\fP
sets one font list for the whole program
.TP 8
.B \-fnm \fI<FONT>\fP
sets font list for menu items and dialogs
.TP 8
.B \-fnt \fI<FONT>\fP
sets font list for the edit text area
.TP 8
.B \-helpdir \fI<DIR>\fP
sets directory for the asedit help file \fI(asedit.hlp)\fP
.TP 8
.B \-tab \fI<N>\fP
sets the tabstops to interval of N characters
.TP 8
.B \+<N>\fP
after opening the file go to line <N>
.TP 8
.B \-emacs\fP
turns on Emacs mode (alternate shortcuts set is used)
.TP 8
.B \-/+ai\fP
turns on/off autoindent
.TP 8
.B \-/+status\fP
turns on/off status line
.TP 8
.B \-/+wrap\fP
turns on/off auto wraparound (*slow* before Motif 1.2)
.TP 8
.B \-/+v\fP
turns on/off view only mode
.TP 8
   .....  and all standard X-Window options, including:
.TP 8
.B \-display \fI<HOST:SCREEN>\fP
sets the display where the window will appear
.TP 8
.B \-geometry \fI<WIDTHxHEIGHT+X+Y>\fP
sets window size and position (in pixels)
.TP 8
.B \-iconic\fP
starts the program up iconified
.TP 8
.B \-xrm \fI<RESOURCE>\fP
sets additional X resource specification
.PP

.I filename(s)
Specifies the file that is to be loaded during start-up and edited afterwards.
Note that you might specify more than one file.
If a file is not specified,
.I asedit
starts with a "NoName" file, so text might be entered in immediately.
.PP
.SH ON-LINE HELP
.I asedit
has a comprehensive, context sensitive, hypertext on-line help, so,
to avoid having to keep the information up to date in two places, it will not
be duplicated here. For more information see on-line help (just press the help key, F1, whenever you need help when working with
.I asedit
).
.SH AUTHOR
Andrzej Stochniol (A.Stochniol@ic.ac.uk)
.br
30 Hatch Road, London SW16 4PN, UK
.SH COPYRIGHT
Copyright 1992 - 1994 by Andrzej Stochniol



