/* machine.h - extra include file to define the machine the code is generated for */

/*
 * Copyright 1991 - 1994,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * By using or copying this Software, Licensee agrees to abide by the
 * copyright law and all other applicable laws, and the terms of this
 * license.
 * AS shall have the right to terminate this license immediately by
 * written notice upon Licensee's breach of, or non-compliance with, any
 * of its terms.  Licensee may be held legally responsible for any
 * copyright infringement that is caused or encouraged by Licensee's
 * failure to abide by the terms of this license.
 *
 *
 *      Andrzej Stochniol       (A.Stochniol@ic.ac.uk)
 *      30 Hatch Road
 *      London SW16 4PN
 *      UK
 */

#ifndef _as_machine_h
#define _as_machine_h

#undef PLATFORM_NAME

#if defined(_M88KOCS_TARGET)
    static char platform_id[] = "@(#)version for 88-open computers(m88kocs)";
#   define PLATFORM_NAME "88-open"
#endif

#if !defined(PLATFORM_NAME) && defined(_M88KBCS_TARGET)
    static char platform_id[] = "@(#)version for 88-open computers (m88kbcs)";
#   define PLATFORM_NAME "88-open"
#endif

#if !defined(PLATFORM_NAME) && defined(__DGUX__)
    static char platform_id[] = "@(#)version for AViiON running DG-UX";
#   define PLATFORM_NAME "DG_UX"
#endif

#if defined(__hpux)
#if (XmVersion >= 1002)
    static char platform_id[] = "@(#)version for HP9000 series 700 running HP-UX 9.x";
#else
    static char platform_id[] = "@(#)version for HP9000 series 700 running HP-UX 8.x or 9.x";
#endif /* Motif 1.2 */
#   define PLATFORM_NAME "HP_UX"
#endif

#if defined(__sgi)
#if (XmVersion >= 1002)
    static char platform_id[] = "@(#)version for SGI running IRIX 5.x";
#else
    static char platform_id[] = "@(#)version for SGI running IRIX 4.x";
#endif	/* Motif 1.2 */
#   define PLATFORM_NAME "Silicon Graphics"
#endif

#if defined(ultrix)
    static char platform_id[] = "@(#)version for DEC Ultrix";
#   define PLATFORM_NAME "DEC Ultrix"
#endif

#if defined(_IBMR2)
#if (XmVersion >= 1002)
    static char platform_id[] = "@(#)version for IBM RS/6000 running AIX 3.2.5 or higher";
#else
    static char platform_id[] = "@(#)version for IBM RS/6000 running AIX 3.2.x";
#endif
#   define PLATFORM_NAME "IBM RS/6000 AIX"
#endif

#if defined(sun) && !defined(SVR4)
    static char platform_id[] = "@(#)version for Sun Sparc running SunOS 4.x";
#   define PLATFORM_NAME "Sun"
#endif
#if defined(sun) && defined(SVR4)
    static char platform_id[] = "@(#)version for Sun Sparc running SunOS 5.x (Solaris 2.x)";
#   define PLATFORM_NAME "Sun Solaris"
#endif

#if defined(NEXT)
    static char platform_id[] = "@(#)version for Next BSD";
#   define PLATFORM_NAME "NeXT BSD"
#endif

#if defined(cray)
    static char platform_id[] = "@(#)version for Cray";
#   define PLATFORM_NAME "Cray"
#endif

#if defined(VMS)
    static char platform_id[] = "@(#)version for VMS";
#   define PLATFORM_NAME "VMS"
#endif

#if defined(NeXT)
    static char platform_id[] = "@(#)version for NeXT";
#   define PLATFORM_NAME "NeXT"
#endif

#if defined(__alpha)
    static char platform_id[] = "@(#)version for DEC ALPHA";
#   define PLATFORM_NAME "ALPHA"
#endif

#ifndef PLATFORM_NAME
    static char platform_id[] = "@(#)version for an Unknown platform";
#   define PLATFORM_NAME "Unknown platform"
#endif




#endif  /* (_as_machine_h) do NOT add any stuff after this line */


