/* write_l -  simple functions to write into a label widget or gadget;
	      procedures write_ll (writing long) & write_ls (writing string)
	      replace write_lw printf function that accepts variable
	      number of arguments (but the latter causes some compatibility
	      problems on different systems so we do not use it if possible)

	      A widget into which something will be written must belongs
	      to a label widget class or to a label gadget class.
	      The output will be written using appropriate character set.
	      (C) A. Stochniol 1991 - 1993
	      All rights reserved
	      Last revision: 17.11.1993
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>





#ifdef _NO_PROTO
void write_ll(label, charset, format, n)
    Widget label;
    XmStringCharSet charset;
    char *format;
    long n;

#else  /* _NO_PROTO */
void write_ll(Widget label, XmStringCharSet charset, char *format, long n)
#endif
{
 char output[512];	/* watch out not to use longer output !!!! */
 Arg       al[1];
 XmString  xmstr;

 if(!label) return;             /* safety test .... */

 /* format the string to be displayed in the widget */
 sprintf(output, format, n);

 /* Make sure that the destination widget is a subclass of XmLabel. */
 if(!XmIsLabel(label) && !XmIsLabelGadget(label))
 {
	fprintf(stderr, "Error: write_ll requires a Label Widget or Gadget. The following output not written:\n %s \n",
		output);
	return;
 }

  /* convert the string to an appropriate compound string and set it */
  xmstr =  XmStringLtoRCreate(output, charset);
  XtSetArg(al[0], XmNlabelString, xmstr);
  XtSetValues(label, al, 1);

  XmStringFree(xmstr);

} /* write_ll */


#ifdef _NO_PROTO
void write_ls(label, charset, format, s)
    Widget label;
    XmStringCharSet charset;
    char *format;
    char *s;

#else  /* _NO_PROTO */
void write_ls(Widget label, XmStringCharSet charset, char *format, char *s)
#endif
{
 char output[512];      /* watch out not to use longer output !!!! */
 Arg       al[1];
 XmString  xmstr;

 if(!label) return;             /* safety test .... */

 /* format the string to be displayed in the widget */
 sprintf(output, format, s);

 /* Make sure that the destination widget is a subclass of XmLabel. */
 if(!XmIsLabel(label) && !XmIsLabelGadget(label))
 {
        fprintf(stderr, "Error: write_ls requires a Label Widget or Gadget. The following output not written:\n %s \n",
                output);
        return;
 }

  /* convert the string to an appropriate compound string and set it */
  xmstr =  XmStringLtoRCreate(output, charset);
  XtSetArg(al[0], XmNlabelString, xmstr);
  XtSetValues(label, al, 1);

  XmStringFree(xmstr);

} /* write_ls */



