/* xresrc.h - X resources include file
   New X resource fields for asedit program. 
   This file must be included in the asedit.c file and after asedit.h 
   (I use it to reduce the size of the main file)
*/

/*
 * Copyright 1991 - 1994,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * By using or copying this Software, Licensee agrees to abide by the
 * copyright law and all other applicable laws, and the terms of this
 * license.
 * AS shall have the right to terminate this license immediately by
 * written notice upon Licensee's breach of, or non-compliance with, any
 * of its terms.  Licensee may be held legally responsible for any
 * copyright infringement that is caused or encouraged by Licensee's
 * failure to abide by the terms of this license.
 *
 *
 *      Andrzej Stochniol       (A.Stochniol@ic.ac.uk)
 *      30 Hatch Road
 *      London SW16 4PN
 *      UK
 */


#ifndef _as_xresources_h
#define _as_xresources_h

static XtResource resources[] = {
    { "noname", "Noname", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, noname), XmRString, ""},
    { "tmpDir", "TmpDir", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, tmpDir), XmRString, NULL},

    { "helpDir", "HelpDir", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, helpDir), XmRString, NULL},
    { "helpName", "HelpName", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, helpName), XmRString, NULL},

    { "backupFileSuffix", "BackupFileSuffix", XmRString, sizeof(String),
       XtOffset(as_lstr_ptr, backupFileSuffix), XmRString, NULL},

    { "fm_unable_to_open", "Fm_unable_to_open", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_unable_to_open), XmRString, ""},
    { "fm_unable_to_save", "Fm_unable_to_save", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_unable_to_save), XmRString, ""},
    { "fm_not_closed", "Fm_not_closed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_closed), XmRString, ""},
    { "fm_print_failed", "Fm_print_failed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_print_failed), XmRString, ""},
    { "fm_exit_aborted", "Fm_exit_aborted", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_exit_aborted), XmRString, ""},
    { "fm_not_printed", "Fm_not_printed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_printed), XmRString, ""},
    { "fm_no_selection", "Fm_no_selection", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_no_selection), XmRString, ""},
    { "fm_no_printer", "Fm_no_printer", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_no_printer), XmRString, ""},
    { "fm_no_filename", "Fm_no_filename", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_no_filename), XmRString, ""},
    { "fm_not_regular", "Fm_not_regular", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fm_not_regular), XmRString, ""},
    { "fq_overwrite", "Fq_overwrite", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fq_overwrite), XmRString, ""},
    { "fq_save_changes", "Fq_save_changes", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fq_save_changes), XmRString, ""},
    { "find_label", "Find_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_label), XmRString, ""},
    { "find_next_label", "Find_next_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_next_label), XmRString, ""},
    { "change_label", "Change_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, change_label), XmRString, ""},
    { "find_n_verify_label", "Find_n_verify_label", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_n_verify_label), XmRString, ""},
    { "find_dialogTitle", "Find_dialogTitle", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, find_dialogTitle), XmRString, ""},
    { "change_dialogTitle", "Change_dialogTitle", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, change_dialogTitle), XmRString, ""},
    { "sm_have_to_enter", "Sm_have_to_enter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_have_to_enter), XmRString, ""},
    { "sm_have_to_select", "Sm_have_to_select", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_have_to_select), XmRString, ""},
    { "sm_not_found", "Sm_not_found", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_not_found), XmRString, ""},
    { "sm_change_all_completed", "Sm_change_all_completed", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_change_all_completed), XmRString, ""},
    { "sm_line_range", "Sm_line_range", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sm_line_range), XmRString, ""},
    { "sq_change", "Sq_change", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_change), XmRString, ""},
    { "sq_doc_end", "Sq_doc_end", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_doc_end), XmRString, ""},
    { "sq_doc_beg", "Sq_doc_beg", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sq_doc_beg), XmRString, ""},

    { "flt_no_selection", "Flt_no_selection", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_no_selection), XmRString, ""},
    { "flt_no_filter", "Flt_no_filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_no_filter), XmRString, ""},
    { "flt_no_text", "Flt_no_text", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_no_text), XmRString, ""},
    { "flt_no_value", "Flt_no_value", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_no_value), XmRString, ""},
    { "flt_wrong_margins", "Flt_wrong_margins", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_wrong_margins), XmRString, ""},
    { "flt_missing_margins", "Flt_missing_margins", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, flt_missing_margins), XmRString, ""},

    { "cant_find_lf", "Cant_find_lf", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cant_find_lf), XmRString, ""},

    { "read_only_marker", "Read_only_marker", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, read_only_marker), XmRString, ""},

    { "help_err_fopen", "Help_err_fopen", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_err_fopen), XmRString, ""},
    { "help_err_finc", "Help_err_finc", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_err_finc), XmRString, ""},
    { "help_no_info", "Help_no_info", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, help_no_info), XmRString, ""},

    { "load_font_err", "Font_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, load_font_err), XmRString, ""},

    { "open_tmp_err", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, open_tmp_err), XmRString, ""},
    { "close_tmp_err", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, close_tmp_err), XmRString, ""},
    { "backup_file_err", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, backup_file_err), XmRString, ""},
    { "file_close_errr", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, file_close_err), XmRString, ""},
    { "file_move_err", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, file_move_err), XmRString, ""},
    { "open_tmp_print_err", "File_ERROR", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, open_tmp_print_err), XmRString, ""},


    { "initial_geometry", "Initial_geometry", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, initial_geometry), XmRString, ""},
    { "first_window_iconic", "First_window_iconic", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, first_window_iconic), XmRString, "False"},
    { "changeHint", "ChangeHint", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, changeHint), XmRString, ""},
    { "wrong_syntax", "Syntax", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, wrong_syntax), XmRString, ""},
    { "syntax", "Syntax", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, syntax), XmRString, ""},

    { "oldAppDefs", "OldAppDefs", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, oldAppDefs), XmRString, 
       "Warning: (very) old application defaults file loaded!!!\n"},

    { "noAppDefs", "NoAppDefs", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, noAppDefs), XmRString, 
       "Warning: application defaults file not found or an incompatible one used!!!\n"},

    { "fallAppDefs", "FallAppDefs", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fallAppDefs), XmRString, 
       "Warning: fallback resources used!\n"},

    { "tabSize", "TabSize", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, tabSize), XmRString, "8"},	/* SHOULD be 8 */


    { "defaultWrap", "Wrap", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, defaultWrap), XmRString, "False"},

    { "autoAddEOFnewline", "Default", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, autoAddEOFnewline), XmRString, "True"},

    { "selectDelimitedText", "Default", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, selectDelimitedText), XmRString, "True"},

    { "defaultStatus", "Default", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, defaultStatus), XmRString, "True"},
    { "defaultAutoIndent", "Default", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, defaultAutoIndent), XmRString, "True"},
    { "useOldColorSetup", "UseOldColorSetup", XmRBoolean, sizeof(Boolean),
      XtOffset(as_lstr_ptr, useOldColorSetup), XmRString, "False"},

    { "readOnlyBackground", XmCBackground, XmRPixel, sizeof(Pixel),
      XtOffset(as_lstr_ptr, readOnlyBackground), XmRString, "grey77"},
    { "startLine", "startLine", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, startLine), XmRString, "0"},

    { "appDefaultsVersion", "AppDefaultsVersion", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, appDefaultsVersion), XmRString, "0"},

    { "progressInterval", "ProgressDelay", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, progressInterval), XmRString, "500"},
    { "progressInitialDelay", "ProgressDelay", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, progressInitialDelay), XmRString, "1000"},
    { "progressShortInitialDelay", "ProgressDelay", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, progressShortInitialDelay), XmRString, "250"},

    { "sortCmd", "SortCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, sortCmd), XmRString, ""},
    { "spellCmd", "SpellCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, spellCmd), XmRString, ""},

#if defined(DONT_HAVE_EXPAND) || defined(__sgi)
    /* use pr -t -eN instead of non-existing expand (tabstop would be added in run time)	*/
    /* we define defaults here to avoid platform specific app-defaults file */
    { "expandCmd", "ExpandCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, expandCmd), XmRString, "pr -t -e%d"},
    { "unexpandCmd", "UnexpandCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, unexpandCmd), XmRString, "pr -t -i%d"},
#else
    { "expandCmd", "ExpandCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, expandCmd), XmRString, "expand -%d"},
    { "unexpandCmd", "UnexpandCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, unexpandCmd), XmRString, "unexpand "},	/* Note -%d doesn't exist for unexpand */
#endif /* DONT_HAVE_EXPAND */

    { "fmtCmd", "FmtCmd", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, fmtCmd), XmRString, "fmt -%d"},


    { "sortExt", "SortExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, sortExt), XmRString, ""},
    { "spellExt", "SpellExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, spellExt), XmRString, ""},
    { "expandExt", "ExpandExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, expandExt), XmRString, ""},
    { "unexpandExt", "UnexpandExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, unexpandExt), XmRString, ""},

    { "allFormatExt", "AllFormatExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, allFormatExt), XmRString, ""},

    { "filterNum", "FilterNum", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, filterNum), XmRString, "0"},
    { "filter0", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter0), XmRString, ""},
    { "filter1", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter1), XmRString, ""},
    { "filter2", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter2), XmRString, ""},
    { "filter3", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter3), XmRString, ""},
    { "filter4", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter4), XmRString, ""},
    { "filter5", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter5), XmRString, ""},
    { "filter6", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter6), XmRString, ""},
    { "filter7", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter7), XmRString, ""},
    { "filter8", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter8), XmRString, ""},
    { "filter9", "Filter", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, filter9), XmRString, ""},

    { "filterExt0", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt0), XmRString, ""},
    { "filterExt1", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt1), XmRString, ""},
    { "filterExt2", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt2), XmRString, ""},
    { "filterExt3", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt3), XmRString, ""},
    { "filterExt4", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt4), XmRString, ""},
    { "filterExt5", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt5), XmRString, ""},
    { "filterExt6", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt6), XmRString, ""},
    { "filterExt7", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt7), XmRString, ""},
    { "filterExt8", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt8), XmRString, ""},
    { "filterExt9", "FilterExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, filterExt9), XmRString, ""},

    { "cmdNum", "CmdNum", XmRInt, sizeof(int),
      XtOffset(as_lstr_ptr, cmdNum), XmRString, "0"},
    { "cmdDef0", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef0), XmRString, ""},
    { "cmdDef1", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef1), XmRString, ""},
    { "cmdDef2", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef2), XmRString, ""},
    { "cmdDef3", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef3), XmRString, ""},
    { "cmdDef4", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef4), XmRString, ""},
    { "cmdDef5", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef5), XmRString, ""},
    { "cmdDef6", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef6), XmRString, ""},
    { "cmdDef7", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef7), XmRString, ""},
    { "cmdDef8", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef8), XmRString, ""},
    { "cmdDef9", "CmdDef", XmRString, sizeof(String),
      XtOffset(as_lstr_ptr, cmdDef9), XmRString, ""},

    { "cmdExt0", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt0), XmRString, ""},
    { "cmdExt1", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt1), XmRString, ""},
    { "cmdExt2", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt2), XmRString, ""},
    { "cmdExt3", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt3), XmRString, ""},
    { "cmdExt4", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt4), XmRString, ""},
    { "cmdExt5", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt5), XmRString, ""},
    { "cmdExt6", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt6), XmRString, ""},
    { "cmdExt7", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt7), XmRString, ""},
    { "cmdExt8", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt8), XmRString, ""},
    { "cmdExt9", "CmdExt", XmRXmStringTable, sizeof(XmStringTable),
      XtOffset(as_lstr_ptr, cmdExt9), XmRString, ""},

    };

/* extra command line options */
static XrmOptionDescRec cline_options[] = {
  {"-fn",     "*fontList",            XrmoptionSepArg, NULL},
  {"-fnt",    "*XmText*fontList",     XrmoptionSepArg, NULL},
  /* up to 1.26 {"-fnm",     "*menu_bar*fontList",    XrmoptionSepArg, NULL}, **/
  {"-fnm",    "*menuBar*fontList",    XrmoptionSepArg, NULL},
  {"-iconic", "*first_window_iconic", XrmoptionNoArg,  "True"},
  {"-i",      "*first_window_iconic", XrmoptionNoArg,  "True"},
  {"-geometry", "*initial_geometry",        XrmoptionSepArg, NULL},
  {"-geom", "*initial_geometry",        XrmoptionSepArg, NULL},
  {"-helpdir", "*helpDir",              XrmoptionSepArg, NULL},
  {"-tab", "*tabSize",          	XrmoptionSepArg, NULL},
  {"-wrap", 	"*defaultWrap", 	XrmoptionNoArg,  "True"},
  {"+wrap", 	"*defaultWrap", 	XrmoptionNoArg,  "False"},
  {"-status",	"*defaultStatus", 	XrmoptionNoArg,  "True"},
  {"+status",	"*defaultStatus", 	XrmoptionNoArg,  "False"},
  {"-ai",    	"*defaultAutoIndent", 	XrmoptionNoArg,  "True"},
  {"+ai",       "*defaultAutoIndent", 	XrmoptionNoArg,  "False"},
  {"-emacs",  	"*emacsMode", 		XrmoptionNoArg,  "True"},
  {"-em",  	"*emacsMode", 		XrmoptionNoArg,  "True"},
  {"-v",  	"*open_dialog*open_view_only.set", XrmoptionNoArg,  "True"},
  {"+v",  	"*open_dialog*open_view_only.set", XrmoptionNoArg,  "False"},
  {"+", 	"*startLine",    	XrmoptionStickyArg, NULL},
};

#endif  /* do NOT add any stuff after this line */


