/*----------------------------------------------------------------------------
--
--  Module:           msgXdiary
--
--  Project:          Xdiary
--  System:           msg - Message catalogue
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Message catalogue for domain Xdiary.
--
--  Filename:         msgXdiary.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-03-12
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: msgXdiary.h, Version: 1.1, Date: 95/02/18 15:51:48 */


/* Only include this file once. */
#ifndef define_msgXdiary_h
#  define define_msgXdiary_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Message catalogue interface. */
#define MXDI_OK_BUTTON                                0
#define MXDI_CANCEL_BUTTON                            1
#define MXDI_MOVE_COPY_APPOINTMENT                    2
#define MXDI_DATE_SELECT_TITLE                        3
#define MXDI_MSG_WIN_TITLE                            4
#define MXDI_SEL_HIDDEN_MENU                          5
#define MXDI_SEL_HIDDEN_MENU_ACC                      6
#define MXDI_INVALID_DATE                             7
#define MXDI_MOVE_COPY_TITLE                          8
#define MXDI_APPLY_BUTTON                             9
#define MXDI_TODO_TITLE                              10
#define MXDI_INVALID_DATE_RANGE                      11
#define MXDI_MSG_WIN_LIST_LABEL                      12
#define MXDI_MORE_ACCESS                             13
#define MXDI_SUMMARY_LABEL                           14
#define MXDI_BETWEEN_DATES                           15
#define MXDI_ENTRY_TITLE                             16
#define MXDI_FILE_MENU                               17
#define MXDI_FILE_MENU_ACC                           18
#define MXDI_HELP_MENU                               19
#define MXDI_HELP_MENU_ACC                           20
#define MXDI_EXIT_MENU                               21
#define MXDI_EXIT_MENU_ACC                           22
#define MXDI_CLEAR_BUTTON                            23
#define MXDI_EXPLAIN_BUTTON                          24
#define MXDI_INVALID_ENTRY_TIME                      25
#define MXDI_INVALID_MINUTE_TIME                     26
#define MXDI_ALARM_VIEW                              27
#define MXDI_NO_VALID_USERNAME                       28
#define MXDI_NO_VALID_GROUPNAME                      29
#define MXDI_NO_ACCESS_FLAGS                         30
#define MXDI_NO_VALID_DAYS                           31
#define MXDI_SIMPLE_NOTE_FLAG                        32
#define MXDI_ENTRY_START_LABEL                       33
#define MXDI_ENTRY_DURATION_LABEL                    34
#define MXDI_ALARM_BUTTON                            35
#define MXDI_TYPE_NOTE                               36
#define MXDI_PRIVATE_BUTTON                          37
#define MXDI_IMPORTANT_BUTTON                        38
#define MXDI_EDIT_MENU                               39
#define MXDI_VALID_DAYS_LABEL                        40
#define MXDI_EDIT_MENU_ACC                           41
#define MXDI_COPY_MENU                               42
#define MXDI_COPY_MENU_ACC                           43
#define MXDI_NO_PRINTER_GIVEN                        44
#define MXDI_PRINTER_NAME                            45
#define MXDI_PRINTER_TYPE                            46
#define MXDI_ALARM_PAR_TITLE                         47
#define MXDI_OPT_MENU                                48
#define MXDI_OPT_MENU_ACC                            49
#define MXDI_PREF_ACTION                             50
#define MXDI_STAND_ACTION                            51
#define MXDI_PREF_TITLE                              52
#define MXDI_ALARM_LABEL                             53
#define MXDI_BEFORE_LABEL                            54
#define MXDI_AFTER_LABEL                             55
#define MXDI_TUNE_LABEL                              56
#define MXDI_MSG_TO_LABEL                            57
#define MXDI_ALARM_ACTION                            58
#define MXDI_TUNE_ID_LABEL                           59
#define MXDI_TUNE_TEST                               60
#define MXDI_ENTRY_COLOR_LABEL                       61
#define MXDI_COLOR_SAMPLE_LABEL                      62
#define MXDI_PICK_TITLE                              63
#define MXDI_PRINT_MENU                              64
#define MXDI_PRINT_MENU_ACC                          65
#define MXDI_PICK_FILE_LABEL                         66
#define MXDI_PICK_DIARY_LABEL                        67
#define MXDI_SUM_MENU                                68
#define MXDI_SUM_MENU_ACC                            69
#define MXDI_SELECT_ITEM                             70
#define MXDI_TYPE_STICKY_NOTE                        71
#define MXDI_DELETE_LABEL                            72
#define MXDI_ACL_POSITION                            73
#define MXDI_YES_LABEL                               74
#define MXDI_CUSTOM_MENU                             75
#define MXDI_CUSTOM_MENU_ACC                         76
#define MXDI_APP_EDITOR_MENU                         77
#define MXDI_APP_EDITOR_MENU_ACC                     78
#define MXDI_MONTH_LABEL                             79
#define MXDI_YEAR_LABEL                              80
#define MXDI_DATABASE_LABEL                          81
#define MXDI_TYPE_APPOINT                            82
#define MXDI_OPEN_VIEW_MENU                          83
#define MXDI_OPEN_VIEW_MENU_ACC                      84
#define MXDI_ENTRY_HAS_NO_TEXT                       85
#define MXDI_APPOINTMENT_LABEL                       86
#define MXDI_DAY_LABEL                               87
#define MXDI_PRINTING_TITLE                          88
#define MXDI_MUST_SEE_STAND_WINDOW                   89
#define MXDI_NO_LABEL                                90
#define MXDI_FORMAT_LABEL                            91
#define MXDI_PRINT_FORMATS                           92
#define MXDI_PRINT_PAPER_FORMAT                      93
#define MXDI_OUTPUT_LABEL                            94
#define MXDI_PRINT_ON                                95
#define MXDI_HOW_TO_PLAN_LABEL                       96
#define MXDI_NEW_CALENDAR_LABEL                      97
#define MXDI_PRINT_FILE_OUTPUT_OK                    98
#define MXDI_INFORMATION_LABEL                       99
#define MXDI_PRINT_OUTPUT_OK                        100
#define MXDI_STAND_DAYS_VALID_LABEL                 101
#define MXDI_DELETE_ENTRY_TITLE                     102
#define MXDI_DELETE_ENTRY_CONF                      103
#define MXDI_WORKING_TITLE                          104
#define MXDI_WORKING_MESSAGE                        105
#define MXDI_SELECT_ALL_LABEL                       106
#define MXDI_CLEAR_ALL_LABEL                        107
#define MXDI_DONE_BUTTON                            108
#define MXDI_ALL_LABEL                              109
#define MXDI_SELECT_CALENDAR                        110
#define MXDI_STANDING_LABEL                         111
#define MXDI_NOTES_LABEL                            112
#define MXDI_NOTES_DONE_LABEL                       113
#define MXDI_NOTES_NOT_DONE_LABEL                   114
#define MXDI_SEARCH_STRING_LABEL                    115
#define MXDI_PR_FILE_OPEN_ERR                       116
#define MXDI_INTERVAL_LABEL                         117
#define MXDI_COPY_BUTTON                            118
#define MXDI_MOVE_BUTTON                            119
#define MXDI_ENTRY_FLAGS_PARAM                      120
#define MXDI_ENTRY_FLAGS_HELP                       121
#define MXDI_DUPL_TO_MANY_DAYS                      122
#define MXDI_PRINT_SHOW_TO_MANY_DAYS                123
#define MXDI_SAVE_IN_DB_LABEL                       124
#define MXDI_RECIPIENT_MSG_TITLE                    125
#define MXDI_SEND_BUTTON                            126
#define MXDI_TO_USER_LABEL                          127
#define MXDI_ALARM_TITLE                            128
#define MXDI_FLAGS_DISPLAY_MENU                     129
#define MXDI_FLAGS_DISPLAY_MENU_ACC                 130
#define MXDI_DUPLICATE_TITLE                        131
#define MXDI_FROM_LABEL                             132
#define MXDI_TO_LABEL                               133
#define MXDI_DUPLICATE_ENTRY_CONF                   134
#define MXDI_COMPOSE_MESSAGE_BUTTON                 135
#define MXDI_DUPLICATE_APPOINTMENT                  136
#define MXDI_PRIM_SEL_MENU                          137
#define MXDI_SEC_SEL_MENU                           138
#define MXDI_CLIP_SEL_MENU                          139
#define MXDI_XBUF_SEL_MENU                          140
#define MXDI_CUT_SEL_MENU                           141
#define MXDI_COPY_SEL_MENU                          142
#define MXDI_PASTE_SEL_MENU                         143
#define MXDI_LINE_LABEL                             144
#define MXDI_LINE_ENTRY_LABEL                       145
#define MXDI_LINE_ALARM_LABEL                       146
#define MXDI_MSG_INFO_LABEL                         147
#define MXDI_MSG_DB_LIST_LABEL                      148
#define MXDI_MSG_GROUP_LIST_LABEL                   149
#define MXDI_MSG_CAL_MAIL_ADDR_LABEL                150
#define MXDI_CANNOT_CREATE_DB_DIR                   151
#define MXDI_MSG_NEXT_INFO_LABEL                    152
#define MXDI_CANNOT_CREATE_DB                       153
#define MXDI_TO_GROUP_LABEL                         154
#define MXDI_WEEK_NUMBER_LABEL                      155
#define MXDI_WEEKDAYS_MO_FIRST                      156
#define MXDI_CUSTOM_TITLE                           157
#define MXDI_DB_LOCATION_LABEL                      158
#define MXDI_DB_NAME_LABEL                          159
#define MXDI_DB_DIR_LABEL                           160
#define MXDI_MSG_ADD_RECIPIENT                      161
#define MXDI_CUST_GROUP_TITLE                       162
#define MXDI_CUST_CAL_TITLE                         163
#define MXDI_CUST_ARCHIVE_TITLE                     164
#define MXDI_SEARCH_TAG_LABEL                       165
#define MXDI_CUST_CONFIRM_CANCEL                    166
#define MXDI_COMPOSE_MSG_TITLE                      167
#define MXDI_EXPLAIN_INCLUDE_DB                     168
#define MXDI_ADD_ITEM                               169
#define MXDI_ADD_CHANGE_ITEM                        170
#define MXDI_DELETE_ITEM                            171
#define MXDI_ONLY_MAIL_LABEL                        172
#define MXDI_OPEN_VIEW_TITLE                        173
#define MXDI_MAIL_IF_FAIL_LABEL                     174
#define MXDI_STARTING_PROCESS_MSG                   175
#define MXDI_CLOSE_MENU                             176
#define MXDI_CLOSE_MENU_ACC                         177
#define MXDI_CUST_GENERAL_LABEL                     178
#define MXDI_NO_ENTRY                               179
#define MXDI_REMARK_LABEL                           180
#define MXDI_MISSING_NAME_OR_LOC                    181
#define MXDI_DATE_LABEL                             182
#define MXDI_NO_CAL_NO_LOC                          183
#define MXDI_PICK_CALENDAR                          184
#define MXDI_ALARM_PRC_TITLE                        185
#define MXDI_CLOSE_BUTTON                           186
#define MXDI_ALARM_PRC_MENU                         187
#define MXDI_ALARM_PRC_MENU_ACC                     188
#define MXDI_TEXT_LABEL                             189
#define MXDI_CANNOT_OPEN_CMD_PIPE                   190
#define MXDI_HELP_BUTTON                            191
#define MXDI_PROCESS_CANNOT_FORK                    192
#define MXDI_PROCESS_NO_FILE                        193
#define MXDI_ALARM_CONFIRM                          194
#define MXDI_ALARM_NO_MORE                          195
#define MXDI_ALARM_SNOOZE                           196
#define MXDI_ALARM_DELETE                           197
#define MXDI_TO_RECIPIENT_LABEL                     198
#define MXDI_APPOINTMENTS_PANE                      199
#define MXDI_CANNOT_SAVE_CUSTOM                     200
#define MXDI_ERROR_MESSAGE                          201
#define MXDI_ENTRY_TAG_LABEL                        202
#define MXDI_MAKE_NOTE_LABEL                        203
#define MXDI_SNOOZE_TITLE                           204
#define MXDI_SNOOZE_LABEL                           205
#define MXDI_MINUTES_LABEL                          206
#define MXDI_PRINT_BUTTON                           207
#define MXDI_MORE_ARCHIVE                           208
#define MXDI_START_DV_DAYS                          209
#define MXDI_CUSTOM_DIR_NOT_EXIST                   210
#define MXDI_ERROR_MESSAGE_LABEL                    211
#define MXDI_ARCHIVE_TITLE                          212
#define MXDI_ARCH_LOCATION_LABEL                    213
#define MXDI_ARCH_NAME_LABEL                        214
#define MXDI_ARCH_FILE_LABEL                        215
#define MXDI_ARCH_WRONG_ENTRY                       216
#define MXDI_ARCH_ALREADY_ARCHIVED                  217
#define MXDI_ARCH_CANNOT_OPEN_FILE                  218
#define MXDI_ARCHIVE_ENTRY_LABEL                    219
#define MXDI_REDISPLAY_MENU                         220
#define MXDI_REDISPLAY_MENU_ACC                     221
#define MXDI_CUST_DATA_SAVED                        222
#define MXDI_INFO_MESSAGE_LABEL                     223
#define MXDI_CANNOT_START_ALARM_PROCESS             224
#define MXDI_NO_CMD_TO_ALARM_PROC                   225
#define MXDI_UNIX_ACCESS_TITLE                      226
#define MXDI_MAKE_APPOINTMENT_LABEL                 227
#define MXDI_NO_RECIPIENTS                          228
#define MXDI_SAVE_BUTTON                            229
#define MXDI_USER_LABEL                             230
#define MXDI_GROUP_LABEL                            231
#define MXDI_READ_LABEL                             232
#define MXDI_WRITE_LABEL                            233
#define MXDI_NOTE_DONE_MENU                         234
#define MXDI_SUMMARY_LINES                          235
#define MXDI_ENTRY_MAIL_MESSAGE                     236
#define MXDI_CASE_SENSITIVE_LABEL                   237
#define MXDI_SEND_MSG_MENU                          238
#define MXDI_SEND_MSG_MENU_ACC                      239
#define MXDI_RCV_MSG_MENU                           240
#define MXDI_RCV_MSG_MENU_ACC                       241
#define MXDI_MESSAGE_SENT                           242
#define MXDI_MSG_FAIL                               243
#define MXDI_MSG_FAIL_BACK_MAIL                     244
#define MXDI_RECEIVE_MSG_TITLE                      245
#define MXDI_MSG_BOX_LABEL                          246
#define MXDI_MAIL_ADDRESS_LABEL                     247
#define MXDI_ANSWER_BUTTON                          248
#define MXDI_HIDE_IN_LABEL                          249
#define MXDI_QUESTION_MESSAGE_LABEL                 250
#define MXDI_DELETE_MESSAGE_CONF                    251
#define MXDI_GROUP_MEMBERS_LABEL                    252
#define MXDI_READ_MSG_TITLE                         253
#define MXDI_ANSWER_MSG_TITLE                       254
#define MXDI_MESSAGE_PRIV_LABEL                     255
#define MXDI_REDISPLAY_BUTTON                       256
#define MXDI_MESSAGE_GROUPS                         257
#define MXDI_GROUP_NAME_LABEL                       258
#define MXDI_PLAN_MENU                              259
#define MXDI_PLAN_MENU_ACC                          260
#define MXDI_MORE_PARAMETERS                        261
#define MXDI_DAY_VIEW_TAGS_LABEL                    262
#define MXDI_ALARM_TAGS_LABEL                       263
#define MXDI_CUST_CAL_BUTTON                        264
#define MXDI_CUST_GROUP_BUTTON                      265
#define MXDI_CUST_PARAM_BUTTON                      266
#define MXDI_CUST_ARCH_BUTTON                       267
#define MXDI_CUST_ACCESS_BUTTON                     268
#define MXDI_HIDE_IN_CAL_LABEL                      269
#define MXDI_STAND_TITLE                            270
#define MXDI_STAND_VALID_LABEL                      271
#define MXDI_DAYS_LABEL                             272
#define MXDI_WEEKS_LABEL                            273
#define MXDI_MONTHS_LABEL                           274
#define MXDI_YEARS_LABEL                            275
#define MXDI_INT_EVERY_LABEL                        276
#define MXDI_INCLUDE_MENU                           277
#define MXDI_INCLUDE_MENU_ACC                       278
#define MXDI_INCLUDE_DB_TITLE                       279
#define MXDI_INCLUDE_DB_LABEL                       280
#define MXDI_NO_DATABASE                            281
#define MXDI_CUST_HOW_TO_ACTIVATE                   282
#define MXDI_ACL_EDIT                               283
#define MXDI_INCLUDE_TITLE                          284
#define MXDI_INCLUDE_DB                             285
#define MXDI_INCLUDE_IN_THE_DB                      286
#define MXDI_INCLUDE_ACTION_LABEL                   287
#define MXDI_HIDE_IN_DAY_VIEW_LABEL                 288
#define MXDI_INCLUDE_REMOVE_ACTION_LABEL            289
#define MXDI_MORE_INCLUDE                           290
#define MXDI_INCLUDE_HIDE_LABEL                     291
#define MXDI_INCLUDE_NO_HIDE_LABEL                  292
#define MXDI_AFS_ID_LABEL                           293
#define MXDI_AFS_ACCESS_TITLE                       294
#define MXDI_INFORMATION_NOT_SAVED                  295
#define MXDI_ERRMSG_DB_LOCKED                       296
#define MXDI_ERRMSG_CANNOT_OPEN_DB                  297
#define MXDI_ERRMSG_INSERT_ENTRY                    298
#define MXDI_HIDE_IN_SUMMARY_LABEL                  299
#define MXDI_ERRMSG_NO_ACCESS_DB                    300
#define MXDI_ERRMSG_GENERATE_ID                     301
#define MXDI_ERRMSG_DELETE_ENTRY                    302
#define MXDI_HIDE_IN_PRINT_LABEL                    303
#define MXDI_ERRMSG_FETCH_ENTRY                     304
#define MXDI_HIDE_IN_DUMP_LABEL                     305
#define MXDI_ERRMSG_FETCH_NAMED_DB                  306
#define MXDI_APP_PANE_HEIGHT_PARAM                  307
#define MXDI_APP_PANE_HEIGHT_HELP                   308
#define MXDI_CUST_WRONG_VERSION                     309
#define MXDI_ERRMSG_NO_ACCESS_NAMED_DB              310
#define MXDI_ERRMSG_CREATE_DB                       311
#define MXDI_ERRMSG_CREATE_STAND_DB                 312
#define MXDI_ERRMSG_CREATE_PRIV_DB                  313
#define MXDI_ERRMSG_CREATE_ID_FILE                  314
#define MXDI_ERRMSG_EXECUTE_PROCESS                 315
#define MXDI_ERRMSG_REG_EXP                         316
#define MXDI_CUST_UNKNOWN_LINE                      317
#define MXDI_ERRMSG_HOLIDAY_DATE                    318
#define MXDI_ENTRY_PANE_WIDTH_PARAM                 319
#define MXDI_ENTRY_PANE_WIDTH_HELP                  320
#define MXDI_ALARM_ENTRY_DELETE_INFO                321
#define MXDI_ENTRY_IS_SAVED                         322
#define MXDI_SCHED_TITLE                            323
#define MXDI_SCHED_DESCRIPTION                      324
#define MXDI_SCHED_BTW_DATES                        325
#define MXDI_WEEK_LABEL                             326
#define MXDI_FILTER_MENU                            327
#define MXDI_FILTER_MENU_ACC                        328
#define MXDI_PROMPT_REPEAT_PARAM                    329
#define MXDI_PROMPT_REPEAT_HELP                     330
#define MXDI_TODAY_LABEL                            331
#define MXDI_FILTER_INTRO_LABEL                     332
#define MXDI_ENTRIES_INTER_PARAM                    333
#define MXDI_ENTRIES_INTER_HELP                     334
#define MXDI_FILTER_DB_TITLE                        335
#define MXDI_FILTER_PICK_TYPE_LABEL                 336
#define MXDI_START_DV_ON_PARAM                      337
#define MXDI_START_DV_ON_HELP                       338
#define MXDI_NOTIFY_TITLE                           339
#define MXDI_NOTIFY_DESC_LABEL                      340
#define MXDI_REMINDER_TITLE                         341
#define MXDI_REMINDERS_LABEL                        342
#define MXDI_REMINDERS_ACTIVE_LABEL                 343
#define MXDI_REMINDER_WORK_LABEL                    344
#define MXDI_CUST_UNKNOWN_COLOR                     345
#define MXDI_RESET_BUTTON                           346
#define MXDI_REMINDER_ALARM_TITLE                   347
#define MXDI_REMIND_MENU                            348
#define MXDI_REMIND_MENU_ACC                        349
#define MXDI_HELP_CONTEXT                           350
#define MXDI_HELP_CONTEXT_ACC                       351
#define MXDI_HELP_WINDOWS                           352
#define MXDI_HELP_WINDOWS_ACC                       353
#define MXDI_HELP_KEYS                              354
#define MXDI_HELP_KEYS_ACC                          355
#define MXDI_HELP_INDEX                             356
#define MXDI_HELP_INDEX_ACC                         357
#define MXDI_HELP_HELP                              358
#define MXDI_HELP_HELP_ACC                          359
#define MXDI_HELP_VERSION                           360
#define MXDI_HELP_VERSION_ACC                       361
#define MXDI_WHICH_AL_ACTION_LABEL                  362
#define MXDI_LAUNCH_WHEN_LABEL                      363
#define MXDI_ACT_USE_SHELL_LABEL                    364
#define MXDI_ACT_USE_TEXT_LABEL                     365
#define MXDI_SKIP_THIS_WEEK                         366
#define MXDI_SKIP_BUTTON                            367
#define MXDI_SKIP_TITLE                             368
#define MXDI_SKIP_INSTR_LABEL                       369
#define MXDI_SKIP_RESET                             370
#define MXDI_NO_DB_SELECTED                         371
#define MXDI_SETUP_DB_MISSING                       372
#define MXDI_SETUP_CANNOT_READ_DB                   373
#define MXDI_SETUP_TITLE                            374
#define MXDI_MESSAGE_FROM                           375
#define MXDI_TYPE_STAND_APPOINT                     376
#define MXDI_TYPE_STAND_NOTE                        377
#define MXDI_COPY_MOVE_TO                           378
#define MXDI_CANNOT_COPY_MOVE_STAND                 379
#define MXDI_DELETE_MENU                            380
#define MXDI_DELETE_MENU_ACC                        381
#define MXDI_MOVE_MENU                              382
#define MXDI_MOVE_MENU_ACC                          383
#define MXDI_DUPL_MENU                              384
#define MXDI_DUPL_MENU_ACC                          385
#define MXDI_ARCH_MENU                              386
#define MXDI_ARCH_MENU_ACC                          387
#define MXDI_COPY_BUF_MENU                          388
#define MXDI_COPY_BUF_MENU_ACC                      389
#define MXDI_CUT_BUF_MENU                           390
#define MXDI_CUT_BUF_MENU_ACC                       391
#define MXDI_PASTE_BUF_MENU                         392
#define MXDI_PASTE_BUF_MENU_ACC                     393
#define MXDI_CAL_MENU                               394
#define MXDI_CAL_MENU_ACC                           395
#define MXDI_NAV_CAL_TITLE                          396
#define MXDI_CHANGE_DURATION_TO                     397
#define MXDI_CONF_MENU                              398
#define MXDI_CONF_MENU_ACC                          399
#define MXDI_TIME_LAY_MENU                          400
#define MXDI_TIME_LAY_MENU_ACC                      401
#define MXDI_GRID_MENU                              402
#define MXDI_GRID_MENU_ACC                          403
#define MXDI_CTRL_MENU                              404
#define MXDI_CTRL_MENU_ACC                          405
#define MXDI_OPEN_SAME_MENU                         406
#define MXDI_OPEN_SAME_MENU_ACC                     407
#define MXDI_NEW_VIEW_MENU                          408
#define MXDI_NEW_VIEW_MENU_ACC                      409
#define MXDI_INCL_FILE_MENU                         410
#define MXDI_INCL_FILE_MENU_ACC                     411
#define MXDI_DIRECTORY_LABEL                        412
#define MXDI_FILES_LABEL                            413
#define MXDI_FILTER_ACTION_LABEL                    414
#define MXDI_SELECTION_LABEL                        415
#define MXDI_NO_FILE_SELECTED                       416
#define MXDI_CANNOT_READ_FILE                       417
#define MXDI_DISP_DAYS_MENU                         418
#define MXDI_DISP_DAYS_MENU_ACC                     419
#define MXDI_DISP_DAYS_TITLE                        420
#define MXDI_DISP_DAYS_LABEL                        421
#define MXDI_HANDLE_MENU                            422
#define MXDI_HANDLE_MENU_ACC                        423
#define MXDI_INCLUDE_COLORS_LABEL                   424
#define MXDI_ENTRY_IC_TITLE                         425
#define MXDI_MY_EDITOR_ACTION                       426
#define MXDI_UNIX_ACCESS_IC_TITLE                   427
#define MXDI_CUSTOM_IC_TITLE                        428
#define MXDI_REMINDER_IC_TITLE                      429
#define MXDI_SEND_MSG_IC_TITLE                      430
#define MXDI_RECEIVE_MSG_IC_TITLE                   431
#define MXDI_PARAMETERS_LABEL                       432
#define MXDI_DESCRIPTION_LABEL                      433
#define MXDI_VALUE_LABEL                            434
#define MXDI_ON_LABEL                               435
#define MXDI_OFF_LABEL                              436
#define MXDI_DEFAULTS_LABEL                         437
#define MXDI_OVERWRITE_PARAM_CONF                   438
#define MXDI_NOT_VALID_PARAM                        439
#define MXDI_MAIL_ADDR_PARAM                        440
#define MXDI_MAIL_ADDR_HELP                         441
#define MXDI_VIEW_TAGS_PARAM                        442
#define MXDI_VIEW_TAGS_HELP                         443
#define MXDI_ALARM_TAGS_PARAM                       444
#define MXDI_ALARM_TAGS_HELP                        445
#define MXDI_INCL_COLOR_PARAM                       446
#define MXDI_INCL_COLOR_HELP                        447
#define MXDI_DB_ALARM_PARAM                         448
#define MXDI_DB_ALARM_HELP                          449
#define MXDI_DEFAULT_DB_PARAM                       450
#define MXDI_DEFAULT_DB_HELP                        451
#define MXDI_START_ICON_PARAM                       452
#define MXDI_START_ICON_HELP                        453
#define MXDI_START_WINDOW_PARAM                     454
#define MXDI_START_WINDOW_HELP                      455
#define MXDI_NOTIFY_CHANGED_PARAM                   456
#define MXDI_NOTIFY_CHANGED_HELP                    457
#define MXDI_MORE_GENERAL                           458
#define MXDI_CONFIRM_PARAM                          459
#define MXDI_CONFIRM_HELP                           460
#define MXDI_DAY_VIEW_LIST_PARAM                    461
#define MXDI_DAY_VIEW_LIST_HELP                     462
#define MXDI_GIVE_ALARM_PARAM                       463
#define MXDI_GIVE_ALARM_HELP                        464
#define MXDI_MONDAY_DAY1_PARAM                      465
#define MXDI_MONDAY_DAY1_HELP                       466
#define MXDI_DISPLAY_NAV_CAL_PARAM                  467
#define MXDI_DISPLAY_NAV_CAL_HELP                   468
#define MXDI_STANDING_CAL_PARAM                     469
#define MXDI_STANDING_CAL_HELP                      470
#define MXDI_SUMMARY_START_PARAM                    471
#define MXDI_SUMMARY_START_HELP                     472
#define MXDI_US_DATE_PARAM                          473
#define MXDI_US_DATE_HELP                           474
#define MXDI_DAY_VIEW_STARTS_PARAM                  475
#define MXDI_DAY_VIEW_STARTS_HELP                   476
#define MXDI_DAY_VIEW_STOPS_PARAM                   477
#define MXDI_DAY_VIEW_STOPS_HELP                    478
#define MXDI_DAY_VIEW_DAYS_PARAM                    479
#define MXDI_DAY_VIEW_DAYS_HELP                     480
#define MXDI_WEEK_NUMBERS_PARAM                     481
#define MXDI_WEEK_NUMBERS_HELP                      482
#define MXDI_ALARM_LINES_PARAM                      483
#define MXDI_ALARM_LINES_HELP                       484
#define MXDI_ENTRY_LINES_PARAM                      485
#define MXDI_ENTRY_LINES_HELP                       486
#define MXDI_ENTRY_DELTA_PARAM                      487
#define MXDI_ENTRY_DELTA_HELP                       488
#define MXDI_TUNE_PARAM                             489
#define MXDI_TUNE_HELP                              490
#define MXDI_SHEETS_PER_PAGE_LABEL                  491
#define MXDI_SHEETS_PER_PAGE                        492
#define MXDI_DO_REFRESH_PARAM                       493
#define MXDI_DO_REFRESH_HELP                        494
#define MXDI_REFRESH_RATE_PARAM                     495
#define MXDI_REFRESH_RATE_HELP                      496
#define MXDI_NOTE_PANE_HEIGHT_PARAM                 497
#define MXDI_NOTE_PANE_HEIGHT_HELP                  498
#define MXDI_DAY_WIDTH_TITLE                        499
#define MXDI_DAY_WIDTH_LABEL                        500
#define MXDI_DAY_WIDTH_MENU                         501
#define MXDI_DAY_WIDTH_MENU_ACC                     502
#define MXDI_DAY_WIDTH_PARAM                        503
#define MXDI_DAY_WIDTH_HELP                         504
#define MXDI_SUMMARY_LINES_PARAM                    505
#define MXDI_SUMMARY_LINES_HELP                     506
#define MXDI_PRINT_LINES_PARAM                      507
#define MXDI_PRINT_LINES_HELP                       508
#define MXDI_CANNOT_WRITE_TMP_FILE                  509
#define MXDI_CANNOT_READ_TMP_FILE                   510
#define MXDI_HIDE_IN_ALARM_LABEL                    511
#define MXDI_PROCESS_CANNOT_SET_PGROUP              512
#define MXDI_GUESS_LOCATION_BUTTON                  513
#define MXDI_MISSING_CALENDAR_NAME                  514
#define MXDI_CANNOT_LOCATE_CALENDAR                 515
#define MXDI_SEND_AS_MAIL                           516
#define MXDI_ALL_CHANGES_LOST                       517
#define MXDI_DAY_VIEW_DAY_SWITCH_PARAM              518
#define MXDI_DAY_VIEW_DAY_SWITCH_HELP               519
#define MXDI_DAY_VIEW_SWITCH_DAYS                   520
#define MXDI_REREAD_CUST_MENU                       521
#define MXDI_REREAD_CUST_MENU_ACC                   522
#define MXDI_CLOSE_CANCEL_MENU                      523
#define MXDI_CLOSE_CANCEL_MENU_ACC                  524
#define MXDI_CLOSE_SAVE_MENU                        525
#define MXDI_CLOSE_SAVE_MENU_ACC                    526
#define MXDI_SHOW_MENU                              527
#define MXDI_SHOW_MENU_ACC                          528
#define MXDI_APP_SHOW_MENU                          529
#define MXDI_APP_SHOW_MENU_ACC                      530
#define MXDI_STYLE_LABEL                            531
#define MXDI_PLAN_TITLE                             532
#define MXDI_PLAN_ICON_TITLE                        533
#define MXDI_ARCHIVE_FILE_LABEL                     534
#define MXDI_INSTANT_UPDATE_MENU                    535
#define MXDI_INSTANT_UPDATE_MENU_ACC                536
#define MXDI_SCHED_CONFIRM_CLOSE                    537
#define MXDI_WHAT_PRINTERS_LABEL                    538
#define MXDI_YOUR_OWN_PRINTERS_LABEL                539
#define MXDI_TRUE_COLOR_INCL_PARAM                  540
#define MXDI_TRUE_COLOR_INCL_HELP                   541
#define MXDI_TRUE_COLOR_MENU                        542
#define MXDI_TRUE_COLOR_MENU_ACC                    543
#define MXDI_DATE_TODAY_LABEL                       544
#define MXDI_DATE_THIS_WEEK_LABEL                   545
#define MXDI_DATE_THIS_MONTH_LABEL                  546
#define MXDI_DATE_THIS_YEAR_LABEL                   547
#define MXDI_NOT_THIS_WEEK_MENU                     548
#define MXDI_ENTRY_INFO_MENU                        549
#define MXDI_ENTRY_INFO_MENU_ACC                    550
#define MXDI_ENTRY_INFO_TEMPLATE                    551
#define MXDI_DISPLAY_DAY_VIEW                       552
#define MXDI_TIME_OUTSIDE_LIMITS                    553
#define MXDI_FREEZE_ONLY_REPEATED                   554
#define MXDI_FREEZE_TITLE                           555
#define MXDI_FREEZE_INFO_LABEL                      556
#define MXDI_FREEZE_DO_SKIP_WEEK                    557
#define MXDI_FREEZE_MENU                            558
#define MXDI_FREEZE_MENU_ACC                        559
#define MXDI_CAL_MONTH_EXTEND_PARAM                 560
#define MXDI_CAL_MONTH_EXTEND_HELP                  561
#define MXDI_CAL_MONTH_EXTEND_MENU                  562
#define MXDI_CAL_MONTH_EXTEND_MENU_ACC              563
#define MXDI_RELEASE_NOTES_TITLE                    564
#define MXDI_DISPLAY_RELEASE_NOTES                  565
#define MXDI_FILTER_APPOINTMENTS_LABEL              566
#define MXDI_FILTER_NOTES_LABEL                     567
#define MXDI_FILTER_ALARMS_LABEL                    568
#define MXDI_FILTER_IMPORTANT_LABEL                 569
#define MXDI_FILTER_PRIVATE_LABEL                   570
#define MXDI_FILTER_DONE_LABEL                      571
#define MXDI_FILTER_NOT_DONE_LABEL                  572
#define MXDI_FILTER_REPEATED_LABEL                  573
#define MXDI_FILTER_STICKY_LABEL                    574
#define MXDI_FILTER_PICK_SPEC_LABEL                 575
#define MXDI_PICK_A_DAY_LABEL                       576
#define MXDI_ABOUT_TITLE                            577
#define MXDI_DEFAULT_COLORS_LABEL                   578
#define MXDI_PROT_NOT_OWNER_CHANGE_LABEL            579
#define MXDI_PROT_NOT_OWNER_DELETE_LABEL            580
#define MXDI_HIDE_CAL_IN_CAL_PARAM                  581
#define MXDI_HIDE_CAL_IN_CAL_HELP                   582
#define MXDI_CAL_STACKING_ORDER_PARAM               583
#define MXDI_CAL_STACKING_ORDER_HELP                584
#define MXDI_CAL_STACKING_ORDER_LIST                585
#define MXDI_KEEP_ENTRY_IN_BG_LABEL                 586
#define MXDI_KEEP_ENTRY_IN_FG_LABEL                 587
#define MXDI_NOTIFY_INTRO_TEXT                      588
#define MXDI_ABOUT_TEXT                             589
#define MXDI_HELP_ABOUT                             590
#define MXDI_HELP_ABOUT_ACC                         591
#define MXDI_ALARM_NEW_APP_PARAM                    592
#define MXDI_ALARM_NEW_APP_HELP                     593
#define MXDI_REFRESH_BUTTON                         594
#define MXDI_PR_WORKDAYS_PARAM                      595
#define MXDI_PR_WORKDAYS_HELP                       596
#define MXDI_PARAM_PR_ONLY_WORKDAYS_LABEL           597
#define MXDI_FULL_WEEKDAYS_SU_FIRST                 598
#define MXDI_FULL_WEEKDAYS_MO_FIRST                 599
#define MXDI_PARAM_PR_3D_LABEL                      600
#define MXDI_PR_3D_PARAM                            601
#define MXDI_PR_3D_HELP                             602
#define MXDI_CUST_INCL_TO_DEEP                      603
#define MXDI_NO_MOD_INCL_CAL_ERR                    604
#define MXDI_NO_MOD_INCL_GROUP_ERR                  605
#define MXDI_EDIT_BUTTON                            606
#define MXDI_SEL_HIDDEN_TITLE                       607
#define MXDI_SEL_HIDDEN_LABEL                       608
#define MXDI_ADD_CAL_BUTTON                         609
#define MXDI_ERRMSG_DATE_OR_TIME_FORMAT             610
#define MXDI_DATE_ORDER_LABEL                       611
#define MXDI_MDY_LABEL                              612
#define MXDI_DMY_LABEL                              613
#define MXDI_YMD_LABEL                              614
#define MXDI_DATE_SEPARATOR_LABEL                   615
#define MXDI_DAY_LEAD_ZERO_LABEL                    616
#define MXDI_MONTH_LEAD_ZERO_LABEL                  617
#define MXDI_CENTURY_LABEL                          618
#define MXDI_DATE_FORMAT_PARAM                      619
#define MXDI_DATE_FORMAT_HELP                       620
#define MXDI_DATE_HOUR12_LABEL                      621
#define MXDI_DATE_HOUR24_LABEL                      622
#define MXDI_TIME_SEPARATOR_LABEL                   623
#define MXDI_HOUR_LEAD_ZERO_LABEL                   624
#define MXDI_TIME_FORMAT_PARAM                      625
#define MXDI_TIME_FORMAT_HELP                       626
#define MXDI_PAPER_SIZE_PARAM                       627
#define MXDI_PAPER_SIZE_HELP                        628
#define MXDI_PRINT_SIZE_FORMAT                      629
#define MXDI_CHANGE_BUTTON                          630
#define MXDI_HOSTNAME_LABEL                         631
#define MXDI_USERID_LABEL                           632
#define MXDI_PASSWORD_LABEL                         633
#define MXDI_CONNECTION_TYPE_LABEL                  634
#define MXDI_REMOTE_SCRIPT_LABEL                    635
#define MXDI_UPLOAD_BUTTON                          636
#define MXDI_DOWNLOAD_BUTTON                        637
#define MXDI_UPLOAD_MENU                            638
#define MXDI_UPLOAD_MENU_ACC                        639
#define MXDI_DOWNLOAD_MENU                          640
#define MXDI_DOWNLOAD_MENU_ACC                      641
#define MXDI_REMOTE_TITLE                           642
#define MXDI_REMOTE_EXPLAIN_LABEL                   643
#define MXDI_REMOTE_OPERATION_RUNNING_MESSAGE       644
#define MXDI_REMOTE_PWD_EXPLAIN_LABEL               645
#define MXDI_WEEK_1ST_DAY_LABEL                     646
#define MXDI_WEEK_1ST_DAYS                          647
#define MXDI_IS_REMOTE_PARAM                        648
#define MXDI_IS_REMOTE_HELP                         649
#define MXDI_REMOTE_HOST_PARAM                      650
#define MXDI_REMOTE_HOST_HELP                       651
#define MXDI_REMOTE_PWD_PARAM                       652
#define MXDI_REMOTE_PWD_HELP                        653
#define MXDI_REMOTE_TYPE_PARAM                      654
#define MXDI_REMOTE_TYPE_HELP                       655
#define MXDI_REMOTE_USER_PARAM                      656
#define MXDI_REMOTE_USER_HELP                       657
#define MXDI_ENTER_HIDDEN_LABEL                     658
#define MXDI_FOPR_DATE                              659
#define MXDI_FOPR_CALENDAR                          660
#define MXDI_DAY_ABBREV                             661
#define MXDI_WEEK_ABBREV                            662
#define MXDI_MONTH_ABBREV                           663
#define MXDI_YEAR_ABBREV                            664
#define MXDI_SELECT_DATE_LABEL                      665
#define MXDI_TIME_NOW_LABEL                         666
#define MXDI_TIME_NOON_LABEL                        667
#define MXDI_SELECT_TIME_LABEL                      668
#define MXDI_PLUS_ONE_WEEK_LABEL                    669
#define MXDI_PLUS_TWO_WEEKS_LABEL                   670
#define MXDI_PLUS_ONE_MONTH_LABEL                   671
#define MXDI_SELECT_START_DATE_LABEL                672
#define MXDI_SELECT_END_DATE_LABEL                  673
#define MXDI_FOPR_APPS                              674
#define MXDI_FOPR_NOTES                             675
#define MXDI_FOPR_NOTE                              676
#define MXDI_ERRMSG_ALARM_PROCESS_EXIT              677
#define MXDI_SHEETS_PER_PAGE_PARAM                  678
#define MXDI_SHEETS_PER_PAGE_HELP                   679
#define MXDI_IMPORT_BUTTON                          680
#define MXDI_EXPLAIN_IMPORT_DB                      681
#define MXDI_IMPORT_TITLE                           682
#define MXDI_MORE_IMPORT                            683
#define MXDI_EVERY_IN_MONTH_LABEL                   684
#define MXDI_VALID_ON_DAY_IN_MONTH                  685
#define MXDI_VALID_ON_INT_DAYS_LABEL                686
#define MXDI_DAY_IN_MONTH_LABEL                     687
#define MXDI_REPEATED_TYPE_DAY_LABEL                688
#define MXDI_REPEATED_TYPE_INT_LABEL                689
#define MXDI_VALID_EVERY                            690
#define MXDI_ACTION_NO_WORK_LABEL                   691
#define MXDI_ACTION_DO_NO_WORK                      692
#define MXDI_NO_DAYS_IN_WEEK_SEL                    693
#define MXDI_START_DATE_MISSING                     694
#define MXDI_ENTRY_INTERVAL_MISSING                 695
#define MXDI_WORKDAYS_PARAM                         696
#define MXDI_WORKDAYS_HELP                          697


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* The message catalogue. */
extern char  *msgXdiaryTexts[];


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


#endif
