/*----------------------------------------------------------------------------
--
--  Module:           xtmBaseCal
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmBaseCal.c.
--
--  Filename:         xtmBaseCal.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-07-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmBaseCal.h, Version: 1.1, Date: 95/02/18 15:51:56 */


/* Only include this module once. */
#ifndef define_xtmBaseCalendar_h
#  define define_xtmBaseCalendar_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Calendar style. */
typedef enum {
  XTM_BC_STYLE_NOTEBOOK,
  XTM_BC_STYLE_PLAIN
} XTM_BC_CAL_STYLE;

/* Reasons when the action routine is called. */
typedef enum {
  XTM_BC_REASON_DESTROY,
  XTM_BC_REASON_ENTRIES_DEFINED,
  XTM_BC_REASON_DATE_SELECTED,
  XTM_BC_REASON_MSG_SELECTED,
  XTM_BC_REASON_MONTH_DISPLAYED
} XTM_BC_REASON;

/* Handle to use when comminucating with the calendar window. */
typedef  void  *XTM_BC_HANDLE;

/* Callback when the calendar window is cahnged or something selected. */
typedef void ( *XTM_BC_ACTION_CB ) ( XTM_BC_REASON, TIM_TIME_REF,
                                     XmAnyCallbackStruct *, void * );

/* Callback to find entries defined. */
typedef void ( *XTM_BC_HAS_ENTRIES_CB ) ( XTM_BC_REASON, void *,
                                          TIM_TIME_REF, int, Boolean * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmBcDestroy( XTM_BC_HANDLE  cal_handle );

void
  xtmBcDisplayMonth( XTM_BC_HANDLE  cal_handle,
                     TIM_TIME_REF   cal_date );

void
  xtmBcDisplayTime( XTM_BC_HANDLE  cal_handle );

void
  xtmBcEmptyCache();

Widget
  xtmBcGetWidget( XTM_BC_HANDLE  cal_handle );

XTM_BC_HANDLE
  xtmBcInitialize( XTM_GL_BASE_DATA_REF   appl_data_ref,
                   Widget                 parentW,
                   XTM_BC_CAL_STYLE       style,
                   XTM_BC_ACTION_CB       actionCB,
                   XTM_BC_HAS_ENTRIES_CB  hasEntriesCB,
                   void                   *user_data );

void
  xtmBcSignalMessage( XTM_BC_HANDLE  cal_handle,
                      Boolean        has_message );

#endif
