/*----------------------------------------------------------------------------
--
--  Module:           xtmCalendar
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmCalendar.c.
--
--  Filename:         xtmCalendar.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1990-12-18
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCalendar.h, Version: 1.1, Date: 95/02/18 15:51:59 */


/* Only include this module once. */
#ifndef define_xtmCalendar_h
#  define define_xtmCalendar_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_CA_REASON_DATE_SELECT,
  XTM_CA_REASON_DESTROY,
  XTM_CA_REASON_EXIT,
  XTM_CA_REASON_OPEN_VIEW,
  XTM_CA_REASON_NEW_DATE
} XTM_CA_REASON;


/* Handle to use when comminucating with the calendar window. */
typedef  void  *XTM_CA_HANDLE;

/* Callback when the calendar window is cahnged. */
typedef void ( *XTM_CA_ACTION_CB ) ( XTM_CA_REASON, void *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmCaDestroy( XTM_CA_HANDLE  cal_handle );

XTM_CA_HANDLE
  xtmCaInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                toplevel,
                   Boolean               toplevel_form,
                   Boolean               menu_bar,
                   char                  *db_name,
                   XTM_CA_ACTION_CB      actionCB,
                   void                  *user_data );

Widget
  xtmCaMainWindow( XTM_CA_HANDLE  cal_handle );

void
  xtmCaProcessEvents( XTM_CA_HANDLE  cal_handle,
                      XEvent         *event );

Widget
  xtmCaToplevelWindow( XTM_CA_HANDLE  cal_handle );

void
  xtmCaView( XTM_CA_HANDLE  cal_handle,
             TIM_TIME_REF   at_date );

#endif
