/*----------------------------------------------------------------------------
--
--  Module:           xtmDbMisc
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmDbMisc
--
--  Filename:         xtmDbMisc.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-01-08
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmDbMisc.h, Version: 1.1, Date: 95/02/18 15:52:09 */


/* Only include this module once. */
#ifndef define_xtmDbMisc_h
#  define define_xtmDbMisc_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "Standard.h"
#include "LstLinked.h"
#include "TimDate.h"

#include "xtmGlobal.h"
#include "xtmCalDb.h"
#include "xtmDbTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Max search strings. */
#define XTM_DM_MAX_TEXT_SEARCH  50
#define XTM_DM_MAX_TAG_SEARCH   25


/* Flags for filters. */
#define XTM_DM_FLAG_ALL                   (1<<0)
#define XTM_DM_FLAG_APPOINTMENTS          (1<<5)
#define XTM_DM_FLAG_NOTES                 (1<<6)
#define XTM_DM_FLAG_PRIVATE               (1<<10)
#define XTM_DM_FLAG_IMPORTANT             (1<<11)
#define XTM_DM_FLAG_DONE                  (1<<12)
#define XTM_DM_FLAG_NOT_DONE              (1<<13)
#define XTM_DM_FLAG_ALARMS                (1<<14)
#define XTM_DM_FLAG_REPEATED              (1<<15)
#define XTM_DM_FLAG_STICKY                (1<<16)
#define XTM_DM_FLAG_SEARCH_TEXT           (1<<20)
#define XTM_DM_FLAG_SEARCH_TAG            (1<<21)
#define XTM_DM_FLAG_TEXT_CASE_SENS        (1<<22)
#define XTM_DM_FLAG_TAG_CASE_SENS         (1<<23)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Filter record. */
typedef struct {

  /* Search flags. */
  UINT32  flags;

  /* Text string. */
  char  text_string[ XTM_DM_MAX_TEXT_SEARCH + 1 ];

  /* Tag string. */
  char  tag_string[ XTM_DM_MAX_TAG_SEARCH + 1 ];

} XTM_DM_FILTER_REC;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmDmDeleteEntriesList( LST_DESC_TYPE entries );

Boolean
  xtmDmDeleteEntry( Widget                  parentW,
                    XTM_DB_ENTRY_DATABASES  *database,
                    UINT32                  entry_id );

void
  xtmDmEntriesDefined( XTM_GL_BASE_DATA_REF  appl_data_ref,
                       char                  *db_name,
                       TIM_TIME_REF          date,
                       int                   days,
                       Boolean               include_db,
                       Boolean               show_standing,
                       Boolean               entry_defined[] );

Boolean
  xtmDmFetchEntry( Widget                  parentW,
                   XTM_DB_ENTRY_DATABASES  *database,
                   UINT32                  entry_id,
                   XTM_DB_ALL_ENTRY_REF    entry_ref,
                   char                    **entry_text );

XTM_DB_STATUS
  xtmDmFetchEntriesDay( XTM_GL_CUSTOM_DATA_REF  custom_data,
                        XTM_CD_CAL_INFO         *cal_info,
                        TIM_TIME_REF            date,
                        UINT32                  flags,
                        LST_DESC_TYPE           *notes,
                        LST_DESC_TYPE           *appointments );

Boolean
  xtmDmFetchEntry( Widget                  parentW,
                   XTM_DB_ENTRY_DATABASES  *database,
                   UINT32                  entry_id,
                   XTM_DB_ALL_ENTRY_REF    entry_ref,
                   char                    **entry_text );

XTM_DB_STATUS
  xtmDmFetchFilteredEntriesRange( XTM_GL_BASE_DATA_REF  appl_data_ref,
                                  char                  *db_name,
                                  XtAppContext          context,
                                  Widget                parent,
                                  TIM_TIME_REF          starts,
                                  TIM_TIME_REF          ends,
                                  UINT32                flags,
                                  XTM_DM_FILTER_REC     *filter_ref,
                                  LST_DESC_TYPE         *entries );

Boolean
  xtmDmInsertEntry( Widget                  parentW,
                    XTM_DB_ENTRY_DATABASES  *database,
                    UINT32                  entry_id,
                    XTM_DB_ALL_ENTRY_REF    entry_ref,
                    char                    *entry_text );

Boolean
  xtmDmOpenDatabase( XTM_GL_BASE_DATA_REF    appl_data_ref,
                     char                    *db_name,
                     UINT32                  access_mode,
                     XTM_DB_ENTRY_DATABASES  *database_ref );

#endif
