/*----------------------------------------------------------------------------
--
--  Module:           xtmSchedWin
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmSchedWin.c.
--
--  Filename:         xtmSchedWin.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSchedWin.h, Version: 1.1, Date: 95/02/18 15:52:47 */


/* Only include this module once. */
#ifndef define_xtmSchedWin_h
#  define define_xtmSchedWin_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmSchedPriv.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void 
  xtmSwEntryScrolledHorizCB( Widget                     widget,
                             SCHED_REC_REF              sched_ref,
                             XmScrollBarCallbackStruct  *call_data );

void 
  xtmSwEntryScrolledVertCB( Widget                     widget,
                            SCHED_REC_REF              sched_ref,
                            XmScrollBarCallbackStruct  *call_data );

void
  xtmSwSelectEntryCB( Widget               widget,
                      SCHED_REC_REF        sched_ref,
                      XmAnyCallbackStruct  *call_data );

void
  xtmSwSelectScaleValue( SCHED_REC_REF     sched_ref,
                         SCHED_SCALE_TYPE  scale_type );

void
  xtmSwSetSchedule( SCHED_REC_REF  sched_ref,
                    Widget         widget );

void
  xtmSwSetScheduleDates( SCHED_REC_REF  sched_ref,
                         Widget         widget,
                         Boolean        fetch );

void
  xtmSwUnselectEntry( SCHED_REC_REF  sched_ref );

#endif
