/*----------------------------------------------------------------------------
--
--  Module:           msgTopic
--
--  Project:          Xtools
--  System:           msg - Message catalogue
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Message catalogue for domain Topic.
--
--  Filename:         msgTopic.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-12
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: msgTopic.h, Version: 1.1, Date: 95/02/18 15:10:18 */


/* Only include this file once. */
#ifndef define_msgTopic_h
#  define define_msgTopic_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Message catalogue interface. */
#define MINF_CANCEL_BUTTON                0
#define MINF_EXIT_MENU                    1
#define MINF_EXIT_MENU_ACC                2
#define MINF_FILE_MENU                    3
#define MINF_FILE_MENU_ACC                4
#define MINF_GOTO_NEXT_BUTTON             5
#define MINF_GOTO_PREV_BUTTON             6
#define MINF_HELP_TITLE                   7
#define MINF_NAV_MENU                     8
#define MINF_NAV_MENU_ACC                 9
#define MINF_NO_FILE                     10
#define MINF_NO_FILE_TITLE               11
#define MINF_RESULT_LABEL                12
#define MINF_SEARCH_BUTTON               13
#define MINF_SEARCH_FOR_LABEL            14
#define MINF_SEARCH_HEADERS_LABEL        15
#define MINF_SEARCH_CASE_SENS            16
#define MINF_MASTER_BOOK_BUTTON          17
#define MINF_BACK_BUTTON                 18
#define MINF_SEARCH_TEXT_LABEL           19
#define MINF_SEARCH_TITLE                20
#define MINF_SECTION_LABEL               21
#define MINF_TOC_BUTTON                  22
#define MINF_TOP_MENU                    23
#define MINF_TOP_MENU_ACC                24
#define MINF_BOOKS_MENU                  25
#define MINF_BOOKS_MENU_ACC              26
#define MINF_BOOK_TITLE                  27
#define MINF_BOOK_LIST_LABEL             28
#define MINF_OK_BUTTON                   29
#define MINF_SEARCH_NO_MATCH             30
#define MINF_CLOSE_BUTTON                31
#define MINF_DO_PRINT_BUTTON             32
#define MINF_PRINT_TITLE                 33
#define MINF_PRINTER_NAME                34
#define MINF_PRINT_WHAT_LABEL            35
#define MINF_NO_PRINTER_GIVEN            36
#define MINF_INFORMATION_LABEL           37
#define MINF_PRINT_SECTION               38
#define MINF_PRINT_CHAPTER               39
#define MINF_PRINT_BOOK                  40
#define MINF_PRINT_BUTTON                41
#define MINF_OUTPUT_TO_PRINTER           42
#define MINF_OUTPUT_TO_FILE              43
#define MINF_OUTPUT_TO_LABEL             44
#define MINF_RESULT_TO_FILE              45
#define MINF_RESULT_TO_PRINTER           46
#define MINF_CANNOT_CREATE_PRINT_FILE    47
#define MINF_DO_SEARCH_BUTTON            48
#define MINF_TOC_TITLE                   49
#define MINF_TOC_LIST_LABEL              50
#define MINF_APPLY_BUTTON                51
#define MINF_START_PROGRAM               52
#define MINF_SEARCH_IN_BOOKS_LABEL       53


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* The message catalogue. */
extern char  *msgTopicTexts[];


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


#endif
