/*----------------------------------------------------------------------------
--
--  Module:           xitFonts.c
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    X fonts routines.
--
--  Filename:         xitFonts.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitFonts.c, Version: 1.1, Date: 95/02/18 15:10:31";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xitFnGetCharMaxBounds( XmFontList  font_list,
                         char        *use_char_set,
                         Dimension   *width,
                         Dimension   *height )
{

  /* Code. */

  *width  = 0;
  *height = 0;

  {
    Boolean        ok;
    char           *char_set;
    XFontStruct    *font;
    XmFontContext  context;

    ok = XmFontListInitFontContext( &context, font_list );
    if( ! ok )
      return;

    ok = XmFontListGetNextFont( context, &char_set, &font );
    if( ! ok ) {
      XmFontListFreeFontContext( context );
      return;
    }

    /* Now we have our font. */
    *width  = (Dimension) (font -> max_bounds.width);
    *height = (Dimension) (font -> max_bounds.ascent + 
                           font -> max_bounds.descent);

    XmFontListFreeFontContext( context );
    SysFree( char_set );

  } /* block */


  return;

} /* xitFnGetCharMaxBounds */
