/*----------------------------------------------------------------------------
--
--  Module:           xitGetPar
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Search a named parent for this widget.
--
--  Filename:         xitGetPar.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitGetPar.c, Version: 1.1, Date: 95/02/18 15:10:33";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget
  xitGetParentWidget( Widget  child,
                      char    *search_parent )
{

  /* Variables. */
  Widget  currentW;


  /* Code. */

  /* Search the widget hierarchy for the parent. */
  currentW = child;

  while( currentW != NULL ) {
    if( strcmp( search_parent, currentW -> core.name ) == 0 )
      return( currentW );

    currentW = XtParent( currentW );
  } /* while */

  return( NULL );

} /* xitGetParentWidget */
