/*----------------------------------------------------------------------------
--
--  Module:           xitInfoBook
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file to module xitInfoBook.
--
--  Filename:         xitInfoBook.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfoBook.h, Version: 1.1, Date: 95/02/18 15:10:35 */


/* Only include this module once. */
#ifndef define_xitInfoBook_h
#  define define_xitInfoBook_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_IB_REASON_DESTROY,
  XIT_IB_REASON_NEW_BOOK,
  XIT_IB_REASON_POPDOWN
} XIT_IB_REASON;


/* Information about one book. */
typedef struct {
  char  name[ 50 ];
  char  description[ 100 ];
} XIT_IB_BOOK_REC;


/* Callback function. */
typedef void  ( *XIT_IB_ACTION_CB ) ( XIT_IB_REASON, void *, char * );

/* Handle to the book window. */
typedef void  *XIT_IB_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitIbDestroy( XIT_IB_HANDLE  book_handle );

XIT_IB_HANDLE
  xitIbInitialize( Widget            parent,
                   XIT_IB_ACTION_CB  actionCB,
                   void              *user_data );

void 
  xitIbSelectBook( XIT_IB_HANDLE    book_handle,
                   XIT_IB_BOOK_REC  *user_books,
                   int              user_books_no,
                   XIT_IB_BOOK_REC  *system_books,
                   int              system_books_no );

#endif
