/*----------------------------------------------------------------------------
--
--  Module:           xitInfoDia
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Manages an information dialog where Enter and Return are used as 
--    activate keys.
--
--  Filename:         xitInfoDia.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitInfoDia.c, Version: 1.1, Date: 95/02/18 15:10:36";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data );

static void
  removeTimeoutCB( Widget  toplevel_widget );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateInformationDialog( Widget parent, 
                              char   *dialog_name,
                              char   *title,
                              char   *message,
                              void   (*okCB) (),
                              void   *ok_client_data )
{

  /* Variablesf. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     button;
  Widget     w;
  XmString   xstr;


  /* Code. */

  n = 0;
  XtSetArg( args[ n ], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL ); n++;
  XtSetArg( args[ n ], XmNautoUnmanage, False ); n++;
  XtSetArg( args[ n ], XmNnoResize, True ); n++;
  XtSetArg( args[ n ], XmNuserData, (XtPointer) 0 ); n++;

  w = XmCreateInformationDialog( parent, dialog_name, args, n );

  if( strlen( message ) > 0 ) {
    xstr = XmStringCreateLtoR( message, CS );

    n = 0;
    XtSetArg( args[ n ], XmNmessageString, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  if( strlen( title ) > 0 ) {
    xstr = XmStringCreateLtoR( title, CS );

    n = 0;
    XtSetArg( args[ n ], XmNdialogTitle, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  /* Unmanage the cancel and help buttons. */
  button = XmMessageBoxGetChild( w, XmDIALOG_CANCEL_BUTTON );
  XtUnmanageChild( button );

  button = XmMessageBoxGetChild( w, XmDIALOG_HELP_BUTTON );
  XtUnmanageChild( button );

  /* Add callback? */
  if( okCB != NULL ) {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) okCB, (XtPointer) ok_client_data );
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  } else {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  }

  XtManageChild( w );


  return( w );

} /* xitCreateInformationDialog */


/*----------------------------------------------------------------------*/

void
  xitInformationDialogTimeout( Widget widget,
                               int    secs )
{

  /* Variables. */
  Arg           args[ 5 ];
  Cardinal      n;
  XtIntervalId  interval_id;


  /* Code. */

  if( secs <= 0 )
    return;

  interval_id = XtAppAddTimeOut( XtWidgetToApplicationContext( widget ),
                                 secs * 1000,
                                 (XtTimerCallbackProc) removeTimeoutCB,
                                 (XtPointer) widget );

  n = 0;
  XtSetArg( args[ n ], XmNuserData, (XtPointer) interval_id ); n++;
  XtSetValues( widget, args, n );


  return;

} /* xitInformationDialogTimeout */


/*----------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data )
{

  Arg           args[ 5 ];
  Cardinal      n;
  XtIntervalId  interval_id;


  /* Code. */

  /* Timeout to remove? */
  n = 0;
  XtSetArg( args[ n ], XmNuserData, (XtPointer) &interval_id ); n++;
  XtGetValues( toplevel_widget, args, n );

  if( interval_id > 0 )
    XtRemoveTimeOut( interval_id );


  XtDestroyWidget( toplevel_widget );


  return;

} /* removeCB */


/*----------------------------------------------------------------------*/

static void
  removeTimeoutCB( Widget  toplevel_widget )
{

  /* Code. */

  XtDestroyWidget( toplevel_widget );


  return;

} /* removeTimeoutCB */

