/*----------------------------------------------------------------------------
--
--  Module:           xtmCustCals
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustCals.
--
--  Filename:         xtmCustCals.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustCals.h, Version: 1.1, Date: 95/02/18 15:52:03 */


/* Include this module only once. */
#ifndef define_xtmCustCals_h
#  define define_xtmCustCals_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmCalDb.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_CC_REASON_OK,
  XTM_CC_REASON_DESTROY,
  XTM_CC_REASON_POPDOWN
} XTM_CC_REASON;

/* Handle to use when comminucating with the calendar window. */
typedef  void  *XTM_CC_HANDLE;

/* Callback from the calendar window. */
typedef void ( *XTM_CC_ACTION_CB ) ( XTM_CC_REASON, XTM_CD_HANDLE, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void 
  xtmCcCustomCalendars( XTM_CC_HANDLE  cal_handle,
                        XTM_CD_HANDLE  cal_db_handle );

void
  xtmCcDestroy( XTM_CC_HANDLE  cal_handle );

XTM_CC_HANDLE
  xtmCcInitialize( XTM_CU_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_CC_ACTION_CB      actionCB,
                   void                  *user_data );

#endif
