/*----------------------------------------------------------------------------
--
--  Module:           xtmCustom
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustom.
--
--  Filename:         xtmCustom.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustom.h, Version: 1.1, Date: 95/02/18 15:52:06 */


/* Include this file only once. */
#ifndef define_xtmCustom_h
#  define define_xtmCustom_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xitInfo.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Basic data structure for the XDcustom appliaction. */
typedef struct {

  /* Command line flags. */
  Boolean  startup_help;
  Boolean  version_help;

  /* Script (program) for access control. */
  char  *acl_script;

  /* Toplevel widget. */
  Widget  toplevel;

  /* Customize window widget. */
  Widget  customW;

  /* Parameter window. */
  Widget  paramW;

  /* The X application context. */
  XtAppContext  context;

  /* Customization data. */
  XTM_GL_CUSTOM_DATA_REF  custom_data;

  /* Calendar customization window. */
  void  *cal_handle;

  /* Group customization window. */
  void  *group_handle;

  /* Info reference. */
  XIT_IN_HANDLE  info_handle;

} XTM_CU_BASE_DATA, *XTM_CU_BASE_DATA_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Default translations */
extern XtTranslations  xtm_cu_tab_group_trans;
extern XtTranslations  xtm_cu_newline_trans;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/


#endif
