/*----------------------------------------------------------------------------
--
--  Module:           xtmEditAclUx
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmEditAclUx.
--
--  Filename:         xtmEditAclUx.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-30
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditAclUx.h, Version: 1.1, Date: 95/02/18 15:52:14 */


/* Include this file only once. */
#ifndef define_xtmEditAclUnix_h
#  define define_xtmEditAclUnix_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xitInfo.h"
#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_AU_REASON_APPLY,
  XTM_AU_REASON_CHANGED,
  XTM_AU_REASON_DESTROY,
  XTM_AU_REASON_OK
} XTM_AU_REASON;

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_AU_HANDLE;

/* Callback. */
typedef void ( *XTM_AU_ACTION_CB ) (XTM_AU_REASON, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmAuDestroy( XTM_AU_HANDLE  acl_handle );

void
  xtmAuEditAcl( XTM_AU_HANDLE  acl_handle,
                char           *cal_name,
                char           *cal_location );

XTM_AU_HANDLE
  xtmAuInitialize( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                   XIT_IN_HANDLE           info_handle,
                   Widget                  parent,
                   XTM_AU_ACTION_CB        actionCB,
                   void                    *user_data );

#endif
