/*----------------------------------------------------------------------------
--
--  Module:           xtmViewDb
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmViewDb.
--
--  Filename:         xtmViewDb.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmViewDb.h, Version: 1.1, Date: 95/02/18 15:52:56 */


/* Include this file only once. */
#ifndef define_xtmViewDb_h
#  define define_xtmViewDb_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Handle to use when comminucating with the view db. */
typedef  void  *XTM_VD_HANDLE;



/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Boolean
  xtmVdAddCalendar( XTM_VD_HANDLE  view_handle,
                    char           *view_name,
                    char           *cal_name );
Boolean
  xtmVdAddView( XTM_VD_HANDLE  view_handle,
                char           *name );
Boolean
  xtmVdAddCalFlags( XTM_VD_HANDLE  view_handle,
                    char           *view_name,
                    char           *cal_name,
                    UINT32         flags );
Boolean
  xtmVdAddViewBgColor( XTM_VD_HANDLE  view_handle,
                       char           *name,
                       int            color );

Boolean
  xtmVdAddViewFgColor( XTM_VD_HANDLE  view_handle,
                       char           *name,
                       int            color );

Boolean
  xtmVdAddViewImpColor( XTM_VD_HANDLE  view_handle,
                        char           *name,
                        int            color );

Boolean
  xtmVdAddViewRoColor( XTM_VD_HANDLE  view_handle,
                       char           *name,
                       int            color );

Boolean
  xtmVdAddViewFlags( XTM_VD_HANDLE  view_handle,
                     char           *name,
                     UINT32         flags );

Boolean
  xtmVdCreateShadowView( XTM_VD_HANDLE  view_handle,
                         char           *name,
                         char           *shadow_name );

Boolean
  xtmVdDeleteCalendar( XTM_VD_HANDLE  view_handle,
                       char           *view_name,
                       char           *cal_name );

Boolean
  xtmVdDeleteView( XTM_VD_HANDLE  view_handle,
                   char           *name );

Boolean
  xtmVdFetchCalFlags( XTM_VD_HANDLE  view_handle,
                      char           *view_name,
                      char           *cal_name,
                      UINT32         *flags );

Boolean
  xtmVdFetchCalNames( XTM_VD_HANDLE  view_handle,
                      char           *view_name,
                      char           **cal_names );

Boolean
  xtmVdFetchViewBgColor( XTM_VD_HANDLE  view_handle,
                         char           *name,
                         int            *color );

Boolean
  xtmVdFetchViewFgColor( XTM_VD_HANDLE  view_handle,
                         char           *name,
                         int            *color );

Boolean
  xtmVdFetchViewImpColor( XTM_VD_HANDLE  view_handle,
                          char           *name,
                          int            *color );

Boolean
  xtmVdFetchViewRoColor( XTM_VD_HANDLE  view_handle,
                         char           *name,
                         int            *color );

Boolean
  xtmVdFetchViewFlags( XTM_VD_HANDLE  view_handle,
                       char           *name,
                       UINT32         *flags );

Boolean
  xtmVdFetchViewNames( XTM_VD_HANDLE  view_handle,
                       char           **view_names );

void
  xtmVdFree( XTM_VD_HANDLE  view_handle );

Boolean
  xtmVdFreeShadowView( XTM_VD_HANDLE  view_handle,
                       char           *name );

XTM_VD_HANDLE
  xtmVdInitialize();

#endif
