/*----------------------------------------------------------------------------
--
--  Module:           DirScan
--
--  Project:          Tools - General C objects.
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This module provides a way to scan a directory tree.
--
--  Filename:         DirScan.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-01-12
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: DirScan.h, Version: 1.1, Date: 95/02/18 14:32:27 */


/* Only include once. */
#ifndef define_DirScan_h
#  define define_DirScan_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <sys/stat.h>

#include "System.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Directory scan options. */
#define DIR_SCAN_FOLLOW_SOFT_LINKS     (1<<0)
#define DIR_SCAN_DESCEND_IN_MOUNTED    (1<<1)
#define DIR_SCAN_DESCEND_IN_SUBDIRS    (1<<2)

#define DIR_SCAN_CALL_FOR_FILES        (1<<10)
#define DIR_SCAN_CALL_FOR_SUBDIRS      (1<<11)
#define DIR_SCAN_CALL_FOR_SOFT_LINKS   (1<<12)
#define DIR_SCAN_CALL_FOR_MOUNTED      (1<<13)
#define DIR_SCAN_CALL_FOR_SOCKETS      (1<<14)
#define DIR_SCAN_CALL_FOR_PIPES        (1<<15)
#define DIR_SCAN_CALL_FOR_DRIVERS      (1<<16)

#define DIR_SCAN_ABORT                 (1<<0)
#define DIR_SCAN_DO_NOT_DESCEND        (1<<1)


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Information passed to the caller. */
typedef struct {
  char         *path;
  char         *name;
  struct stat  *file_info;
} DIR_SCAN_INFO, *DIR_SCAN_INFO_REF;


/* Reasons when the action routine is called. */
typedef enum {
  DIR_SCAN_REASON_FILE_INFO,
  DIR_SCAN_REASON_ERR_CHDIR
} DIR_SCAN_REASON;


/* Handle to use when comminucating with directory scan. */
typedef  void  *DIR_SCAN_HANDLE;

/* Callback from the directory scan. */
typedef UINT32 ( *DIR_SCAN_ACTION_CB ) ( DIR_SCAN_REASON, 
                                         DIR_SCAN_INFO_REF, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  DirScanDestroy( DIR_SCAN_HANDLE  dir_scan_handle );

DIR_SCAN_HANDLE
  DirScanInitialize( DIR_SCAN_ACTION_CB  actionCB,
                     void                *user_data );

int
  DirScanTraverseTree( DIR_SCAN_HANDLE  dir_scan_handle,
                       char             *top_directory,
                       UINT32           flags );

#endif 
