/*----------------------------------------------------------------------------
--
--  Module:           SigHandler
--
--  Project:          Tools - General C objects.
--  System:           Sig - Signal handling riutines.
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module SigHandler.
--
--  Filename:         SigHandler.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: SigHandler.h, Version: 1.1, Date: 95/02/18 14:32:30 */


/* Include this file only once. */
#ifndef define_SigHandler_h
#  define define_SigHandler_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "System.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback when calling a registered callback. */
typedef void ( *SIG_SIGNAL_CB ) ( int, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  SigInitialize();

UINT32
  SigRegister( int            signal,
               int            pid,
               SIG_SIGNAL_CB  signalCB,
               void           *user_data );

void
  SigRemove( UINT32  id );


#endif
