/*----------------------------------------------------------------------------
--
--  Module:           XmUbMonthDisplay
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the private header file for the widget.
--
--  Filename:         XmUbMonthDP.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-26
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbMonthDP.h, Version: 1.1, Date: 95/02/18 15:10:09 */

#ifndef _XmUbMonthDP_h
#define _XmUbMonthDP_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/XmP.h>

#if XmVersion > 1001
#include "Xm/ManagerP.h"
#endif

#include "XmUbMonthD.h"

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Indices for widgets in the internal children array. */

#define NO_INTERNAL_CHILDREN  ( XmUbMD_LAST_CHILD + 1 )

/* With a maximum of bad luck, we can have 6 rows with days. */
#define NO_DAY_BUTTONS        42

#define NO_DAY_NAME_BUTTONS     7

/* The week number row-column is vertically oriented. */
#define NO_WEEK_NUMBER_BUTTONS  7

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* CLASS RECORD */

typedef struct {

  XtPointer  extension;

} XmUbMonthDisplayClassPart;


/* Full class record declaration. */

typedef struct {

  CoreClassPart              core_class;
  CompositeClassPart         composite_class;
  ConstraintClassPart        constraint_class;
  XmManagerClassPart         manager_class;
  XmUbMonthDisplayClassPart  monthdisplay_class;

} XmUbMonthDisplayClassRec;


/* INSTANCE RECORD */

typedef struct {

  /* RESOURCES. */
  /* Callbacks. */
  XtCallbackList    date_selected_callback;
  XtCallbackList    new_month_callback;
  XtCallbackList    title_callback;
  XtCallbackList    update_day_callback;

  /* Current state. */
  int               current_year;
  int               current_month;

  /* Offsets and spacings. */
  Dimension         margin_height;
  Dimension         margin_width;
  Dimension         label_spacing;
  Dimension         arrow_spacing;

  /* Size computation. */
  Boolean           recompute_width;
  Boolean           recompute_height;

  /* Internal widget creation. */
  /* These resources may not be changed in SetValues. */
  XmString          month_label;
  XmString          year_label;
  XmString          week_number_label;
  Boolean           month_arrows;
  Boolean           year_arrows;
  Boolean           enable_separator;
  Boolean           use_default_title_callback;
  Boolean           week_numbers;

  /* Display. */
  Pixel             weekday_foreground;
  Pixel             sun_foreground;
  Pixel             sat_foreground;
  Pixel             today_foreground;
  Pixel             other_month_foreground;
  Pixel             week_number_foreground;

  int               day_name_characters;
  Boolean           fill_out_week;
  Boolean           title_shadows;
  unsigned char     title_alignment;

  /* PRIVATE STATE. */
  /* Internal widgets. Some may be NULL depending on format. */
  Widget    internal_children[ NO_INTERNAL_CHILDREN ];
  Widget    day_name_buttons[ NO_DAY_NAME_BUTTONS ];
  Widget    day_number_buttons[ NO_DAY_BUTTONS ];
  Widget    week_number_buttons[ NO_WEEK_NUMBER_BUTTONS ];

  /* Drag and drop icons. */
  Widget    date_icon;
  Pixmap    date_icon_bm;
  Pixmap    date_icon_mask;
  Widget    inv_date_icon;
  Pixmap    inv_date_icon_bm;
  Pixmap    inv_date_icon_mask;

  /* Shadows for pushbuttons. */
  Pixel     pushb_default_topshadow;
  Pixel     pushb_default_bottomshadow;

  /* Index in day_number_buttons array for first day of current month. */
  int       first_date_index;

  Boolean   resize_called;  /* Because unclear widget set philosophy. */
  Boolean   internal_widgets_created;
  Boolean   exposed;

} XmUbMonthDisplayPart;

/* Full instance record declaration. */

typedef struct _XmUbMonthDisplayRec {

  CorePart              core;
  CompositePart         composite;
  ConstraintPart        constraint;
  XmManagerPart         manager;
  XmUbMonthDisplayPart  md;

} XmUbMonthDisplayRec;



/* Constraint record for the children of this widget. */
typedef struct {

  XtPointer  extension;

} XmUbMonthDisplayConstraintsPart;


typedef struct {

  XmManagerConstraintPart          manager;
  XmUbMonthDisplayConstraintsPart  md;

} XmUbMonthDisplayConstraintsRec, *XmUbMonthDisplayConstraints;

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Conventional declaration. */
extern XmUbMonthDisplayClassRec xmUbMonthDisplayClassRec;

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif
