/*----------------------------------------------------------------------------
--
--  Module:           XmUbNoteBook
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the public header file for the widget.
--
--  Filename:         XmUbNoteBk.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-03-06
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbNoteBk.h, Version: 1.1, Date: 95/02/18 15:10:10 */

#ifndef _XmUbNoteBk_h
#define _XmUbNoteBk_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

/*----------------------------------------------------------------------------
--  Resources for the notebook widget.
--  All Core, Composite and XmManager resources apply. 
--  The following list describes resources added in this widget.
--
--  XmUbNbindingPixmapCenter
--                        The pixmap used to draw a binding on the side of the
--                        notebook. This pixmap is drawn at the center of the
--                        side set for the binding. May be repeated -- see 
--                        resource XmUbNrepeatCenterPixmap.
--                        Applies only when the resource 
--                        XmUbNbindingType is set to XmUbBINDING_PIXMAP.
--                        Do not change this resource when the binding type is
--                        one of the predefined types.
--                        The resource is NOT copied.
--                        Type:    Pixmap
--                        Default: NULL
--
--  XmUbNbindingPixmapEnd
--                        The pixmap used to draw a binding on the side of the
--                        notebook. This pixmap is drawn at the end of the
--                        side set for the binding. May be repeated -- see 
--                        resource XmUbNrepeatCenterPixmap.
--                        Applies only when the resource 
--                        XmUbNbindingType is set to XmUbBINDING_PIXMAP.
--                        Do not change this resource when the binding type is
--                        one of the predefined types.
--                        The resource is NOT copied.
--                        Type:    Pixmap
--                        Default: NULL
--
--  XmUbNbindingPixmapStart
--                        The pixmap used to draw a binding on the side of the
--                        notebook. This pixmap is drawn at the start of the
--                        side set for the binding. May be repeated -- see 
--                        resource XmUbNrepeatCenterPixmap.
--                        Applies only when the resource 
--                        XmUbNbindingType is set to XmUbBINDING_PIXMAP.
--                        Do not change this resource when the binding type is
--                        one of the predefined types.
--                        The resource is NOT copied.
--                        Type:    Pixmap
--                        Default: NULL
--
--  XmUbNbindingSide      The side on which the binding should be drawn.
--                        XmUbTOP, XmUbBOTTOM, XmUbLEFT, XmUbRIGHT
--                        Type:    int
--                        Default: XmUbTOP
--
--  XmUbNbindingType      The type of binding to be used.
--                        XmUbBINDING_NONE    No binding is used.
--                        XmUbBINDING_PIXMAP  The pixmap set in
--                                            XmUbNbindingPixmap is used.
--                                            If NULL, no binding.
--                        XmUbBINDING_SPIRAL  A predefined spiral is drawn.
--                        XmUbBINDING_SOLID   A predefined solid binding.
-- 
--                        Type:    int
--                        Default: XmUbBINDING_SPIRAL
--
--  XmUbNbookSideExtent   The extent of the book side on the right and bottom
--                        sides. Must be a multiple of 4.
--                        Type:    Dimension
--                        Default: 20
--
--  XmUbNcoveredPageBackground
--                        The background color used on the covered pages of the
--                        notebook.
--                        Type:    Pixel
--                        Default: Default background
--     
--  XmUbNcoveredPagesPos  The position of the covered pages in the background.
--                        Valid values:
--                          XmTOP_LEFT
--                          XmBOTTOM_LEFT
--                          XmTOP_RIGHT
--                          XmBOTTOM_RIGHT
--                        Type:    int
--                        Default: XmBOTTOM_RIGHT
--
--  XmUbNequalizeTabsBottom
--  XmUbNequalizeTabsLeft
--  XmUbNequalizeTabsRight
--  XmUbNequalizeTabsTop
--                        If True, the spacing between the tabs on the side is
--                        calculated so that the tabs fit on the size allocated
--                        for the side. These resources are only meaningful if
--                        XmUbNsizeIsWorkArea is True.
--                        Type:    Boolean
--                        Default: True
--
--  XmUbNfrontPageBackground
--                        The background color used on the front page of the
--                        notebook.
--                        Type:    Pixel
--                        Default: Default background
--     
--  XmUbNfrontPageFixed   If True, the front page keeps its size and position
--                        within the notebook regardless of what happens to
--                        the tabs or bindings.
--                        It will only resize when triggered from outside.
--                        Type:    Boolean
--                        Default: False
--
--  XmNrecomputeSize      If True, the notebook may resize itself when the 
--                        children request new geometries, if False, the 
--                        notebook never resizes itself.
--                        Note that this resource refers to the outer bounds of
--                        the notebook, i.e. the front page may still be 
--                        resized to accommodate longer tabs. For a fixed
--                        size on the front page, set XmUbNfrontPageFixed to
--                        False.
--                        Type:    Boolean
--                        Default: True
--
--  XmUbNrepeatCenterPixmap
--                        If True, the center binding pixmap is repeated and
--                        the start and end pixmaps are drawn at the edges, if
--                        defined. 
--                        If False, the center pixmap is drawn at the middle of
--                        the binding side and the start and end pixmaps are 
--                        repeated at either side. 
--                        This resource is forced to True if one of the 
--                        predefined binding types is used.
--                        Type:    Boolean
--                        Default: True
--
--  XmUbNresizeWorkArea   If True, the work area will be resized to fit the 
--                        margins set for the front page. If False, the work
--                        area will not be resized, but keep its requested size
--                        unless it is too big for the front page, in which
--                        case it will be shrunk.
--                        Type:    Boolean
--                        Default: True
--
--  XmUbNscrollOffsetBottom 
--  XmUbNscrollOffsetLeft
--  XmUbNscrollOffsetRight
--  XmUbNscrollOffsetTop
--                        The spacing between the first/last tab and the 
--                        scroll button.
--                        If < 0, the tab will overlap the scroll button.
--                        The scroll button and tab are not stacked against
--                        eachother.
--                        Type:    int
--                        Default: 2
--
--  XmUbNsizeIsWorkArea   If True, the size of the notebook widget will be 
--                        decided by the size of the work area. If the
--                        XmUbNequalizeTabs resource is set for the side,
--                        the tabs will be smeared out on the side as well.
--                        If the equalize resource is not set for a side, 
--                        tabs may be clipped as a result of the widget 
--                        asking for a size that cannot accommodate the tabs.
--                        Type:    Boolean
--                        Default: True
--
--  XmUbNtabDirBottom
--  XmUbNtabDirTop
--                        The direction in which the tabs are laid out on the
--                        side. 
--                        XmUbLEFT_TO_RIGHT    First tab is the leftmost one.
--                        XmUbRIGHT_TO_LEFT    First tab is the rightmost one.
--                        Type:    int
--                        Default: XmUbLEFT_TO_RIGHT
--
--  XmUbNtabDirLeft
--  XmUbNtabDirRight
--                        The direction in which the tabs are laid out on the
--                        side. 
--                        XmUbTOP_TO_BOTTOM    First tab is the topmost one.
--                        XmUbBOTTOM_TO_TOP    First tab is the bottommost one.
--                        Type:    int
--                        Default: XmUbTOP_TO_BOTTOM
--
--  XmUbNtabPacking       The policy to be used when laying out the tabs.
--                        XmUbTAB_PACK_TIGHT   All tabs as small as possible.
--                        XmUbTAB_PACK_COLUMN  All tabs the same size in the 
--                                             dimension perpendicular to the
--                                             layout side.
--                                             Variable in the other dim.
--                        XmUbTAB_PACK_EQUAL   All tabs the same size 
--                                             (per layout side).
--                        Type:    int
--                        Default: XmUbTAB_PACK_TIGHT
--
--  XmUbNtabSpacingBottom 
--  XmUbNtabSpacingLeft
--  XmUbNtabSpacingRight
--  XmUbNtabSpacingTop
--                        The spacing between two tab children on the side.
--                        If set to < 0, the tabs will overlap.
--                        Replaced by an automatically calculated value if
--                        the XmUbNequalizeTabs resource is set for the side.
--                        Type:    int
--                        Default: 2
--  
--  XmUbNworkArea         The widget ID for the work area. Must be a child
--                        of the notebook widget.
--                        Type:    Widget
--                        Default: NULL
--
------------------------------------------------------------------------------
--
-- Constraint resources for tab children.
--
------------------------------------------------------------------------------
--
--  XmUbNposition         The side on which the tab should be displayed.
--                        XmUbTOP, XmUbBOTTOM, XmUbLEFT, XmUbRIGHT
--                        Type:    int
--                        Default: XmUbBOTTOM
--
--  XmUbNchildType        The type of child.
--                        XmUbTAB, XmUbSCROLL_BUTTON, XmUbWORK_AREA.
--                        Determines how the child should be handled in the 
--                        layout. 
--                        XmUbTAB            The child is laid out as a tab.
--                                           XmUbNposition determines on which
--                                           side and the order of creation 
--                                           sets the order of the tabs.
--                        XmUbSCROLL_BUTTON  The child is a scroll button.
--                                           XmUbNposition determines on which
--                                           side and XmUbNscrollDirection 
--                                           if it's a backward or forward
--                                           scroll button.
--                        XmUbWORK_AREA      This is the work area. It can also
--                                           be set with the XmUbNworkArea
--                                           resource of the notebook widget.
--                                           If only one is set, the other is
--                                           filled in by default.
--                        Type:    int
--                        Default: XmUbTAB
--
--  XmUbNscrollDirection  The direction of the scroll button. Valid only for
--                        children with the XmUbNchildType set to
--                        XmUbSCROLL_BUTTON.
--                        XmUbSCROLL_BACK, XmUbSCROLL_FORWARD
--                        Type:    int
--                        Default: XmUbSCROLL_FORWARD
--
----------------------------------------------------------------------------
-- 
-- Note:
--  There may be any number of tab children for each side, but only one scroll
--  child per unique combination of XmUbNposition and XmUbNscrollDirection,
--  and only one work area. If duplicates are defined, the one(s) created first
--  will be used, and the duplicates will be ignored.
--
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define XmUbNbindingPixmapCenter       "bindingPixmapCenter"
#define XmUbNbindingPixmapEnd          "bindingPixmapEnd"
#define XmUbNbindingPixmapStart        "bindingPixmapStart"
#define XmUbNbindingSide               "bindingSide"
#define XmUbNbindingType               "bindingType"
#define XmUbNbookSideExtent            "bookSideExtent"
#define XmUbNchildType                 "childType"
#define XmUbNcoveredPageBackground     "coveredPageBackground"
#define XmUbNcoveredPagesPos           "coveredPagesPos"
#define XmUbNequalizeTabsBottom        "equalizeTabsBottom"
#define XmUbNequalizeTabsLeft          "equalizeTabsLeft"
#define XmUbNequalizeTabsRight         "equalizeTabsRight"
#define XmUbNequalizeTabsTop           "equalizeTabsTop"
#define XmUbNfrontPageBackground       "frontPageBackground"
#define XmUbNfrontPageFixed            "frontPageFixed"
#define XmUbNposition                  "position"
#define XmUbNrepeatCenterPixmap        "repeatCenterPixmap"
#define XmUbNresizeWorkArea            "resizeWorkArea"
#define XmUbNscrollDirection           "scrollDirection"
#define XmUbNscrollOffsetBottom        "scrollOffsetBottom"
#define XmUbNscrollOffsetLeft          "scrollOffsetLeft"
#define XmUbNscrollOffsetRight         "scrollOffsetRight"
#define XmUbNscrollOffsetTop           "scrollOffsetTop"
#define XmUbNsizeIsWorkArea            "sizeIsWorkArea"
#define XmUbNtabPacking                "tabPacking"
#define XmUbNtabSpacingBottom          "tabSpacingBottom"
#define XmUbNtabSpacingLeft            "tabSpacingLeft"
#define XmUbNtabSpacingRight           "tabSpacingRight"
#define XmUbNtabSpacingTop             "tabSpacingTop"
#define XmUbNtabDirBottom              "tabDirBottom"
#define XmUbNtabDirLeft                "tabDirLeft"
#define XmUbNtabDirRight               "tabDirRight"
#define XmUbNtabDirTop                 "tabDirTop"
#define XmUbNworkArea                  "workArea"

#define XmUbCBindingPixmapCenter       "BindingPixmapCenter"
#define XmUbCBindingPixmapEnd          "BindingPixmapEnd"
#define XmUbCBindingPixmapStart        "BindingPixmapStart"
#define XmUbCBindingSide               "BindingSide"
#define XmUbCBindingType               "BindingType"
#define XmUbCBookSideExtent            "BookSideExtent"
#define XmUbCChildType                 "ChildType"
#define XmUbCCoveredPagesPos           "CoveredPagesPos"
#define XmUbCEqualizeTabs              "EqualizeTabs"
#define XmUbCFrontPageFixed            "FrontPageFixed"
#define XmUbCPosition                  "Position"
#define XmUbCResizeWorkArea            "ResizeWorkArea"
#define XmUbCRepeatCenterPixmap        "RepeatCenterPixmap"
#define XmUbCScrollDirection           "ScrollDirection"
#define XmUbCScrollOffset              "ScrollOffset"
#define XmUbCSizeIsWorkArea            "SizeIsWorkArea"
#define XmUbCTabPacking                "TabPacking"
#define XmUbCTabHdirection             "TabHdirection"
#define XmUbCTabVdirection             "TabVdirection"
#define XmUbCTabSpacing                "TabSpacing"
#define XmUbCWorkArea                  "WorkArea"

/* Binding types. */

#define XmUbBINDING_NONE     0
#define XmUbBINDING_PIXMAP   1
#define XmUbBINDING_SOLID    2
#define XmUbBINDING_SPIRAL   3

/* Packing constants. */
#define XmUbTAB_PACK_TIGHT   0
#define XmUbTAB_PACK_COLUMN  1
#define XmUbTAB_PACK_EQUAL   2

/* Child types. */
#define XmUbTAB              0
#define XmUbSCROLL_BUTTON    1
#define XmUbWORK_AREA        2

/* Scroll directions. */
#define XmUbSCROLL_FORWARD   0
#define XmUbSCROLL_BACK      1


/* Positions. */
#define XmUbTOP              0
#define XmUbBOTTOM           1
#define XmUbLEFT             2
#define XmUbRIGHT            3

/* Horizontal directions. */
#define XmUbLEFT_TO_RIGHT    0
#define XmUbRIGHT_TO_LEFT    1

/* Vertical directions. */
#define XmUbTOP_TO_BOTTOM    0
#define XmUbBOTTOM_TO_TOP    1

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Class record constants. */
extern WidgetClass xmUbNoteBookWidgetClass;


typedef struct _XmUbNoteBookClassRec *XmUbNoteBookWidgetClass;
typedef struct _XmUbNoteBookRec      *XmUbNoteBookWidget;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Widget  
  XmUbCreateNoteBook( Widget    parent,
                      String    name,
                      ArgList   arglist,
                      Cardinal  argcount );


/* Set that no tab is active on the side. If the tabs overlap,
   they will be restacked. Note that restacking can only occur if the tabs
   have been realized. */

void
  XmUbNoteBookDeselectTab( Widget   notebook,
                           int      side,
                           Boolean  redisplay );

/* Restack the tabs on the side. May have to be called if the tabs are
   selected before the widget is realized. */

void
  XmUbNoteBkRestackTabs( Widget  notebook,
                         int     side );

/* Select the tab to be the active tab on the side. If the tabs overlap,
   they will be restacked. Note that restacking can only occur if the tabs
   have been realized. */

void
  XmUbNoteBookSelectedTab( Widget  notebook,
                           Widget  selected,
                           int     side );
                           

#endif /* _XmUbNoteBk_h */
