/*----------------------------------------------------------------------------
--
--  Module:           XmUbTimeSlider
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the public header file for the widget.
--
--    The time slider widget displays two sliders where the user may select
--    a time of day. The selected time is updated in a text field on the right.
--    The time may also be entered as a text string in the text field. In this
--    case, the sliders are updated to reflect the selected time.
--
--  Filename:         XmUbTimeSl.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-21
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbTimeSl.h, Version: 1.1, Date: 95/02/18 15:10:17 */

#ifndef _XmUbTimeSl_h
#define _XmUbTimeSl_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

/*----------------------------------------------------------------------------
--  Resources for the time slider widget.
--  All XmManager resources apply. 
--  The following list describes resources added in this widget.
--
--  XmNactivateCallback         CSG
--      XmCCallback
--    Callback(s) that is called when the user pressed <Enter> in the text 
--    field. See description of callbacks below for more information.
--    Type:    XtCallbackList
--    Default: NULL
--    
--  XmNmarginHeight             CSG
--      XmCMarginHeight
--    The margin used at the top and the bottom of the widget.
--    Type:    Dimension
--    Default: 0
--                        
--  XmNmarginWidth              CSG
--      XmCMarginWidth
--    The margin used at the left and right ends of the widget.
--    Type:    Dimension
--    Default: 0
--                        
--  XmUbNtslRecomputeHeight     CSG
--      XmUbCTslRecomputeHeight
--    If True, the height of the widget is dynamically calculated. 
--    If False, the user set height is kept. The resource is forced to False 
--    if the user sets a height.
--    Type:    Boolean
--    Default: True
--                        
--  XmUbNtslRecomputeWidth      CSG
--      XmUbCTslRecomputeWidth
--    If True, the width of the widget is dynamically calculated. 
--    If False, the user set width is kept. The resource is forced to False 
--    if the user sets a width.
--    Type:    Boolean
--    Default: True
--                        
--  XmUbNtslSpacing             CSG
--      XmCSpacing
--    The vertical spacing between the two sliders.
--    Type:    Dimension
--    Default: 4
--                        
--  XmUbNtslTextSpacing         CSG
--      XmCSpacing
--    The horizontal spacing between the sliders and the text widget.
--    Type:    Dimension
--    Default: 8
--                        
--  XmNvalueChangedCallback     CSG
--      XmCCallback
--    Callback(s) that is called when text was inserted into or deleted from
--    the child text widget. 
--    See description of callbacks below for more information.
--    Type:    XtCallbackList
--    Default: NULL
--    
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

#define XmUbNtslRecomputeHeight  "tslRecomputeHeight"
#define XmUbNtslRecomputeWidth   "tslRecomputeWidth"
#define XmUbNtslSpacing          "tslSpacing"
#define XmUbNtslTextSpacing      "tslTextSpacing"

#define XmUbCTslRecomputeHeight  "TslRecomputeHeight"
#define XmUbCTslRecomputeWidth   "TslRecomputeWidth"


/* Id's for children retrieval. */
#define XmUbTS_CHILD_HOUR_SLIDER    0
#define XmUbTS_CHILD_MINUTE_SLIDER  1 
#define XmUbTS_CHILD_TEXT_FIELD     2

#define XmUbTS_FIRST_CHILD  XmUbTS_CHILD_HOUR_SLIDER
#define XmUbTS_LAST_CHILD   XmUbTS_CHILD_TEXT_FIELD

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Callback structure. */

typedef struct {

  int      reason;
  XEvent   *event;
  int      child_index;
  Widget   child;

} XmUbTimeSliderCallbackStruct;

/* 
-- CALLBACKS
--
-- XmNactivateCallback
--   Called when <Enter> is pressed in the text field.
--
--   reason              XmCR_ACTIVATE
--   event               The keyboard event.
--   child_index         The index of the child ( XmUbTS_CHILD_... )
--   child               The widget id for the child.
--
-- XmNvalueChangedCallback
--   Called when the text in the text field is changed.
--
--   reason              XmCR_VALUE_CHANGED
--   event               The keyboard event.
--   child_index         The index of the child ( XmUbTS_CHILD_... )
--   child               The widget id for the child.
--
--
*/

/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Class record constants. */
extern WidgetClass xmUbTimeSliderWidgetClass;


typedef struct _XmUbTimeSliderClassRec *XmUbTimeSliderWidgetClass;
typedef struct _XmUbTimeSliderRec      *XmUbTimeSliderWidget;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Widget  
  XmUbCreateTimeSlider( Widget    parent,
                        String    name,
                        ArgList   arglist,
                        Cardinal  argcount );

Widget 
  XmUbTimeSliderGetChild( Widget  widget,
                          int     child );

/* XmUbTimeSliderGetTime returns the time relative to 1970-01-01, in GMT. */
/* The time returned is the time set with the scales, regardless of the 
   text in the text field. Therefore, the time is always valid. */
time_t
  XmUbTimeSliderGetTime( Widget  widget );


/* The caller must free the returned string. */
char
  *XmUbTimeSliderGetTimeString( Widget  widget );
                             

void
  XmUbTimeSliderSetTime( Widget  widget,
                         time_t  time );

#endif


